/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jobicade.betterhud.config.ConfigSlot;
import jobicade.betterhud.config.FileConfigSlot;
import jobicade.betterhud.config.HudConfig;
import jobicade.betterhud.config.ResourceConfigSlot;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;

public class ConfigManager
implements IResourceManagerReloadListener {
    public static final ResourceLocation CONFIGS_LOCATION = new ResourceLocation("betterhud", "configs/configs.json");
    private PathMatcher pathMatcher;
    private IResourceManager resourceManager;
    private Gson gson = new Gson();
    private List<ConfigSlot> internalConfigs;
    private Path rootDirectory;
    private final Path configPath;
    private HudConfig config;

    public ConfigManager(Path configPath, Path rootDirectory) {
        this.setRootDirectory(rootDirectory);
        try {
            Files.createDirectories(rootDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.configPath = configPath;
        this.reloadConfig();
    }

    public void reloadConfig() {
        this.config = new HudConfig(this.configPath.toFile());
    }

    public HudConfig getConfig() {
        return this.config;
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public Path getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(Path rootDirectory) {
        this.rootDirectory = rootDirectory;
        this.pathMatcher = rootDirectory.getFileSystem().getPathMatcher("glob:**/*.cfg");
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.internalConfigs = null;
    }

    public List<ConfigSlot> getSlots() {
        return (List)Stream.concat(this.getInternalSlots().stream(), this.streamExternalSlots()).filter(ConfigManager.distinctBy(ConfigSlot::getName)).collect(ImmutableList.toImmutableList());
    }

    public List<ConfigSlot> getInternalSlots() {
        if (this.internalConfigs == null) {
            this.internalConfigs = (List)this.streamInternalSlots().collect(ImmutableList.toImmutableList());
        }
        return this.internalConfigs;
    }

    private Stream<ConfigSlot> streamInternalSlots() {
        try {
            return this.resourceManager.func_135056_b(CONFIGS_LOCATION).stream().flatMap(this::streamJsonSlots);
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Stream<ConfigSlot> streamJsonSlots(IResource resource) {
        try (InputStreamReader reader = new InputStreamReader(resource.func_110527_b());){
            String[] paths = (String[])this.gson.fromJson((Reader)reader, String[].class);
            Stream<ConfigSlot> stream = Arrays.stream(paths).map(path -> new ResourceConfigSlot(new ResourceLocation(path)));
            return stream;
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }

    public List<ConfigSlot> getExternalSlots() {
        return (List)this.streamExternalSlots().collect(ImmutableList.toImmutableList());
    }

    private Stream<ConfigSlot> streamExternalSlots() {
        try {
            return Files.walk(this.rootDirectory, new FileVisitOption[0]).filter(this.pathMatcher::matches).map(FileConfigSlot::new);
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }

    private static <T, U> Predicate<T> distinctBy(Function<? super T, U> key) {
        HashSet seen = new HashSet();
        return t -> seen.add(key.apply(t));
    }
}

