/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud;

import java.nio.file.Path;
import java.util.Arrays;
import jobicade.betterhud.config.ConfigManager;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.events.KeyEvents;
import jobicade.betterhud.events.RenderEvents;
import jobicade.betterhud.geom.LayoutManager;
import jobicade.betterhud.network.InventoryNameQuery;
import jobicade.betterhud.network.MessageNotifyClientHandler;
import jobicade.betterhud.network.MessageVersion;
import jobicade.betterhud.util.Tickable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.Restriction;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

@Mod(modid="betterhud", name="Better HUD", version="1.4", updateJSON="https://raw.githubusercontent.com/mccreery/better-hud/develop/update.json", dependencies="required-after:forge@[14.23.1.2557,)", acceptedMinecraftVersions="[1.12.2]")
public class BetterHud {
    public static final String MODID = "betterhud";
    public static final VersionRange ALL = VersionRange.newRange(null, Arrays.asList(Restriction.EVERYTHING));
    public static final ArtifactVersion ZERO = new DefaultArtifactVersion("0.0");
    protected static final String VERSION_STRING = "1.4";
    public static final ArtifactVersion VERSION = new DefaultArtifactVersion("1.4");
    public static ArtifactVersion serverVersion = ZERO;
    private static Logger logger;
    @SideOnly(value=Side.CLIENT)
    public static Minecraft MC;
    public static final ResourceLocation ICONS;
    public static final ResourceLocation WIDGETS;
    public static final ResourceLocation PARTICLES;
    public static final ResourceLocation HUD_ICONS;
    public static final ResourceLocation SETTINGS;
    private static ConfigManager CONFIG_MANAGER;
    public static final LayoutManager MANAGER;
    public static final int SPACER = 5;
    public static final SimpleNetworkWrapper NET_WRAPPER;

    public static boolean serverSupports(VersionRange range) {
        return range.containsVersion(serverVersion);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static ConfigManager getConfigManager() {
        return CONFIG_MANAGER;
    }

    public static boolean isEnabled() {
        return HudElement.GLOBAL.isEnabledAndSupported() && (!HudElement.GLOBAL.hideOnDebug() || !BetterHud.MC.field_71474_y.field_74330_P);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        if (event.getSide() == Side.CLIENT) {
            MC = Minecraft.func_71410_x();
            HudElement.loadAllDefaults();
            Path configPath = event.getSuggestedConfigurationFile().toPath();
            CONFIG_MANAGER = new ConfigManager(configPath, configPath.resolveSibling(MODID));
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            KeyEvents.registerEvents();
            RenderEvents.registerEvents();
            Tickable.Ticker.registerEvents();
            HudElement.initAll(event);
        }
        NET_WRAPPER.registerMessage(MessageNotifyClientHandler.class, MessageVersion.class, 2, Side.CLIENT);
        NET_WRAPPER.registerMessage(InventoryNameQuery.ServerHandler.class, InventoryNameQuery.Request.class, 3, Side.SERVER);
        NET_WRAPPER.registerMessage(InventoryNameQuery.ClientHandler.class, InventoryNameQuery.Response.class, 4, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)this);
        IResourceManager manager = MC.func_110442_L();
        if (manager instanceof IReloadableResourceManager) {
            IReloadableResourceManager reloadableManager = (IReloadableResourceManager)manager;
            reloadableManager.func_110542_a(m -> HudElement.SORTER.markDirty(HudElement.SortType.ALPHABETICAL));
            reloadableManager.func_110542_a((IResourceManagerReloadListener)BetterHud.getConfigManager());
        } else {
            logger.warn("Unable to register alphabetical sort update on language change");
        }
    }

    @SubscribeEvent
    public void onPlayerConnected(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            NET_WRAPPER.sendTo((IMessage)new MessageVersion(VERSION), (EntityPlayerMP)e.player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        serverVersion = ZERO;
    }

    static {
        ICONS = Gui.field_110324_m;
        WIDGETS = new ResourceLocation("textures/gui/widgets.png");
        PARTICLES = new ResourceLocation("textures/particle/particles.png");
        HUD_ICONS = new ResourceLocation(MODID, "textures/gui/icons_hud.png");
        SETTINGS = new ResourceLocation(MODID, "textures/gui/settings.png");
        MANAGER = new LayoutManager();
        NET_WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
    }
}

