const sliderTo = 600;

let slider = $("#volume").roundSlider({
	radius: 80,
	width: 8,
	handleSize: "+8",
    circleShape: "pie",
    sliderType: "min-range",
	showTooltip: false,
	min: 0,
	max: 600,
    value: 100,
	startAngle: 315
});

$(".volume-circle").text(slider.roundSlider("getValue") + "%");

$("#insite-controller").change(function(e) {
	let checked = e.target.checked;
	if (checked) {
		$(".checkbox span").text("ON");
	} else {
		$(".checkbox span").text("OFF");
	}
})

const insite_controller = document.querySelector("#insite-controller");

function enableExt() {
	$("body").removeClass("dis");
	$("#tab-scope").prop("disabled", false);

	slider.roundSlider('enable');
}

function disableExt() {
	$("body").addClass("dis");
	$("#tab-scope").prop("disabled", true);
	slider.roundSlider('disable');
}

chrome.storage.local.get('insiteCtrl', function(result) {
	if (result.insiteCtrl !== undefined) {
		if (result.insiteCtrl === true) {
			insite_controller.checked = true;
			enableExt();
		} else {
			insite_controller.checked = false;
			disableExt();
		}
	} else {
		chrome.storage.local.set({'insiteCtrl': true}, null);
		insite_controller.checked = true;
	}
});

insite_controller.addEventListener('click', function(event) {
	if (event.target.checked === true) {
		chrome.storage.local.set({'insiteCtrl': true}, null);
		chrome.runtime.sendMessage({
            action: "enable_site_ctrl"
		});
		enableExt();
	} else {
		chrome.storage.local.set({'insiteCtrl': false}, null);
		chrome.runtime.sendMessage({
            action: "disable_site_ctrl"
		});
		disableExt();

		chrome.tabs.query({
			active: true,
			currentWindow: true,
		}, tabs => {
			tabId = tabs[0].id;
			tabUrl = tabs[0].url;

			chrome.runtime.sendMessage({
				action: "set_volume",
				tabId: tabId,
				sliderValue: "100",
				tabUrl: tabUrl
			});
			slider.roundSlider('setValue', "100");
			slider.roundSlider('disable');
		});
	}
});

function getRootUrl(url) {
    var hostname;
    if (url.indexOf("//") > -1) {
        hostname = url.split('/')[2];
    }
    else {
        hostname = url.split('/')[0];
    }
    hostname = hostname.split(':')[0];
    hostname = hostname.split('?')[0];

    return hostname;
}

function setCurTabScope(url) {
	chrome.storage.local.set({'scope': 0}, null);
	chrome.storage.local.get('scopeAlways', function(scopeAlwaysResult) {
		if (scopeAlwaysResult['scopeAlways']) {
			if (scopeAlwaysResult['scopeAlways'].includes(url)) {
				let updatedScope = scopeAlwaysResult['scopeAlways'].filter(function(item) {
					return item !== url
				});
				chrome.storage.local.set({'scopeAlways': updatedScope}, null);
			}
		} else {
			chrome.storage.local.set({'scopeAlways': []}, null);
		}
	});
}

function setCurUrlScope() {
	chrome.storage.local.set({'scope': 1}, null);
	chrome.storage.local.get('scopeAlways', function(scopeAlwaysResult) {
		if (scopeAlwaysResult['scopeAlways']) {
			if (!scopeAlwaysResult['scopeAlways'].includes(url)) {
				updatedScope = scopeAlwaysResult['scopeAlways'];
				updatedScope.push(url);
				chrome.storage.local.set({'scopeAlways': updatedScope}, null);
			}
		} else {
			chrome.storage.local.set({'scopeValue': {[url]: slider.roundSlider("getValue")}}, null);
		}
		
		chrome.storage.local.get('scopeValue', function(scopeValueResult) {
			if (scopeValueResult['scopeValue']) {
				scopeValueCopy = scopeValueResult['scopeValue'];
				scopeValueCopy[url] = slider.roundSlider("getValue");
				chrome.storage.local.set({'scopeValue': scopeValueCopy}, null);
			} else {
				chrome.storage.local.set({'scopeValue': {[url]: slider.roundSlider("getValue")}}, null);
			}
		});
	});
}

function setAllUrlScope() {
	chrome.storage.local.set({'scope': 2}, null);
	chrome.storage.local.set({'scopeValue': {'all': slider.roundSlider("getValue")}}, null);
	chrome.storage.local.set({'scopeAlways': []}, null);
}

function updateSelectScope(defaultScope) {
	$("#tab-scope option").prop("selected", false);
	chrome.storage.local.get('scopeAlways', function(scopeAlwaysResult) {
		if (scopeAlwaysResult['scopeAlways']) {
			if (scopeAlwaysResult['scopeAlways'].includes(url)) {
				$("#tab-scope #curUrl").prop("selected", true);
			} else {
				$("#tab-scope #curTab").prop("selected", true);
			}
		} else {
			$(`#tab-scope ${defaultScope}`).prop("selected", true);
		}
	});
}


let tabId;
let tabUrl;
chrome.tabs.query({
	active: true,
	currentWindow: true,
}, tabs => {
	tabId = tabs[0].id;
	tabUrl = tabs[0].url;

	if(chrome.runtime.lastError){return;}

	$(".volume-circle").text(slider.roundSlider("getValue") + "%");

	url = getRootUrl(tabUrl);

	$("#tab-scope").change(function(e) {
		switch (e.target.value) {
			case "curTab":
				setCurTabScope(url);
				break;
			case "curUrl":
				setCurUrlScope(url);
				break;
			case "allUrl":
				setAllUrlScope();
				break;
		}
	});


	chrome.storage.local.get('scope', function(scopeResult) {
		if (scopeResult['scope']) {
			if (scopeResult['scope'] === 0) {
				updateSelectScope("#curTab");
			} else if (scopeResult['scope'] === 1) {
				updateSelectScope("#curUrl");
			} else if (scopeResult['scope'] === 2) {
				$("#tab-scope #allUrl").prop("selected", true);
			}
		}
	});

	chrome.storage.local.get([url], function(result) {
		chrome.storage.local.get('scope', function(scopeResult) {
			chrome.storage.local.get('scopeValue', function(scopeValueResult) {
				let scope = 0;
				if (scopeResult['scope'] !== undefined) {
					scope = scopeResult['scope'];
				}

				if (result[url] !== undefined && scope !== 0 || scope === 2) {
					let gain = 100;
					if (scope == 1) {
						chrome.storage.local.get('scopeAlways', function(scopeAlwaysResult) {
							if (scopeAlwaysResult['scopeAlways'] !== undefined) {
								if (!scopeAlwaysResult['scopeAlways'].includes(url)) {
									if (result[url] !== undefined) {
										gain = result[url];
									}
				
									if (Number(gain) !== 100) {
										slider.roundSlider('setValue', String(gain));
									}
								} else {
									chrome.storage.local.get('scopeValue', function(scopeValueResult) {
										gain = Number(scopeValueResult['scopeValue'][url]);
										if (Number(gain) !== 100) {
											slider.roundSlider('setValue', String(gain));
										}
									})
								}
							} else {
								if (result[url] !== undefined) {
									gain = result[url];
								}
			
								if (Number(gain) !== 100) {
									slider.roundSlider('setValue', String(gain));
								}
							}
						});
					} else {
						if (scope === 2) {
							gain = Number(scopeValueResult['scopeValue']['all']);
						} else if (result[url] !== undefined) {
							gain = result[url];
						}
	
						if (Number(gain) !== 100) {
							slider.roundSlider('setValue', String(gain));
						}
					}
				} else { 
					chrome.runtime.sendMessage({
						action: "get_gain",
						tabId: tabId,
						tabUrl: tabUrl
					}, response => {
						if (response.gainValue !== null) {
							const gain = response.gainValue * 100 || 0;
							slider.roundSlider('setValue', String(gain));
						}
					});
				}
			});
		});
	});
});

slider.roundSlider({
	valueChange: function(e) {
		url = getRootUrl(tabUrl);
		const value = String(Number(e.value));
	
		$(".volume-circle").text(value + "%");
	
		chrome.storage.local.get('scope', function(scopeResult) {
			chrome.storage.local.get('scopeValue', function(scopeValueResult) {
				if (scopeValueResult['scopeValue'] !== undefined) {
					scopeValueCopy = scopeValueResult['scopeValue'];
					if (scopeResult['scope'] == 2) {
						scopeValueCopy['all'] = value;
					} else {
						scopeValueCopy[url] = value;
					}
					chrome.storage.local.set({'scopeValue': scopeValueCopy}, null);
				}
			});  
		})
	
		chrome.storage.local.get('insiteCtrl', function(result) {
			if (result.insiteCtrl !== undefined) {
				if (result.insiteCtrl === true) {
					chrome.runtime.sendMessage({
						action: "set_volume",
						tabId: tabId,
						sliderValue: value,
						tabUrl: tabUrl
					});
				}
			} else {
				chrome.runtime.sendMessage({
					action: "set_volume",
					tabId: tabId,
					sliderValue: value,
					tabUrl: tabUrl
				});
			}
		});
	}
})

$(".min, .max").click(function() {
	if ($("body").hasClass("dis")) return;
	let value = slider.roundSlider("getValue");
	if ($(this).hasClass("min")) {
		slider.roundSlider("setValue", value - 5);
	} else {
		slider.roundSlider("setValue", value + 5);
	}
});