/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.Installer;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public final class HelpCtxProcessor
implements Environment.Provider {
    private static Help findHelp() {
        return (Help)Lookup.getDefault().lookup(Help.class);
    }

    public Lookup getEnvironment(final DataObject dataObject) {
        try {
            Class.forName("javax.help.HelpSet");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Lookup.EMPTY;
        }
        Installer.log.log(Level.FINE, "creating help context presenter from {0}", dataObject.getPrimaryFile());
        return Lookups.singleton((Object)new InstanceCookie(){
            private Action instance = null;

            public String instanceName() {
                return dataObject.getName();
            }

            public Class<?> instanceClass() throws IOException, ClassNotFoundException {
                return Action.class;
            }

            public synchronized Object instanceCreate() throws IOException, ClassNotFoundException {
                if (this.instance != null) {
                    return this.instance;
                }
                try {
                    Document document = XMLUtil.parse((InputSource)new InputSource(dataObject.getPrimaryFile().getURL().toString()), (boolean)true, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), (EntityResolver)EntityCatalog.getDefault());
                    Element element = document.getDocumentElement();
                    if (!element.getNodeName().equals("helpctx")) {
                        throw new IOException();
                    }
                    this.instance = new ShortcutAction(dataObject, element.getAttribute("id"), Boolean.valueOf(element.getAttribute("showmaster")));
                    if (dataObject.getPrimaryFile().getAttribute("iconBase") != null) {
                        this.instance.putValue("iconBase", dataObject.getPrimaryFile().getAttribute("iconBase"));
                    }
                    return this.instance;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new IOException(exception);
                }
            }
        });
    }

    private static final class ShortcutAction
    extends AbstractAction
    implements HelpCtx.Provider,
    NodeListener,
    ChangeListener {
        private static final RequestProcessor RP = new RequestProcessor(ShortcutAction.class);
        private final DataObject obj;
        private String helpID;
        private boolean showmaster;

        public ShortcutAction(DataObject dataObject, String string, boolean bl) {
            Help help;
            this.obj = dataObject;
            this.helpID = string;
            this.showmaster = bl;
            this.putValue("noIconInMenu", true);
            Installer.log.log(Level.FINE, "new ShortcutAction: {0} {1} showmaster={2}", new Object[]{dataObject, string, bl});
            this.updateText();
            this.updateIcon();
            this.updateEnabled();
            if (dataObject.isValid()) {
                help = dataObject.getNodeDelegate();
                help.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)help));
            }
            if ((help = HelpCtxProcessor.findHelp()) != null) {
                help.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)help));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Help help = HelpCtxProcessor.findHelp();
            if (help != null) {
                Installer.log.log(Level.FINE, "ShortcutAction.actionPerformed: {0} showmaster={1}", new Object[]{this.helpID, this.showmaster});
                help.showHelp(new HelpCtx(this.helpID), this.showmaster);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("ide.welcome");
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.updateEnabled();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!this.obj.isValid()) {
                return;
            }
            if (string == null || string.equals("name") || string.equals("displayName")) {
                this.updateText();
            }
            if (string == null || string.equals("icon")) {
                this.updateIcon();
            }
        }

        private void updateText() {
            String string = this.obj.isValid() ? this.obj.getNodeDelegate().getDisplayName() : "dead";
            this.putValue("Name", string);
        }

        private void updateIcon() {
            Image image;
            if (this.obj.isValid() && (image = this.obj.getNodeDelegate().getIcon(1)) != null) {
                this.putValue("SmallIcon", new ImageIcon(image));
            }
        }

        private void updateEnabled() {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Boolean bl;
                    Help help = HelpCtxProcessor.findHelp();
                    Boolean bl2 = bl = help == null ? Boolean.FALSE : help.isValidID(ShortcutAction.this.helpID, false);
                    if (bl != null) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ShortcutAction.this.setEnabled(bl);
                            }
                        });
                    }
                    Installer.log.log(Level.FINE, "enabled: xml={0} id={1} enabled={2}", new Object[]{ShortcutAction.this.obj.getPrimaryFile(), ShortcutAction.this.helpID, bl});
                }
            });
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            this.setEnabled(false);
            this.updateText();
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }
    }
}

