﻿
'在 VisualFreeBasic 选项里，可以选择是不是启用本插件，禁用后，除了 initialization 其它全部失效，也就是 initialization 不受选项控制，必须要执行的。
'VisualFreeBasicStart 函数，除了【启用】选项，还受到 选项里【启动执行】 控制，不选择启动时是不会被执行的。

'由于VFb是32位的，因此编译的 DLL 也必须是32位，不可以是64位DLL
'编译完成后，若无出错，可以按提示选择自动重启VFB生效（选项里已启用此插件才行），重启后自动恢复先前开启的工程。
'假如插件造成VFB无法使用，可以把 VFB\Settings\StartupReBak.txt 文件更名为 VFB\Settings\StartupReplace.txt 后重开软件还原。


Function initialization(xName As String, xExplain As String) As Long Export '初始化，VFB启动后加载插件时，调用此函数，返回插件名称 （不可执行其它代码）
                         '多个插件按优先度依次执行（优先度在VFB选项里设置，每个插件都能执行到）
                         '注意：由于此时VFB在做各种初始化工作，加载窗口还在提示中，请勿执行和调用EXE里各个输出函数，避免引发崩溃
                         '后面还有 VisualFreeBasicStart 为初始化完成后调用，弹窗及显示功能窗口，在初始化结束后使用。
                         '推荐在此做插件的初始化工作，非有必要请勿写在程序入口函数里。
   SetFunctionAddress()  '设置函数地址 ，必须要做的
   xName    = "代码格式化"                                                     '插件名，在 标签 上显示的名称
   xExplain = "对代码格式化操作、缩进、注释等等，对代码美化及对齐等多个功能。" '插件的说明解释，主要时在VFB插件管理里显示，让大家知道插件是干嘛的。
   Function = 3                                                                '返回协议版本号，不同协议（发生接口变化）不能通用，会发生崩溃等问题，因此VFB主软件会判断此版本号，不匹配就不使用本插件。
End Function
Dim Shared MenuID_右移       As Long
Dim Shared MenuID_左移       As Long
Dim Shared MenuID_注释       As Long
Dim Shared MenuID_取消注释   As Long
Dim Shared MenuID_格式化     As Long
Dim Shared MenuID_格式化模块 As Long
Sub MenuAdd(zMenu As HMENU, nPos As Long, tFont As HFONT, ByRef IDC As Long) Export  ' 创建VFB主菜单时调用，在这里可以添加菜单（不可执行其它代码）
   'zMenu   菜单句柄
   'nPos    当前位置，0-7 代表：文件 编辑 搜索  视图 工程 工具 帮助 插件
   'tFont   字体句柄，就是符号字体的句柄，需要传递给加载菜单画字体图标用
   'IDC     控件唯一识辨码，在这里作为菜单ID，必须是唯一的，使用后必须 IDC +=1 ，避免产生重复（请勿随便修改，造成VFb混乱）
   ''       自己添加菜单后，自己必须记住自己的 IDC ，好在事件中处理识辨是自己的菜单。
   
   'VFB自己添加完菜单后，再调用这里，这里---{只做添加菜单用，请勿执行其它东西，避免引发崩溃}---
   '注意：由于此时VFB在做各种初始化工作，加载窗口还在提示中，请勿执行和调用EXE里各个输出函数，避免引发崩溃
   ''     只可以用 Menu_Add_Jilu 函数添加，不要用API添加或修改，VFB无法自动处理，发生混乱
   
   '以下为添加菜单例题
   'Menu_Add_Jilu(zMenu, tFont, 图标的符号值,图标样式,IDC, 有效值, 菜单文字, 快捷键)
   '有效值(自动根据状态禁用或启用菜单功能):  =0始终有效 =1代码编辑器时有效 =2窗口区有效 =3有工程时有效 =4窗口和代码
   Select Case nPos
      Case 0 '文件
      Case 1 '编辑
         Menu_Add_Jilu(zMenu, tFont, 0, 0, 0, 0, "", "")
         MenuID_右移 = IDC : IDC += 1
         Menu_Add_Jilu(zMenu, tFont, &HE719, &H0,MenuID_右移, 1, "右移(缩进)(&I)", "TAB")
         MenuID_左移 = IDC : IDC += 1
         Menu_Add_Jilu(zMenu, tFont, &HE716, &H0,MenuID_左移, 1, "左移(取消缩进)(&N)", "Shift+TAB")
         Menu_Add_Jilu(zMenu, tFont, 0, 0, 0, 0, "", "")
         MenuID_注释 = IDC : IDC += 1
         Menu_Add_Jilu(zMenu, tFont, &HE60A, &H0,MenuID_注释, 1, "注释(&M)", "Ctrl+B")
         MenuID_取消注释 = IDC : IDC += 1
         Menu_Add_Jilu(zMenu, tFont, &HE60B, &H0,MenuID_取消注释, 1, "取消注释(&B)", "Ctrl+Shift+B")
         Menu_Add_Jilu(zMenu, tFont, 0, 0, 0, 0, "", "")
         MenuID_格式化 = IDC : IDC += 1
         Menu_Add_Jilu(zMenu, tFont, &HE631, &H0,MenuID_格式化, 1, "代码格式化，当前过程/函数", "Ctrl+G")
         MenuID_格式化模块 = IDC : IDC += 1
         Menu_Add_Jilu(zMenu, tFont, &H0,&H0,MenuID_格式化模块, 1, "代码格式化，当前模块", "")
      Case 2 '搜索
      Case 3 '视图
      Case 4 '工程
      Case 5 '工具
      Case 6 '帮助
      Case 7 '插件专用菜单，一般需要什么功能，可以增加到这里
         '还原IDC = IDC
         'Menu_Add_Jilu(zMenu, tFont, 0, &H0,IDC, 0, ("一键还原插件或控件"), "")
         'IDC += 1
      Case 8  '代码编辑时，右键菜单， 字符转换 里的子菜单
      Case 9  '代码编辑时，右键菜单， 代码插入 里的子菜单
      Case 10 '代码编辑时，右键菜单， 代码格式 里的子菜单
         Menu_Add_Jilu(zMenu, tFont, &HE631, &H0,MenuID_格式化, 1, !"代码格式化\&H09Ctrl+G", "")
         Menu_Add_Jilu(zMenu, tFont, &HE60A, &H0,MenuID_注释, 1, !"注释(&M)\&H09Ctrl+B", "")
         Menu_Add_Jilu(zMenu, tFont, &HE60B, &H0,MenuID_取消注释, 1, !"取消注释(&B)\&H09Ctrl+Shift+B", "")
         Menu_Add_Jilu(zMenu, tFont, 0, 0, 0, 0, "", "")
         Menu_Add_Jilu(zMenu, tFont, &HE719, &H0,MenuID_右移, 1, !"右移(缩进)(&I)\&H09TAB", "")
         Menu_Add_Jilu(zMenu, tFont, &HE716, &H0,MenuID_左移, 1, !"左移(取消缩进)(&N)\&H09Shift+TAB", "")
         
      Case 11 '工程设置菜单，用在工具栏最后面工程类型按钮
      Case 12 '标签菜单 ，用在 TAB0 右键菜单
      Case 13 '代码编辑器，右键菜单
      Case 14 '工程列表，右键菜单
      Case 15 '窗口编辑器，右键菜单
   End Select
   
   'Menu_Add_Jilu(zMenu, tFont, &HE657, &H0,IDC, 0, ("新建(&N)..."), "Ctrl+N")
   'IDC +=1
   'Menu_Add_Jilu(zMenu, tFont, &HE64D, &H0,IDC, 0, ("打开(&O)..."), "Ctrl+O")
   'IDC +=1
   'Menu_Add_Jilu(zMenu, tFont, &H0,&H0,IDC, 3, ("关闭当前工程(&R)"), "Ctrl+Q")
   'IDC +=1
   'Menu_Add_Jilu(zMenu, tFont, &HE6B2, &H0,IDC, 4, ("保存全部(&E)"), "Ctrl+S")
   'IDC +=1
   'Menu_Add_Jilu(zMenu, tFont, &H0,&H0,IDC, 3, ("另存为模版"), "")
   'IDC +=1
   'Menu_Add_Jilu(zMenu, tFont, 0, 0, 0, 0, "", "")   '分割符号
   'IDC +=1
   'Menu_Add_Jilu(zMenu, tFont, &HE65B, &H0,IDC, 0, ("最近文件"), "Ctrl+T")
   'IDC +=1
   'Menu_Add_Jilu(zMenu, tFont, 0, 0, 0, 0, "", "")
   'IDC +=1
   'Menu_Add_Jilu(zMenu, tFont, &HE637, &H0,IDC, 0, ("命令提示符"), "")
   'IDC +=1
   'Menu_Add_Jilu(zMenu, tFont, 0, 0, 0, 0, "", "")
   'IDC +=1
   'Menu_Add_Jilu(zMenu, tFont, &HE7C2, &H0,IDC, 0, ("退出(&X)"), "")
End Sub

Sub ToolAdd(ByRef IDC As Long) Export '在工具栏 增加按钮（不可执行其它代码）
   '******注意：由于此时VFB在做各种初始化工作，加载窗口还在提示中，请勿执行和调用EXE里各个输出函数，避免引发崩溃*****
   'IDC     控件唯一识辨码，在这里作为菜单ID，必须是唯一的，使用后必须 IDC +=1 ，避免产生重复（请勿随便修改，造成VFb混乱）
   
   '用 InsertTool(position As Long, IcoWchr As Long, Colour As Long, CommandID As Long, xTyep As Long, xTips As String,FileImg As String="") '插入工具栏按钮，此函数只在这里有效果，其它地方无效。
   'position As Long '在此位置插入按钮，从1 开始 到 ** ，分割线也算1个位置，多个插件插入按钮后引起位置改变，注意插件优先度，最后看运行结果。
   '位置 = 0 就不操作，只设置位置，CommandID = 0 表示是分割符
   'IcoWchr   As Long   '宽字符符号值
   'Colour    As Long   '显示的颜色
   'CommandID As Long   '菜单的命令ID号
   'xTyep     As Long   ' 属性  =0始终有效 =1代码编辑器时有效 =2窗口区有效 =3有工程时有效 =4窗口和代码
   'xTips     As String ' 提示
   'FileImg  As String  ' 图标文件名，不包含路径，文件必须在 VFB\Settings\img\tool  里 ，如 "1.ico"
   
   InsertTool(17 ,0 ,0 ,0 ,0 ,"") '分隔符
   InsertTool(18 ,&HE631 ,&H008000 ,MenuID_格式化 ,1 ,"格式化当前函数的代码")
   InsertTool(19 ,&HE719 ,&H006400 ,MenuID_右移 ,1 ,"右移(缩进)（TAB）")
   InsertTool(20 ,&HE716 ,&H006400 ,MenuID_左移 ,1 ,"左移(取消缩进)（Shift + Tab）")
   InsertTool(21 ,&HE60A ,&H1F7824 ,MenuID_注释 ,1 ,"注释（Ctrl + B）")
   InsertTool(22 ,&HE60B ,&H1F7824 ,MenuID_取消注释 ,1 ,"取消注释（Ctrl + Shift + B）")
   
End Sub

Sub VisualFreeBasicStart(nThemes As TYPE_THEMES, nThemesWin As TYPE_THEMES) Export 'VFB 初始结束，可以开始执行其它操作
   '初始化完成后调用，可以在这里弹窗及显示功能窗口，
   '多个插件按优先度依次执行（优先度在VFB选项里设置，每个插件都能执行到）
   ThemeCode = nThemes        '代码主题
   ThemeWin = nThemesWin      '窗口主题
   
End Sub


Function MenuCommand(wID As Long) As Long Export '点击VFB菜单后调用，返回非零后，VFB或优先度低的就不再被执行。等所有插件执行完成后，VFB才执行自己的代码。  wID 是菜单命令ID
   '这里可以根据 wID 执行自己添加的菜单命令，也可以执行别的插件和VFB的命令。
   Select Case wID
      Case MenuID_右移  '  缩进
         Code_IndentBlock True
      Case MenuID_左移  ' 凸出
         Code_IndentBlock False
      Case MenuID_注释  '  注释
         Code_BlockCommentP True
      Case MenuID_取消注释  '  取消注释
         Code_BlockCommentP False
      Case MenuID_格式化  ' 代码格式化当前过程/函数
         Code_DaiMaGeSiHua(1)
      Case MenuID_格式化模块  ' 代码格式化当前模块
         Code_DaiMaGeSiHua(2)
   End Select
   Function = 0
End Function
Enum
   BLOCK_STATEMENT_IF 
   BLOCK_STATEMENT_FOR
   BLOCK_STATEMENT_SELECT
   BLOCK_STATEMENT_WHILE
   BLOCK_STATEMENT_DO
   BLOCK_STATEMENT_FUNCTION
   BLOCK_STATEMENT_SUB
   BLOCK_STATEMENT_PROPERTY
   BLOCK_STATEMENT_TYPE
   BLOCK_STATEMENT_WITH
   BLOCK_STATEMENT_ENUM
   BLOCK_STATEMENT_UNION
   BLOCK_STATEMENT_CONSTRUCTOR
   BLOCK_STATEMENT_DESTRUCTOR
End Enum
   
Function CodeAttemptAutoInsert(pSci As Any Ptr) as Long Export '代码编辑器里按下回车后，需要处理事情（如自动美化，格式，自动配对等）。返回非零就退出后续操作，优先度低的就无法执行。
   '尝试自动完成for/do/select等块。此函数还处理自动定向，因此需要根据用户选择的设置分别处理这两个问题。
   '为了效率，就一个插件干这个活即可，其它插件留空，不处理。
   
   
   Dim As Long nLine, nCurLine, curPos, LineLen, nFoldLevel, TabSize, nSpaces, IndentSize, i
   Dim As String strFill, strTemp, strCurLine, strPrevLine

   '当前行和上一行
   curPos = CodeEditMsg(pSci, SCI_GETCURRENTPOS, 0, 0)
   nLine = Code_GetCurrentLineNumberP(pSci)
   strCurLine = Code_GetLineP(pSci, nLine)
   DaiMaZiDonMeiHua pSci , nLine -1
   strPrevLine = Code_GetLineP(pSci, nLine -1)
   If Len(strPrevLine) = 0 Then Exit Function
   
   '获取标签宽度和缩进大小
   TabSize = CodeEditMsg(pSci, SCI_GETTABWIDTH, 0, 0)
   IndentSize = CodeEditMsg(pSci, SCI_GETINDENT, 0, 0)
   
   '计算左侧要填充的空格数
   For i = 1 To Len(strPrevLine)
      If Mid(strPrevLine, i, 1) <> " " Then
         If Mid(strPrevLine, i, 1) = Chr(9) Then
            nSpaces = nSpaces + TabSize
         Else
            Exit For
         End If
      Else
         nSpaces = nSpaces + 1
      End If
   Next
   strPrevLine = Trim(UCase(strPrevLine), Any Chr(32, 9))
   Dim vfbOp As pezi Ptr = GetOpAPP() 
   If vfbOp->AutoIndentation = 0 Then
      nSpaces = 0 : IndentSize = 0 : TabSize = 0
   End If
   
   
   ''''''''''
   'ELSE / ELSEIF
   '在最近的 IF/THEN 行中向后搜索，并使用该行的缩进作为ELSE或ELSEIF语句。
   If vfbOp->AutoIndentation Then
      If (Left(strPrevLine, 4) = "ELSE") Or (Left(strPrevLine, 7) = "ELSEIF ") Then
         nCurLine = Code_GetCurrentLineNumberP(pSci)
         Dim ji As Long
         For i = nCurLine To 0 Step -1
            ji += 1
            if ji > 999 Then Exit for
            strTemp = Code_GetLineP(pSci, i)
            If Left(LTrim(UCase(strTemp), Any Chr(32, 9)), 3) = "IF " Then
               '重新定位ELSE / ELSEIF线以与IF线对齐
               nSpaces = InStr(UCase(strTemp), "IF ") - 1
               strPrevLine = Space(nSpaces) & Trim(Code_GetLineP(pSci, nLine -1), Any Chr(32, 9))  ' 需要它是原始 case
               Code_SetLineP(pSci, nLine -1, strPrevLine)
               strFill = Space(nSpaces + IndentSize) & strCurLine
               Code_SetLineP(pSci, nLine, strFill)
               '添加当前编辑位置
               curPos = CodeEditMsg(pSci, SCI_POSITIONFROMLINE, nLine, 0) + nSpaces + IndentSize
               CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
               Exit Function
            End If
         Next
      End If
   End If
   
   ''''''''''
   'CASE
   '在最近的CASE行中向后搜索，并使用该行的缩进作为CASE或CASE ELSE语句。
   If vfbOp->AutoIndentation Then
      If Left(strPrevLine, 5) = "CASE " Then  ' 这也将抓住CASE ELSE
         strPrevLine = Trim(Code_GetLineP(pSci, nLine -1), Any Chr(32, 9))  '需要它是原始案例
         nSpaces = InStr(UCase(Code_GetLineP(pSci, nLine -1)), "CASE ") - 1
         nCurLine = Code_GetCurrentLineNumberP(pSci) - 2  ' 跳过当前的CASE并寻找之前的
         Dim ji As Long
         For i = nCurLine To 0 Step -1
            ji += 1
            if ji > 999 Then Exit for
            strTemp = Code_GetLineP(pSci, i)
            Dim As String strTempTrim = LTrim(UCase(strTemp), Any Chr(32,9))
            If Left(strTempTrim, 12) = "SELECT CASE " Then
               Exit For   ' 无需继续搜索
            ElseIf Left(strTempTrim, 5) = "CASE " Then
               nSpaces = InStr(UCase(strTemp), "CASE ") - 1
               Exit For
            End If
         Next
         '重新定位CASE行以与之前的CASE行对齐
         strPrevLine = Space(nSpaces) & strPrevLine
         Code_SetLineP(pSci, nLine -1, strPrevLine)
         strFill = Space(nSpaces + IndentSize) & strCurLine
         Code_SetLineP(pSci, nLine, strFill)
         '添加当前编辑位置
         curPos = CodeEditMsg(pSci, SCI_POSITIONFROMLINE, nLine, 0) + nSpaces + IndentSize
         CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
         Exit Function
      End If
   End If
   
   
   ''''''''''
   'IF/THEN
   '在自动延迟IF语句之前，请确保这实际上是一个多行IF语句。
   If (Left(strPrevLine, 3) = "IF " And Right(strPrevLine, 5) = " THEN") Then
      '删除当前行，因为一旦我们将它包装在END IF中，我们将在下面再次添加它。 它将包括在单行IF / THEN之后的THEN之后的任何文本块
      CodeEditMsg(pSci, SCI_LINEDELETE, 0, 0)
      strFill = Space(nSpaces + IndentSize) & LTrim(strCurline, Any Chr(32, 9)) & vbCrLf
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_IF, nLine) Then
         strFill &= Space(nSpaces) & "End If" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'FOR/NEXT
   If Left(strPrevLine, 4) = "FOR " Then
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_FOR, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "Next" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'SELECT CASE
   If Left(strPrevLine, 12) = "SELECT CASE " Then
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_SELECT, nLine) Then
         strFill &= "Case " & vbCrLf & Space(nSpaces) & "End Select" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize + 5
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'WHILE/WEND
   If (Left(strPrevLine, 6) = "WHILE ") Or (strPrevLine = "WHILE") Then
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_WHILE, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "Wend" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'DO/LOOP
   If (Left(strPrevLine, 3) = "DO ") Or (strPrevLine = "DO") Then
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_DO, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "Loop" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'FUNCTION/END FUNCTION
   If (Left(strPrevLine, 9) = "FUNCTION ") Or _
      (Left(strPrevLine, 17) = "PRIVATE FUNCTION ") Or _
      (Left(strPrevLine, 16) = "PUBLIC FUNCTION ") Then
         '确定这是否是FUNCTION =语句而不是true函数。
      strTemp = strPrevLine
      i = InStr(strTemp, "(")
      If i Then strTemp = Left(strTemp, i -1)
      If InStr(strTemp, "=") Then Exit Function
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_FUNCTION, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "End Function" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'SUB/END SUB
   If (Left(strPrevLine, 4) = "SUB ") Or (Left(strPrevLine, 12) = "PRIVATE SUB ") Or (Left(strPrevLine, 11) = "PUBLIC SUB") Then
      if IsSubOK(strPrevLine) = 0 Then Exit Function
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_SUB, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "End Sub" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'PROPERTY/END PROPERTY
   If (Left(strPrevLine, 9) = "PROPERTY ") Then
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_SUB, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "End Property" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'CONSTRUCTOR/END CONSTRUCTOR
   If (Left(strPrevLine, 12) = "CONSTRUCTOR ") Then
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_CONSTRUCTOR, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "End Constructor" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'DESTRUCTOR/END DESTRUCTOR
   If (Left(strPrevLine, 11) = "DESTRUCTOR ") Then
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_DESTRUCTOR, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "End Destructor" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'TYPE/END TYPE
   If (Left(strPrevLine, 5) = "TYPE ") Then
      '确定这是否是TYPE =语句而不是真正的TYPE结构
      If InStr(UCase(strPrevLine), " AS ") Then Exit Function
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_TYPE, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "End Type" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'WITH/END WITH
   If (Left(strPrevLine, 4) = "WITH") Then
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_WITH, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "End With" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'ENUM/END ENUM
   If (Left(strPrevLine, 4) = "ENUM") Then
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_ENUM, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "End Enum" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   'UNION/END UNION
   If (Left(strPrevLine, 6) = "UNION ") Then
      strFill = Space(nSpaces + IndentSize)
      If CanCompleteBlockStatement(pSci, BLOCK_STATEMENT_UNION, nLine) Then
         strFill &= vbCrLf & Space(nSpaces) & "End Union" & vbCrLf
      End If
      CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
      curPos = curPos + nSpaces + IndentSize
      CodeEditMsg(pSci, SCI_SETSEL, curPos, curPos)
      Exit Function
   End If
   
   '''''''''''''
   '在左上方添加相同的空格
   strFill = Space(nSpaces)
   CodeEditMsg(pSci, SCI_ADDTEXT, Len(strFill), Cast(lParam, StrPtr(strFill)))
   
   Function = 0  
End Function

Function CompileStart(ProFile As String, nFile As String) As Long Export  '编译前调用此函数，此时还未生成临时编译文件。返回非零就退出，停止编译，优先度低的就无法执行。
   'ProFile   工程文件，包含文件夹
   'nFile      输出文件，包含文件夹，如软件为 EXE扩展名，DLL为DLL扩展名，64位为 在 release64 路径里。
   
   Function = 0 
End Function

Function CompileEnd(ProFile As String, nFile As String) As Long Export  '编译后调用此函数，返回非零就退出，后续操作优先度低的就无法执行。
   'ProFile   工程文件，包含文件夹
   'nFile      输出文件，包含文件夹，如软件为 EXE扩展名，DLL为DLL扩展名，64位为 在 release64 路径里。
   
   Function = 0 
End Function

Sub WinThemeChange(nThemes As TYPE_THEMES) Export '窗口主题已经修改
   ThemeWin = nThemes
   
End Sub

Sub CodeThemeChange(nThemes As TYPE_THEMES) Export '代码主题已经修改
   ThemeCode = nThemes
   
End Sub

Function VisualFreeBasicClose(hWndForm As hWnd) As LResult Export
   'hWndForm   VFB 主窗口，来自 VFB_WM_Close 事件
   '即将关闭窗口，返回非0可阻止关闭  Return True
   
   Function =0 
End Function
#Define SCI_POSITIONFROMLINE                            2167
#Define SCI_GOTOPOS                                     2025
#Define SCI_SETSELECTIONSTART                           2142
#Define SCI_GETSELECTIONSTART                           2143
#Define SCI_GETSELECTIONEND                             2145
#Define SCI_SETCURRENTPOS                               2141
#Define SCI_SETANCHOR                                   2026
#Define SCI_REPLACESEL                                  2170
#Define SCI_GETTEXTRANGE                                2162
#Define SCI_GETLINEENDPOSITION                          2136
#Define SCI_LINEFROMPOSITION                            2166
#Define SCI_LINELENGTH                                  2350
#Define SCI_GETCOLUMN                                   2129
#Define SCI_GETLINE                                     2153
#Define SCI_GOTOLINE                                    2024
#Define SCI_GETLINECOUNT                                2154
#Define SCI_GETCURRENTPOS                               2008
#Define SCI_GETFIRSTVISIBLELINE                         2152
#Define SCI_SETTARGETSTART                              2190
#Define SCI_GETTARGETSTART                              2191
#Define SCI_SETTARGETEND                                2192
#Define SCI_GETTARGETEND                                2193
#Define SCI_REPLACETARGET                               2194
#Define SCI_SETFIRSTVISIBLELINE                         2613
#Define SCI_GETTABWIDTH                                 2121
#Define SCI_GETINDENT                                   2123
#Define SCI_SETSEL                                      2160
#Define SCI_LINEDELETE                                  2338
#Define SCI_ADDTEXT                                     2001



Function Code_IndentBlock(ByVal flagBlock As BOOLEAN) As Long  '缩进块 {2.True.False}
   Dim pSci As Any Ptr = GetCurrentSci()
   If pSci = 0 Then Return 1
   Dim i As Long        ' 循环计数器
   Dim startPos As Long        ' 起始位置
   Dim endPos As Long        ' 结束位置
   Dim startLine As Long        ' 起始行
   Dim endLine As Long        ' 结束行
   Dim nPos As Long        ' 位置
   Dim strText As String      ' 要替换的行部分
   Dim nLen As Long
   'flagBlock = True 块注释, False 取消块注释
   Code_GetSelectedLineRangeP(pSci ,startLine ,endLine ,startPos ,endPos)
   startPos = CodeEditMsg(pSci ,SCI_POSITIONFROMLINE ,startLine ,0)
   endPos = CodeEditMsg(pSci ,SCI_GETLINEENDPOSITION ,endLine ,0)
   Dim vfbOp As pezi Ptr = GetOpAPP()
   Dim spp As Long = vfbOp->TabSize
   If spp = 0 Then spp = 1
   'op.SuppressNotify = True
   For i = startLine To endLine
      Dim ss As String = Code_GetLineP(pSci ,i)
      If flagBlock = False Then   ' 取消块注释
         If Left(ss ,spp) = Space(spp) Then
            strText &= Mid(ss ,spp + 1) & vbCrLf
         Else
            strText &= LTrim(ss) & vbCrLf
         End If
      Else
         strText &= Space(spp) & ss & vbCrLf
      End If
   Next
   'op.SuppressNotify = False
   CodeEditMsg(pSci ,SCI_SETCURRENTPOS ,startPos ,0)    '选择位置
   CodeEditMsg(pSci ,SCI_SETANCHOR ,endPos ,0)  '结束选择
   i = Len(strText)
   If i > 1 Then strText = Left(strText ,i -2)
   CodeEditMsg(pSci ,SCI_REPLACESEL ,len(strText) ,Cast(lParam ,StrPtr(strText)))
   startPos = CodeEditMsg(pSci ,SCI_POSITIONFROMLINE ,startLine ,0)
   endPos = CodeEditMsg(pSci ,SCI_GETLINEENDPOSITION ,endLine ,0)
   CodeEditMsg(pSci ,SCI_SETCURRENTPOS ,endPos ,0)    '选择位置
   CodeEditMsg(pSci ,SCI_SETANCHOR ,startPos ,0)  '结束选择
   'CodeEditMsg(pSci, SCI_GOTOLINE, endLine, 0)
   Function = 0
End Function

Function Code_GetSelectedLineRangeP(pSci As Any Ptr ,ByRef startLine As Long ,ByRef endLine As Long ,ByRef startPos As Long ,ByRef endPos As Long) As Long ' 获取所选行范围 Pos是按utf8 算的字节数
   
   startPos = CodeEditMsg(pSci ,SCI_GETSELECTIONSTART ,0 ,0)
   endPos = CodeEditMsg(pSci ,SCI_GETSELECTIONEND ,0 ,0)
   startLine = CodeEditMsg(pSci ,SCI_LINEFROMPOSITION ,startPos ,0)
   endLine = CodeEditMsg(pSci ,SCI_LINEFROMPOSITION ,endPos ,0)
   
   Dim nCol As Long = CodeEditMsg(pSci ,SCI_GETCOLUMN ,endPos ,0)
   If (nCol = 0) And (endLine > startLine) Then endLine = endLine - 1
   
   Function = 0
End Function
Function Code_GetLineP(pSci As Any Ptr ,ByVal nLine As Long) As String '获取行文本，原文尾部带 13,10 ，已经消除
   Dim nLen As Long
   Dim buffer As String
   nLen = CodeEditMsg(pSci ,SCI_LINELENGTH ,nLine ,0)
   If nLen < 1 Then Exit Function
   buffer = Space(nLen)
   CodeEditMsg(pSci ,SCI_GETLINE ,nLine ,Cast(lParam ,StrPtr(buffer)))
   Function = RTrim(buffer ,Any Chr(13 ,10 ,0))
End Function
Function Code_BlockCommentP(ByVal flagBlock As BOOLEAN) As Long '块注释 {2.True.False}
   Dim pSci As Any Ptr = GetCurrentSci()
   If pSci = 0 Then Return 1
   Dim i          As Long   ' 循环计数器
   Dim startPos   As Long   ' 起始位置
   Dim endPos     As Long   ' 结束位置
   Dim startLine  As Long   ' 起始行
   Dim endLine    As Long   ' 结束行
   Dim nPos       As Long   ' 位置
   Dim strText    As String ' 要替换的行部分
   Dim nLen       As Long
   Dim LineText() As String
   
   'flagBlock = True 块注释, False 取消块注释
   Code_GetSelectedLineRangeP(pSci ,startLine ,endLine ,startPos ,endPos)
   startPos = CodeEditMsg(pSci ,SCI_POSITIONFROMLINE ,startLine ,0)
   endPos   = CodeEditMsg(pSci ,SCI_GETLINEENDPOSITION ,endLine ,0)
   'op.SuppressNotify = True
   ReDim LineText(startLine To endLine)
   Dim pp As UByte Ptr
   If flagBlock = False Then ' 取消块注释
      For i = startLine To endLine
         LineText(i) = Code_GetLineP(pSci ,i)
         If Len(LineText(i)) > 0 Then
            For ii As Long = 0 To Len(LineText(i)) -1
               pp = StrPtr(LineText(i))
               If pp[ii] = 39 Then ' 遇到注解
                  LineText(i) = Left(LineText(i) ,ii) & Mid(LineText(i) ,ii + 2)
                  Exit For
               ElseIf pp[ii] <> 32 And pp[ii] <> 9 Then
                  Exit For
               End If
            Next
         End If
      Next
   Else
      Dim nn As Long =99
      For i = startLine To endLine
         LineText(i) = Code_GetLineP(pSci ,i)
         If Len(LineText(i)) > 0 Then
            For ii As Long = 0 To Len(LineText(i)) -1
               pp = StrPtr(LineText(i))
               If pp[ii] <> 32 And pp[ii] <> 9 Then
                  if ii<nn Then nn=ii 
                  Exit For
               End If
            Next
         End If
      Next
      if nn = 99 Then nn = 0
      strText = Space(nn) & "'"
      nn+=1
      For i = startLine To endLine
         LineText(i) = strText & Mid(LineText(i),nn)
      Next      
      
   End If
   strText = FF_Join(LineText() ,vbCrLf)
   CodeEditMsg(pSci ,SCI_SETCURRENTPOS ,startPos ,0) '选择位置
   CodeEditMsg(pSci ,SCI_SETANCHOR ,endPos ,0)       '结束选择
   CodeEditMsg(pSci ,SCI_REPLACESEL ,len(strText) ,Cast(lParam ,StrPtr(strText)))
   CodeEditMsg(pSci ,SCI_GOTOLINE ,endLine ,0)
   Function = 0
End Function
Sub Code_DaiMaGeSiHua(aa As Long) '代码格式化
   Dim pSci As Any Ptr = GetCurrentSci()
   If pSci = 0 Then Return
   Dim As Long Y1 , Y2 , I ,p1,p2,x,y,f1,f2,sely,ifsel,ki
   Dim As String  b , bb , el() ,kt(2)={"PRIVATE ", "PUBLIC ","PROTECTED "}
   '类中用的属性  '类中用  '类中用
   'Type | Class | Union | Enum
   'End { Type | Class | Union | Enum }
   Dim As Long  startLine, endLine, startPos, endPos
   Code_GetSelectedLineRangeP(pSci, startLine, endLine, startPos, endPos)
   
   Select Case aa
      Case 0 '选择区
         
      Case 1 '当前过程
         Code_GetRunFenLine pSci, el(), startLine, y1, Y2
         
      Case 2 '全部
         Dim u As Long = CodeEditMsg(pSci, SCI_GETLINECOUNT, 0, 0)
         ReDim el(u)
         y1 = 0 : y2 = u -1
   End Select
   '开始格式化
   'SendDate(Str(y1+1) & "," &  Str(y2+1))
   Dim 上行是长行 As Long '表示上一行最后有 _ ，那本行是上行的续行
   Dim thel As String
   Dim vfbOp As pezi Ptr = GetOpAPP()
   Dim SuJin As Long = vfbOp->TabSize  '代码缩进量
   If SuJin < 1 Then SuJin = 1
   If SuJin > 10 Then SuJin = 10
   Dim tSuJin As Long = SuJin ' Int(SuJin / 2)  本来开始是半个TAB，暂时用全TAB数
   If tSuJin < 1 Then tSuJin = 1
   ReDim elto(y2 - y1) As String
   Dim eli As Long
   For i = y1 To y2
      If Len(el(i)) = 0 Then el(i) = Code_GetLineP(pSci, i)
      thel = Trim(el(i))
'      If Left(thel, 1) = "'" Then  '去除第1个为注解后的空格
'         If Len(thel) > 1 Then
'            For ki = 1 To Len(thel) -1
'               If thel[ki] <> 32 Then Exit For
'               thel[ki -1] = 32
'               thel[ki] = 39
'            Next
'            thel = LTrim(thel)
'         End If
'      End If
      If ifsel > 0 Then  'IF 长行
         bb = UCase(thel)
         thel = Space(ifsel) & thel
         
         bb = TiCuFeiDaiMa(bb)
         If xxLineNext(bb) = True Then '长行
            
         Else
            ifsel = 0
            If Right(bb, 5) = " THEN" Or bb = "THEN" Then p1 += SuJin : p2 = p1
         End If
      Else
         If sely > 0 Then ' FF 函数
            thel = Space(sely) & thel
            If InStr(thel, "_") = 0 Then sely = 0
            上行是长行 = 0
         Else
            thel = DaiMaMaiHua(thel) '代码美化
            bb = UCase(thel)
            bb = TiCuFeiDaiMa(bb)
            For ki = 0 To 2
               If Bijiao(bb, kt(ki)) Then
                  bb = Mid(bb, Len(kt(ki)) + 1)
                  Exit For
               End If
            Next         '
            If Bijiao(bb, "SUB ") Then
               if IsSubOK(bb) Then p2 += tSuJin
            ElseIf Bijiao(bb, "FUNCTION ") Then
               If Bijiao(bb, "FUNCTION =") = 0 Then
                  p2 += tSuJin
'                  If Right(bb, 3) = "( _" Then sely = Len(bb) - 3   '是FF产生的函数头参数表，不需要格式
               End If
            ElseIf Bijiao(bb, "PROPERTY ") Then
               If Bijiao(bb, "PROPERTY =") = 0 Then
                  p2 += tSuJin
               End If
            ElseIf Bijiao(bb, "OPERATOR ") Then
               If Bijiao(bb, "OPERATOR =") = 0 Then
                  p2 += tSuJin
               End If
            ElseIf Bijiao(bb, "DESTRUCTOR ") Then
               p2 += tSuJin
            ElseIf Bijiao(bb, "CONSTRUCTOR ") Then
               p2 += tSuJin
            ElseIf Bijiao(bb, "IF ") Then 'IF 特殊处理
               If xxLineNext(bb) = True Then '长行
                  ifsel = p1 + tSuJin
               Else
                  If Right(bb, 5) = " THEN" Then p2 += SuJin
               End If
            ElseIf Bijiao2(bb, "TYPE") Then
               If InStr(bb, " AS ") = 0 Then p2 += SuJin
            ElseIf Bijiao(bb, "SELECT ") Then
               p2 += SuJin * 2
            ElseIf Bijiao2(bb, "DO") Then
               p2 += SuJin
            ElseIf Bijiao2(bb, "SCOPE") Then
               p2 += SuJin
            ElseIf Bijiao2(bb, "ENUM") Then
               p2 += SuJin
            ElseIf Bijiao2(bb, "ASM") Then
               p2 += SuJin
            ElseIf Bijiao(bb, "FOR ") Then
               p2 += SuJin
            ElseIf Bijiao(bb, "WITH ") Then
               p2 += SuJin
            ElseIf Bijiao2(bb, "WHILE") Then
               p2 += SuJin
            ElseIf Bijiao(bb, "ELSEIF ") Then
               P1 -= SuJin : p2 = p1 + SuJin
            ElseIf Bijiao2(bb, "ELSE") Then
               P1 -= SuJin : p2 = p1 + SuJin
            ElseIf Bijiao2(bb, "CASE") Then
               P1 -= SuJin : p2 = p1 + SuJin
            ElseIf Bijiao2(bb, "ENDIF") Then
               P1 -= SuJin : p2 = p1
            ElseIf Bijiao2(bb, "LOOP") Then
               P1 -= SuJin : p2 = p1
            ElseIf Bijiao2(bb, "NEXT") Then
               P1 -= SuJin : p2 = p1
            ElseIf Bijiao2(bb, "END IF") Then
               P1 -= SuJin : p2 = p1
            ElseIf Bijiao2(bb, "END TYPE") Then
               P1 -= SuJin : p2 = p1
            ElseIf Bijiao2(bb, "END ENUM") Then
               P1 -= SuJin : p2 = p1
            ElseIf Bijiao2(bb, "END SCOPE") Then
               P1 -= SuJin : p2 = p1
            ElseIf Bijiao2(bb, "END SELECT") Then
               P1 -= SuJin * 2 : p2 = p1
            ElseIf Bijiao2(bb, "END SUB") Then
               P1 -= tSuJin : p2 = p1
            ElseIf Bijiao2(bb, "END FUNCTION") Then
               P1 -= tSuJin : p2 = p1
            ElseIf Bijiao2(bb, "END PROPERTY") Then
               P1 -= tSuJin : p2 = p1
            ElseIf Bijiao2(bb, "END DESTRUCTOR") Then
               P1 -= tSuJin : p2 = p1
            ElseIf Bijiao2(bb, "END OPERATOR") Then
               P1 -= tSuJin : p2 = p1
            ElseIf Bijiao2(bb, "END CONSTRUCTOR") Then
               P1 -= tSuJin : p2 = p1
            ElseIf Bijiao2(bb, "END WITH") Then
               P1 -= SuJin : p2 = p1
            ElseIf Bijiao2(bb, "END ASM") Then
               P1 -= SuJin : p2 = p1
            ElseIf Bijiao2(bb, "WEND") Then
               P1 -= SuJin : p2 = p1
            End If
            If p1 < 0 Then p1 = 0
            If Right(bb, 1) <> ":" Then
               If 上行是长行 = 0 Then
                  thel = Space(p1) & thel
               Else
                  thel = Space(p1 + SuJin) & thel
               End If
               
            End If
            p1 = p2
            If xxLineNext(bb) = True Then 上行是长行 = 1 Else 上行是长行 = 0
         End If
      End If
      elto(eli) = thel
      eli += 1
      'If el(i) <> thel Then
      'Dim nPos As Long = CodeEditMsg(pSci, SCI_POSITIONFROMLINE, i, 0)   ' 起始位置 行
      'CodeEditMsg(pSci, SCI_SETTARGETSTART, nPos, 0)    '选择位置
      'CodeEditMsg(pSci, SCI_SETTARGETEND, nPos + Len(el(i)), 0)  '结束选择
      'CodeEditMsg(pSci, SCI_REPLACETARGET, Len(thel), Cast(lParam, StrPtr(thel)))
      '
      'End If
   Next
   '智能对齐 -----------------------
   智能对齐(elto())
   
   thel = FF_Join(elto(), vbCrLf)
   Dim nPos As Long = CodeEditMsg(pSci, SCI_GETCURRENTPOS, 0, 0)
   Dim nPos2 As Long = CodeEditMsg(pSci, SCI_GETFIRSTVISIBLELINE, 0, 0)
   CodeEditMsg(pSci, SCI_SETTARGETSTART, CodeEditMsg(pSci, SCI_POSITIONFROMLINE, y1, 0), 0)    '选择位置
   CodeEditMsg(pSci, SCI_SETTARGETEND, CodeEditMsg(pSci, SCI_GETLINEENDPOSITION, y2, 0), 0)  '结束选择
   CodeEditMsg(pSci, SCI_REPLACETARGET, Len(thel), Cast(lParam, StrPtr(thel)))
   CodeEditMsg(pSci, SCI_GOTOPOS, nPos, 0)
   CodeEditMsg(pSci, SCI_SETFIRSTVISIBLELINE, nPos2, 0)
   
   
End Sub
Sub Code_GetRunFenLine(pSci As Any Ptr, el() As String, startLine As Long, ByRef Y1 As Long, ByRef Y2 As Long) '寻找当前 函数或过程 范围，返回 行号
   Dim As Long I ,p1,p2,f1,f2,ki ,uu
   Dim As String  b , bb  ,kt(2)={"PRIVATE ", "PUBLIC ","PROTECTED "},ksu(4)={"FUNCTION ","SUB ","PROPERTY " ,"DESTRUCTOR " ,"CONSTRUCTOR "}
   uu = CodeEditMsg(pSci, SCI_GETLINECOUNT, 0, 0)   '返回文档中的行数。空文档包含1行。仅包含行结束序列的文档有2行。
   ReDim el(uu)  ' 原文内容
   Dim ji As Long
   y1 = -1
   For i = startLine To 0 Step -1
      ji += 1
      if ji > 999 Then Exit for
      el(i) = Code_GetLineP(pSci, i)
      b = UCase(Trim(el(i))) 'b = UCase(Trim(el(i)))
      Do Until(InStr(b, "  ") = 0)
         b = YF_Replace(b, "  ", " ")
      Loop
      For ki = 0 To 2
         If Bijiao(b, kt(ki)) Then
            b = Mid(b, Len(kt(ki)) + 1)
            Exit For
         End If
      Next
      For ki = 0 To 4
         If Bijiao(b, ksu(ki)) Then
            If ki = 0 Then
               If Bijiao(b, "FUNCTION =") = 0 Then
                  y1 = i
                  b = "END FUNCTION"
                  Exit For, For
               End If
            Else
               if IsSubOK(b) Then
                  y1 = i
                  b = "END " & Trim(ksu(ki))
                  Exit For, For
               End if
            End If
         End If
      Next
   Next i
   If y1 = -1 Then
      For i = 0 To uu -1 ' UBound(el)
         If Len(el(i)) = 0 Then el(i) = Code_GetLineP(pSci, i)
         b = UCase(Trim(el(i))) 'b = UCase(Trim(el(i)))
         Do Until(InStr(b, "  ") = 0)
            b = YF_Replace(b, "  ", " ")
         Loop
         For ki = 0 To 2
            If Bijiao(b, kt(ki)) Then
               b = Mid(b, Len(kt(ki)) + 1)
               Exit For
            End If
         Next
         For ki = 0 To 4
            If Bijiao(b, ksu(ki)) Then
               If ki = 0 Then
                  If Bijiao(b, "FUNCTION =") = 0 Then
                     y1 = i
                     Exit For, For
                  End If
               Else
                  y1 = i
                  Exit For, For
               End If
            End If
         Next
      Next
      If y1 = -1 Then
         y1 = 0 : y2 = 0
      Else
         y2 = y1 -1 : y1 = 0
      End If
   Else
      For i = startLine To uu -1 ' UBound(el)
         If Len(el(i)) = 0 Then el(i) = Code_GetLineP(pSci, i)
         bb = UCase(Trim(el(i))) 'b = UCase(Trim(el(i)))
         If Left(bb, 4) = "END " Then '预防中间空格太多，没查到结束
            Do
               If InStr(bb, "  ") = 0 Then Exit Do
               bb = YF_Replace(bb, "  ", " ")
            Loop
            f1 = InStr(bb, "'")
            If f1 > 0 Then
               bb = Left(bb, f1 -1)
               bb = Trim(bb)
            End If
         End If
         If bb = b Then y2 = i : Exit For '完成查找
      Next
      If y2 < y1 Then y2 = uu -1
   End If
End Sub
Function TiCuFeiDaiMa(ByVal bb As String) As String  '剔除非代码，如 引号内和注释
   Dim F1 As Long, F2 As Long
   Do Until(InStr(bb, "  ") = 0)
      bb = YF_Replace(bb, "  ", " ")
   Loop
   Do '剔除 ""
      f1 = InStr(bb, """")
      If f1 = 0 Then Exit Do
      f2 = InStr(f1 + 1, bb, """")
      If f2 = 0 Then f2 = Len(bb)
      bb = Mid(bb, 1, f1 - 1) & Mid(bb, f2 + 1)
   Loop
   f1 = InStr(bb, "'")
   If f1 > 0 Then bb = Mid(bb, 1, f1 - 1)
   f1 = InStr(bb, "REM ")
   If f1 > 0 Then bb = Mid(bb, 1, f1 - 1)
   
   Function = Trim(bb)
End Function
Function xxLineNext(Lstr As String) As BOOLEAN  '判断是不是长行 ，判断前，必须先处理代码为无注解，无字符串代码
   Dim LL As Long
   LL = Len(Lstr)
   If LL > 1 Then
      LL -= 1
      If Lstr[LL] = 95 Then  '"_"可能是续行符
         LL -= 1
         If Lstr[LL] = 32 Then ' " "
            Return True
         Else
            Do
               If LL < 0 Then Exit Do
               If InStr("1234567890", Chr(Lstr[LL])) > 0 Then
                  
               Else
                  If InStr("""~^([{|,.;'!@$%&?=)*+-/]}\<>: ", Chr(Lstr[LL])) Then
                     Return True
                  Else
                     Return 0
                  End If
               End If
               LL -= 1
            Loop
         End If
      End If
   End If
End Function
Function DaiMaMaiHua(DaiMa As String) As String '代码美化
   Dim As String yStr ,mStr ,tStr
   Dim As Long i      ,u1   ,u2 ,aa ,yin ,ii ,cc
   If Len(DaiMa) = 0 Then Exit Function

   yStr = LTrim(DaiMa)
   
   '检查是不是FF产生的事件代码参数列表，如果是就不处理 (作废，不再使用FF)
   'mStr = UCase(yStr)
   'If Left(mStr ,6) = "BYREF " Or Left(mStr ,6) = "BYVAL " Then mStr = LTrim(Mid(mStr ,7))
   'ii = InStr(mStr ," ")
   'If ii > 0 Then
   'mStr = LTrim(Mid(mStr ,ii + 1))
   'If Left(mStr ,3) = "AS " Then Return DaiMa
   'End If
   
   cc   = Len(DaiMa) - Len(yStr)
   mStr = String(Len(ystr) * 2 ,32)
   '后面无空格-----------------------------------------
   u1 = Len(yStr)
   u2 = 0
   For i = 0 To u1 - 1
      If yin     = 2 Then '注解状态
      ElseIf yin = 1 Then ' " 号状态
         If yStr[i] = 34 Then yin = 0
      Else
         Select Case yStr[i]
            Case 34 ' " 号
               yin = 1
            Case 39 ' 注解
               yin = 2
            Case 32
               If aa = 40 Or aa = 46 Or aa = 91 Or aa = 123 Or aa = 64 Or aa = 44 Then Continue For '遇到 ( [ { . @  ,
               If aa = 33 Or aa = 35 Or aa = 36 Then '! # $
                  If u2 > 1 Then
                     If mStr[u2 - 2] < 48 Or mStr [u2 - 2] > 57 Then Continue For
                  End If
               ElseIf aa = 62 And u2 > 1 Then ' >
                  If mStr[u2 - 2] = 45 Then Continue For ' -
               End If
               
         End Select
      End If
      mStr[u2] = yStr[i]
      aa       = yStr[i]
      u2       += 1
   Next
   
   '前面无空格-----------------------------------------
   yStr = Left(mStr ,u2)
   mStr = String(Len(ystr) * 2 ,32)
   u1   = Len(yStr)
   u2   = 0 : yin = 0
   For i = 0 To u1 - 1
      If yin     = 2 Then '注解状态
      ElseIf yin = 1 Then ' " 号状态
         If yStr[i] = 34 Then yin = 0
      Else
         Select Case yStr[i]
            Case 34 ' " 号
               yin = 1
            Case 39 ' 注解
               yin = 2
            Case 41 ,93 ,125 ,46 ,40 ,44 '遇到 ）] } . (
               If u2 > 0 Then
                  For ii = u2 - 1 To 0 Step - 1
                     If mStr[ii] <> 32 Then Exit For
                     u2 -= 1
                  Next
               End If
            Case 45 ' -
               If i < u1 - 1 Then
                  If yStr[i + 1] = 62 Then '->
                     If u2 > 0 Then
                        For ii = u2 - 1 To 0 Step - 1
                           If mStr[ii] <> 32 Then Exit For
                           u2 -= 1
                        Next
                     End If
                     
                  End If
               End If
               
         End Select
      End If
      mStr[u2] = yStr[i]
      u2       += 1
   Next
   '-----------------------------------------
   yStr = Left(mStr ,u2)
   mStr = String(Len(ystr) * 2 ,32)
   u1   = Len(yStr)
   u2   = 0 : aa = 0 : yin = 0
   For i = 0 To u1 - 1
      If yin = 2 Then                 '注解状态
         mStr[u2] = yStr[i]
         u2       += 1
      ElseIf yin = 1 Then ' " 号状态
         If yStr[i] = 34 Then yin = 0
         mStr[u2] = yStr[i]
         u2       += 1
      Else
         Select Case UCase(Mid(yStr ,i + 1 ,2))
            Case "&=" ,"+=" ,"-=" ,"*=" ,"\=" ,"/=" ,"^=" ,"<>" ,"<=" ,">="
               '清除前面多余的空格
               If u2 > 0 Then
                  For ii = u2 - 1 To 0 Step - 1
                     If mStr[ii] <> 32 Then Exit For
                     u2 -= 1
                  Next
               End If
               mStr[u2] = 32
               U2       += 1
               mStr[u2] = yStr[i]
               U2       += 1 : i += 1
               mStr[u2] = yStr[i]
               U2       += 1
               mStr[u2] = 32
               U2       += 1
               '清除后面多余的空格
               If i < u1 - 1 Then
                  For ii = i + 1 To u1 - 1
                     If yStr[ii] <> 32 Then Exit For
                     i = ii
                  Next
               End If
               Continue For
            Case "->" ,"-&"       '不处理的
               mStr[u2] = yStr[i]
               U2       += 1 : i += 1
               mStr[u2] = yStr[i]
               U2       += 1
               Continue For
            Case "&B"      '不处理的
               mStr[u2] = yStr[i]
               U2       += 1 : i += 1
               mStr[u2] = 66 'B 给大写
               U2       += 1
               Continue For
            Case "&O"       '不处理的
               mStr[u2] = yStr[i]
               U2       += 1 : i += 1
               mStr[u2] = 79 'O 给大写 yStr[i]
               U2       += 1
               Continue For
            Case "&H"       '不处理的
               mStr[u2] = yStr[i]
               Dim ee As UByte
               For ii = i + 1 To u1 - 1  '将后面全部字符变为大写
                  U2 += 1 : i += 1
                  ee = yStr[i]
                  If (ee > 96 And ee < 103) Or ee = 104 Then ee -= 32 'abcdefh
                  if InStr("0123456789ABCDEFH" ,Chr(ee)) = 0 Then ' ee <> 72 And (ee < 48 Or ee > 57) Then  '
                     mStr[u2] = ee
                     exit for
                  End if
                  mStr[u2] = ee
               Next
         End Select
         
         Select Case yStr[i]
            Case 34 ' " 号
               yin = 1
            Case 39 ' 注解
               If u2 > 0 Then
                  For ii = u2 - 1 To 0 Step - 1
                     If mStr[ii] <> 32 Then Exit For
                     u2 -= 1
                  Next
                  If mStr[u2 - 1] <> 32 Then ' ’前必须有个空格
                     mStr[u2] = 32
                     U2       += 1
                  End If
               End If
               yin = 2
            Case 44 ' ,
               If u2 > 0 Then
                  If mStr[u2 - 1] <> 32 Then ' ’前必须有个空格
                     mStr[u2] = 32
                     U2       += 1
                  End If
               End If
            Case 32 '遇到 空
               Dim tt As Long
               If i < u1 - 1 Then
                  For ii = i + 1 To u1 - 1
                     If yStr[ii] <> 32 Then
                        If tt > 0 Then
                           Dim i3 As Long
                           If yStr[ii] = 39 Then ' 单引号和 _ 长行
                              For i3 = 1 To tt
                                 mStr[u2] = 32
                                 U2       += 1
                                 i        += 1
                              Next
                           Else
                              i += tt
                           End If
                        End If
                        Exit For
                     End If
                     tt += 1
                  Next
                  
               End If
            Case 40 '遇到  (
               '提取关键词
               If i > 0 Then
                  For ii = i - 1 To 0 Step - 1
                     If yStr[ii] = 32 Then Exit For
                  Next
                  tStr = Mid(yStr ,ii + 2 ,i - ii - 1)
                  aa   = 0
                  Select Case UCase(tStr)
                     Case "ANDALSO" ,"ORELSE" ,"CONST" ,"CASE" ,"EXIT" ,"ELSEIF" ,"ENUM" ,"MOD=" ,"AND=" ,"EQV=" ,"IMP=" ,"SHL=" ,"SHR=" ,"XOR=" ,"WHILE"
                        aa = 1
                     Case "END" ,"FOR" ,"MOD" ,"SHL" ,"SHR" ,"AND" ,"EQV" ,"IMP" ,"NOT" ,"XOR" ,"DIM" ,"VAR" ,"OR="
                        aa = 1
                     Case "DO" ,"OR" ,"OR" ,"IS" ,"IF" ,"TO" ,"AS"
                        aa = 1
                  End Select
                  If aa = 1 Then   ' 只消后面多余空空
                     mStr[u2] = 32
                     U2       += 1
                     If yStr[i] = 40 Then
                        mStr[u2] = 40
                        U2       += 1
                        
                     End If
                     '清除后面多余的空格
                     If i < u1 - 1 Then
                        For ii = i + 1 To u1 - 1
                           If yStr[ii] <> 32 Then Exit For
                           i = ii
                        Next
                     End If
                     Continue For
                  End If
               End If
            Case 45 ' - 什么情况下是  负，什么情况是 减号，
               '清除前面多余的空格
               If u2 > 0 Then
                  For ii = u2 - 1 To 0 Step - 1
                     If mStr[ii] <> 32 Then Exit For
                     u2 -= 1
                  Next
               End If
               mStr[u2] = 32
               U2       += 1
               mStr[u2] = yStr[i]
               u2       += 1
               If i < u1 - 1 Then
                  If yStr[i + 1] < 48 Or yStr[i + 1] > 57 Then '不是数字，表示 减号
                     mStr[u2] = 32
                     U2       += 1
                     For ii = i + 1 To u1 - 1
                        If yStr[ii] <> 32 Then Exit For
                        i = ii
                     Next
                  End If
               End If
               Continue For
            Case 42 ' * 什么情况下是  取值，什么情况是 乘，
               '清除前面多余的空格
               If u2 > 0 Then
                  For ii = u2 - 1 To 0 Step - 1
                     If mStr[ii] <> 32 Then Exit For
                     u2 -= 1
                  Next
               End If
               mStr[u2] = 32
               U2       += 1
               mStr[u2] = yStr[i]
               u2       += 1
               If i < u1 - 1 Then
                  Select Case yStr[i + 1]
                     Case Is > 126
                     Case 97 To 122
                     Case 65 To 90
                     Case Else '不是有效语句名称，表示 取值
                        mStr[u2] = 32
                        U2       += 1
                        For ii = i + 1 To u1 - 1
                           If yStr[ii] <> 32 Then Exit For
                           i = ii
                        Next
                  End Select
               End If
               Continue For
            Case 61 ,43 ,47 ,92 ,94 ,58 ,60 ,62 '= + / \ ^ *  < >  ,44
               '清除前面多余的空格
               If u2 > 0 Then
                  For ii = u2 - 1 To 0 Step - 1
                     If mStr[ii] <> 32 Then Exit For
                     u2 -= 1
                  Next
               End If
               Dim kon As Long ,ss As String
               Select Case yStr[i]
                  Case 61  '=号前不需要空格的
                     If u2 > 0 Then
                        Dim pp As Long
                        For ii = u2 - 1 To 0 Step - 1
                           If mStr[ii] = 32 Then
                              pp = ii + 1
                              Exit For
                           End If
                        Next
                        pp += 1
                        ss = Mid(mStr ,pp ,u2 - pp + 1)
                        Select Case UCase(ss)
                           Case "&" ,"+" ,"-" ,"*" ,"/" ,"\" ,"^" ,">" ,"<" , _
                                 "MOD" ,"AND" ,"EQV" ,"IMP" ,"OR" ,"XOR" ,"SHL" ,"SHR"
                              kon = Len(ss)
                        End Select
                     End If
                  Case 62  ' >
                     If u2 > 0 Then
                        If mStr[u2 -1] = 60 Or mStr[u2 - 1] = 45 Then
                           kon = 1   ' <> ->
                           ss  = Chr(mStr[u2 -1])
                        End If
                     End If
               End Select
               
               If kon = 0 Then  '遇到不需要空格的
                  mStr[u2] = 32
                  U2       += 1
               Else
                  If u2 - kon > 0 Then  '将与 = 号组合的赋值语句前面的空格全部清除
                     For ii = u2 - kon -1 To 0 Step - 1
                        If mStr[ii] <> 32 Then Exit For
                        u2 -= 1
                     Next
                     u2       -= kon
                     mStr[u2] = 32
                     U2       += 1
                     For ii = 0 To kon -1
                        mStr[u2] = ss[ii]
                        U2       += 1
                     Next
                     
                  End If
               End If
               mStr[u2] = yStr[i]
               u2       += 1
               mStr[u2] = 32
               U2       += 1
               '清除后面多余的空格
               If i < u1 - 1 Then
                  For ii = i + 1 To u1 - 1
                     If yStr[ii] <> 32 Then Exit For
                     i = ii
                  Next
               End If
               Continue For
            Case 38 ', &
               mStr[u2] = yStr[i]
               u2       += 1
               mStr[u2] = 32
               U2       += 1
               '清除后面多余的空格
               If i < u1 - 1 Then
                  For ii = i + 1 To u1 - 1
                     If yStr[ii] <> 32 Then Exit For
                     i = ii
                  Next
               End If
               Continue For
            Case 95 ' _ 长行
               If u2 > 0 Then
                  Select Case mStr[u2 - 1]
                     Case 32 ,95
                     Case 48 To 57
                     Case 65 To 90
                     Case 97 To 122
                     Case Is > 122
                     Case Else
                        mStr[u2] = 32
                        U2       += 1
                  End Select
               End If
               
         End Select
         mStr[u2] = yStr[i]
         u2       += 1
      End If
   Next
   Function = Space(cc) & Left(mStr ,u2)
End Function
Function Bijiao(aa As String, bb As String ) As Long '比较
   Function = Left(aa, Len(bb)) = bb
End Function
Function Bijiao2(aa As String,bb As String  ) As Long '比较
  Dim cc As Long,ee As String
  If aa=bb Then
      cc=1
  Else
      ee=Left(aa,Len(bb)+1)
      If ee=bb & " " Then
          cc=1
      ElseIf ee=bb & "'" Then
          cc=1
      ElseIf ee=bb & "(" Then
          cc=1
      End If
  End If
  Function = cc
End Function
Function IsSubOK(ubb As String ) As Long  '判断是不是 Sub 语句，还是 汇编里的 SUB ,参数要大写
   Dim a As Long = InStr(ubb, "(")
   Dim b As Long = InStr(ubb, ",")
   if a = 0 And b > 0 Then Return 0
   Return 1
End Function
Function Code_GetCurrentLineNumberP(pSci As Any Ptr) As Long  '' 获取当前行号
   Dim nPos As Long = CodeEditMsg(pSci, SCI_GETCURRENTPOS, 0, 0)
   Function = CodeEditMsg(pSci, SCI_LINEFROMPOSITION, nPos, 0)
   
End Function

Sub DaiMaZiDonMeiHua(pSci As Any Ptr ,clh As Long) '代码自动美化
   '代码自动美化
   
   Dim As String el ,bb
   Dim As Long   ki ,p2 ,i
   
   If clh < 0 Or clh + 1 >= CodeEditMsg(pSci ,SCI_GETLINECOUNT ,0 ,0) Then Exit Sub
   Dim vfbOp As pezi Ptr = GetOpAPP()
   Dim SuJin As Long     = vfbOp->TabSize  '代码缩进量
   If SuJin < 1  Then SuJin = 1
   If SuJin > 10 Then SuJin = 10
   Dim tSuJin As Long = SuJin  ' Int(SuJin / 2)
   If tSuJin < 1 Then tSuJin = 1
   If clh > 0    Then '检查出上1行的缩进情况和需要下一行的
      Dim dstr As String
      Dim ji As Long
      For i = clh -1 To 0 Step -1
         ji += 1
         if ji > 999 Then Exit for
         dstr = Code_GetLineP(pSci ,i)
         If Len(Trim(dstr)) > 0 Then Exit For
      Next
      If i < 0 Then
         p2 = 0
      Else
         el = LTrim(dstr)
         p2 = Len(dstr) - Len(el)
         el = Trim(el)
         bb = UCase(el)
         bb = TiCuFeiDaiMa(bb)
         If Right(bb ,1) = ":" Then
            p2 += tSuJin
         ElseIf bb = ") AS LONG" Then ' 是FF产生的函数头参数表，不需要格式
            p2 = tSuJin
         ElseIf bb = ")AS LONG" Then ' 是FF产生的函数头参数表，不需要格式
            p2 = tSuJin
         ElseIf Bijiao(bb ,"SUB ") Then
            if IsSubOK(bb) Then p2 += tSuJin
         ElseIf Bijiao(bb ,"FUNCTION ") Then
            If Bijiao(bb ,"FUNCTION =") = 0 Then
               p2 += tSuJin
            End If
         ElseIf Bijiao(bb ,"PROPERTY ") Then
            p2 += tSuJin
            If Bijiao(bb ,"PROPERTY =") = 0 Then
               p2 += tSuJin
            End If            
         ElseIf Bijiao(bb ,"OPERATOR ") Then
            If Bijiao(bb ,"OPERATOR =") = 0 Then
               p2 += tSuJin
            End If
         ElseIf Bijiao(bb ,"DESTRUCTOR ") Then
            p2 += tSuJin
         ElseIf Bijiao(bb ,"CONSTRUCTOR ") Then
            p2 += tSuJin
         ElseIf Bijiao(bb ,"IF ") Then 'IF 特殊处理
            If Right(bb ,5) = " THEN" Then p2 += SuJin
         ElseIf Bijiao2(bb ,"TYPE") Then
            If InStr(bb ," AS ") = 0 Then p2 += SuJin
         ElseIf Bijiao(bb ,"SELECT ") Then
            p2 += SuJin * 2
         ElseIf Bijiao2(bb ,"DO") Then
            p2 += SuJin
         ElseIf Bijiao2(bb ,"ENUM") Then
            p2 += SuJin
         ElseIf Bijiao2(bb ,"SCOPE") Then
            p2 += SuJin
         ElseIf Bijiao2(bb ,"ASM") Then
            p2 += SuJin
         ElseIf Bijiao(bb ,"FOR ") Then
            p2 += SuJin
         ElseIf Bijiao(bb ,"WITH ") Then
            p2 += SuJin
         ElseIf Bijiao2(bb ,"WHILE") Then
            p2 += SuJin
         ElseIf Bijiao(bb ,"ELSEIF ") Then
            p2 += SuJin
         ElseIf Bijiao2(bb ,"ELSE") Then
            p2 += SuJin
         ElseIf Bijiao2(bb ,"CASE") Then
            p2 += SuJin
         End If
      End If
   End If
   Dim zz  As String = Code_GetLineP(pSci ,clh)
   Dim szz As String = zz
   zz = DaiMaMaiHua(zz)
   If p2 <> -1 Then
      el = Trim(zz)
      bb = UCase(el)
      bb = TiCuFeiDaiMa(bb)
      If Bijiao(bb ,"FUNCTION ") Then
         If Bijiao(bb ,"FUNCTION =") = 0 Then
            p2 = 0
         End If
      ElseIf Bijiao(bb ,"ELSEIF ") Then
         p2 -= SuJin
      ElseIf Bijiao2(bb ,"ELSE") Then
         p2 -= SuJin
      ElseIf Bijiao2(bb ,"CASE") Then
         p2 -= SuJin
      ElseIf Bijiao2(bb ,"ENDIF") Then
         p2 -= SuJin
      ElseIf Bijiao2(bb ,"LOOP") Then
         p2 -= SuJin
      ElseIf Bijiao2(bb ,"NEXT") Then
         p2 -= SuJin
      ElseIf Bijiao2(bb ,"END IF") Then
         p2 -= SuJin
      ElseIf Bijiao2(bb ,"END ASM") Then
         p2 -= SuJin
      ElseIf Bijiao2(bb ,"END TYPE") Then
         p2 -= SuJin
      ElseIf Bijiao2(bb ,"END SCOPE") Then
         p2 -= SuJin
      ElseIf Bijiao2(bb ,"END SELECT") Then
         p2 -= SuJin * 2
      ElseIf Bijiao2(bb ,"END SUB") Then
         p2 = 0
      ElseIf Bijiao2(bb ,"END FUNCTION") Then
         p2 = 0
      ElseIf Bijiao2(bb ,"END OPERATOR") Then
         p2 = 0
      ElseIf Bijiao2(bb ,"END PROPERTY") Then
         p2 = 0
      ElseIf Bijiao2(bb ,"END DESTRUCTOR") Then
         p2 = 0
      ElseIf Bijiao2(bb ,"END CONSTRUCTOR") Then
         p2 = 0
      ElseIf Bijiao2(bb ,"END WITH") Then
         p2 -= SuJin
      ElseIf Bijiao2(bb ,"WEND") Then
         p2 -= SuJin
      End If
      If p2 < 0 Then p2 = 0
      zz = Space(p2) & LTrim(zz)
   End If
   If zz <> szz Then Code_SetLineP(pSci ,clh ,zz)
   
End Sub
Function Code_SetLineP(pSci As Any Ptr, ByVal nLineNum As Long, ByVal sText As String) As Long '设置行文本
   Dim nStartPos As Long = CodeEditMsg(pSci, SCI_POSITIONFROMLINE, nLineNum, 0)
   Dim nEndPos   As Long = CodeEditMsg(pSci, SCI_GETLINEENDPOSITION, nLineNum, 0)
   CodeEditMsg(pSci, SCI_SETTARGETSTART, nStartPos, 0)
   CodeEditMsg(pSci, SCI_SETTARGETEND, nEndPos, 0)
   Function = CodeEditMsg(pSci, SCI_REPLACETARGET, Len(sText), Cast(lParam, StrPtr(sText)))
End Function
Function CanCompleteBlockStatement(ByVal pSci As Any Ptr ,ByVal idBlockType As Long ,ByVal nStartLine As Long) As boolean
   Dim vfbOp As pezi Ptr = GetOpAPP()
   If vfbOp->AutoComplete = False Then Return False
   
   Dim As Long NumLines, nLenMatch
   Dim As String sStartMatch, sEndMatch, sLine
   
   '为短语添加一个唯一的终止分隔符，以便以后更容易匹配仅包含匹配的结束短语且没有后续空格字符的行（即，它们单独存在于该行上）。
   '该算法需要搜索匹配的结束短语，但是如果它首先找到块类型的匹配开始短语
   Select Case idBlockType
      Case BLOCK_STATEMENT_IF          : sStartMatch = "IF "     : sEndMatch = "END IF|"
      Case BLOCK_STATEMENT_FOR         : sStartMatch = "FOR "    : sEndMatch = "NEXT|"
      Case BLOCK_STATEMENT_SELECT      : sStartMatch = "SELECT " : sEndMatch = "END SELECT|"
      Case BLOCK_STATEMENT_WHILE       : sStartMatch = "WHILE "  : sEndMatch = "WEND|"
      Case BLOCK_STATEMENT_DO          : sStartMatch = "DO "     : sEndMatch = "LOOP|"
      Case BLOCK_STATEMENT_FUNCTION    : sStartMatch = ""        : sEndMatch = "END FUNCTION|"
      Case BLOCK_STATEMENT_SUB         : sStartMatch = ""        : sEndMatch = "END SUB|"
      Case BLOCK_STATEMENT_PROPERTY    : sStartMatch = ""        : sEndMatch = "END PROPERTY|"
      Case BLOCK_STATEMENT_TYPE        : sStartMatch = "TYPE "   : sEndMatch = "END TYPE|"
      Case BLOCK_STATEMENT_WITH        : sStartMatch = "WITH "   : sEndMatch = "END WITH|"
      Case BLOCK_STATEMENT_ENUM        : sStartMatch = "ENUM "   : sEndMatch = "END ENUM|"
      Case BLOCK_STATEMENT_UNION       : sStartMatch = "UNION "  : sEndMatch = "END UNION|"
      Case BLOCK_STATEMENT_CONSTRUCTOR : sStartMatch = ""        : sEndMatch = "END CONSTRUCTOR|"
      Case BLOCK_STATEMENT_DESTRUCTOR  : sStartMatch = ""        : sEndMatch = "END DESTRUCTOR|"
   End Select
   
   NumLines   = CodeEditMsg(pSci ,SCI_GETLINECOUNT ,0 ,0)
   nStartLine = nStartLine + 1
   Dim ji As Long
   For i  As Long = nStartLine To NumLines - 1
      '这一行是否以我们正在寻找的匹配短语开头？
      ji += 1
      if ji > 999 Then Exit for
      sLine = UCase(LTrim(Code_GetLineP(pSci ,i)))
      
      nLenMatch = Len(sStartMatch)
      If nLenMatch Then
         If sStartMatch = Mid(sLine ,1 ,nLenMatch) Then
            Return True    ' 在找到匹配结束之前找到了一个起始块。
         End If
      End If
      
      nLenMatch = Len(sEndMatch)
      If nLenMatch Then
         If sEndMatch = Mid(sLine ,1 ,nLenMatch -1) & "|" Then
            Return False    ' 块语句的匹配结束已存在
         End If
      End If
      
      '如果我们找到另一个块语句结构的开头并允许插入，则停止搜索。
      If (idBlockType <> BLOCK_STATEMENT_FUNCTION) And (idBlockType <> BLOCK_STATEMENT_SUB) Then
         If Left(sLine ,3) = "IF "     Then Return True
         If Left(sLine ,4) = "FOR "    Then Return True
         If Left(sLine ,3) = "DO "     Then Return True
         If Left(sLine ,7) = "SELECT " Then Return True
         If Left(sLine ,6) = "WHILE "  Then Return True
      End If
      If Left(sLine ,9) = "FUNCTION " Then
         If InStr(10 ,sLine ,"=") = 0 Then Return True
      End If
      If Left(sLine ,4)  = "SUB " AndAlso IsSubOK(sLine) <> 0 Then Return True
      If Left(sLine ,17) = "PRIVATE FUNCTION " Then Return True
      If Left(sLine ,16) = "PUBLIC FUNCTION "  Then Return True
      If Left(sLine ,12) = "PRIVATE SUB "      Then Return True
      If Left(sLine ,11) = "PUBLIC SUB "       Then Return True
      If Left(sLine ,9)  = "PROPERTY "         Then Return True
      If Left(sLine ,6)  = "UNION "            Then Return True
      If Left(sLine ,5)  = "ENUM "             Then Return True
   Next
   
   '默认我们可以允许插入
   Function = True
End Function
Sub 智能对齐(elto() As String)
   Dim xElto() As String ,uxElto() As String ,cElto() As Long
   Dim uu      As Long = UBound(elto)
   if uu < 1 Then Return
   ReDim xElto(uu ,29) ,uxElto(uu ,29) ,cElto(uu ,29) '按照空格分离，最多30个
   Dim As Long I       ,ti             ,ei ,cc ,yh ,ci ,mm ,ku
   Dim by As UByte Ptr                     ,tStr As String
   '分隔字符
   For i = 0 To uu  '按照空格分离，多个或1个空格都为1个
      ci = 1 '字符开始位置
      ti = 0 '开始索引
      yh = 0 '引号状态，处于引号状态就停止处理
      mm = 0 '初次遇到非空格就跳过
      cc = Len(elto(i))
      ku = 0 '括号状态，() 里就当成一个整体
      if cc = 0 Then Continue For
      by = StrPtr(elto(i))
      For ei = 0 To cc -1
         select case by[ei]
            Case 39 ' ' 遇到注解就结束
               if yh     Then Continue For
               if ei = 0 Then '第1个字符就是 注解
                  xElto(i ,ti)  = elto(i)
                  uxElto(i ,ti) = "'"  '第1个字符，用于对比
               Else
                  tStr = Mid(elto(i) ,ci ,ei + 1 - ci)
                  if ti > 0 AndAlso UCase(Left(tStr ,4)) = "PTR " Then '属于前面的整体
                     xElto(i ,ti -1) &= tStr
                  Else
                     xElto(i ,ti)  = tStr
                     uxElto(i ,ti) = 获取特定对齐字符(tStr)
                     ti            += 1
                  End if
                  xElto(i ,ti)  = Mid(elto(i) ,ei + 1)
                  uxElto(i ,ti) = "'"  '第1个字符，用于对比
               End if
               ci = cc + 1  '表示后面都提取
               Exit For
            Case 32
               if yh <> 0 Or ku > 0 Then Continue For
               if mm = 2            Then mm = 1 '解除字符状态
            Case Else '非空格就。。。
               'if ei =0 Then mm =2 '第1个不是空格
               if mm = 0 Then
                  mm = 2
               ElseIf mm = 2 Then
                  '字符状态
               Else
                  if yh = 0 Then '非引号状态
                     tStr = Mid(elto(i) ,ci ,ei + 1 - ci)
                     if ti > 0 AndAlso UCase(Left(tStr ,4)) = "PTR " Then '属于前面的整体
                        xElto(i ,ti -1) &= tStr
                     Else
                        xElto(i ,ti)  = tStr
                        uxElto(i ,ti) = 获取特定对齐字符(tStr)
                        ti            += 1
                     End if
                     ci = ei + 1
                     
                     if ti = 29 Then '超过太多，就结束
                        tStr = Mid(elto(i) ,ci)
                        if ti > 0 AndAlso UCase(Left(tStr ,4)) = "PTR " Then '属于前面的整体
                           xElto(i ,ti -1) &= tStr
                        Else
                           xElto(i ,ti)  = tStr
                           uxElto(i ,ti) = 获取特定对齐字符(tStr)
                        End if
                        ci = cc + 1  '表示后面都提取
                        Exit For
                     End if
                     mm = 2 '字符状态
                  End if
               end if
               if by[ei] = 34 Then
                  yh = yh = 0  '切换引号状态，处于引号状态就停止处理
               elseif yh = 0 Then
                  if by[ei] = 40 Then  '(
                     ku += 1
                  ElseIf by[ei] = 41 Then  ')
                     ku -= 1
                  End if
               end if
         End Select
      Next
      if ci <= cc Then
         tStr = Mid(elto(i) ,ci)
         if ti > 0 AndAlso UCase(Left(tStr ,4)) = "PTR " Then '属于前面的整体
            xElto(i ,ti -1) &= tStr
         Else
            xElto(i ,ti)  = tStr
            uxElto(i ,ti) = 获取特定对齐字符(tStr)
         end if
      End if
   Next
   '为连续变量声明后类型对齐用  Dim As xxx ****
   For i = 0 To uu
      Select Case uxElto(i ,0)
         Case "DIM "
            if uxElto(i ,1) = "AS " Then  '连续变量声明
               xElto(i ,0) &= xElto(i ,1) & xElto(i ,2)
               For ti = 1 To 29 -2
                  xElto(i ,ti)  = xElto(i ,ti + 2)
                  uxElto(i ,ti) = uxElto(i ,ti + 2)
               Next
               For ti = 28 To 29
                  xElto(i ,ti)  = ""
                  uxElto(i ,ti) = ""
               Next
               uxElto(i ,1) = "P"  '对齐用
            End if
         Case "FOR "
            For ti = 0 To 29
               if Len(uxElto(i ,ti)) Then uxElto(i ,ti) = ""
            Next
         Case "IF " 'IF 和 Then 之间，就算1个对象
            For ti = 1 To 29
               if Len(xElto(i ,ti)) = 0 Then Exit For
               if uxElto(i ,ti) = "THEN " Then
                  if ti > 2 Then
                     xElto(i ,2)  = xElto(i ,ti)
                     uxElto(i ,2) = "THEN "
                     if ti < 29 Then
                        Dim ki As Long = 3
                        For pi As Long = ti + 1 To 29
                           xElto(i ,ki)  = xElto(i ,pi)
                           uxElto(i ,ki) = uxElto(i ,pi)
                           ki            += 1
                        Next
                        ti = 29
                     End if
                     xElto(i ,ti)  = ""
                     uxElto(i ,ti) = ""
                  End if
                  Exit For
               End if
               if ti > 1 Then
                  xElto(i ,1)   &= xElto(i ,ti)
                  xElto(i ,ti)  = ""
                  uxElto(i ,ti) = ""
               End if
            Next
      End Select
   Next
   '先算出字符长度
   Dim jp() As Long
   ReDim jp(uu)    '前面空格长度，只有长度相同才对齐
   For i = 0 To uu
      For ti = 0 To 29
         cc = LenUtf8(xElto(i ,ti))
         if cc = 0 Then Exit For '表示无后面内容
         cElto(i ,ti) = cc
         'PrintA i, ti, uxElto(i, ti) ,xElto(i, ti)
      Next
      cc = Len(xElto(i ,0))
      if cc Then
         by = StrPtr(xElto(i ,0))
         mm = 0
         For ti = 0 To cc -1
            if by[ti] <> 32 Then Exit For
            mm += 1
         Next
         jp(i) = mm
         'PrintA i,mm
      End if
      
   Next
   '对比每行相同的第一个字符，对齐
   Dim kk As Long ,pp() As Long
   ReDim pp(uu)
   For ti = 1 To 29
      mm = 0 '统计相同符号
      kk = 0 '单行字符长度，要统计前面的
      i  = 0
      For ci = ti -1 To 0 Step -1
         kk += cElto(i ,ci)
      Next
      pp(i) = kk  '保存长度，后面用于处理填充空格
      cc    = kk  '最大字符长度
      For i = 1 To uu
         kk = 0 '单行字符长度，要统计前面的
         For ci = ti -1 To 0 Step -1
            kk += cElto(i ,ci)
            'PrintA i,ci,cElto(i, ci)
         Next
         pp(i) = kk '保存长度，后面用于处理填充空格
         if cElto(i ,ti) = 0 OrElse jp(i) <> jp(i -1) OrElse abs(pp(i -1) - kk) > 35 OrElse Len(uxElto(i ,ti)) = 0 OrElse uxElto(i ,ti) <> uxElto(i -1 ,ti) Then
            yh = 0 '是不是相同字符
         Else
            if uxElto(i -1 ,0) = "DIM " AndAlso uxElto(i ,0) <> "DIM " Then  '非同类语句不参与对齐
               yh = 0
            Elseif uxElto(i -1 ,0) = "IF " AndAlso uxElto(i ,0) <> "IF " Then
               yh = 0
            Else
               yh = 1
               mm += 1 '相同字符，对齐处理
               if cc < kk Then cc = kk
               if i = uu Then
                  i  += 1  '遇到最后一行
                  yh = 0
               End if
            End if
         End if
         if yh = 0 And mm > 0 Then '有相同的，需要处理对齐
            For ci = i - (mm + 1) To i -1
               ei = ti -1 '需要处理的
               kk = cc - pp(ci)  '和最大长度差多少
               'PrintA ci,ei,kk
               if kk > 0 Then
                  xElto(ci ,ei) &= Space(kk)  '补空格
                  cElto(ci ,ei) += kk
               End if
            Next
            mm = 0
         end if
         if yh = 0 then cc = kk
         
      Next
   Next
   '合并字符
   For i = 0 To uu
      kk = 0
      For ti = 0 To 29 '先统计长度
         cc = Len(xElto(i ,ti))
         if cc = 0 Then Exit For '表示无后面内容
         kk += cc
      Next
      if kk = 0 Then
         elto(i) = ""
      Else
         elto(i) = Space(kk)  '
         ei      = 1
         For ti = 0 To 29 '先统计长度
            cc = Len(xElto(i ,ti))
            if cc = 0 Then Exit For '表示无后面内容
            Mid(elto(i) ,ei ,cc) = xElto(i ,ti)
            ei                   += cc
         Next
      End if
   Next
End Sub

Function LenUtf8(Str_Utf8 As String) As Long   '字符长度，中文为2个
   Dim i  As Long
   Dim uu As Long = Len(Str_Utf8)
   if uu < 3 Then Return uu
   Dim zz As Long
   For i = 0 To uu -1
      If Bit(Str_Utf8[i], 7) Then  'UTF8 格式，遇到高位1 就是中文
         zz += 2
         i  += 2  ' 中文占3个字符
      Else
         zz += 1
      End if
   Next
   Function = zz
End Function
Function 获取特定对齐字符(nStr As String) As String
   Dim uStr            As String = UCase(nStr)
   Static 语句类(...)  As zString * 10 = {"AS "  ,"THEN " ,"ELSE " ,": " ,"& " ,","}
   Static 语句类2(...) As zString * 10 = {"DIM " ,"FOR "  ,"IF "}
   Static 赋值类(...)  As zString * 10 = {"= "   ,"+= "   ,"&= "  ,"-= "  ,"*= " ,"/= " ,"\= " ,"^= " ,"MOD= " ,"AND= " ,"EQV= " ,"IMP= " ,"OR= " ,"XOR= " ,"SHL= " ,"SHR= "}
   Static 运算类(...)  As zString * 10 = {"+ "   ,"- "    ,"* "   ,"/ "   ,"\ "  ,"^ "}
   Static 关系类(...)  As zString * 10 = {"<> "  ,"< "    ,"> "   ,"<= "  ,">= "}
   Static 位运算(...)  As zString * 10 = {"MOD " ,"SHL "  ,"SHR " ,"AND " ,"OR " ,"EQV  " ,"IMP " ,"NOT " ,"XOR "}
   
   Dim i As Long
   For i = 0 To UBound(语句类)
      if Left(uStr ,Len(语句类(i))) = 语句类(i) Then Return 语句类(i)
   Next
   For i = 0 To UBound(语句类2)
      if Right(uStr ,Len(语句类2(i))) = 语句类2(i) Then Return 语句类2(i)
      'DIM 为连续变量声明后类型对齐用
      'For 不参与对齐
      'IF 和 Then 之间，就算1个对象
   Next
   For i = 0 To UBound(赋值类)
      if Left(uStr ,Len(赋值类(i))) = 赋值类(i) Then Return "="
   Next
   For i = 0 To UBound(运算类)
      if Left(uStr ,Len(运算类(i))) = 运算类(i) Then Return "+"
   Next
   For i = 0 To UBound(关系类)
      if Left(uStr ,Len(关系类(i))) = 关系类(i) Then Return "<>"
   Next
   For i = 0 To UBound(位运算)
      if Left(uStr ,Len(位运算(i))) = 位运算(i) Then Return "AND"
   Next
   
   Function = ""
End Function




