﻿'这里是所有控件源码的公共部分

Type clsControl       '控件类
   nHwnd            As hWnd           '句柄
   IDC              As Long           '本控件的IDC 号 从 1001 开始，每创建1个控件就 +1
   nName            As String         '控件名称，代码中使用
   Caption          As String         '窗口文字 utf8编码
   Font             As String         '字体，Utf8 格式 ，控件中绘制文本的字体，格式为：字体,字号,加粗,斜体,下划线,删除线  中间用英文豆号分割，可以省略参数 默认为：宋体,9,0,0,0,0  自动响应系统DPI创建字体大小。
   ControlName      As String         '控件类型名称
   IsTab            As Long           '是不是允许使用Tab
   Index            As Long = -1       '控件数组索引，小于零表示非控件数组
   nLeft            As Long
   nTop             As Long
   nWidth           As Long
   nHeight          As Long
   ForeColor        As Long = &H197F7F7F        '保存颜色值，事件里用，需要用 GetCodeColorGDI 或 GetCodeColorGDIplue 转为 GDI 和 GDI+ 颜色值
   BackColor        As Long = &H197F7F7F        '保存颜色值，事件里用，需要用 GetCodeColorGDI 或 GetCodeColorGDIplue 转为 GDI 和 GDI+ 颜色值
   Style            As UInteger  '     '样式，主要用于虚拟控件，各个控件定义不同
   cTi              As Long      '控件对应 控件工具箱索引
   pValue(1 To 100) As String    '控件属性属性值 utf8编码，为了支持大字符
   IsSelected As Long      '是不是被多选中，副的选中
   CtlData(99)      As Integer    '为每个控件提供 100 个数据储存(编写控件使用，控件根据自己需要存放任意数据)。
   
End Type
Type ColProType '控件属性类
   sName   As String    '属性英文名称
   uName   As String    '名称，大写，用来不区分大小写对比查找
   zName   As String    '属性中文名称
   sHelp   As String    '帮助文档
   Default As String    '默认值 ，新建控件用
   AllList As String    '所有值，提供选择
   nType   As Long      '类型，0：数字 1：文本 2：选择 3：颜色 4：字体 5：图像 6：图标
End Type
Type ColEventType '控件事件
   sName As String  '事件英文名称
   uName As String  '名称，大写，用来不区分大小写对比查找
   Param As String  '参数表，带前后 () 和返回类型
   sHelp As String  '注解或帮助文档
   tMsg  As String  '消息值（在控件DLL中识辨处理用）在 CODE_FORM 模板中要替换的目标 {目标}
   gCall As String  '调用事件代码，要代替的代码，其中 {$1} 是事件合成名称，必须由IDE合成后替换
   nNew  As String  '新建事件时插入的代码
End Type
Type ColToolType '控件工具
   sName                     As String       '名称，大小写
   uName                     As String       '名称，大写，用来不区分大小写对比查找
   sTips                     As String       '鼠标提示，在控件显示区提示用
   Folder                    As String       '控件配置文件夹名，不带路径。路径固定为：app.path + Languages\语言\Control
   ClassFile                 As String       '控件类文件名，在 Folder 文件夹里的类声明文件名
   ProLib                    As String       '处理编译和编辑的DLL文件名，在 Folder 文件夹里
   group                     As String       '分组
   sVale                     As Long         '字体图标值，在控件显示区显示用
   sIco                      As HICON        '图标句柄，有图标时显示图标，不显示字体图标。
   Feature                   As Long         '特征 =0 不使用 =1 主窗口 =2 普通控件  =3 虚拟控件有界面 =4 虚拟控件无界面
   Only                      As Long         '是否是唯一的，就是一个窗口只能有1个此控件
   ProList(1 To 100)         As ColProType   '最多100个属性
   plU                       As Long         '属性个数
   EveList(1 To 100)         As ColEventType '最多100个事件
   elU                       As Long         '事件个数
   library                   As Any Ptr      '处理 DLL 模块地址
   initialization            As Any Ptr
   Edit_ControlPropertyAlter As Any Ptr
   Edit_AddControls          As Any Ptr
   Edit_SetControlProperty   As Any Ptr
   Edit_OnPaint              As Any Ptr
   Compile_ExplainControl    As Any Ptr
End Type
Type StyleFormType
   hWndForm As hWnd
   hWndList As hWnd
   nType    As Long
   value    As String Ptr
   default  As String Ptr
   AllList  As String Ptr
   Rvalue   As String    '返回值
   nName    As String    '当前控件名 A字符
   FomName  As String    '当前窗口名 A字符
End Type
Declare Function pp_Replace(Expression As String ,Find As String ,Replacewith As String)  As String
Declare Function TextAddWindowStyle(ByVal tStyle As String ,aStyle As String)             As String  '给文本样式列表中增加样式。
Declare Function TextRemoveWindowStyle(ByVal tStyle As String ,rStyle As String)          As String  '移除文本样式列表中的样式
Declare Function GetStyleOR(sNameOR As String ,EX As Long = 0)                            As String  '获取所有样式值组合,EX=0 所有 =1 扩展 =2非扩展
Declare Function pp_Split(SourceStr as String ,delimeter as String ,StrArray() as String) as Long
Declare Function GetColorTextCode(nText As String)                              As String  '转换字符样式为代
Declare Function GetTextFileStr(szFileName As CWSTR)                            As String  '从文件读取文本，自动识别编码，统一返回 Utf8格式
Declare Function pp_wStrToUtf8(WStrPtr as WString Ptr ,WStrLen as UInteger = 0) as String
Declare Function pp_StrToUtf8(sStr as String)                                   as String

Dim Shared GetWinFontLog           As Function(mFont As String) As hFont '有没有存在样式，需要全部都没有才成立，返回非0，
Dim Shared IsEventComparison       As Function(Control As clsControl ,ColTool As ColToolType ,ii As Long ,ff As Long ,nFile As String ,aa As String ,Form_clName As String) As Long '判断事件是不是正确，返回非0，
Dim Shared SetTextStyleVale        As Sub(Control As clsControl ,ColTool As ColToolType ,ki As Long ,i As Long ,vv As String ,tTy As String) '修改文本样式值
Dim Shared GetColToolProIndex      As Function(ColTool As ColToolType ,proName As String) As Long       '获取控件工具箱上属性名称对应的索引
Dim Shared GetColorText            As Function(nText As String)                           As Long       '样式符合，转换为颜色值,系统色为 SYS,1
Dim Shared IsStyleAllON            As Function(AllStyle As String ,cStyle As String)      As Long       '有没有存在样式，需要全部都有才成立，返回非0，
Dim Shared IsStyleAllOFF           As Function(AllStyle As String ,cStyle As String)      As Long       '有没有存在样式，需要全部都没有才成立，返回非0，
Dim Shared GetStyleValeOR          As Function(sNameOR As String ,EX As Long)             As UInteger   '获取所有样式值组合,EX=0 所有 =1 扩展 =2非扩展
Dim Shared ExplainControlPublic    As Function(Form_clName As String ,Control As clsControl ,clName As String ,ii As Long ,uName As String ,clType As Long ,clStyle as String ,clExStyle As String ,clPro As String ,ProWinCode As String) As Long '处理公共部分，已处理返回0，未处理返回非0
Dim Shared GetExeAPP               As Function() As Any Ptr  '获取EXE 的 APP指针
Dim Shared GetProRunFileEx         As Function(p As Long ,n As Long ,r As zString Ptr)          As Long '{2.0 带输出路径+输出文件.1 输出路径.2 输出文件（不带路径）.3 工程文件.4 工程文件夹.5 工程名称}
Dim Shared GetImgFormEx            As Function(yName As String ,nImg As Long ,r As zString Ptr) As Long
Dim Shared CheckIfTheControlExists As Function(nName As String ,ToolName As String)             As Long
Dim Shared OpenHelp                As Sub(nHelp As String)
Dim Shared OpenColorDialog         As Function(cHwnd As HWND ,nColor As Long) As HWND
Dim Shared GetMainWinHandle        As Function()                              As HWND
Dim Shared IsMultiLanguage         As Function()                              As Long '当前工程是不是启用多国语言
Dim Shared CurProIsChildWindow     As Function(chuanko As String)             As Long '当前工程中，窗口是不是存在以及是不是子窗口属性。
Dim Shared CurProSetChildWindow    As Sub(hWndForm As hWnd)  '当前工程中，让主窗口填充子窗口属性的窗口。
'函数声明

Sub SetFunctionAddress()  '设置函数地址
   Dim library As Any Ptr = GetModuleHandle(null) 'EXE 模块句柄
   GetWinFontLog = DyLibSymbol(library, "GETWINFONTLOG") '有没有存在样式，需要全部都没有才成立，返回非0，
   IsEventComparison = DyLibSymbol(library, "ISEVENTCOMPARISON") '判断事件是不是正确，返回非0，
   SetTextStyleVale = DyLibSymbol(library, "SETTEXTSTYLEVALEEX") '修改文本样式值
   GetColToolProIndex = DyLibSymbol(library, "GETCOLTOOLPROINDEXEX") '获取控件工具箱上属性名称对应的索引
   GetColorText = DyLibSymbol(library, "GETCOLORTEXT") '样式符合，转换为颜色值,系统色为 SYS,1
   IsStyleAllON = DyLibSymbol(library, "ISSTYLEALLON") '有没有存在样式，需要全部都有才成立，返回非0，
   IsStyleAllOFF = DyLibSymbol(library, "ISSTYLEALLOFF") '有没有存在样式，需要全部都没有才成立，返回非0，
   GetStyleValeOR = DyLibSymbol(library, "GETSTYLEVALEOR") '获取所有样式值组合,EX=0 所有 =1 扩展 =2非扩展
   ExplainControlPublic = DyLibSymbol(library, "EXPLAINCONTROLPUBLIC") ''处理公共部分，已处理返回0，未处理返回非0
   GetExeAPP = DyLibSymbol(library, "GETEXEAPP") '获取EXE 的 APP指针
   GetProRunFileEx = DyLibSymbol(library, "GETPRORUNFILEEX") '得到工程编译的文件名,p=0为当前工程{2.0 带输出路径+输出文件.1 输出路径.2 输出文件（不带路径）.3 工程文件 .4 工程文件夹}
   GetImgFormEx = DyLibSymbol(library, "GETIMGFORMEX") '打开图像管理器，获取图像文件名称,yName=原名 nImg=0 任意图像 =1 ICO图标
   CheckIfTheControlExists = DyLibSymbol(library, "CHECKIFTHECONTROLEXISTS") '检查控件是不是存在，不存在返回0 ，存在返回非0
   OpenHelp = DyLibSymbol(library, "OPENHELP") '只能指定帮助文件下的帮助文档
   OpenColorDialog = DyLibSymbol(library, "OPENCOLORDIALOG") ' 打开色彩对话框，返回窗口句柄，选择好颜色将会 PostMessage cHwnd,9898,9898,颜色值
   GetMainWinHandle = DyLibSymbol(library, "GETMAINWINHANDLE") '获取EXE主窗口句柄
   IsMultiLanguage = DyLibSymbol(library, "ISMULTILANGUAGE") '当前工程是不是启用多国语言
   CurProIsChildWindow = DyLibSymbol(library, "CURPROISCHILDWINDOW") '当前工程中，窗口是不是存在以及是不是子窗口属性。
   CurProSetChildWindow = DyLibSymbol(library, "CURPROSETCHILDWINDOW") '当前工程中，让主窗口填充子窗口属性的窗口。
   
End Sub
Function pp_Replace(Expression As String, Find As String, Replacewith As String) As String
   Dim As  Long  FF(),ff1,i,u,Lf,Le,Lr,Lu,t
   Dim outstr As String
   Dim As UByte Ptr pE,pF
   Dim As Any Ptr pU,pR
   Le = Len(Expression)
   Lf = Len(Find)
   Lr = Len(Replacewith)
   If Le = 0 Or Lf = 0 Then
      Return Expression
   Else
      '先找出替换数与位置----------------------------------
      u = -1
      ReDim ff(100)
      pE = StrPtr(Expression)
      pR = StrPtr(Replacewith)
      pF = StrPtr(Find)
      For i = 0 To Le - Lf
         If pe[i] = pf[0] Then
            If MemCmp(@pe[i], pf, lf) = 0 Then
               u += 1
               If u > UBound(ff) Then ReDim Preserve ff(u + 100)
               ff(u) = i
               i += lf -1
            End If
         End If
      Next
      If u = -1 Then
         Return Expression
      Else
         Lu = Le + (Lr - Lf) * (u + 1)  'Lu=Le - Lf * (u+1) + Lr * (u+1)
         outstr = String(Lu, 0)
         pU = StrPtr(outstr)
         t = 0
         For i = 0 To u
            Lu = FF(i) - t
            If Lu > 0 Then '复制原字符
               MemCpy(pU, pE, Lu)
               pU += Lu
            End If
            If Lr > 0 Then '复制替换字符
               MemCpy(pU, pR, Lr)
               pU += Lr
            End If
            pE += Lu + Lf
            t += Lu + Lf
         Next
         If t < le Then
            lu = le - t
            MemCpy(pU, pE, Lu)
         End If
         Return outstr
      End If
   End If
End Function
Function pp_Split(SourceStr as String, delimeter as String, StrArray() as String) as Long
   Dim as Integer f1,f2,u,umax,ld
   If SourceStr = "" Then
      Function = -1
      Exit Function
   End If
   ld = Len(delimeter)
   f1 = 1 - ld
   u = -1
   umax = 100  '加速数组操作
   ReDim StrArray(umax)
   Do
      f2 = InStr(f1 + ld, SourceStr, delimeter)
      u += 1
      If u > umax Then
         umax += 100
         ReDim Preserve StrArray(umax)
      End If
      If f2 = 0 Then '没有分割符合了
         StrArray(u) = Mid(SourceStr, f1 + ld)
         Exit Do
      End If
      StrArray(u) = Mid(SourceStr, f1 + ld, f2 - f1 - ld)
      f1 = f2
   Loop
   ReDim Preserve StrArray(u)
   
   Function = u + 1
End Function

Function TextAddWindowStyle(ByVal tStyle As String, aStyle As String) As String '给文本样式列表中增加样式。
   If Len(tStyle) = 0 Then Return aStyle
   Dim sStyle As String = "," & pp_Replace(tStyle, " ", "") & ","
   sStyle = pp_Replace(sStyle, "," & aStyle & ",", ",") & aStyle & ","
   Function = Trim(sStyle, ",")
End Function
Function TextRemoveWindowStyle(ByVal tStyle As String, rStyle As String) As String '移除文本样式列表中的样式
   If Len(tStyle) = 0 Then Return ""
   Dim sStyle As String = "," & pp_Replace(tStyle, " ", "") & ","
   sStyle = pp_Replace(sStyle, "," & rStyle & ",", ",")
   Function = Trim(sStyle, ",")
   
End Function
Function GetStyleOR(sNameOR As String, EX As Long = 0) As String  '获取所有样式值组合,EX=0 所有 =1 扩展 =2非扩展
   Dim syt() As String
   Dim u As Long = pp_Split(sNameOR, ",", syt()), aa As String
   If u = -1 Then Return "0"
   For i As Long = 0 To u -1
      If EX > 0 Then
         If InStr(syt(i), "_EX_") > 0 Then
            If EX = 2 Then Continue For
         Else
            If EX = 1 Then Continue For
         End If
      End If
      If Len(aa) = 0 Then
         aa = syt(i)
      Else
         aa &= " Or " & syt(i)
      End If
   Next
   if Len(aa) = 0 Then aa = "0"
   Function = aa
End Function
Function GetColorTextCode(nText As String) As String  '转换字符样式为代码
   Dim cs As String = Trim(nText)
   If Left(cs, 3) = "SYS" Then
      Dim f As Long = InStr(cs, ",")
      If f > 0 Then cs = Mid(cs, f + 1)
      f = ValInt(cs)
      Return "GetSysColor(" & f & ")"
   Else
      If Len(nText) > 8 Then
         Return "&H" & Mid(nText, 5)
      Else
         Return nText
      End If
   End If
End Function
Function GetProRunFile(p As Long ,a As Long ) As String  
   Dim r As zString * 260
   GetProRunFileEx(p, a, @r)
   Function = r 
End Function
Sub Insert_code(ProWinCode As String, mark As String, InCode As String,Eline As Long =0) Export '插入代码
   'ProWinCode   模板代码
   'mark         标记，区分大小写，标记应该是唯一的。
   'InCode       插入的代码
   'Eline        是否在标记下一行插入
   Dim ff As Long
   Do
      ff = InStr(ff + 1, ProWinCode, mark)
      if ff = 0 Then Exit Do
      if Mid(ProWinCode, ff -1, 1) <> """" Then  '预防抓错，抓到非标记
         if Eline Then 
            ff = InStr(ff + 1, ProWinCode, vbCrLf)
            ProWinCode = Left(ProWinCode, ff +1) & InCode & Mid(ProWinCode, ff)
         Else 
            ProWinCode = Left(ProWinCode, ff -1) & InCode & vbCrLf & Mid(ProWinCode, ff)
         End if 
         Exit Do
      End if
   Loop
End Sub
Function GetTextFileStr(szFileName As CWSTR) As String '从文件读取文本，自动识别编码，统一返回 Utf8格式
   Dim hFile As HANDLE = CreateFileW(szFileName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)
   Dim r As Long 
   if hFile = INVALID_HANDLE_VALUE Then r = 1
   dim bErrorFlag As WINBOOL, nFileSize As UInteger, txt As String
   if r = 0 Then 
      if GetFileSizeEx(hFile, Cast(Any Ptr,@nFileSize)) = 0 Then r = 1
   End if 
   if r=0 And nFileSize>0 Then 
      txt =String(nFileSize,0) 
      bErrorFlag = ReadFile(hFile, StrPtr(txt), Len(txt), @nFileSize, NULL)
      if bErrorFlag = FALSE Then r = 1
   End if 
   CloseHandle(hFile)   
   
   if r=0 Then    
      '什么头都没有直接数据的就是ANSI类型,
      'EF BB BF头的就是UTF-8类型,
      'FF FE头的就是UNICODE类型的,
      'FE FF头的就是UNICODE BIG ENDIAN类型的
      If Len(txt) > 2 AndAlso txt[0] = &HEF AndAlso txt[1] = &HBB AndAlso txt[2] = &HBF Then
         txt = Mid(txt ,4)
      elseIf Len(txt) > 1 AndAlso txt[0] = &HFF AndAlso txt[1] = &HFE Then
         txt = pp_wStrToUtf8(Cast(Any Ptr ,Cast(UInteger ,StrPtr(txt)) + 2) ,Len(txt) / 2 -1)
      Else
         txt = pp_StrToUtf8(txt)
      End If
      '替换 Chr(9) 为空格 ,避免代码分析软件出错
      if Len(txt) > 0 Then 
         for i As Long = 0 To Len(txt) -1
            if txt[i] = 9 Then txt[i] = 32
         Next 
      end if   
      if InStr(txt ,vbCrLf) = 0 Then txt = pp_Replace(txt ,vblf ,vbCrLf) '会遇到几个特殊的
      
      Function = txt      
   End If
End Function
Function pp_wStrToUtf8(WStrPtr as WString Ptr, WStrLen as UInteger=0) as  String
'WStrLen 是宽字符个数，不是字节长度
    Dim UTF8Mem as  ZString Ptr
    Dim ss as String  
    if WStrLen=0 then WStrLen=Len(*WStrPtr)
    If WStrPtr>0 And WStrLen>0 Then
        ss=String(WStrLen*3,0)
        UTF8Mem=StrPtr(ss)    
        Dim UTF8Len as Integer =WideCharToMultiByte(CP_UTF8, 0, WStrPtr, WStrLen, UTF8Mem, Len(ss), Null, Null)
        If UTF8Len Then Function=Left(ss,UTF8Len)
    EndIf
End Function
Function pp_StrToUtf8(sStr as String ) as String
   Dim LenStr As Integer = Len(sStr)
   If LenStr = 0 Then Return ""
   Dim bLen As Integer = LenStr * 2
   '转换为宽字符，这是必须的，大家都这么做，直接转换就不一样了
   Dim wsStr As String  = String(bLen + 2 ,0)
   Dim eLen  As Integer = MultiByteToWideChar(ansiStr_CodePage ,0 ,StrPtr(sStr) ,LenStr ,Cast(WString Ptr ,StrPtr(wsStr)) ,bLen)
   '由宽字符转换为 UTF8
   Dim dst     As String  = String(bLen ,0)      '为输出Utf8预留空间
   Dim UTF8Len as Integer = WideCharToMultiByte(CP_UTF8 ,0 ,Cast(WString Ptr ,StrPtr(wsStr)) ,eLen ,StrPtr(dst) ,bLen ,Null ,Null)
   If UTF8Len Then Function = Left(dst ,UTF8Len)
End Function

Function GetImgForm(yName As String, nImg As Long) As String  
   Dim r As ZString *260
   GetImgFormEx(yName, nImg, @r)
   Function = r  
End Function








