﻿

Function initialization() As Long Export '初始化
   '当 VFB5 主软件加载本DLL后，主动调用一下此函数，可以在此做初始化代码
   SetFunctionAddress()  '设置函数地址
   Function = 4 '返回协议版本号，不同协议（发生接口变化）不能通用，会发生崩溃等问题，因此VFB主软件会判断此版本号，不匹配就不使用本控件。
End Function


Function Edit_AddControls(cw As CWindow Ptr,hParent AS HWND,IDC As ULong ,Caption As CWSTR, x As Long, y As Long, w As Long, h As Long,WndProc As Any Ptr) As HWND Export '增加1个控件 
   '编辑：窗口刚被打开，需要新建，返回新建后的控件窗口句柄
   'cw      基于CWindow创建，这是当前窗口的 CWindow 指针
   'hParent 父窗口句柄
   'IDC     控件IDC号
   'Caption 控件标题
   'xywh    位置
   'WndProc 主窗口处理消息的函数地址(窗口消息回调函数)

   Function = cw->AddControl("STATUSBAR", hParent, IDC, Caption, x, y, w, h,WS_CHILD oR WS_CLIPSIBLINGS OR WS_VISIBLE OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR CCS_BOTTOM OR SBARS_SIZEGRIP , , , WndProc)

End Function

Function Edit_SetControlProperty(ByRef Control As clsControl, ByRef ColTool As ColToolType, ki As Long) As Long Export '设置控件属性
   '编辑：新创建控件、修改控件属性后，都调用1次
   'Control  窗口中的控件
   'ColTool  当前控件配置和属性
   'ki       被修改的属性索引，=0为全部
   Dim hWndControl As hWnd = Control.nHwnd
   Dim vv As String, cvv As CWSTR, i As Long
   
   For i = 1 To ColTool.plU
      vv = Control.pValue(i) '值是 Utf8 格式
      cvv.UTF8 = pp_Replace(vv, Chr(3, 1), vbCrLf)
      '先设置通用部分
      Select Case ColTool.ProList(i).uName
         Case "CAPTION"
            if ColTool.uName <> "STATUSBAR" Then
               SetWindowTextW hWndControl, cvv.vptr
            End if
            Control.Caption = pp_Replace(vv, Chr(3, 1), vbCrLf)
         Case "ICON"
            Dim pa As String = GetProRunFile(0,4)
            Dim svv As String, fvv As Long = InStr(vv, "|")
            if fvv = 0 Then svv = vv Else svv = Left(vv, fvv -1)
            Dim hIcon As HICON = LoadImage(Null, pa & "images\" & Utf8toStr(svv), IMAGE_ICON, 0, 0, LR_DEFAULTSIZE Or LR_LOADFROMFILE)
            If hIcon Then
               hIcon = AfxSetWindowIcon(hWndControl, ICON_SMALL, hIcon)
               If hIcon Then DestroyIcon(hIcon)
            End If
         Case "LEFT"
            If ki = i Then  '只有控件才设置，主窗口不设置
               Control.nLeft = ValInt(vv)
               FF_Control_SetLoc hWndControl, AfxScaleX(Control.nLeft), AfxScaleY(Control.nTop)
            End If
         Case "TOP"   '只有控件才设置，主窗口不设置
            If ki = i Then
               Control.nTop = ValInt(vv)
               FF_Control_SetLoc hWndControl, AfxScaleX(Control.nLeft), AfxScaleY(Control.nTop)
            End If
         Case "WIDTH"
            If ki = i And ColTool.Feature <> 4 Then
               Control.nWidth = ValInt(vv)
               FF_Control_SetSize hWndControl, AfxScaleX(Control.nWidth), AfxScaleY(Control.nHeight)
            End If
         Case "HEIGHT"
            If ki = i And ColTool.Feature <> 4 Then
               Control.nHeight = ValInt(vv)
               FF_Control_SetSize hWndControl, AfxScaleX(Control.nWidth), AfxScaleY(Control.nHeight)
            End If
         Case "CHILD"
         Case "MOUSEPOINTER"
         Case "FORECOLOR"
            Control.ForeColor = GetColorText(vv)
         Case "BACKCOLOR"
            Control.BackColor = GetColorText(vv)
         Case "TAG"
         Case "TAB"
         Case "ACCEPTFILES"
         Case "INDEX"
         Case "FONT"
            Dim tFont As HFONT = GetWinFontLog(vv)
            SendMessage hWndControl, WM_SETFONT, Cast(wParam, tFont), True
            Control.Font = vv
         Case "TOOLTIPBALLOON"
         Case "TOOLTIP"
            '==============     以上是公共设置，下面是每个控件私有设置    =================
         Case "SIZEGRIP"  '\调整柄\2\状态栏控件将包含状态栏右端的大小调整柄。调整柄类似于定尺寸的边框，它是一个矩形区域，用户可以点击并拖动来调整父窗口的大小。\True\True,False
            If UCase(vv) = "TRUE" Then AfxAddWindowStyle hWndControl, SBARS_SIZEGRIP Else AfxRemoveWindowStyle hWndControl, SBARS_SIZEGRIP
         Case "MINHEIGHT"
            SendMessage(hWndControl, SB_SETMINHEIGHT, ValInt(vv), 0)
            SendMessage(hWndControl, WM_SIZE, SIZE_RESTORED, 0)
         Case "STATUS"  '\窗格\8\多窗格内容设置\\
            'SendMessage(hWndControl, SB_SIMPLE, 0, 0)
            if Len(vv) = 0 Then vv = String(5, 2)
            Dim el() As String
            Dim u As Long = pp_Split(vv, chr(1), el())
            ReDim St(u -1) As StausList_t
            Dim si As Long = -1, i As Long
            for i = 0 To u -1
               el(i) = Trim(el(i))
               if Len(el(i)) Then
                  Dim sl() As String
                  Dim uu As Long = pp_Split(el(i), chr(2), sl())
                  if uu > 5 Then
                     si += 1
                     St(si).zText     = sl(0)         'utf8 格式
                     St(si).zTipText  = sl(1)         'utf8 格式
                     St(si).alignment = valint(sl(2))
                     St(si).uType     = valint(sl(3))
                     St(si).nWidth    = valint(sl(4))
                     St(si).nIco      = sl(5)         'utf8 格式
                  End if
               End if
            Next
            if si = -1 Then
               Erase st
               SendMessage(hWndControl, SB_SETPARTS, 0, 0)
            Else
               if UBound(st) <> si Then ReDim Preserve st(si)
               Dim FLY_Rect As Rect
               GetClientRect hWndControl, @FLY_Rect
               Dim As Long  SP(u) , i ,t ,m = FLY_Rect.Right
               u = UBound(st)
               For i = 0 To u
                  if St(i).nWidth <= 0 Then t += m / (u - i + 1) Else t += AfxScaleX(St(i).nWidth)
                  m = FLY_Rect.Right - t '剩余
                  if m < 1 Then m = 1
                  sp(i) = t
               Next
               SendMessage hWndControl, SB_SETPARTS, u + 1, Cast(LPARAM, @sp(0))
               Dim pa As String = GetProRunFile(0,4) & "images\"
               For i = 0 To u
                  Dim zz As CWSTR
                  zz.UTF8 = St(i).zText
                  if St(i).alignment = 1 Then
                     zz = WChr(9) & zz
                  elseif St(i).alignment = 2 Then
                     zz = WChr(9, 9) & zz
                  end if
                  Dim SBT As Long
                  Select Case St(i).uType
                     Case 0
                        SBT = SBT_NOBORDERS
                     Case 1
                        SBT = 0
                     Case 2
                        SBT = SBT_POPOUT
                     Case 3
                        SBT = SBT_OWNERDRAW
                  End Select
                  SendMessageW hWndControl, SB_SETTEXT, i or SBT, Cast(LPARAM, zz.vptr)
                  Dim hi As HICON = Cast(HICON, SendMessage(hWndControl, SB_GETICON, i, 0))
                  if hi then DeleteObject hi
                  if Len(St(i).nIco) = 0 Then
                     hi = 0
                  Else
                     hi = ImgFileToIcon(St(i).nIco)
                     
                  end if
                  SendMessage(hWndControl, SB_SETICON, i, Cast(lParam, hi))
               Next
            End if
            
      End Select
   Next
   Function = 0
End Function

Function Edit_ControlPropertyAlter(hWndForm As hWnd, hWndList As hWnd, nType As Long, value As String, default As String, AllList As String, nName As String, FomName As String) As Long Export  ' 控件属性修改
   '编辑：用户点击窗口属性，修改属性时，1--6由EXE处理，7 或其它由本DLL处理
   'hWndForm   EXE 主窗口句柄
   'hWndList   控件属性显示窗口句柄（是List控件）
   'nType      类型，由 Attribute.ini 里设置，7 或其它由本DLL处理
   'value      当前的值
   'default    默认值，由 Attribute.ini 里设置
   'AllList    所有值，由 Attribute.ini 里设置
   Select Case nType  '这里根据需要编写
      Case 100
         Dim aa As StyleFormType
         aa.hWndForm = hWndForm
         aa.hWndList = hWndList
         aa.nType    = nType
         aa.value    = @value
         aa.default  = @default
         aa.AllList  = @AllList
         aa.Rvalue   = value
         aa.nName    = nName 
         aa.FomName  = FomName '当前被编辑的控件名和窗口名
         StausForm.Show hWndForm, True, Cast(Integer, @aa)
         value       = aa.Rvalue
         Function    = len(value)
         
   End Select
End Function
Function Edit_OnPaint(gg As yGDI, Control As clsControl, ColTool As ColToolType, WinCc As Long, nFile As String) as Long Export '描绘控件
   '编辑：当被刷新窗口，需要重绘控件时，窗口和实控件由系统绘画，不需要我们在这里处理，虚拟控件必须由此画出来。
   'gg    目标， 画在这个缓冲里。
   'Control  窗口中的控件
   'ColTool  当前控件配置和属性
   'WinCc    主窗口底色，不是本控件底色
   'nFile    当前工程主文件名，带文件夹，用来提取路径用。
   '返回非0  将会立即结束描绘操作，就是在此之后的控件就不会画了。按照最底层的控件先画。
   

   Function = 0
End Function
Function Compile_ExplainControl(Control As clsControl, ColTool As ColToolType, ProWinCode As String, ussl() As String, ByRef IDC As Long, DECLARESdim As String, Form_clName as String, nFile As String) as Long Export '解释控件，制造创建控件和事件的代码
   '编译：解释控件 ，注意：编译处理字符全部为 UTF8 编码。Control和ColTool里的是 A字符。
   'Control      窗口中的控件
   'ColTool      当前控件配置和属性
   'ProWinCode   处理后的窗口代码，最初由窗口加载窗口模板处理，然后分发给其它控件。填充处理
   'ussl()       已特殊处理过的用户写的窗口代码，主要用来识辨事件
   'IDC          控件IDC，每个控件唯一，VFB自动累计1，我们代码也可以累计
   'DECLARESdim  全局变量定义，整个工程的定义都在此处
   'Form_clName  主窗口类名，最初由窗口设置，方便后面控件使用。
   'nFile        窗口文件名，用在事件调用注释，出错时可以提示源文件地方，避免提示临时文件。
   
   
   '创建控件 ------------------------------
   Dim ii As Long
   Dim As String clClName,clName,clStyle,clExStyle,clPro
   
   Dim As Long clType '为了解释代码里用，>=100 为虚拟控件  100=LABEL 1=TEXT
   clName = pp_StrToUtf8(Control.nName)
   If Control.Index > -1 Then clName &= "(" & Control.Index & ")"
   clClName = "STATUSBAR"
   clType = 0
   clStyle = "WS_CHILD,WS_VISIBLE,WS_CLIPCHILDREN,WS_CLIPSIBLINGS,CCS_BOTTOM"
   clExStyle = ""
   For ii = 1 To ColTool.plU
      if ExplainControlPublic(Form_clName, Control, clName, ii, ColTool.ProList(ii).uName, clType, clStyle, clExStyle, clPro, ProWinCode) Then '处理公共部分，已处理返回0，未处理返回非0
         Select Case ColTool.ProList(ii).uName
               'Case "NAME"  '名称\1\用来代码中识别对象的名称
               'Case "INDEX"  '数组索引\0\控件数组中的控件位置的索引数字。值小于零表示不是控件数组
               'Case "CAPTION"  '文本\1\显示的文本\Label\
               'Case "TEXT"  '文本\1\显示的文本\Label\
               'Case "ENABLED"  '允许\2\创建控件时最初是否允许操作。\True\True,False
               'Case "VISIBLE"  '显示\2\创建控件时最初是显示或隐藏。\True\True,False
               'Case "FORECOLOR"  '文字色\3\用于在对象中显示文本和图形的前景色。\SYS,8\
               'Case "BACKCOLOR"  '背景色\3\用于在对象中显示文本和图形的背景色。\SYS,15\
               'Case "FONT"  '字体\4\用于此对象的文本字体。\微软雅黑,9,0\
               'Case "LEFT"  '位置X\0\左边缘和父窗口的左边缘之间的距离。自动响应DPI缩放\0\
               'Case "TOP"  '位置Y\0\内部上边缘和父窗口的顶部边缘之间的距离。自动响应DPI缩放\0\
               'Case "WIDTH"  '宽度\0\窗口宽度，100%DPI时的像素单位，自动响应DPI缩放。\100\
               'Case "HEIGHT"  '高度\0\窗口高度，100%DPI时的像素单位，自动响应DPI缩放。\20\
               'Case "LAYOUT"
               'Case "MOUSEPOINTER"  '鼠标指针\2\鼠标在窗口上的形状\0 - 默认\0 - 默认,1 - 后台运行,2 - 标准箭头,3 - 十字光标,4 - 箭头和问号,5 - 文本工字光标,6 - 不可用禁止圈,7 - 移动,8 - 双箭头↙↗,9 - 双箭头↑↓,10 - 双箭头向↖↘,11 - 双箭头←→,12 - 垂直箭头,13 - 沙漏,14 - 手型
               'Case "TAG"  '附加\1\私有自定义文本与控件关联。\\
               'Case "TAB"  '导航\2\当用户按下TAB键时可以接收键盘焦点。\False\True,False
               'Case "TOOLTIP"  '提示\1\一个提示，当鼠标光标悬停在控件时显示它。\\
               'Case "TOOLTIPBALLOON"  '气球样式\2\一个气球样式显示工具提示。\False\True,False
               'Case "ACCEPTFILES"  '拖放\2\窗口是否接受拖放文件。\False\True,False
               '==============     以上是公共设置，下面是每个控件私有设置    =================
            Case "SIZEGRIP"  '\调整柄\2\状态栏控件将包含状态栏右端的大小调整柄。调整柄类似于定尺寸的边框，它是一个矩形区域，用户可以点击并拖动来调整父窗口的大小。\True\True,False
               If UCase(Control.pValue(ii)) = "TRUE" Then clStyle = TextAddWindowStyle(clStyle, "SBARS_SIZEGRIP")
            Case "STATUS"  '\窗格\8\多窗格内容设置\\
               if Len(Control.pValue(ii)) = 0 Then Control.pValue(ii) = String(5, 2)
               Dim el() As String
               Dim u As Long = pp_Split(Control.pValue(ii), chr(1), el())
               ReDim St(u -1) As StausList_t
               Dim si As Long = -1, gi As Long
               for gi = 0 To u -1
                  el(gi) = Trim(el(gi))
                  if Len(el(gi)) Then
                     Dim sl() As String
                     Dim uu As Long = pp_Split(el(gi), chr(2), sl())
                     if uu > 5 Then
                        si += 1
                        St(si).zText = sl(0)    'utf8 格式
                        St(si).zTipText = sl(1)  'utf8 格式
                        St(si).alignment = valint(sl(2))
                        St(si).uType = valint(sl(3))
                        St(si).nWidth = valint(sl(4))
                        St(si).nIco = sl(5)    'utf8 格式
                     End if
                  End if
               Next
               if si = -1 Then
                  
               Else
                  if UBound(st) <> si Then ReDim Preserve st(si)
                  u = UBound(st)
                  For gi = 0 To u
                     Dim SBT As Long
                     Select Case St(gi).uType
                        Case 0
                           SBT = SBT_NOBORDERS
                        Case 1
                           SBT = 0
                        Case 2
                           SBT = SBT_POPOUT
                        Case 3
                           SBT = SBT_OWNERDRAW
                     End Select
                     if St(gi).alignment = 1 Then
                        St(gi).zText = Chr(9) & St(gi).zText
                     elseif St(gi).alignment = 2 Then
                        St(gi).zText = Chr(9, 9) & St(gi).zText
                     end if
                     Dim ffi As Long = InStr(St(gi).nIco, "|")
                     if ffi > 0 Then St(gi).nIco = Mid(St(gi).nIco, ffi + 1)
                     if IsMultiLanguage() Then   'IsMultiLanguage 后面加()才表示使用函数，不然就是函数指针。
                        clPro &= "      This." & clName & ".AddPane vfb_LangString(""" & St(gi).zText & """),vfb_LangString(""" & St(gi).zTipText & """)," & SBT & "," & St(gi).nWidth & ",""" & St(gi).nIco & """" & vbCrLf
                     Else
                        clPro &= "      This." & clName & ".AddPane """ & St(gi).zText & """,""" & St(gi).zTipText & """," & SBT & "," & St(gi).nWidth & ",""" & St(gi).nIco & """" & vbCrLf
                     End if
                  Next
               End if
               
            Case "TOOLTIPS"
               If UCase(Control.pValue(ii)) = "TRUE" Then clStyle = TextAddWindowStyle(clStyle, "SBT_TOOLTIPS")
            Case "MINHEIGHT"
               If ValInt(Control.pValue(ii)) > 0 Then clPro &= "      SNDMSG(hWndControl,SB_SETMINHEIGHT, " & ValInt(Control.pValue(ii)) & ",0)" & vbCrLf
         End Select
      End if
   Next
   Insert_code(ProWinCode, "'[CONTROL_WM_SIZE]", _
      "            " & Form_clName & "." & clName & ".hWndForm = hWndForm" & vbCrLf & _
      "            " & Form_clName & "." & clName & ".SetSize ")
   '当主窗口销毁，通知每个控件类（包括虚拟控件），做必要的卸载工作，因为窗口类是全局的，不会因为窗口销毁而销毁。
   Insert_code(ProWinCode, "'[CALL_WM_DESTROY]", _
      "            " & Form_clName & "." & clName & ".hWndForm = hWndForm" & vbCrLf & _
      "            " & Form_clName & "." & clName & ".Destructor")
   
   
   Dim CONTROL_CODExx As String
   If Len(clExStyle) = 0 Then clExStyle = "0"
   If Len(clStyle) = 0 Then clStyle = "0"
   
   CONTROL_CODExx &= "   hWndControl = pWindow->AddControl(""" & clClName & """, hWnd, " & IDC & ", """ & pp_Replace(Control.Caption, Chr(34), Chr(34, 34)) & """, " & _
      Control.nLeft & ", " & Control.nTop & ", " & Control.nWidth & ", " & Control.nHeight & "," & pp_Replace(clStyle, ",", " Or ") & " ," & pp_Replace(clExStyle, ",", " Or ") & _
      " , , Cast(Any Ptr, @" & Form_clName & "_CODEPROCEDURE))" & vbCrLf
   CONTROL_CODExx &= "   If hWndControl Then " & vbCrLf
   CONTROL_CODExx &= "      Dim fp As FormControlsPro_TYPE ptr = new FormControlsPro_TYPE" & vbCrLf
   CONTROL_CODExx &= "      vfb_Set_Control_Ptr(hWndControl,fp)" & vbCrLf
   CONTROL_CODExx &= "      fp->hWndParent = hWnd" & vbCrLf
   CONTROL_CODExx &= "      fp->Index = " & Control.Index & vbCrLf
   CONTROL_CODExx &= "      fp->IDC = " & IDC & vbCrLf
   CONTROL_CODExx &= "      fp->nText = """ & pp_Replace(Control.Caption, Chr(34), Chr(34, 34)) & """" & vbCrLf
'   CONTROL_CODExx &= "      fp->ControlType = " & clType & vbCrLf
   CONTROL_CODExx &= "      This." & clName & ".hWnd = hWndControl " & vbCrLf  '真实控件========
   CONTROL_CODExx &= "      This." & clName & ".IDC =" & IDC & vbCrLf
   CONTROL_CODExx &= clPro
   CONTROL_CODExx &= "   End IF" & vbCrLf
   Insert_code(ProWinCode, "'[Create control]", CONTROL_CODExx)
   '事件处理 ------------------------------
   Dim LeaveHoverI As Long
   '控件事件
   '真实控件事件
   For ii = 1 To ColTool.elU
      Dim sim As String '事件函数名组合
      sim = " " & UCase(Form_clName & "_" & pp_StrToUtf8(Control.nName & "_" & ColTool.EveList(ii).sName)) & "("
      Dim ff As Long
      for fi As Long = 0 To UBound(ussl)
         If left(ussl(fi), 1) <> "'" AndAlso InStr(ussl(fi), sim) > 0 Then
            ff = fi + 1
            Exit for
         End If
      Next
      If ff > 0 Then
         if IsEventComparison(Control, ColTool, ii, ff, nFile, ussl(ff -1), Form_clName) Then Return 3 '检查事件是不是正确
         Select Case ColTool.EveList(ii).tMsg
            Case "NM_CLICK", "NM_DBLCLK", "NM_RCLICK", "NM_RDBLCLK" '工具栏
               Dim CONTROLS_NOTIFY As String = "         If (FLY_pNotify->idFrom = " & IDC & ") And (FLY_pNotify->Code = " & ColTool.EveList(ii).tMsg & ") Then" & vbCrLf
               CONTROLS_NOTIFY &= "             tLResult = " & sim
               If Control.Index > -1 Then CONTROLS_NOTIFY &= Control.Index & ","
               CONTROLS_NOTIFY &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
               CONTROLS_NOTIFY &= "            If tLResult Then Return tLResult" & vbCrLf
               CONTROLS_NOTIFY &= "         End If"
               Insert_code(ProWinCode, "'[CONTROLS_NOTIFY]", CONTROLS_NOTIFY)
            Case "CUSTOM"
               dim CALL_CONTROL_CUSTOM As String = "    If IDC = " & IDC & " Then  ' " & clName & vbCrLf
               CALL_CONTROL_CUSTOM &= "       tLResult = " & sim
               If Control.Index > -1 Then CALL_CONTROL_CUSTOM &= Control.Index & ","
               CALL_CONTROL_CUSTOM &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
               CALL_CONTROL_CUSTOM &= "       If tLResult Then Return tLResult" & vbCrLf
               CALL_CONTROL_CUSTOM &= "    End If" & vbCrLf
               Insert_code(ProWinCode, "'[CALL_CONTROL_CUSTOM]", CALL_CONTROL_CUSTOM)
            Case "OWNERDRAW"
               ProWinCode = pp_Replace(ProWinCode, "'{FORM_WM_DRAWITEM}", "      Case WM_DRAWITEM" & vbCrLf & "         Dim lpdis As DRAWITEMSTRUCT Ptr = Cast(Any Ptr, lParam)")
               Dim FORM_WM_DRAWITEM As String = "         If Cast(Long, wParam) = " & IDC & "  Then ' " & clName & vbCrLf
               FORM_WM_DRAWITEM &= "           tLResult = " & sim
               If Control.Index > -1 Then FORM_WM_DRAWITEM &= Control.Index & ","
               FORM_WM_DRAWITEM &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
               FORM_WM_DRAWITEM &= "           If tLResult Then Return tLResult" & vbCrLf
               FORM_WM_DRAWITEM &= "         End If" & vbCrLf
               Insert_code(ProWinCode, "'[FORM_WM_DRAWITEM]", FORM_WM_DRAWITEM)
            Case Else
               If ColTool.EveList(ii).tMsg = "WM_MOUSEHOVER" Then LeaveHoverI Or= 1
               If ColTool.EveList(ii).tMsg = "WM_MOUSELEAVE" Then LeaveHoverI Or= 10
               Dim ca As String = "      Case " & ColTool.EveList(ii).tMsg & " ''' "
               Dim other As String = "          If IDC = " & IDC & " Then  ' " & clName & vbCrLf
               If Right(ColTool.EveList(ii).Param, 1) <> ")" Then '这是函数
                  other &= "          tLResult = " & sim
                  If Control.Index > -1 Then other &= Control.Index & ","
                  other &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                  other &= "          If tLResult Then Return tLResult" & vbCrLf
               Else   '这是过程
                  other &= "             " & sim
                  If Control.Index > -1 Then other &= Control.Index & ","
                  other &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
               End If
               other &= "          End If" & vbCrLf
               ff = InStr(ProWinCode, ca)
               If ff = 0 Then '不存在
                  Insert_code(ProWinCode, "'[CONTROL_CASE_OTHER]", ca & vbCrLf & other)
               Else '已经有了
                  ProWinCode = Left(ProWinCode, ff + Len(ca) -1) & vbCrLf & other & Mid(ProWinCode, ff + Len(ca))
               End If
         End Select
      End If
   Next
   
   If LeaveHoverI > 0 Then
      dim CONTROL_LEAVEHOVER As String = "          If wMsg = WM_MouseMove AndAlso IDC = " & IDC & " Then  ' " & clName & vbCrLf
      CONTROL_LEAVEHOVER &= "             Dim entTrack As tagTRACKMOUSEEVENT" & vbCrLf
      CONTROL_LEAVEHOVER &= "             entTrack.cbSize = SizeOf(tagTRACKMOUSEEVENT)" & vbCrLf
      If LeaveHoverI = 11 Then
         CONTROL_LEAVEHOVER &= "             entTrack.dwFlags = TME_LEAVE Or TME_HOVER" & vbCrLf
      ElseIf LeaveHoverI = 10 Then
         CONTROL_LEAVEHOVER &= "             entTrack.dwFlags = TME_LEAVE " & vbCrLf
      Else
         CONTROL_LEAVEHOVER &= "             entTrack.dwFlags =  TME_HOVER" & vbCrLf
      End If
      CONTROL_LEAVEHOVER &= "             entTrack.hwndTrack = hWndControl" & vbCrLf
      CONTROL_LEAVEHOVER &= "             entTrack.dwHoverTime = HOVER_DEFAULT" & vbCrLf
      CONTROL_LEAVEHOVER &= "             TrackMouseEvent @entTrack" & vbCrLf
      CONTROL_LEAVEHOVER &= "          End IF" & vbCrLf
      Insert_code(ProWinCode, "'[CONTROL_LEAVEHOVER]", CONTROL_LEAVEHOVER)
   End If
   
   '成功返回0，失败非0
   Function = 0
End Function

Function ImgFileToIcon(ByVal ResImg As String) As HICON  '从资源文件获取图标句柄
   Dim nIcon As HICON
   if Len(ResImg)=0  Then  Return 0
   Dim ffi As Long = InStr(ResImg, "|")
   if ffi > 0 Then ResImg = left(ResImg, ffi -1)
   Dim pa As String =  GetProRunFile(0,4) & "images\" & ResImg
   nIcon = AfxGdipIconFromFile(StringToCWSTR(pa))

   Function = nIcon
End Function
























