'    WinFBE - Programmer's Code Editor for the FreeBASIC Compiler
'    Copyright (C) 2016-2019 Paul Squires, PlanetSquires Software
'
'    This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.
'
'    This program is distributed in the hope that it will be useful,
'    but WITHOUT any WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS for A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.


''  Scintilla source code edit control 
''  @file SciLexer.h, v. 3.3.5
''  Interface to the added lexer functions in the SciLexer version of the edit control.
''  
''  Copyright 1998-2002 by Neil Hodgson <neilh@scintilla.org>
''  The License.txt file describes the conditions under which this software may be distributed. 
''  
''  Most of this file is automatically generated from the Scintilla.iface interface definition
''  file which contains any comments about the definitions. HFacer.py does the generation. 
                   
#Pragma Once

''  SciLexer features - not in standard Scintilla

#Define SCLEX_CONTAINER                            0      ' // No lexer selected (default)
'#Define SCLEX_NULL                                 1      ' // Null lexer (does not syntax styling)
'#Define SCLEX_PYTHON                               2      ' // Python lexer
'#Define SCLEX_CPP                                  3      ' // C++ lexer
'#Define SCLEX_HTML                                 4      ' // HTML lexer
'#Define SCLEX_XML                                  5      ' // XML lexer
'#Define SCLEX_PERL                                 6      ' // Perl lexer
'#Define SCLEX_SQL                                  7      ' // SQL lexer
#Define SCLEX_VB                                   8      ' // Visual Basic lexer
'#Define SCLEX_PROPERTIES                           9      ' // Lexer for properies style files
'#Define SCLEX_ERRORLIST                            10     ' // Lexer for error style files
'#Define SCLEX_MAKEFILE                             11     ' // Makefile lexer
'#Define SCLEX_BATCH                                12     ' // Windows batch file lexer
'#Define SCLEX_XCODE                                13
'#Define SCLEX_LATEX                                14     ' // LaTex lexer
'#Define SCLEX_LUA                                  15     ' // LUA lexer
'#Define SCLEX_DIFF                                 16     ' // Lexer for diff output
'#Define SCLEX_CONF                                 17     ' // Lexer for Apache configuration files
'#Define SCLEX_PASCAL                               18     ' // Pascal lexer
'#Define SCLEX_AVE                                  19     ' // Avenue lexer
'#Define SCLEX_ADA                                  20     ' // Ada lexer
'#Define SCLEX_LISP                                 21     ' // Lisp lexer
'#Define SCLEX_RUBY                                 22     ' // Ruvy lexer
'#Define SCLEX_EIFFEL                               23     ' // Eiffel lexer
'#Define SCLEX_EIFFELKW                             24     ' // Eiffel lexer folding at keywords
'#Define SCLEX_TCL                                  25     ' // Tcl lexer
'#Define SCLEX_NNCRONTAB                            26     ' // Lexer for nnCron files
'#Define SCLEX_BULLANT                              27     ' // Bullant lexer
'#Define SCLEX_VBSCRIPT                             28     ' // VBScript lexer
'#Define SCLEX_BAAN                                 31     ' // Baan lexer
'#Define SCLEX_MATLAB                               32     ' // Matlab lexer
'#Define SCLEX_SCRIPTOL                             33     ' // Scriptol lexer
'#Define SCLEX_ASM                                  34     ' // ASM lexer
'#Define SCLEX_CPPNOCASE                            35     ' // CPP lexer with case insensitive keywords
'#Define SCLEX_FORTRAN                              36     ' // Fortran lexer
'#Define SCLEX_F77                                  37     ' // Fortran77 lexer
'#Define SCLEX_CSS                                  38     ' // CSS lexer
'#Define SCLEX_POV                                  39     ' // POV lexer
'#Define SCLEX_LOUT                                 40     ' // Basser Lout lexer
'#Define SCLEX_ESCRIPT                              41     ' // EScript lexer
'#Define SCLEX_PS                                   42     ' // PostCript lexer
'#Define SCLEX_NSIS                                 43     ' // NSIS lexer
'#Define SCLEX_MMIXAL                               44     ' // MMIX lexer
'#Define SCLEX_CLW                                  45     ' // Clarion lexer
'#Define SCLEX_CLWNOCASE                            46     ' // Clarion lexer with case insensitive keywords
'#Define SCLEX_LOT                                  47     ' // MPT text log file lexer
'#Define SCLEX_YAML                                 48     ' // YAML lexer
'#Define SCLEX_TEX                                  49     ' // TeX lexer
'#Define SCLEX_METAPOST                             50     ' // Metapost lexer
'#Define SCLEX_POWERBASIC                           51     ' // PowerBASIC lexer
'#Define SCLEX_FORTH                                52     ' // Forth lexer
'#Define SCLEX_ERLANG                               53     ' // Erlang lexer
'#Define SCLEX_OCTAVE                               54     ' // Octave lexer
'#Define SCLEX_MSSQL                                55     ' // MS SQL lexer
'#Define SCLEX_VERILOG                              56     ' // Verilog lexer
'#Define SCLEX_KIX                                  57     ' // Kix-Scripts lexer
'#Define SCLEX_GUI4CLI                              58     ' // Gui4Cli lexer
'#Define SCLEX_SPECMAN                              59     ' // Specman E lexer
'#Define SCLEX_AU3                                  60     ' // AutoIt3 lexer
'#Define SCLEX_APDL                                 61     ' // APDL lexer
'#Define SCLEX_BASH                                 62     ' // Bash lexer
'#Define SCLEX_ASN1                                 63     ' // ASN.1 lexer
'#Define SCLEX_VHDL                                 64     ' // VHDL lexer
'#Define SCLEX_CAML                                 65     ' // Canl lexer
'#Define SCLEX_BLITZBASIC                           66     ' // BlitzBasic lexer
'#Define SCLEX_PUREBASIC                            67     ' // PureBasic lexer
'#Define SCLEX_HASKELL                              68     ' // Haskell lexer
'#Define SCLEX_PHPSCRIPT                            69     ' // PHPScript lexer
'#Define SCLEX_TADS3                                70     ' // TADS3 lexer
'#Define SCLEX_REBOL                                71     ' // REBOL lexer
'#Define SCLEX_SMALLTALK                            72     ' // Smalltalk lexer
'#Define SCLEX_FLAGSHIP                             73     ' // FlagShip lexer
'#Define SCLEX_CSOUND                               74     ' // Csound lexer
'#Define SCLEX_FREEBASIC                            75     ' // FreeBasic lexer
'#Define SCLEX_INNOSETUP                            76     ' // InnoSetup lexer
'#Define SCLEX_OPAL                                 77     ' // Opal lexer
'#Define SCLEX_SPICE                                78     ' // Spice lexer
'#Define SCLEX_D                                    79     ' // D lexer
'#Define SCLEX_CMAKE                                80     ' // CMake lexer
'#Define SCLEX_GAP                                  81     ' // GAP lexer
'#Define SCLEX_PLM                                  82     ' // PLM lexer
'#Define SCLEX_PROGRESS                             83     ' // Progress lexer
'#Define SCLEX_ABAQUS                               84     ' // Abaqus lexer
'#Define SCLEX_ASYMPTOTE                            85     ' // Asymptote lexer
'#Define SCLEX_R                                    86     ' // R lexer
'#Define SCLEX_MAGIK                                87     ' // MagikSF lexer
'#Define SCLEX_POWERSHELL                           88     ' // PowerShell lexer
'#Define SCLEX_MYSQL                                89     ' // MySQL lexer
'#Define SCLEX_PO                                   90     ' // .po file lexer
'#Define SCLEX_TAL                                  91     ' // TAL lexer
'#Define SCLEX_COBOL                                92     ' // COBOL lexer
'#Define SCLEX_TACL                                 93     ' // TAL lexer
'#Define SCLEX_SORCUS                               94     ' // SORCUS installation files lexer
'#Define SCLEX_POWERPRO                             95     ' // PowerPro utility lexer
'#Define SCLEX_NIMROD                               96     ' // Nimrod lexer
'#Define SCLEX_SML                                  97     ' // SML lexer
'#Define SCLEX_MARKDOWN                             98     ' // Markdown lexer
'#Define SCLEX_TXT2TAGS                             99
'#Define SCLEX_A68K                                 100
'#Define SCLEX_MODULA                               101
'#Define SCLEX_COFFEESCRIPT                         102
'#Define SCLEX_TCMD                                 103
'#Define SCLEX_AVS                                  104
'#Define SCLEX_ECL                                  105
'#Define SCLEX_OSCRIPT                              106
'#Define SCLEX_VISUALPROLOG                         107
'#Define SCLEX_AUTOMATIC                            1000
'#Define SCLEX_LITERATEHASKELL                      108
'#Define SCLEX_STTXT                                109
'#Define SCLEX_KVIRC                                110
'#Define SCLEX_AUTOMATIC                            1000
#Define SCE_P_DEFAULT                              0
#Define SCE_P_COMMENTLINE                          1
#Define SCE_P_NUMBER                               2
#Define SCE_P_STRING                               3
#Define SCE_P_CHARACTER                            4
#Define SCE_P_WORD                                 5
#Define SCE_P_TRIPLE                               6
#Define SCE_P_TRIPLEDOUBLE                         7
#Define SCE_P_CLASSNAME                            8
#Define SCE_P_DEFNAME                              9
#Define SCE_P_OPERATOR                             10
#Define SCE_P_IDENTIFIER                           11
#Define SCE_P_COMMENTBLOCK                         12
#Define SCE_P_STRINGEOL                            13
#Define SCE_P_WORD2                                14
#Define SCE_P_DECORATOR                            15
#Define SCE_C_DEFAULT                              0
#Define SCE_C_COMMENT                              1
#Define SCE_C_COMMENTLINE                          2
#Define SCE_C_COMMENTDOC                           3
#Define SCE_C_NUMBER                               4
#Define SCE_C_WORD                                 5
#Define SCE_C_STRING                               6
#Define SCE_C_CHARACTER                            7
#Define SCE_C_UUID                                 8
#Define SCE_C_PREPROCESSOR                         9
#Define SCE_C_OPERATOR                             10
#Define SCE_C_IDENTIFIER                           11
#Define SCE_C_STRINGEOL                            12
#Define SCE_C_VERBATIM                             13
#Define SCE_C_REGEX                                14
#Define SCE_C_COMMENTLINEDOC                       15
#Define SCE_C_WORD2                                16
#Define SCE_C_COMMENTDOCKEYWORD                    17
#Define SCE_C_COMMENTDOCKEYWORDERROR               18
#Define SCE_C_GLOBALCLASS                          19
#Define SCE_C_STRINGRAW                            20
#Define SCE_C_TRIPLEVERBATIM                       21
#Define SCE_C_HASHQUOTEDSTRING                     22
#Define SCE_C_PREPROCESSORCOMMENT                  23
#Define SCE_C_PREPROCESSORCOMMENTDOC               24
#Define SCE_D_DEFAULT                              0
#Define SCE_D_COMMENT                              1
#Define SCE_D_COMMENTLINE                          2
#Define SCE_D_COMMENTDOC                           3
#Define SCE_D_COMMENTNESTED                        4
#Define SCE_D_NUMBER                               5
#Define SCE_D_WORD                                 6
#Define SCE_D_WORD2                                7
#Define SCE_D_WORD3                                8
#Define SCE_D_TYPEDEF                              9
#Define SCE_D_STRING                               10
#Define SCE_D_STRINGEOL                            11
#Define SCE_D_CHARACTER                            12
#Define SCE_D_OPERATOR                             13
#Define SCE_D_IDENTIFIER                           14
#Define SCE_D_COMMENTLINEDOC                       15
#Define SCE_D_COMMENTDOCKEYWORD                    16
#Define SCE_D_COMMENTDOCKEYWORDERROR               17
#Define SCE_D_STRINGB                              18
#Define SCE_D_STRINGR                              19
#Define SCE_D_WORD5                                20
#Define SCE_D_WORD6                                21
#Define SCE_D_WORD7                                22
#Define SCE_TCL_DEFAULT                            0
#Define SCE_TCL_COMMENT                            1
#Define SCE_TCL_COMMENTLINE                        2
#Define SCE_TCL_NUMBER                             3
#Define SCE_TCL_WORD_IN_QUOTE                      4
#Define SCE_TCL_IN_QUOTE                           5
#Define SCE_TCL_OPERATOR                           6
#Define SCE_TCL_IDENTIFIER                         7
#Define SCE_TCL_SUBSTITUTION                       8
#Define SCE_TCL_SUB_BRACE                          9
#Define SCE_TCL_MODIFIER                           10
#Define SCE_TCL_EXPAND                             11
#Define SCE_TCL_WORD                               12
#Define SCE_TCL_WORD2                              13
#Define SCE_TCL_WORD3                              14
#Define SCE_TCL_WORD4                              15
#Define SCE_TCL_WORD5                              16
#Define SCE_TCL_WORD6                              17
#Define SCE_TCL_WORD7                              18
#Define SCE_TCL_WORD8                              19
#Define SCE_TCL_COMMENT_BOX                        20
#Define SCE_TCL_BLOCK_COMMENT                      21
#Define SCE_H_DEFAULT                              0
#Define SCE_H_TAG                                  1
#Define SCE_H_TAGUNKNOWN                           2
#Define SCE_H_ATTRIBUTE                            3
#Define SCE_H_ATTRIBUTEUNKNOWN                     4
#Define SCE_H_NUMBER                               5
#Define SCE_H_DOUBLESTRING                         6
#Define SCE_H_SINGLESTRING                         7
#Define SCE_H_OTHER                                8
#Define SCE_H_COMMENT                              9
#Define SCE_H_ENTITY                               10
#Define SCE_H_TAGEND                               11
#Define SCE_H_XMLSTART                             12
#Define SCE_H_XMLEND                               13
#Define SCE_H_SCRIPT                               14
#Define SCE_H_ASP                                  15
#Define SCE_H_ASPAT                                16
#Define SCE_H_CDATA                                17
#Define SCE_H_QUESTION                             18
#Define SCE_H_VALUE                                19
#Define SCE_H_XCCOMMENT                            20
#Define SCE_H_SGML_DEFAULT                         21
#Define SCE_H_SGML_COMMAND                         22
#Define SCE_H_SGML_1ST_PARAM                       23
#Define SCE_H_SGML_DOUBLESTRING                    24
#Define SCE_H_SGML_SIMPLESTRING                    25
#Define SCE_H_SGML_ERROR                           26
#Define SCE_H_SGML_SPECIAL                         27
#Define SCE_H_SGML_ENTITY                          28
#Define SCE_H_SGML_COMMENT                         29
#Define SCE_H_SGML_1ST_PARAM_COMMENT               30
#Define SCE_H_SGML_BLOCK_DEFAULT                   31
#Define SCE_HJ_START                               40
#Define SCE_HJ_DEFAULT                             41
#Define SCE_HJ_COMMENT                             42
#Define SCE_HJ_COMMENTLINE                         43
#Define SCE_HJ_COMMENTDOC                          44
#Define SCE_HJ_NUMBER                              45
#Define SCE_HJ_WORD                                46
#Define SCE_HJ_KEYWORD                             47
#Define SCE_HJ_DOUBLESTRING                        48
#Define SCE_HJ_SINGLESTRING                        49
#Define SCE_HJ_SYMBOLS                             50
#Define SCE_HJ_STRINGEOL                           51
#Define SCE_HJ_REGEX                               52
#Define SCE_HJA_START                              55
#Define SCE_HJA_DEFAULT                            56
#Define SCE_HJA_COMMENT                            57
#Define SCE_HJA_COMMENTLINE                        58
#Define SCE_HJA_COMMENTDOC                         59
#Define SCE_HJA_NUMBER                             60
#Define SCE_HJA_WORD                               61
#Define SCE_HJA_KEYWORD                            62
#Define SCE_HJA_DOUBLESTRING                       63
#Define SCE_HJA_SINGLESTRING                       64
#Define SCE_HJA_SYMBOLS                            65
#Define SCE_HJA_STRINGEOL                          66
#Define SCE_HJA_REGEX                              67
#Define SCE_HB_START                               70
#Define SCE_HB_DEFAULT                             71
#Define SCE_HB_COMMENTLINE                         72
#Define SCE_HB_NUMBER                              73
#Define SCE_HB_WORD                                74
#Define SCE_HB_STRING                              75
#Define SCE_HB_IDENTIFIER                          76
#Define SCE_HB_STRINGEOL                           77
#Define SCE_HBA_START                              80
#Define SCE_HBA_DEFAULT                            81
#Define SCE_HBA_COMMENTLINE                        82
#Define SCE_HBA_NUMBER                             83
#Define SCE_HBA_WORD                               84
#Define SCE_HBA_STRING                             85
#Define SCE_HBA_IDENTIFIER                         86
#Define SCE_HBA_STRINGEOL                          87
#Define SCE_HP_START                               90
#Define SCE_HP_DEFAULT                             91
#Define SCE_HP_COMMENTLINE                         92
#Define SCE_HP_NUMBER                              93
#Define SCE_HP_STRING                              94
#Define SCE_HP_CHARACTER                           95
#Define SCE_HP_WORD                                96
#Define SCE_HP_TRIPLE                              97
#Define SCE_HP_TRIPLEDOUBLE                        98
#Define SCE_HP_CLASSNAME                           99
#Define SCE_HP_DEFNAME                             100
#Define SCE_HP_OPERATOR                            101
#Define SCE_HP_IDENTIFIER                          102
#Define SCE_HPHP_COMPLEX_VARIABLE                  104
#Define SCE_HPA_START                              105
#Define SCE_HPA_DEFAULT                            106
#Define SCE_HPA_COMMENTLINE                        107
#Define SCE_HPA_NUMBER                             108
#Define SCE_HPA_STRING                             109
#Define SCE_HPA_CHARACTER                          110
#Define SCE_HPA_WORD                               111
#Define SCE_HPA_TRIPLE                             112
#Define SCE_HPA_TRIPLEDOUBLE                       113
#Define SCE_HPA_CLASSNAME                          114
#Define SCE_HPA_DEFNAME                            115
#Define SCE_HPA_OPERATOR                           116
#Define SCE_HPA_IDENTIFIER                         117
#Define SCE_HPHP_DEFAULT                           118
#Define SCE_HPHP_HSTRING                           119
#Define SCE_HPHP_SIMPLESTRING                      120
#Define SCE_HPHP_WORD                              121
#Define SCE_HPHP_NUMBER                            122
#Define SCE_HPHP_VARIABLE                          123
#Define SCE_HPHP_COMMENT                           124
#Define SCE_HPHP_COMMENTLINE                       125
#Define SCE_HPHP_HSTRING_VARIABLE                  126
#Define SCE_HPHP_OPERATOR                          127
#Define SCE_PL_DEFAULT                             0
#Define SCE_PL_ERROR                               1
#Define SCE_PL_COMMENTLINE                         2
#Define SCE_PL_POD                                 3
#Define SCE_PL_NUMBER                              4
#Define SCE_PL_WORD                                5
#Define SCE_PL_STRING                              6
#Define SCE_PL_CHARACTER                           7
#Define SCE_PL_PUNCTUATION                         8
#Define SCE_PL_PREPROCESSOR                        9
#Define SCE_PL_OPERATOR                            10
#Define SCE_PL_IDENTIFIER                          11
#Define SCE_PL_SCALAR                              12
#Define SCE_PL_ARRAY                               13
#Define SCE_PL_HASH                                14
#Define SCE_PL_SYMBOLTABLE                         15
#Define SCE_PL_VARIABLE_INDEXER                    16
#Define SCE_PL_REGEX                               17
#Define SCE_PL_REGSUBST                            18
#Define SCE_PL_LONGQUOTE                           19
#Define SCE_PL_BACKTICKS                           20
#Define SCE_PL_DATASECTION                         21
#Define SCE_PL_HERE_DELIM                          22
#Define SCE_PL_HERE_Q                              23
#Define SCE_PL_HERE_QQ                             24
#Define SCE_PL_HERE_QX                             25
#Define SCE_PL_STRING_Q                            26
#Define SCE_PL_STRING_QQ                           27
#Define SCE_PL_STRING_QX                           28
#Define SCE_PL_STRING_QR                           29
#Define SCE_PL_STRING_QW                           30
#Define SCE_PL_POD_VERB                            31
#Define SCE_PL_SUB_PROTOTYPE                       40
#Define SCE_PL_FORMAT_IDENT                        41
#Define SCE_PL_FORMAT                              42
#Define SCE_PL_STRING_VAR                          43
#Define SCE_PL_XLAT                                44
#Define SCE_PL_REGEX_VAR                           54
#Define SCE_PL_REGSUBST_VAR                        55
#Define SCE_PL_BACKTICKS_VAR                       57
#Define SCE_PL_HERE_QQ_VAR                         61
#Define SCE_PL_HERE_QX_VAR                         62
#Define SCE_PL_STRING_QQ_VAR                       64
#Define SCE_PL_STRING_QX_VAR                       65
#Define SCE_PL_STRING_QR_VAR                       66
#Define SCE_RB_DEFAULT                             0
#Define SCE_RB_ERROR                               1
#Define SCE_RB_COMMENTLINE                         2
#Define SCE_RB_POD                                 3
#Define SCE_RB_NUMBER                              4
#Define SCE_RB_WORD                                5
#Define SCE_RB_STRING                              6
#Define SCE_RB_CHARACTER                           7
#Define SCE_RB_CLASSNAME                           8
#Define SCE_RB_DEFNAME                             9
#Define SCE_RB_OPERATOR                            10
#Define SCE_RB_IDENTIFIER                          11
#Define SCE_RB_REGEX                               12
#Define SCE_RB_GLOBAL                              13
#Define SCE_RB_SYMBOL                              14
#Define SCE_RB_MODULE_NAME                         15
#Define SCE_RB_INSTANCE_VAR                        16
#Define SCE_RB_CLASS_VAR                           17
#Define SCE_RB_BACKTICKS                           18
#Define SCE_RB_DATASECTION                         19
#Define SCE_RB_HERE_DELIM                          20
#Define SCE_RB_HERE_Q                              21
#Define SCE_RB_HERE_QQ                             22
#Define SCE_RB_HERE_QX                             23
#Define SCE_RB_STRING_Q                            24
#Define SCE_RB_STRING_QQ                           25
#Define SCE_RB_STRING_QX                           26
#Define SCE_RB_STRING_QR                           27
#Define SCE_RB_STRING_QW                           28
#Define SCE_RB_WORD_DEMOTED                        29
#Define SCE_RB_STDIN                               30
#Define SCE_RB_STDOUT                              31
#Define SCE_RB_STDERR                              40
#Define SCE_RB_UPPER_BOUND                         41
#Define SCE_B_DEFAULT                              0
#Define SCE_B_COMMENT                              1
#Define SCE_B_NUMBER                               2
#Define SCE_B_KEYWORD                              3
#Define SCE_B_STRING                               4
#Define SCE_B_PREPROCESSOR                         5
#Define SCE_B_OPERATOR                             6
#Define SCE_B_IDENTIFIER                           7
#Define SCE_B_DATE                                 8
#Define SCE_B_STRINGEOL                            9
#Define SCE_B_KEYWORD2                             10
#Define SCE_B_KEYWORD3                             11
#Define SCE_B_KEYWORD4                             12
#Define SCE_B_CONSTANT                             13
#Define SCE_B_ASM                                  14
#Define SCE_B_LABEL                                15
#Define SCE_B_ERROR                                16
#Define SCE_B_HEXNUMBER                            17
#Define SCE_B_BINNUMBER                            18
#Define SCE_B_MULTILINECOMMENT                     19
#Define SCE_PROPS_DEFAULT                          0
#Define SCE_PROPS_COMMENT                          1
#Define SCE_PROPS_SECTION                          2
#Define SCE_PROPS_ASSIGNMENT                       3
#Define SCE_PROPS_DEFVAL                           4
#Define SCE_PROPS_KEY                              5
#Define SCE_L_DEFAULT                              0
#Define SCE_L_COMMAND                              1
#Define SCE_L_TAG                                  2
#Define SCE_L_MATH                                 3
#Define SCE_L_COMMENT                              4
#Define SCE_L_TAG2                                 5
#Define SCE_L_MATH2                                6
#Define SCE_L_COMMENT2                             7
#Define SCE_L_VERBATIM                             8
#Define SCE_L_SHORTCMD                             9
#Define SCE_L_SPECIAL                              10
#Define SCE_L_CMDOPT                               11
#Define SCE_L_ERROR                                12
#Define SCE_LUA_DEFAULT                            0
#Define SCE_LUA_COMMENT                            1
#Define SCE_LUA_COMMENTLINE                        2
#Define SCE_LUA_COMMENTDOC                         3
#Define SCE_LUA_NUMBER                             4
#Define SCE_LUA_WORD                               5
#Define SCE_LUA_STRING                             6
#Define SCE_LUA_CHARACTER                          7
#Define SCE_LUA_LITERALSTRING                      8
#Define SCE_LUA_PREPROCESSOR                       9
#Define SCE_LUA_OPERATOR                           10
#Define SCE_LUA_IDENTIFIER                         11
#Define SCE_LUA_STRINGEOL                          12
#Define SCE_LUA_WORD2                              13
#Define SCE_LUA_WORD3                              14
#Define SCE_LUA_WORD4                              15
#Define SCE_LUA_WORD5                              16
#Define SCE_LUA_WORD6                              17
#Define SCE_LUA_WORD7                              18
#Define SCE_LUA_WORD8                              19
#Define SCE_LUA_LABEL                              20
#Define SCE_ERR_DEFAULT                            0
#Define SCE_ERR_PYTHON                             1
#Define SCE_ERR_GCC                                2
#Define SCE_ERR_MS                                 3
#Define SCE_ERR_CMD                                4
#Define SCE_ERR_BORLAND                            5
#Define SCE_ERR_PERL                               6
#Define SCE_ERR_NET                                7
#Define SCE_ERR_LUA                                8
#Define SCE_ERR_CTAG                               9
#Define SCE_ERR_DIFF_CHANGED                       10
#Define SCE_ERR_DIFF_ADDITION                      11
#Define SCE_ERR_DIFF_DELETION                      12
#Define SCE_ERR_DIFF_MESSAGE                       13
#Define SCE_ERR_PHP                                14
#Define SCE_ERR_ELF                                15
#Define SCE_ERR_IFC                                16
#Define SCE_ERR_IFORT                              17
#Define SCE_ERR_ABSF                               18
#Define SCE_ERR_TIDY                               19
#Define SCE_ERR_JAVA_STACK                         20
#Define SCE_ERR_VALUE                              21
#Define SCE_BAT_DEFAULT                            0
#Define SCE_BAT_COMMENT                            1
#Define SCE_BAT_WORD                               2
#Define SCE_BAT_LABEL                              3
#Define SCE_BAT_HIDE                               4
#Define SCE_BAT_COMMAND                            5
#Define SCE_BAT_IDENTIFIER                         6
#Define SCE_BAT_OPERATOR                           7
#Define SCE_TCMD_DEFAULT                           0
#Define SCE_TCMD_COMMENT                           1
#Define SCE_TCMD_WORD                              2
#Define SCE_TCMD_LABEL                             3
#Define SCE_TCMD_HIDE                              4
#Define SCE_TCMD_COMMAND                           5
#Define SCE_TCMD_IDENTIFIER                        6
#Define SCE_TCMD_OPERATOR                          7
#Define SCE_TCMD_ENVIRONMENT                       8
#Define SCE_TCMD_EXPANSION                         9
#Define SCE_TCMD_CLABEL                            10
#Define SCE_MAKE_DEFAULT                           0
#Define SCE_MAKE_COMMENT                           1
#Define SCE_MAKE_PREPROCESSOR                      2
#Define SCE_MAKE_IDENTIFIER                        3
#Define SCE_MAKE_OPERATOR                          4
#Define SCE_MAKE_TARGET                            5
#Define SCE_MAKE_IDEOL                             9
#Define SCE_DIFF_DEFAULT                           0
#Define SCE_DIFF_COMMENT                           1
#Define SCE_DIFF_COMMAND                           2
#Define SCE_DIFF_HEADER                            3
#Define SCE_DIFF_POSITION                          4
#Define SCE_DIFF_DELETED                           5
#Define SCE_DIFF_ADDED                             6
#Define SCE_DIFF_CHANGED                           7
#Define SCE_CONF_DEFAULT                           0
#Define SCE_CONF_COMMENT                           1
#Define SCE_CONF_NUMBER                            2
#Define SCE_CONF_IDENTIFIER                        3
#Define SCE_CONF_EXTENSION                         4
#Define SCE_CONF_PARAMETER                         5
#Define SCE_CONF_STRING                            6
#Define SCE_CONF_OPERATOR                          7
#Define SCE_CONF_IP                                8
#Define SCE_CONF_DIRECTIVE                         9
#Define SCE_AVE_DEFAULT                            0
#Define SCE_AVE_COMMENT                            1
#Define SCE_AVE_NUMBER                             2
#Define SCE_AVE_WORD                               3
#Define SCE_AVE_STRING                             6
#Define SCE_AVE_ENUM                               7
#Define SCE_AVE_STRINGEOL                          8
#Define SCE_AVE_IDENTIFIER                         9
#Define SCE_AVE_OPERATOR                           10
#Define SCE_AVE_WORD1                              11
#Define SCE_AVE_WORD2                              12
#Define SCE_AVE_WORD3                              13
#Define SCE_AVE_WORD4                              14
#Define SCE_AVE_WORD5                              15
#Define SCE_AVE_WORD6                              16
#Define SCE_ADA_DEFAULT                            0
#Define SCE_ADA_WORD                               1
#Define SCE_ADA_IDENTIFIER                         2
#Define SCE_ADA_NUMBER                             3
#Define SCE_ADA_DELIMITER                          4
#Define SCE_ADA_CHARACTER                          5
#Define SCE_ADA_CHARACTEREOL                       6
#Define SCE_ADA_STRING                             7
#Define SCE_ADA_STRINGEOL                          8
#Define SCE_ADA_LABEL                              9
#Define SCE_ADA_COMMENTLINE                        10
#Define SCE_ADA_ILLEGAL                            11
#Define SCE_BAAN_DEFAULT                           0
#Define SCE_BAAN_COMMENT                           1
#Define SCE_BAAN_COMMENTDOC                        2
#Define SCE_BAAN_NUMBER                            3
#Define SCE_BAAN_WORD                              4
#Define SCE_BAAN_STRING                            5
#Define SCE_BAAN_PREPROCESSOR                      6
#Define SCE_BAAN_OPERATOR                          7
#Define SCE_BAAN_IDENTIFIER                        8
#Define SCE_BAAN_STRINGEOL                         9
#Define SCE_BAAN_WORD2                             10
#Define SCE_LISP_DEFAULT                           0
#Define SCE_LISP_COMMENT                           1
#Define SCE_LISP_NUMBER                            2
#Define SCE_LISP_KEYWORD                           3
#Define SCE_LISP_KEYWORD_KW                        4
#Define SCE_LISP_SYMBOL                            5
#Define SCE_LISP_STRING                            6
#Define SCE_LISP_STRINGEOL                         8
#Define SCE_LISP_IDENTIFIER                        9
#Define SCE_LISP_OPERATOR                          10
#Define SCE_LISP_SPECIAL                           11
#Define SCE_LISP_MULTI_COMMENT                     12
#Define SCE_EIFFEL_DEFAULT                         0
#Define SCE_EIFFEL_COMMENTLINE                     1
#Define SCE_EIFFEL_NUMBER                          2
#Define SCE_EIFFEL_WORD                            3
#Define SCE_EIFFEL_STRING                          4
#Define SCE_EIFFEL_CHARACTER                       5
#Define SCE_EIFFEL_OPERATOR                        6
#Define SCE_EIFFEL_IDENTIFIER                      7
#Define SCE_EIFFEL_STRINGEOL                       8
#Define SCE_NNCRONTAB_DEFAULT                      0
#Define SCE_NNCRONTAB_COMMENT                      1
#Define SCE_NNCRONTAB_TASK                         2
#Define SCE_NNCRONTAB_SECTION                      3
#Define SCE_NNCRONTAB_KEYWORD                      4
#Define SCE_NNCRONTAB_MODIFIER                     5
#Define SCE_NNCRONTAB_ASTERISK                     6
#Define SCE_NNCRONTAB_NUMBER                       7
#Define SCE_NNCRONTAB_STRING                       8
#Define SCE_NNCRONTAB_ENVIRONMENT                  9
#Define SCE_NNCRONTAB_IDENTIFIER                   10
#Define SCE_FORTH_DEFAULT                          0
#Define SCE_FORTH_COMMENT                          1
#Define SCE_FORTH_COMMENT_ML                       2
#Define SCE_FORTH_IDENTIFIER                       3
#Define SCE_FORTH_CONTROL                          4
#Define SCE_FORTH_KEYWORD                          5
#Define SCE_FORTH_DEFWORD                          6
#Define SCE_FORTH_PREWORD1                         7
#Define SCE_FORTH_PREWORD2                         8
#Define SCE_FORTH_NUMBER                           9
#Define SCE_FORTH_STRING                           10
#Define SCE_FORTH_LOCALE                           11
#Define SCE_MATLAB_DEFAULT                         0
#Define SCE_MATLAB_COMMENT                         1
#Define SCE_MATLAB_COMMAND                         2
#Define SCE_MATLAB_NUMBER                          3
#Define SCE_MATLAB_KEYWORD                         4
#Define SCE_MATLAB_STRING                          5
#Define SCE_MATLAB_OPERATOR                        6
#Define SCE_MATLAB_IDENTIFIER                      7
#Define SCE_MATLAB_DOUBLEQUOTESTRING               8
#Define SCE_SCRIPTOL_DEFAULT                       0
#Define SCE_SCRIPTOL_WHITE                         1
#Define SCE_SCRIPTOL_COMMENTLINE                   2
#Define SCE_SCRIPTOL_PERSISTENT                    3
#Define SCE_SCRIPTOL_CSTYLE                        4
#Define SCE_SCRIPTOL_COMMENTBLOCK                  5
#Define SCE_SCRIPTOL_NUMBER                        6
#Define SCE_SCRIPTOL_STRING                        7
#Define SCE_SCRIPTOL_CHARACTER                     8
#Define SCE_SCRIPTOL_STRINGEOL                     9
#Define SCE_SCRIPTOL_KEYWORD                       10
#Define SCE_SCRIPTOL_OPERATOR                      11
#Define SCE_SCRIPTOL_IDENTIFIER                    12
#Define SCE_SCRIPTOL_TRIPLE                        13
#Define SCE_SCRIPTOL_CLASSNAME                     14
#Define SCE_SCRIPTOL_PREPROCESSOR                  15
#Define SCE_ASM_DEFAULT                            0
#Define SCE_ASM_COMMENT                            1
#Define SCE_ASM_NUMBER                             2
#Define SCE_ASM_STRING                             3
#Define SCE_ASM_OPERATOR                           4
#Define SCE_ASM_IDENTIFIER                         5
#Define SCE_ASM_CPUINSTRUCTION                     6
#Define SCE_ASM_MATHINSTRUCTION                    7
#Define SCE_ASM_REGISTER                           8
#Define SCE_ASM_DIRECTIVE                          9
#Define SCE_ASM_DIRECTIVEOPERAND                   10
#Define SCE_ASM_COMMENTBLOCK                       11
#Define SCE_ASM_CHARACTER                          12
#Define SCE_ASM_STRINGEOL                          13
#Define SCE_ASM_EXTINSTRUCTION                     14
#Define SCE_ASM_COMMENTDIRECTIVE                   15
#Define SCE_F_DEFAULT                              0
#Define SCE_F_COMMENT                              1
#Define SCE_F_NUMBER                               2
#Define SCE_F_STRING1                              3
#Define SCE_F_STRING2                              4
#Define SCE_F_STRINGEOL                            5
#Define SCE_F_OPERATOR                             6
#Define SCE_F_IDENTIFIER                           7
#Define SCE_F_WORD                                 8
#Define SCE_F_WORD2                                9
#Define SCE_F_WORD3                                10
#Define SCE_F_PREPROCESSOR                         11
#Define SCE_F_OPERATOR2                            12
#Define SCE_F_LABEL                                13
#Define SCE_F_CONTINUATION                         14
#Define SCE_CSS_DEFAULT                            0
#Define SCE_CSS_TAG                                1
#Define SCE_CSS_CLASS                              2
#Define SCE_CSS_PSEUDOCLASS                        3
#Define SCE_CSS_UNKNOWN_PSEUDOCLASS                4
#Define SCE_CSS_OPERATOR                           5
#Define SCE_CSS_IDENTIFIER                         6
#Define SCE_CSS_UNKNOWN_IDENTIFIER                 7
#Define SCE_CSS_VALUE                              8
#Define SCE_CSS_COMMENT                            9
#Define SCE_CSS_ID                                 10
#Define SCE_CSS_IMPORTANT                          11
#Define SCE_CSS_DIRECTIVE                          12
#Define SCE_CSS_DOUBLESTRING                       13
#Define SCE_CSS_SINGLESTRING                       14
#Define SCE_CSS_IDENTIFIER2                        15
#Define SCE_CSS_ATTRIBUTE                          16
#Define SCE_CSS_IDENTIFIER3                        17
#Define SCE_CSS_PSEUDOELEMENT                      18
#Define SCE_CSS_EXTENDED_IDENTIFIER                19
#Define SCE_CSS_EXTENDED_PSEUDOCLASS               20
#Define SCE_CSS_EXTENDED_PSEUDOELEMENT             21
#Define SCE_CSS_MEDIA                              22
#Define SCE_CSS_VARIABLE                           23
#Define SCE_POV_DEFAULT                            0
#Define SCE_POV_COMMENT                            1
#Define SCE_POV_COMMENTLINE                        2
#Define SCE_POV_NUMBER                             3
#Define SCE_POV_OPERATOR                           4
#Define SCE_POV_IDENTIFIER                         5
#Define SCE_POV_STRING                             6
#Define SCE_POV_STRINGEOL                          7
#Define SCE_POV_DIRECTIVE                          8
#Define SCE_POV_BADDIRECTIVE                       9
#Define SCE_POV_WORD2                              10
#Define SCE_POV_WORD3                              11
#Define SCE_POV_WORD4                              12
#Define SCE_POV_WORD5                              13
#Define SCE_POV_WORD6                              14
#Define SCE_POV_WORD7                              15
#Define SCE_POV_WORD8                              16
#Define SCE_LOUT_DEFAULT                           0
#Define SCE_LOUT_COMMENT                           1
#Define SCE_LOUT_NUMBER                            2
#Define SCE_LOUT_WORD                              3
#Define SCE_LOUT_WORD2                             4
#Define SCE_LOUT_WORD3                             5
#Define SCE_LOUT_WORD4                             6
#Define SCE_LOUT_STRING                            7
#Define SCE_LOUT_OPERATOR                          8
#Define SCE_LOUT_IDENTIFIER                        9
#Define SCE_LOUT_STRINGEOL                         10
#Define SCE_ESCRIPT_DEFAULT                        0
#Define SCE_ESCRIPT_COMMENT                        1
#Define SCE_ESCRIPT_COMMENTLINE                    2
#Define SCE_ESCRIPT_COMMENTDOC                     3
#Define SCE_ESCRIPT_NUMBER                         4
#Define SCE_ESCRIPT_WORD                           5
#Define SCE_ESCRIPT_STRING                         6
#Define SCE_ESCRIPT_OPERATOR                       7
#Define SCE_ESCRIPT_IDENTIFIER                     8
#Define SCE_ESCRIPT_BRACE                          9
#Define SCE_ESCRIPT_WORD2                          10
#Define SCE_ESCRIPT_WORD3                          11
#Define SCE_PS_DEFAULT                             0
#Define SCE_PS_COMMENT                             1
#Define SCE_PS_DSC_COMMENT                         2
#Define SCE_PS_DSC_VALUE                           3
#Define SCE_PS_NUMBER                              4
#Define SCE_PS_NAME                                5
#Define SCE_PS_KEYWORD                             6
#Define SCE_PS_LITERAL                             7
#Define SCE_PS_IMMEVAL                             8
#Define SCE_PS_PAREN_ARRAY                         9
#Define SCE_PS_PAREN_DICT                          10
#Define SCE_PS_PAREN_PROC                          11
#Define SCE_PS_TEXT                                12
#Define SCE_PS_HEXSTRING                           13
#Define SCE_PS_BASE85STRING                        14
#Define SCE_PS_BADSTRINGCHAR                       15
#Define SCE_NSIS_DEFAULT                           0
#Define SCE_NSIS_COMMENT                           1
#Define SCE_NSIS_STRINGDQ                          2
#Define SCE_NSIS_STRINGLQ                          3
#Define SCE_NSIS_STRINGRQ                          4
#Define SCE_NSIS_FUNCTION                          5
#Define SCE_NSIS_VARIABLE                          6
#Define SCE_NSIS_LABEL                             7
#Define SCE_NSIS_USERDEFINED                       8
#Define SCE_NSIS_SECTIONDEF                        9
#Define SCE_NSIS_SUBSECTIONDEF                     10
#Define SCE_NSIS_IFDEFINEDEF                       11
#Define SCE_NSIS_MACRODEF                          12
#Define SCE_NSIS_STRINGVAR                         13
#Define SCE_NSIS_NUMBER                            14
#Define SCE_NSIS_SECTIONGROUP                      15
#Define SCE_NSIS_PAGEEX                            16
#Define SCE_NSIS_FUNCTIONDEF                       17
#Define SCE_NSIS_COMMENTBOX                        18
#Define SCE_MMIXAL_LEADWS                          0
#Define SCE_MMIXAL_COMMENT                         1
#Define SCE_MMIXAL_LABEL                           2
#Define SCE_MMIXAL_OPCODE                          3
#Define SCE_MMIXAL_OPCODE_PRE                      4
#Define SCE_MMIXAL_OPCODE_VALID                    5
#Define SCE_MMIXAL_OPCODE_UNKNOWN                  6
#Define SCE_MMIXAL_OPCODE_POST                     7
#Define SCE_MMIXAL_OPERANDS                        8
#Define SCE_MMIXAL_NUMBER                          9
#Define SCE_MMIXAL_REF                             10
#Define SCE_MMIXAL_CHAR                            11
#Define SCE_MMIXAL_STRING                          12
#Define SCE_MMIXAL_REGISTER                        13
#Define SCE_MMIXAL_HEX                             14
#Define SCE_MMIXAL_OPERATOR                        15
#Define SCE_MMIXAL_SYMBOL                          16
#Define SCE_MMIXAL_INCLUDE                         17
#Define SCE_CLW_DEFAULT                            0
#Define SCE_CLW_LABEL                              1
#Define SCE_CLW_COMMENT                            2
#Define SCE_CLW_STRING                             3
#Define SCE_CLW_USER_IDENTIFIER                    4
#Define SCE_CLW_INTEGER_CONSTANT                   5
#Define SCE_CLW_REAL_CONSTANT                      6
#Define SCE_CLW_PICTURE_STRING                     7
#Define SCE_CLW_KEYWORD                            8
#Define SCE_CLW_COMPILER_DIRECTIVE                 9
#Define SCE_CLW_RUNTIME_EXPRESSIONS                10
#Define SCE_CLW_BUILTIN_PROCEDURES_FUNCTION        11
#Define SCE_CLW_STRUCTURE_DATA_TYPE                12
#Define SCE_CLW_ATTRIBUTE                          13
#Define SCE_CLW_STANDARD_EQUATE                    14
#Define SCE_CLW_ERROR                              15
#Define SCE_CLW_DEPRECATED                         16
#Define SCE_LOT_DEFAULT                            0
#Define SCE_LOT_HEADER                             1
#Define SCE_LOT_BREAK                              2
#Define SCE_LOT_SET                                3
#Define SCE_LOT_PASS                               4
#Define SCE_LOT_FAIL                               5
#Define SCE_LOT_ABORT                              6
#Define SCE_YAML_DEFAULT                           0
#Define SCE_YAML_COMMENT                           1
#Define SCE_YAML_IDENTIFIER                        2
#Define SCE_YAML_KEYWORD                           3
#Define SCE_YAML_NUMBER                            4
#Define SCE_YAML_REFERENCE                         5
#Define SCE_YAML_DOCUMENT                          6
#Define SCE_YAML_TEXT                              7
#Define SCE_YAML_ERROR                             8
#Define SCE_YAML_OPERATOR                          9
#Define SCE_TEX_DEFAULT                            0
#Define SCE_TEX_SPECIAL                            1
#Define SCE_TEX_GROUP                              2
#Define SCE_TEX_SYMBOL                             3
#Define SCE_TEX_COMMAND                            4
#Define SCE_TEX_TEXT                               5
#Define SCE_METAPOST_DEFAULT                       0
#Define SCE_METAPOST_SPECIAL                       1
#Define SCE_METAPOST_GROUP                         2
#Define SCE_METAPOST_SYMBOL                        3
#Define SCE_METAPOST_COMMAND                       4
#Define SCE_METAPOST_TEXT                          5
#Define SCE_METAPOST_EXTRA                         6
#Define SCE_ERLANG_DEFAULT                         0
#Define SCE_ERLANG_COMMENT                         1
#Define SCE_ERLANG_VARIABLE                        2
#Define SCE_ERLANG_NUMBER                          3
#Define SCE_ERLANG_KEYWORD                         4
#Define SCE_ERLANG_STRING                          5
#Define SCE_ERLANG_OPERATOR                        6
#Define SCE_ERLANG_ATOM                            7
#Define SCE_ERLANG_FUNCTION_NAME                   8
#Define SCE_ERLANG_CHARACTER                       9
#Define SCE_ERLANG_MACRO                           10
#Define SCE_ERLANG_RECORD                          11
#Define SCE_ERLANG_PREPROC                         12
#Define SCE_ERLANG_NODE_NAME                       13
#Define SCE_ERLANG_COMMENT_FUNCTION                14
#Define SCE_ERLANG_COMMENT_MODULE                  15
#Define SCE_ERLANG_COMMENT_DOC                     16
#Define SCE_ERLANG_COMMENT_DOC_MACRO               17
#Define SCE_ERLANG_ATOM_QUOTED                     18
#Define SCE_ERLANG_MACRO_QUOTED                    19
#Define SCE_ERLANG_RECORD_QUOTED                   20
#Define SCE_ERLANG_NODE_NAME_QUOTED                21
#Define SCE_ERLANG_BIFS                            22
#Define SCE_ERLANG_MODULES                         23
#Define SCE_ERLANG_MODULES_ATT                     24
#Define SCE_ERLANG_UNKNOWN                         31
#Define SCE_MSSQL_DEFAULT                          0
#Define SCE_MSSQL_COMMENT                          1
#Define SCE_MSSQL_LINE_COMMENT                     2
#Define SCE_MSSQL_NUMBER                           3
#Define SCE_MSSQL_STRING                           4
#Define SCE_MSSQL_OPERATOR                         5
#Define SCE_MSSQL_IDENTIFIER                       6
#Define SCE_MSSQL_VARIABLE                         7
#Define SCE_MSSQL_COLUMN_NAME                      8
#Define SCE_MSSQL_STATEMENT                        9
#Define SCE_MSSQL_DATATYPE                         10
#Define SCE_MSSQL_SYSTABLE                         11
#Define SCE_MSSQL_GLOBAL_VARIABLE                  12
#Define SCE_MSSQL_FUNCTION                         13
#Define SCE_MSSQL_STORED_PROCEDURE                 14
#Define SCE_MSSQL_DEFAULT_PREF_DATATYPE            15
#Define SCE_MSSQL_COLUMN_NAME_2                    16
#Define SCE_V_DEFAULT                              0
#Define SCE_V_COMMENT                              1
#Define SCE_V_COMMENTLINE                          2
#Define SCE_V_COMMENTLINEBANG                      3
#Define SCE_V_NUMBER                               4
#Define SCE_V_WORD                                 5
#Define SCE_V_STRING                               6
#Define SCE_V_WORD2                                7
#Define SCE_V_WORD3                                8
#Define SCE_V_PREPROCESSOR                         9
#Define SCE_V_OPERATOR                             10
#Define SCE_V_IDENTIFIER                           11
#Define SCE_V_STRINGEOL                            12
#Define SCE_V_USER                                 19
#Define SCE_KIX_DEFAULT                            0
#Define SCE_KIX_COMMENT                            1
#Define SCE_KIX_STRING1                            2
#Define SCE_KIX_STRING2                            3
#Define SCE_KIX_NUMBER                             4
#Define SCE_KIX_VAR                                5
#Define SCE_KIX_MACRO                              6
#Define SCE_KIX_KEYWORD                            7
#Define SCE_KIX_FUNCTIONS                          8
#Define SCE_KIX_OPERATOR                           9
#Define SCE_KIX_IDENTIFIER                         31
#Define SCE_GC_DEFAULT                             0
#Define SCE_GC_COMMENTLINE                         1
#Define SCE_GC_COMMENTBLOCK                        2
#Define SCE_GC_GLOBAL                              3
#Define SCE_GC_EVENT                               4
#Define SCE_GC_ATTRIBUTE                           5
#Define SCE_GC_CONTROL                             6
#Define SCE_GC_COMMAND                             7
#Define SCE_GC_STRING                              8
#Define SCE_GC_OPERATOR                            9
#Define SCE_SN_DEFAULT                             0
#Define SCE_SN_CODE                                1
#Define SCE_SN_COMMENTLINE                         2
#Define SCE_SN_COMMENTLINEBANG                     3
#Define SCE_SN_NUMBER                              4
#Define SCE_SN_WORD                                5
#Define SCE_SN_STRING                              6
#Define SCE_SN_WORD2                               7
#Define SCE_SN_WORD3                               8
#Define SCE_SN_PREPROCESSOR                        9
#Define SCE_SN_OPERATOR                            10
#Define SCE_SN_IDENTIFIER                          11
#Define SCE_SN_STRINGEOL                           12
#Define SCE_SN_REGEXTAG                            13
#Define SCE_SN_SIGNAL                              14
#Define SCE_SN_USER                                19
#Define SCE_AU3_DEFAULT                            0
#Define SCE_AU3_COMMENT                            1
#Define SCE_AU3_COMMENTBLOCK                       2
#Define SCE_AU3_NUMBER                             3
#Define SCE_AU3_FUNCTION                           4
#Define SCE_AU3_KEYWORD                            5
#Define SCE_AU3_MACRO                              6
#Define SCE_AU3_STRING                             7
#Define SCE_AU3_OPERATOR                           8
#Define SCE_AU3_VARIABLE                           9
#Define SCE_AU3_SENT                               10
#Define SCE_AU3_PREPROCESSOR                       11
#Define SCE_AU3_SPECIAL                            12
#Define SCE_AU3_EXPAND                             13
#Define SCE_AU3_COMOBJ                             14
#Define SCE_AU3_UDF                                15
#Define SCE_APDL_DEFAULT                           0
#Define SCE_APDL_COMMENT                           1
#Define SCE_APDL_COMMENTBLOCK                      2
#Define SCE_APDL_NUMBER                            3
#Define SCE_APDL_STRING                            4
#Define SCE_APDL_OPERATOR                          5
#Define SCE_APDL_WORD                              6
#Define SCE_APDL_PROCESSOR                         7
#Define SCE_APDL_COMMAND                           8
#Define SCE_APDL_SLASHCOMMAND                      9
#Define SCE_APDL_STARCOMMAND                       10
#Define SCE_APDL_ARGUMENT                          11
#Define SCE_APDL_FUNCTION                          12
#Define SCE_SH_DEFAULT                             0
#Define SCE_SH_ERROR                               1
#Define SCE_SH_COMMENTLINE                         2
#Define SCE_SH_NUMBER                              3
#Define SCE_SH_WORD                                4
#Define SCE_SH_STRING                              5
#Define SCE_SH_CHARACTER                           6
#Define SCE_SH_OPERATOR                            7
#Define SCE_SH_IDENTIFIER                          8
#Define SCE_SH_SCALAR                              9
#Define SCE_SH_PARAM                               10
#Define SCE_SH_BACKTICKS                           11
#Define SCE_SH_HERE_DELIM                          12
#Define SCE_SH_HERE_Q                              13
#Define SCE_ASN1_DEFAULT                           0
#Define SCE_ASN1_COMMENT                           1
#Define SCE_ASN1_IDENTIFIER                        2
#Define SCE_ASN1_STRING                            3
#Define SCE_ASN1_OID                               4
#Define SCE_ASN1_SCALAR                            5
#Define SCE_ASN1_KEYWORD                           6
#Define SCE_ASN1_ATTRIBUTE                         7
#Define SCE_ASN1_DESCRIPTOR                        8
#Define SCE_ASN1_TYPE                              9
#Define SCE_ASN1_OPERATOR                          10
#Define SCE_VHDL_DEFAULT                           0
#Define SCE_VHDL_COMMENT                           1
#Define SCE_VHDL_COMMENTLINEBANG                   2
#Define SCE_VHDL_NUMBER                            3
#Define SCE_VHDL_STRING                            4
#Define SCE_VHDL_OPERATOR                          5
#Define SCE_VHDL_IDENTIFIER                        6
#Define SCE_VHDL_STRINGEOL                         7
#Define SCE_VHDL_KEYWORD                           8
#Define SCE_VHDL_STDOPERATOR                       9
#Define SCE_VHDL_ATTRIBUTE                         10
#Define SCE_VHDL_STDFUNCTION                       11
#Define SCE_VHDL_STDPACKAGE                        12
#Define SCE_VHDL_STDTYPE                           13
#Define SCE_VHDL_USERWORD                          14
#Define SCE_CAML_DEFAULT                           0
#Define SCE_CAML_IDENTIFIER                        1
#Define SCE_CAML_TAGNAME                           2
#Define SCE_CAML_KEYWORD                           3
#Define SCE_CAML_KEYWORD2                          4
#Define SCE_CAML_KEYWORD3                          5
#Define SCE_CAML_LINENUM                           6
#Define SCE_CAML_OPERATOR                          7
#Define SCE_CAML_NUMBER                            8
#Define SCE_CAML_CHAR                              9
#Define SCE_CAML_WHITE                             10
#Define SCE_CAML_STRING                            11
#Define SCE_CAML_COMMENT                           12
#Define SCE_CAML_COMMENT1                          13
#Define SCE_CAML_COMMENT2                          14
#Define SCE_CAML_COMMENT3                          15
#Define SCE_HA_DEFAULT                             0
#Define SCE_HA_IDENTIFIER                          1
#Define SCE_HA_KEYWORD                             2
#Define SCE_HA_NUMBER                              3
#Define SCE_HA_STRING                              4
#Define SCE_HA_CHARACTER                           5
#Define SCE_HA_CLASS                               6
#Define SCE_HA_MODULE                              7
#Define SCE_HA_CAPITAL                             8
#Define SCE_HA_DATA                                9
#Define SCE_HA_IMPORT                              10
#Define SCE_HA_OPERATOR                            11
#Define SCE_HA_INSTANCE                            12
#Define SCE_HA_COMMENTLINE                         13
#Define SCE_HA_COMMENTBLOCK                        14
#Define SCE_HA_COMMENTBLOCK2                       15
#Define SCE_HA_COMMENTBLOCK3                       16
#Define SCE_HA_PRAGMA                              17
#Define SCE_HA_PREPROCESSOR                        18
#Define SCE_HA_STRINGEOL                           19
#Define SCE_HA_RESERVED_OPERATOR                   20
#Define SCE_HA_LITERATE_COMMENT                    21
#Define SCE_HA_LITERATE_CODEDELIM                  22
#Define SCE_T3_DEFAULT                             0
#Define SCE_T3_X_DEFAULT                           1
#Define SCE_T3_PREPROCESSOR                        2
#Define SCE_T3_BLOCK_COMMENT                       3
#Define SCE_T3_LINE_COMMENT                        4
#Define SCE_T3_OPERATOR                            5
#Define SCE_T3_KEYWORD                             6
#Define SCE_T3_NUMBER                              7
#Define SCE_T3_IDENTIFIER                          8
#Define SCE_T3_S_STRING                            9
#Define SCE_T3_D_STRING                            10
#Define SCE_T3_X_STRING                            11
#Define SCE_T3_LIB_DIRECTIVE                       12
#Define SCE_T3_MSG_PARAM                           13
#Define SCE_T3_HTML_TAG                            14
#Define SCE_T3_HTML_DEFAULT                        15
#Define SCE_T3_HTML_STRING                         16
#Define SCE_T3_USER1                               17
#Define SCE_T3_USER2                               18
#Define SCE_T3_USER3                               19
#Define SCE_T3_BRACE                               20
#Define SCE_REBOL_DEFAULT                          0
#Define SCE_REBOL_COMMENTLINE                      1
#Define SCE_REBOL_COMMENTBLOCK                     2
#Define SCE_REBOL_PREFACE                          3
#Define SCE_REBOL_OPERATOR                         4
#Define SCE_REBOL_CHARACTER                        5
#Define SCE_REBOL_QUOTEDSTRING                     6
#Define SCE_REBOL_BRACEDSTRING                     7
#Define SCE_REBOL_NUMBER                           8
#Define SCE_REBOL_PAIR                             9
#Define SCE_REBOL_TUPLE                            10
#Define SCE_REBOL_BINARY                           11
#Define SCE_REBOL_MONEY                            12
#Define SCE_REBOL_ISSUE                            13
#Define SCE_REBOL_TAG                              14
#Define SCE_REBOL_FILE                             15
#Define SCE_REBOL_EMAIL                            16
#Define SCE_REBOL_URL                              17
#Define SCE_REBOL_DATE                             18
#Define SCE_REBOL_TIME                             19
#Define SCE_REBOL_IDENTIFIER                       20
#Define SCE_REBOL_WORD                             21
#Define SCE_REBOL_WORD2                            22
#Define SCE_REBOL_WORD3                            23
#Define SCE_REBOL_WORD4                            24
#Define SCE_REBOL_WORD5                            25
#Define SCE_REBOL_WORD6                            26
#Define SCE_REBOL_WORD7                            27
#Define SCE_REBOL_WORD8                            28
#Define SCE_SQL_DEFAULT                            0
#Define SCE_SQL_COMMENT                            1
#Define SCE_SQL_COMMENTLINE                        2
#Define SCE_SQL_COMMENTDOC                         3
#Define SCE_SQL_NUMBER                             4
#Define SCE_SQL_WORD                               5
#Define SCE_SQL_STRING                             6
#Define SCE_SQL_CHARACTER                          7
#Define SCE_SQL_SQLPLUS                            8
#Define SCE_SQL_SQLPLUS_PROMPT                     9
#Define SCE_SQL_OPERATOR                           10
#Define SCE_SQL_IDENTIFIER                         11
#Define SCE_SQL_SQLPLUS_COMMENT                    13
#Define SCE_SQL_COMMENTLINEDOC                     15
#Define SCE_SQL_WORD2                              16
#Define SCE_SQL_COMMENTDOCKEYWORD                  17
#Define SCE_SQL_COMMENTDOCKEYWORDERROR             18
#Define SCE_SQL_USER1                              19
#Define SCE_SQL_USER2                              20
#Define SCE_SQL_USER3                              21
#Define SCE_SQL_USER4                              22
#Define SCE_SQL_QUOTEDIDENTIFIER                   23
#Define SCE_ST_DEFAULT                             0
#Define SCE_ST_STRING                              1
#Define SCE_ST_NUMBER                              2
#Define SCE_ST_COMMENT                             3
#Define SCE_ST_SYMBOL                              4
#Define SCE_ST_BINARY                              5
#Define SCE_ST_BOOL                                6
#Define SCE_ST_SELF                                7
#Define SCE_ST_SUPER                               8
#Define SCE_ST_NIL                                 9
#Define SCE_ST_GLOBAL                              10
#Define SCE_ST_RETURN                              11
#Define SCE_ST_SPECIAL                             12
#Define SCE_ST_KWSEND                              13
#Define SCE_ST_ASSIGN                              14
#Define SCE_ST_CHARACTER                           15
#Define SCE_ST_SPEC_SEL                            16
#Define SCE_FS_DEFAULT                             0
#Define SCE_FS_COMMENT                             1
#Define SCE_FS_COMMENTLINE                         2
#Define SCE_FS_COMMENTDOC                          3
#Define SCE_FS_COMMENTLINEDOC                      4
#Define SCE_FS_COMMENTDOCKEYWORD                   5
#Define SCE_FS_COMMENTDOCKEYWORDERROR              6
#Define SCE_FS_KEYWORD                             7
#Define SCE_FS_KEYWORD2                            8
#Define SCE_FS_KEYWORD3                            9
#Define SCE_FS_KEYWORD4                            10
#Define SCE_FS_NUMBER                              11
#Define SCE_FS_STRING                              12
#Define SCE_FS_PREPROCESSOR                        13
#Define SCE_FS_OPERATOR                            14
#Define SCE_FS_IDENTIFIER                          15
#Define SCE_FS_DATE                                16
#Define SCE_FS_STRINGEOL                           17
#Define SCE_FS_CONSTANT                            18
#Define SCE_FS_WORDOPERATOR                        19
#Define SCE_FS_DISABLEDCODE                        20
#Define SCE_FS_DEFAULT_C                           21
#Define SCE_FS_COMMENTDOC_C                        22
#Define SCE_FS_COMMENTLINEDOC_C                    23
#Define SCE_FS_KEYWORD_C                           24
#Define SCE_FS_KEYWORD2_C                          25
#Define SCE_FS_NUMBER_C                            26
#Define SCE_FS_STRING_C                            27
#Define SCE_FS_PREPROCESSOR_C                      28
#Define SCE_FS_OPERATOR_C                          29
#Define SCE_FS_IDENTIFIER_C                        30
#Define SCE_FS_STRINGEOL_C                         31
#Define SCE_CSOUND_DEFAULT                         0
#Define SCE_CSOUND_COMMENT                         1
#Define SCE_CSOUND_NUMBER                          2
#Define SCE_CSOUND_OPERATOR                        3
#Define SCE_CSOUND_INSTR                           4
#Define SCE_CSOUND_IDENTIFIER                      5
#Define SCE_CSOUND_OPCODE                          6
#Define SCE_CSOUND_HEADERSTMT                      7
#Define SCE_CSOUND_USERKEYWORD                     8
#Define SCE_CSOUND_COMMENTBLOCK                    9
#Define SCE_CSOUND_PARAM                           10
#Define SCE_CSOUND_ARATE_VAR                       11
#Define SCE_CSOUND_KRATE_VAR                       12
#Define SCE_CSOUND_IRATE_VAR                       13
#Define SCE_CSOUND_GLOBAL_VAR                      14
#Define SCE_CSOUND_STRINGEOL                       15
#Define SCE_INNO_DEFAULT                           0
#Define SCE_INNO_COMMENT                           1
#Define SCE_INNO_KEYWORD                           2
#Define SCE_INNO_PARAMETER                         3
#Define SCE_INNO_SECTION                           4
#Define SCE_INNO_PREPROC                           5
#Define SCE_INNO_INLINE_EXPANSION                  6
#Define SCE_INNO_COMMENT_PASCAL                    7
#Define SCE_INNO_KEYWORD_PASCAL                    8
#Define SCE_INNO_KEYWORD_USER                      9
#Define SCE_INNO_STRING_DOUBLE                     10
#Define SCE_INNO_STRING_SINGLE                     11
#Define SCE_INNO_IDENTIFIER                        12
#Define SCE_OPAL_SPACE                             0
#Define SCE_OPAL_COMMENT_BLOCK                     1
#Define SCE_OPAL_COMMENT_LINE                      2
#Define SCE_OPAL_INTEGER                           3
#Define SCE_OPAL_KEYWORD                           4
#Define SCE_OPAL_SORT                              5
#Define SCE_OPAL_STRING                            6
#Define SCE_OPAL_PAR                               7
#Define SCE_OPAL_BOOL_CONST                        8
#Define SCE_OPAL_DEFAULT                           32
#Define SCE_SPICE_DEFAULT                          0
#Define SCE_SPICE_IDENTIFIER                       1
#Define SCE_SPICE_KEYWORD                          2
#Define SCE_SPICE_KEYWORD2                         3
#Define SCE_SPICE_KEYWORD3                         4
#Define SCE_SPICE_NUMBER                           5
#Define SCE_SPICE_DELIMITER                        6
#Define SCE_SPICE_VALUE                            7
#Define SCE_SPICE_COMMENTLINE                      8
#Define SCE_CMAKE_DEFAULT                          0
#Define SCE_CMAKE_COMMENT                          1
#Define SCE_CMAKE_STRINGDQ                         2
#Define SCE_CMAKE_STRINGLQ                         3
#Define SCE_CMAKE_STRINGRQ                         4
#Define SCE_CMAKE_COMMANDS                         5
#Define SCE_CMAKE_PARAMETERS                       6
#Define SCE_CMAKE_VARIABLE                         7
#Define SCE_CMAKE_USERDEFINED                      8
#Define SCE_CMAKE_WHILEDEF                         9
#Define SCE_CMAKE_FOREACHDEF                       10
#Define SCE_CMAKE_IFDEFINEDEF                      11
#Define SCE_CMAKE_MACRODEF                         12
#Define SCE_CMAKE_STRINGVAR                        13
#Define SCE_CMAKE_NUMBER                           14
#Define SCE_GAP_DEFAULT                            0
#Define SCE_GAP_IDENTIFIER                         1
#Define SCE_GAP_KEYWORD                            2
#Define SCE_GAP_KEYWORD2                           3
#Define SCE_GAP_KEYWORD3                           4
#Define SCE_GAP_KEYWORD4                           5
#Define SCE_GAP_STRING                             6
#Define SCE_GAP_CHAR                               7
#Define SCE_GAP_OPERATOR                           8
#Define SCE_GAP_COMMENT                            9
#Define SCE_GAP_NUMBER                             10
#Define SCE_GAP_STRINGEOL                          11
#Define SCE_PLM_DEFAULT                            0
#Define SCE_PLM_COMMENT                            1
#Define SCE_PLM_STRING                             2
#Define SCE_PLM_NUMBER                             3
#Define SCE_PLM_IDENTIFIER                         4
#Define SCE_PLM_OPERATOR                           5
#Define SCE_PLM_CONTROL                            6
#Define SCE_PLM_KEYWORD                            7
#Define SCE_4GL_DEFAULT                            0
#Define SCE_4GL_NUMBER                             1
#Define SCE_4GL_WORD                               2
#Define SCE_4GL_STRING                             3
#Define SCE_4GL_CHARACTER                          4
#Define SCE_4GL_PREPROCESSOR                       5
#Define SCE_4GL_OPERATOR                           6
#Define SCE_4GL_IDENTIFIER                         7
#Define SCE_4GL_BLOCK                              8
#Define SCE_4GL_END                                9
#Define SCE_4GL_COMMENT1                           10
#Define SCE_4GL_COMMENT2                           11
#Define SCE_4GL_COMMENT3                           12
#Define SCE_4GL_COMMENT4                           13
#Define SCE_4GL_COMMENT5                           14
#Define SCE_4GL_COMMENT6                           15
#Define SCE_4GL_DEFAULT_                           16
#Define SCE_4GL_NUMBER_                            17
#Define SCE_4GL_WORD_                              18
#Define SCE_4GL_STRING_                            19
#Define SCE_4GL_CHARACTER_                         20
#Define SCE_4GL_PREPROCESSOR_                      21
#Define SCE_4GL_OPERATOR_                          22
#Define SCE_4GL_IDENTIFIER_                        23
#Define SCE_4GL_BLOCK_                             24
#Define SCE_4GL_END_                               25
#Define SCE_4GL_COMMENT1_                          26
#Define SCE_4GL_COMMENT2_                          27
#Define SCE_4GL_COMMENT3_                          28
#Define SCE_4GL_COMMENT4_                          29
#Define SCE_4GL_COMMENT5_                          30
#Define SCE_4GL_COMMENT6_                          31
#Define SCE_ABAQUS_DEFAULT                         0
#Define SCE_ABAQUS_COMMENT                         1
#Define SCE_ABAQUS_COMMENTBLOCK                    2
#Define SCE_ABAQUS_NUMBER                          3
#Define SCE_ABAQUS_STRING                          4
#Define SCE_ABAQUS_OPERATOR                        5
#Define SCE_ABAQUS_WORD                            6
#Define SCE_ABAQUS_PROCESSOR                       7
#Define SCE_ABAQUS_COMMAND                         8
#Define SCE_ABAQUS_SLASHCOMMAND                    9
#Define SCE_ABAQUS_STARCOMMAND                     10
#Define SCE_ABAQUS_ARGUMENT                        11
#Define SCE_ABAQUS_FUNCTION                        12
#Define SCE_ASY_DEFAULT                            0
#Define SCE_ASY_COMMENT                            1
#Define SCE_ASY_COMMENTLINE                        2
#Define SCE_ASY_NUMBER                             3
#Define SCE_ASY_WORD                               4
#Define SCE_ASY_STRING                             5
#Define SCE_ASY_CHARACTER                          6
#Define SCE_ASY_OPERATOR                           7
#Define SCE_ASY_IDENTIFIER                         8
#Define SCE_ASY_STRINGEOL                          9
#Define SCE_ASY_COMMENTLINEDOC                     10
#Define SCE_ASY_WORD2                              11
#Define SCE_R_DEFAULT                              0
#Define SCE_R_COMMENT                              1
#Define SCE_R_KWORD                                2
#Define SCE_R_BASEKWORD                            3
#Define SCE_R_OTHERKWORD                           4
#Define SCE_R_NUMBER                               5
#Define SCE_R_STRING                               6
#Define SCE_R_STRING2                              7
#Define SCE_R_OPERATOR                             8
#Define SCE_R_IDENTIFIER                           9
#Define SCE_R_INFIX                                10
#Define SCE_R_INFIXEOL                             11
#Define SCE_MAGIK_DEFAULT                          0
#Define SCE_MAGIK_COMMENT                          1
#Define SCE_MAGIK_HYPER_COMMENT                    16
#Define SCE_MAGIK_STRING                           2
#Define SCE_MAGIK_CHARACTER                        3
#Define SCE_MAGIK_NUMBER                           4
#Define SCE_MAGIK_IDENTIFIER                       5
#Define SCE_MAGIK_OPERATOR                         6
#Define SCE_MAGIK_FLOW                             7
#Define SCE_MAGIK_CONTAINER                        8
#Define SCE_MAGIK_BRACKET_BLOCK                    9
#Define SCE_MAGIK_BRACE_BLOCK                      10
#Define SCE_MAGIK_SQBRACKET_BLOCK                  11
#Define SCE_MAGIK_UNKNOWN_KEYWORD                  12
#Define SCE_MAGIK_KEYWORD                          13
#Define SCE_MAGIK_PRAGMA                           14
#Define SCE_MAGIK_SYMBOL                           15
#Define SCE_POWERSHELL_DEFAULT                     0
#Define SCE_POWERSHELL_COMMENT                     1
#Define SCE_POWERSHELL_STRING                      2
#Define SCE_POWERSHELL_CHARACTER                   3
#Define SCE_POWERSHELL_NUMBER                      4
#Define SCE_POWERSHELL_VARIABLE                    5
#Define SCE_POWERSHELL_OPERATOR                    6
#Define SCE_POWERSHELL_IDENTIFIER                  7
#Define SCE_POWERSHELL_KEYWORD                     8
#Define SCE_POWERSHELL_CMDLET                      9
#Define SCE_POWERSHELL_ALIAS                       10
#Define SCE_POWERSHELL_FUNCTION                    11
#Define SCE_POWERSHELL_USER1                       12
#Define SCE_POWERSHELL_COMMENTSTREAM               13
#Define SCE_POWERSHELL_HERE_STRING                 14
#Define SCE_POWERSHELL_HERE_CHARACTER              15
#Define SCE_POWERSHELL_COMMENTDOCKEYWORD           16
#Define SCE_MYSQL_DEFAULT                          0
#Define SCE_MYSQL_COMMENT                          1
#Define SCE_MYSQL_COMMENTLINE                      2
#Define SCE_MYSQL_VARIABLE                         3
#Define SCE_MYSQL_SYSTEMVARIABLE                   4
#Define SCE_MYSQL_KNOWNSYSTEMVARIABLE              5
#Define SCE_MYSQL_NUMBER                           6
#Define SCE_MYSQL_MAJORKEYWORD                     7
#Define SCE_MYSQL_KEYWORD                          8
#Define SCE_MYSQL_DATABASEOBJECT                   9
#Define SCE_MYSQL_PROCEDUREKEYWORD                 10
#Define SCE_MYSQL_STRING                           11
#Define SCE_MYSQL_SQSTRING                         12
#Define SCE_MYSQL_DQSTRING                         13
#Define SCE_MYSQL_OPERATOR                         14
#Define SCE_MYSQL_FUNCTION                         15
#Define SCE_MYSQL_IDENTIFIER                       16
#Define SCE_MYSQL_QUOTEDIDENTIFIER                 17
#Define SCE_MYSQL_USER1                            18
#Define SCE_MYSQL_USER2                            19
#Define SCE_MYSQL_USER3                            20
#Define SCE_MYSQL_HIDDENCOMMAND                    21
#Define SCE_MYSQL_PLACEHOLDER                      22
#Define SCE_PO_DEFAULT                             0
#Define SCE_PO_COMMENT                             1
#Define SCE_PO_MSGID                               2
#Define SCE_PO_MSGID_TEXT                          3
#Define SCE_PO_MSGSTR                              4
#Define SCE_PO_MSGSTR_TEXT                         5
#Define SCE_PO_MSGCTXT                             6
#Define SCE_PO_MSGCTXT_TEXT                        7
#Define SCE_PO_FUZZY                               8
#Define SCE_PO_PROGRAMMER_COMMENT                  9
#Define SCE_PO_REFERENCE                           10
#Define SCE_PO_FLAGS                               11
#Define SCE_PO_MSGID_TEXT_EOL                      12
#Define SCE_PO_MSGSTR_TEXT_EOL                     13
#Define SCE_PO_MSGCTXT_TEXT_EOL                    14
#Define SCE_PO_ERROR                               15
#Define SCE_PAS_DEFAULT                            0
#Define SCE_PAS_IDENTIFIER                         1
#Define SCE_PAS_COMMENT                            2
#Define SCE_PAS_COMMENT2                           3
#Define SCE_PAS_COMMENTLINE                        4
#Define SCE_PAS_PREPROCESSOR                       5
#Define SCE_PAS_PREPROCESSOR2                      6
#Define SCE_PAS_NUMBER                             7
#Define SCE_PAS_HEXNUMBER                          8
#Define SCE_PAS_WORD                               9
#Define SCE_PAS_STRING                             10
#Define SCE_PAS_STRINGEOL                          11
#Define SCE_PAS_CHARACTER                          12
#Define SCE_PAS_OPERATOR                           13
#Define SCE_PAS_ASM                                14
#Define SCE_SORCUS_DEFAULT                         0
#Define SCE_SORCUS_COMMAND                         1
#Define SCE_SORCUS_PARAMETER                       2
#Define SCE_SORCUS_COMMENTLINE                     3
#Define SCE_SORCUS_STRING                          4
#Define SCE_SORCUS_STRINGEOL                       5
#Define SCE_SORCUS_IDENTIFIER                      6
#Define SCE_SORCUS_OPERATOR                        7
#Define SCE_SORCUS_NUMBER                          8
#Define SCE_SORCUS_CONSTANT                        9
#Define SCE_POWERPRO_DEFAULT                       0
#Define SCE_POWERPRO_COMMENTBLOCK                  1
#Define SCE_POWERPRO_COMMENTLINE                   2
#Define SCE_POWERPRO_NUMBER                        3
#Define SCE_POWERPRO_WORD                          4
#Define SCE_POWERPRO_WORD2                         5
#Define SCE_POWERPRO_WORD3                         6
#Define SCE_POWERPRO_WORD4                         7
#Define SCE_POWERPRO_DOUBLEQUOTEDSTRING            8
#Define SCE_POWERPRO_SINGLEQUOTEDSTRING            9
#Define SCE_POWERPRO_LINECONTINUE                  10
#Define SCE_POWERPRO_OPERATOR                      11
#Define SCE_POWERPRO_IDENTIFIER                    12
#Define SCE_POWERPRO_STRINGEOL                     13
#Define SCE_POWERPRO_VERBATIM                      14
#Define SCE_POWERPRO_ALTQUOTE                      15
#Define SCE_POWERPRO_FUNCTION                      16
#Define SCE_SML_DEFAULT                            0
#Define SCE_SML_IDENTIFIER                         1
#Define SCE_SML_TAGNAME                            2
#Define SCE_SML_KEYWORD                            3
#Define SCE_SML_KEYWORD2                           4
#Define SCE_SML_KEYWORD3                           5
#Define SCE_SML_LINENUM                            6
#Define SCE_SML_OPERATOR                           7
#Define SCE_SML_NUMBER                             8
#Define SCE_SML_CHAR                               9
#Define SCE_SML_STRING                             11
#Define SCE_SML_COMMENT                            12
#Define SCE_SML_COMMENT1                           13
#Define SCE_SML_COMMENT2                           14
#Define SCE_SML_COMMENT3                           15
#Define SCE_MARKDOWN_DEFAULT                       0
#Define SCE_MARKDOWN_LINE_BEGIN                    1
#Define SCE_MARKDOWN_STRONG1                       2
#Define SCE_MARKDOWN_STRONG2                       3
#Define SCE_MARKDOWN_EM1                           4
#Define SCE_MARKDOWN_EM2                           5
#Define SCE_MARKDOWN_HEADER1                       6
#Define SCE_MARKDOWN_HEADER2                       7
#Define SCE_MARKDOWN_HEADER3                       8
#Define SCE_MARKDOWN_HEADER4                       9
#Define SCE_MARKDOWN_HEADER5                       10
#Define SCE_MARKDOWN_HEADER6                       11
#Define SCE_MARKDOWN_PRECHAR                       12
#Define SCE_MARKDOWN_ULIST_ITEM                    13
#Define SCE_MARKDOWN_OLIST_ITEM                    14
#Define SCE_MARKDOWN_BLOCKQUOTE                    15
#Define SCE_MARKDOWN_STRIKEOUT                     16
#Define SCE_MARKDOWN_HRULE                         17
#Define SCE_MARKDOWN_LINK                          18
#Define SCE_MARKDOWN_CODE                          19
#Define SCE_MARKDOWN_CODE2                         20
#Define SCE_MARKDOWN_CODEBK                        21
#Define SCE_TXT2TAGS_DEFAULT                       0
#Define SCE_TXT2TAGS_LINE_BEGIN                    1
#Define SCE_TXT2TAGS_STRONG1                       2
#Define SCE_TXT2TAGS_STRONG2                       3
#Define SCE_TXT2TAGS_EM1                           4
#Define SCE_TXT2TAGS_EM2                           5
#Define SCE_TXT2TAGS_HEADER1                       6
#Define SCE_TXT2TAGS_HEADER2                       7
#Define SCE_TXT2TAGS_HEADER3                       8
#Define SCE_TXT2TAGS_HEADER4                       9
#Define SCE_TXT2TAGS_HEADER5                       10
#Define SCE_TXT2TAGS_HEADER6                       11
#Define SCE_TXT2TAGS_PRECHAR                       12
#Define SCE_TXT2TAGS_ULIST_ITEM                    13
#Define SCE_TXT2TAGS_OLIST_ITEM                    14
#Define SCE_TXT2TAGS_BLOCKQUOTE                    15
#Define SCE_TXT2TAGS_STRIKEOUT                     16
#Define SCE_TXT2TAGS_HRULE                         17
#Define SCE_TXT2TAGS_LINK                          18
#Define SCE_TXT2TAGS_CODE                          19
#Define SCE_TXT2TAGS_CODE2                         20
#Define SCE_TXT2TAGS_CODEBK                        21
#Define SCE_TXT2TAGS_COMMENT                       22
#Define SCE_TXT2TAGS_OPTION                        23
#Define SCE_TXT2TAGS_PREPROC                       24
#Define SCE_TXT2TAGS_POSTPROC                      25
#Define SCE_A68K_DEFAULT                           0
#Define SCE_A68K_COMMENT                           1
#Define SCE_A68K_NUMBER_DEC                        2
#Define SCE_A68K_NUMBER_BIN                        3
#Define SCE_A68K_NUMBER_HEX                        4
#Define SCE_A68K_STRING1                           5
#Define SCE_A68K_OPERATOR                          6
#Define SCE_A68K_CPUINSTRUCTION                    7
#Define SCE_A68K_EXTINSTRUCTION                    8
#Define SCE_A68K_REGISTER                          9
#Define SCE_A68K_DIRECTIVE                         10
#Define SCE_A68K_MACRO_ARG                         11
#Define SCE_A68K_LABEL                             12
#Define SCE_A68K_STRING2                           13
#Define SCE_A68K_IDENTIFIER                        14
#Define SCE_A68K_MACRO_DECLARATION                 15
#Define SCE_A68K_COMMENT_WORD                      16
#Define SCE_A68K_COMMENT_SPECIAL                   17
#Define SCE_A68K_COMMENT_DOXYGEN                   18
#Define SCE_MODULA_DEFAULT                         0
#Define SCE_MODULA_COMMENT                         1
#Define SCE_MODULA_DOXYCOMM                        2
#Define SCE_MODULA_DOXYKEY                         3
#Define SCE_MODULA_KEYWORD                         4
#Define SCE_MODULA_RESERVED                        5
#Define SCE_MODULA_NUMBER                          6
#Define SCE_MODULA_BASENUM                         7
#Define SCE_MODULA_FLOAT                           8
#Define SCE_MODULA_STRING                          9
#Define SCE_MODULA_STRSPEC                         10
#Define SCE_MODULA_CHAR                            11
#Define SCE_MODULA_CHARSPEC                        12
#Define SCE_MODULA_PROC                            13
#Define SCE_MODULA_PRAGMA                          14
#Define SCE_MODULA_PRGKEY                          15
#Define SCE_MODULA_OPERATOR                        16
#Define SCE_MODULA_BADSTR                          17
#Define SCE_COFFEESCRIPT_DEFAULT                   0
#Define SCE_COFFEESCRIPT_COMMENT                   1
#Define SCE_COFFEESCRIPT_COMMENTLINE               2
#Define SCE_COFFEESCRIPT_COMMENTDOC                3
#Define SCE_COFFEESCRIPT_NUMBER                    4
#Define SCE_COFFEESCRIPT_WORD                      5
#Define SCE_COFFEESCRIPT_STRING                    6
#Define SCE_COFFEESCRIPT_CHARACTER                 7
#Define SCE_COFFEESCRIPT_UUID                      8
#Define SCE_COFFEESCRIPT_PREPROCESSOR              9
#Define SCE_COFFEESCRIPT_OPERATOR                  10
#Define SCE_COFFEESCRIPT_IDENTIFIER                11
#Define SCE_COFFEESCRIPT_STRINGEOL                 12
#Define SCE_COFFEESCRIPT_VERBATIM                  13
#Define SCE_COFFEESCRIPT_REGEX                     14
#Define SCE_COFFEESCRIPT_COMMENTLINEDOC            15
#Define SCE_COFFEESCRIPT_WORD2                     16
#Define SCE_COFFEESCRIPT_COMMENTDOCKEYWORD         17
#Define SCE_COFFEESCRIPT_COMMENTDOCKEYWORDERROR    18
#Define SCE_COFFEESCRIPT_GLOBALCLASS               19
#Define SCE_COFFEESCRIPT_STRINGRAW                 20
#Define SCE_COFFEESCRIPT_TRIPLEVERBATIM            21
#Define SCE_COFFEESCRIPT_HASHQUOTEDSTRING          22
#Define SCE_COFFEESCRIPT_COMMENTBLOCK              22
#Define SCE_COFFEESCRIPT_VERBOSE_REGEX             23
#Define SCE_COFFEESCRIPT_VERBOSE_REGEX_COMMENT     24
#Define SCE_AVS_DEFAULT                            0
#Define SCE_AVS_COMMENTBLOCK                       1
#Define SCE_AVS_COMMENTBLOCKN                      2
#Define SCE_AVS_COMMENTLINE                        3
#Define SCE_AVS_NUMBER                             4
#Define SCE_AVS_OPERATOR                           5
#Define SCE_AVS_IDENTIFIER                         6
#Define SCE_AVS_STRING                             7
#Define SCE_AVS_TRIPLESTRING                       8
#Define SCE_AVS_KEYWORD                            9
#Define SCE_AVS_FILTER                             10
#Define SCE_AVS_PLUGIN                             11
#Define SCE_AVS_FUNCTION                           12
#Define SCE_AVS_CLIPPROP                           13
#Define SCE_AVS_USERDFN                            14
#Define SCE_ECL_DEFAULT                            0
#Define SCE_ECL_COMMENT                            1
#Define SCE_ECL_COMMENTLINE                        2
#Define SCE_ECL_NUMBER                             3
#Define SCE_ECL_STRING                             4
#Define SCE_ECL_WORD0                              5
#Define SCE_ECL_OPERATOR                           6
#Define SCE_ECL_CHARACTER                          7
#Define SCE_ECL_UUID                               8
#Define SCE_ECL_PREPROCESSOR                       9
#Define SCE_ECL_UNKNOWN                            10
#Define SCE_ECL_IDENTIFIER                         11
#Define SCE_ECL_STRINGEOL                          12
#Define SCE_ECL_VERBATIM                           13
#Define SCE_ECL_REGEX                              14
#Define SCE_ECL_COMMENTLINEDOC                     15
#Define SCE_ECL_WORD1                              16
#Define SCE_ECL_COMMENTDOCKEYWORD                  17
#Define SCE_ECL_COMMENTDOCKEYWORDERROR             18
#Define SCE_ECL_WORD2                              19
#Define SCE_ECL_WORD3                              20
#Define SCE_ECL_WORD4                              21
#Define SCE_ECL_WORD5                              22
#Define SCE_ECL_COMMENTDOC                         23
#Define SCE_ECL_ADDED                              24
#Define SCE_ECL_DELETED                            25
#Define SCE_ECL_CHANGED                            26
#Define SCE_ECL_MOVED                              27
#Define SCE_OSCRIPT_DEFAULT                        0
#Define SCE_OSCRIPT_LINE_COMMENT                   1
#Define SCE_OSCRIPT_BLOCK_COMMENT                  2
#Define SCE_OSCRIPT_DOC_COMMENT                    3
#Define SCE_OSCRIPT_PREPROCESSOR                   4
#Define SCE_OSCRIPT_NUMBER                         5
#Define SCE_OSCRIPT_SINGLEQUOTE_STRING             6
#Define SCE_OSCRIPT_DOUBLEQUOTE_STRING             7
#Define SCE_OSCRIPT_CONSTANT                       8
#Define SCE_OSCRIPT_IDENTIFIER                     9
#Define SCE_OSCRIPT_GLOBAL                         10
#Define SCE_OSCRIPT_KEYWORD                        11
#Define SCE_OSCRIPT_OPERATOR                       12
#Define SCE_OSCRIPT_LABEL                          13
#Define SCE_OSCRIPT_TYPE                           14
#Define SCE_OSCRIPT_FUNCTION                       15
#Define SCE_OSCRIPT_OBJECT                         16
#Define SCE_OSCRIPT_PROPERTY                       17
#Define SCE_OSCRIPT_METHOD                         18
#Define SCE_VISUALPROLOG_DEFAULT                   0
#Define SCE_VISUALPROLOG_KEY_MAJOR                 1
#Define SCE_VISUALPROLOG_KEY_MINOR                 2
#Define SCE_VISUALPROLOG_KEY_DIRECTIVE             3
#Define SCE_VISUALPROLOG_COMMENT_BLOCK             4
#Define SCE_VISUALPROLOG_COMMENT_LINE              5
#Define SCE_VISUALPROLOG_COMMENT_KEY               6
#Define SCE_VISUALPROLOG_COMMENT_KEY_ERROR         7
#Define SCE_VISUALPROLOG_IDENTIFIER                8
#Define SCE_VISUALPROLOG_VARIABLE                  9
#Define SCE_VISUALPROLOG_ANONYMOUS                 10
#Define SCE_VISUALPROLOG_NUMBER                    11
#Define SCE_VISUALPROLOG_OPERATOR                  12
#Define SCE_VISUALPROLOG_CHARACTER                 13
#Define SCE_VISUALPROLOG_CHARACTER_TOO_MANY        14
#Define SCE_VISUALPROLOG_CHARACTER_ESCAPE_ERROR    15
#Define SCE_VISUALPROLOG_STRING                    16
#Define SCE_VISUALPROLOG_STRING_ESCAPE             17
#Define SCE_VISUALPROLOG_STRING_ESCAPE_ERROR       18
#Define SCE_VISUALPROLOG_STRING_EOL_OPEN           19
#Define SCE_VISUALPROLOG_STRING_VERBATIM           20
#Define SCE_VISUALPROLOG_STRING_VERBATIM_SPECIAL   21
#Define SCE_VISUALPROLOG_STRING_VERBATIM_EOL       22
#Define SCE_STTXT_DEFAULT                          0
#Define SCE_STTXT_COMMENT                          1
#Define SCE_STTXT_COMMENTLINE                      2
#Define SCE_STTXT_KEYWORD                          3
#Define SCE_STTXT_TYPE                             4
#Define SCE_STTXT_FUNCTION                         5
#Define SCE_STTXT_FB                               6
#Define SCE_STTXT_NUMBER                           7
#Define SCE_STTXT_HEXNUMBER                        8
#Define SCE_STTXT_PRAGMA                           9
#Define SCE_STTXT_OPERATOR                         10
#Define SCE_STTXT_CHARACTER                        11
#Define SCE_STTXT_STRING1                          12
#Define SCE_STTXT_STRING2                          13
#Define SCE_STTXT_STRINGEOL                        14
#Define SCE_STTXT_IDENTIFIER                       15
#Define SCE_STTXT_DATETIME                         16
#Define SCE_STTXT_VARS                             17
#Define SCE_STTXT_PRAGMAS                          18
#Define SCE_KVIRC_DEFAULT                          0
#Define SCE_KVIRC_COMMENT                          1
#Define SCE_KVIRC_COMMENTBLOCK                     2
#Define SCE_KVIRC_STRING                           3
#Define SCE_KVIRC_WORD                             4
#Define SCE_KVIRC_KEYWORD                          5
#Define SCE_KVIRC_FUNCTION_KEYWORD                 6
#Define SCE_KVIRC_FUNCTION                         7
#Define SCE_KVIRC_VARIABLE                         8
#Define SCE_KVIRC_NUMBER                           9
#Define SCE_KVIRC_OPERATOR                         10
#Define SCE_KVIRC_STRING_FUNCTION                  11
#Define SCE_KVIRC_STRING_VARIABLE                  12
