#include Once "afx/AfxRichEdit.inc"
Type Class_RichEdit Extends Class_Control

   Declare Constructor
   Declare Destructor
   Declare Property Text() As CWStr                '/ÿؼеͨı
   Declare Property Text(sText As CWStr)
   Declare Property TextRtf() As String                '/ÿؼеRTFʽı
   Declare Property TextRtf(sText As String)
   Declare Function GetLineCount() As Long 'һıеûıڣ򷵻ֵΪ 1
   Declare Function GetLine(nLine As Long) As CWStr 'ȡTextBox ؼĳеı е㿪ʼ
   Declare Property MaxLength() As Long                 '/õǰıƣַΪλĬ64,000ַ
   Declare Property MaxLength(MaxCharacters As Long)
   Declare Sub SelClear() 'ɾǰѡݡ
   Declare Sub SelCopy() ' Ƶǰѡݣڼ塣
   Declare Sub SelCut() ' еǰѡݣڼ塣
   Declare Sub Paste() ' ճеĵǰλãѡ滻ѡ
   Declare Sub PopMenu() 'ùܲ˵ͨҼ˵
   Declare Function CanUndo() As Long ' Ƿг ,Ϊգ򷵻ֵΪ㣬в򷵻ֵΪ㡣
   Declare Function CanRedo() As Long ' Ƿ ,Ϊգ򷵻ֵΪ㣬в򷵻ֵΪ㡣
   Declare Function Undo() As Long '  ,ڵб༭ؼֵʼΪֵڶб༭ؼɹ򷵻ֵΪֵ;ʧܣ򷵻ֵΪ㡣
   Declare Function Redo() As Long '  ,RedoɹֵһֵRedoʧܣֵΪ㡣
   
   Declare Sub ReplaceText(TheText As CWStr) ' ǰѡ滻ָı
   Declare Sub Scroll(nScrollFlag As Long) ' ıеı{1.SB_LINEDOWN һС.SB_LINEUP һС.SB_PAGEDOWN һҳ.SB_PAGEUP һҳ}
   
   Declare Property MarginLeft() As Long ' ı߾(ֻ֧ȡȡ=0,MSDNҲô˵)
   Declare Property MarginLeft(nLeftMargin As Long)
   Declare Property MarginRight() As Long ' Ҳı߾ (ֻ֧ȡȡ=0,MSDNҲô˵)
   Declare Property MarginRight(nRightMargin As Long)
   Declare Property Modify() As Boolean '/ıѱ޸ı־{=.True.False}
   Declare Property Modify(nFlagValue As Boolean)
   Declare Property SelStart() As Long '/õǰѡıеʼַλáXPϵͳЧ
   Declare Property SelStart(Value As Long)
   Declare Property SelEnd() As Long '/ıеǰѡݵĽַλáXPϵͳЧ
   Declare Property SelEnd(Value As Long)
   Declare Function SetSel(nStartPos As Long, nEndPos As Long) As Long ' ѡĳΧַ(ǰѡַ)XPϵͳЧ
   Declare Function TextLength() As Long 'ıĳ
   Declare Property AutoURLDetect() As Boolean '/ûø༭ؼԶⳬ(Ĭϲ){=.True.False}
   Declare Property AutoURLDetect(Value As Boolean)
   Declare Property EditStyle() As Long '/ ༭ʽ18ϣϸMSDN
   Declare Property EditStyle(fStyle As Long)
   Declare Property EditStyleEx() As Long '/ ༭ʽWIN8 ϵͳ8ϣϸMSDN
   Declare Property EditStyleEx(fStyleEx As Long)
    Declare Property Locked() As Boolean '/Ƿסݣû޸ģ뻹ǿ޸ĵ{=.True Ա༭.False ûԱ༭}
    Declare Property Locked(nValue As Boolean) 
End Type

'----------------------------------------------------------------------------------------------------------------------------------------------------------------
Constructor Class_RichEdit
   'ע⣺ڴõģȫֱΪ˿⹦ܣConstructor  Destructor ظִ
   '1󴴽˴ִ࣬1 Constructor
   '2ÿ xxForm.Show ִ1 Constructor
   '3ÿδ  ִ1 Destructor  ʾ͹شھظ 23 
   '4˳  ִ1 Destructor

End Constructor

Destructor Class_RichEdit

End Destructor
   
Property Class_RichEdit.Text() As CWStr                '/ÿؼеͨı
  Return AfxGetWindowText(hWndControl)
End Property
Property Class_RichEdit.Text(sText As CWStr)
  AfxSetWindowText  hWndControl, sText
End Property
Property Class_RichEdit.TextRtf() As String                '/ÿؼеRTFʽı
  Return RichEdit_GetRtfText(hWndControl)
End Property
Property Class_RichEdit.TextRtf(sText As String)  
  Dim bb As SETTEXTEX 
  bb.flags = ST_NEWCHARS
  bb.codepage = CP_ACP
  SendMessageA( hWndControl , EM_SETTEXTEX ,Cast(wParam, @bb) ,Cast(lParam, StrPtr(sText)) )
End Property
Function Class_RichEdit.GetLineCount () As Long 'һıеûıڣ򷵻ֵΪ 1
  Function = SendMessage(hWndControl, EM_GETLINECOUNT, 0, 0)
End Function
Function Class_RichEdit.GetLine (nLine As Long) As CWStr 'ȡTextBox ؼĳеı е㿪ʼ
   '   Return RichEdit_GetLine(hWndControl,nLine)
   Dim nBufferSize As Long ,LineIndex As Long 
   Dim nBuffer() As Byte
   If IsWindow(hWndControl) Then
      LineIndex = SendMessageW(hWndControl, EM_LINEINDEX, nLine, 0)   'ȡб༭ؼָеĵһַַ
      nBufferSize = SendMessageW(hWndControl, EM_LINELENGTH, LineIndex, 0) '༭ؼһеĳȣַΪλ
      If nBufferSize = 0 Then Return ""
      ReDim nBuffer(nBufferSize * 2 + 4)
       *CPtr(UShort Ptr, @nBuffer(0)) = nBufferSize
      SendMessageW(hWndControl, EM_GETLINE, nLine, Cast(lParam, @nBuffer(0)))
      Return *CPtr(WString Ptr, @nBuffer(0))
   Else
      Return ""
   End If   
End Function
Property Class_RichEdit.MaxLength() As Long                 '/õǰıƣַΪλ
  Return SendMessage(hWndControl, EM_GETLIMITTEXT, 0, 0)
End Property
Property Class_RichEdit.MaxLength(MaxCharacters As Long)
  SendMessage hWndControl, EM_SETLIMITTEXT, MaxCharacters, 0
End Property

Sub Class_RichEdit.SelClear () 'ɾǰѡݡ
    SendMessage hWndControl, WM_CLEAR, 0, 0
End Sub
Sub Class_RichEdit.SelCopy () ' Ƶǰѡݣڼ塣
    SendMessage hWndControl, WM_COPY, 0, 0
End Sub
Sub Class_RichEdit.SelCut () ' еǰѡݣڼ塣
    SendMessage hWndControl, WM_CUT, 0, 0
End Sub
Sub Class_RichEdit.Paste () ' ճеĵǰλãѡ滻ѡ
    SendMessage hWndControl, WM_PASTE, 0, 0
End Sub
Sub Class_RichEdit.ReplaceText (TheText As CWStr) ' ǰѡ滻ָı
    SendMessageW hWndControl, EM_REPLACESEL, True, Cast(lParam, TheText.vptr)
End Sub
Sub Class_RichEdit.Scroll (nScrollFlag As Long) ' ıеı
    SendMessage hWndControl, EM_SCROLL, nScrollFlag, 0
End Sub


Property Class_RichEdit.Modify() As Boolean '/ıѱ޸ı־{=.True.False}
  Property = SendMessage(hWndControl, EM_GETMODIFY, 0, 0)
End Property
Property Class_RichEdit.Modify(nFlagValue As Boolean)
    SendMessage(hWndControl, EM_SETMODIFY, nFlagValue, 0)
End Property
Property Class_RichEdit.MarginLeft() As Long '/ ı߾
    Property = LoWord(SendMessage(hWndControl, EM_GETMARGINS, 0, 0))
End Property
Property Class_RichEdit.MarginLeft(nLeftMargin As Long)
  SendMessage hWndControl, EM_SETMARGINS,  EC_LEFTMARGIN ,nLeftMargin
End Property
Property Class_RichEdit.MarginRight() As Long '/ Ҳı߾
  Property = HiWord(SendMessage(hWndControl, EM_GETMARGINS, 0, 0))
End Property
Property Class_RichEdit.MarginRight(nRightMargin As Long)
    SendMessage hWndControl, EM_SETMARGINS,   EC_RIGHTMARGIN, nRightMargin
End Property
Property Class_RichEdit.SelStart() As Long 'ǰѡıеʼַλá
    Dim nStartPos As Long, nEndPos As Long
    SendMessage(hWndControl, EM_GETSEL, Cast(wParam,@nStartPos),Cast(lParam,@nEndPos))
    Property = nStartPos
End Property
Property Class_RichEdit.SelStart(Value As Long)
  This.SetSel Value, This.SelEnd
End Property
Property Class_RichEdit.SelEnd() As Long 'ıеǰѡݵĽַλá
    Dim nStartPos As Long, nEndPos As Long
    SendMessage(hWndControl, EM_GETSEL, Cast(wParam,@nStartPos),Cast(lParam,@nEndPos))
  Property = nEndPos
End Property
Property Class_RichEdit.SelEnd(Value As Long)
    This.SetSel This.SelStart, Value
End Property
Function Class_RichEdit.SetSel(nStartPos As Long, nEndPos As Long) As Long ' ѡĳΧַ
    Function = SendMessage( hWndControl, EM_SETSEL, nStartPos, nEndPos)
End Function
Function Class_RichEdit.TextLength() As Long 'ıĳ
    Function = GetWindowTextLength(hWndControl)
End Function
Property Class_RichEdit.AutoURLDetect() As Boolean '/ûø༭ؼԶⳬ(Ĭϲ){=.True.False}
  Property = SendMessage(hWndControl, EM_GETAUTOURLDETECT, 0,0)
End Property
Property Class_RichEdit.AutoURLDetect(Value As Boolean) 
   If Value Then
      SendMessage( hWndControl, EM_AUTOURLDETECT, AURL_ENABLEEA, Null)
   Else 
     SendMessage( hWndControl, EM_AUTOURLDETECT, 0, Null)
   End If
End Property
Property Class_RichEdit.EditStyle() As Long '/ ༭ʽ18ϣϸMSDN
  Property = SendMessage(hWndControl, EM_GETEDITSTYLE, 0,0)
End Property
Property Class_RichEdit.EditStyle(fStyle As Long)   
     SendMessage( hWndControl, EM_SETEDITSTYLE, fStyle, 0)
End Property
Property Class_RichEdit.EditStyleEx() As Long '/ ༭ʽWIN8 ϵͳ8ϣϸMSDN
  Property = SendMessage(hWndControl, WM_USER + 276, 0,0)
End Property
Property Class_RichEdit.EditStyleEx(fStyleEx As Long) 
     SendMessage( hWndControl, WM_USER + 275, fStyleEx, 0)
End Property
Function Class_RichEdit.CanUndo() As Long ' Ƿг ,Ϊգ򷵻ֵΪ㣬в򷵻ֵΪ㡣
    Function = SendMessage( hWndControl, EM_CANUNDO, 0, 0)
End Function
Function Class_RichEdit.CanRedo() As Long ' Ƿ ,Ϊգ򷵻ֵΪ㣬в򷵻ֵΪ㡣
    Function = SendMessage( hWndControl, EM_CANREDO, 0, 0)
End Function
Function Class_RichEdit.Undo() As Long '  ,ڵб༭ؼֵʼΪֵڶб༭ؼɹ򷵻ֵΪֵ;ʧܣ򷵻ֵΪ㡣
    Function = SendMessage( hWndControl, EM_UNDO, 0, 0)
End Function
Function Class_RichEdit.Redo() As Long '  ,RedoɹֵһֵRedoʧܣֵΪ㡣
    Function = SendMessage( hWndControl, EM_REDO, 0, 0)
End Function
Sub Class_RichEdit.PopMenu()
   Dim P As Point
   Dim hMenuRT As HMENU = CreatePopupMenu() 'Ҽ˵
   AppendMenu hMenuRT, MF_STRING, 8800, "(&C)"
   AppendMenu hMenuRT, MF_STRING, 8801, "(&T)"
   AppendMenu hMenuRT, MF_SEPARATOR, 0, Null
   AppendMenu hMenuRT, MF_STRING, 8802, "ճ(&P)"
   AppendMenu hMenuRT, MF_SEPARATOR, 0, Null
   AppendMenu hMenuRT, MF_STRING, 8803, "(&U)"
   AppendMenu hMenuRT, MF_STRING, 8804, "(&R)"
   
   Dim mType As MenuItemInfo
   GetCursorPos @p
   mType.cbSize = SizeOf(mType)
   mType.fMask = MIIM_STATE
   If CanUndo Then mType.fState = MFS_ENABLED Else mType.fState = MFS_DISABLED
   SetMenuItemInfo(hMenuRT, 8803, False, @mType)
   If CanRedo Then mType.fState = MFS_ENABLED Else mType.fState = MFS_DISABLED
   SetMenuItemInfo(hMenuRT, 8804, False, @mType)
   Select Case TrackPopupMenu(hMenuRT, TPM_RETURNCMD, p.x, p.y, 0, GetParent(hWndControl), Null) 'ȷ˵˵
      Case 8800 ',""
         SelCopy
      Case 8801 ',""
         SelCut
      Case 8802 ', "ճ"
         Paste
      Case 8803 ', ""
         Undo
      Case 8804 ', ""
         Redo
   End Select
   DestroyMenu hMenuRT
End Sub
Property Class_RichEdit.Locked() As Boolean
    return  (AfxGetWindowStyle(hWndControl) and ES_READONLY) <>0
End Property
Property Class_RichEdit.Locked(nValue As Boolean)
   SendMessage(hWndControl, EM_SETREADONLY, nValue, 0)
End Property