﻿#IfDef __FB_64BIT__
#inclib "miniblink"
#else
#inclib "node"
#endif

extern "Windows"
Type wkeWebView As Any Ptr 
enum wkeWindowType 
    WKE_WINDOW_TYPE_POPUP
    WKE_WINDOW_TYPE_TRANSPARENT
    WKE_WINDOW_TYPE_CONTROL
End Enum 
enum wkeCookieCommand 
    wkeCookieCommandClearAllCookies
    wkeCookieCommandClearSessionCookies
    wkeCookieCommandFlushCookiesToFile
    wkeCookieCommandReloadCookiesFromFile
End Enum 
Type wkeRect
    x As Integer 
    y As Integer 
    w As Integer 
    h As Integer 
End Type 
type wkePoint
    x As Integer 
    y As Integer 
 End Type  
enum wkeProxyType
    WKE_PROXY_NONE
    WKE_PROXY_HTTP
    WKE_PROXY_SOCKS4
    WKE_PROXY_SOCKS4A
    WKE_PROXY_SOCKS5
    WKE_PROXY_SOCKS5HOSTNAME
End Enum   
type wkeProxy
    wpType as wkeProxyType
    hostname_utf8 As ZString *100 ' [100];
    port As UShort 
    username_utf8 As ZString *50 '[50];
    password_utf8 As ZString *50 '[50];
End Type     
type wkeSettings 
    proxy As wkeProxy
    mask As UInteger 
    extension_utf8 As ZString Ptr 
End Type
type wkeViewSettings 
    size As Integer 
    bgColor As UInteger 
End Type
enum wkeRequestType
    kWkeRequestTypeInvalidation
    kWkeRequestTypeGet
    kWkeRequestTypePost
    kWkeRequestTypePut
End enum
enum wkeHttBodyElementType 
    wkeHttBodyElementTypeData
    wkeHttBodyElementTypeFile
End enum
type wkeMemBuf 
    unuse As Integer 
    data_ As Any Ptr 
    length As size_t
End Type 
type wkeString As Any Ptr 
type jsExecState As Any Ptr 
type wkePostBodyElement
    size As Integer 
    type_ As wkeHttBodyElementType
    data_ As wkeMemBuf Ptr 
    filePath As wkeString 
    fileStart As LongInt 
    fileLength As LongInt '; // -1 means to the end of the file.
End Type  
type wkePostBodyElements
    size As Integer 
    element As wkePostBodyElement Ptr Ptr 
    elementSize As size_t
    isDirty As bool
End Type 
enum jsType
    JSTYPE_NUMBER
    JSTYPE_STRING
    JSTYPE_BOOLEAN
    JSTYPE_OBJECT
    JSTYPE_FUNCTION
    JSTYPE_UNDEFINED
    JSTYPE_ARRAY
    JSTYPE_NULL
End enum
Type jsValue As LongInt      
type jsKeys
    length As UInteger 
    keys As ZString Ptr Ptr 
End Type 

type jsData  '// cexer JS对象、函数绑定支持
    typeName As ZString *100 
    propertyGet As Function(es As jsExecState ,object_ As jsValue,propertyName_utf8 As ZString Ptr) As jsValue  'jsGetPropertyCallback
    propertySet As Function(es As jsExecState ,object_ As jsValue,propertyName_utf8 As ZString Ptr,value As jsValue) As bool ' jsSetPropertyCallback
    finalize As Sub(data_ As jsData Ptr ) ' jsFinalizeCallback
    callAsFunction  As Function(es As jsExecState ,object_ As jsValue,args As jsValue Ptr,argCount As Integer ) As jsValue 'jsCallAsFunctionCallback
End Type 
type jsExceptionInfo
    message_utf8 As ZString Ptr  '; // Returns the exception message.
    sourceLine_utf8 As ZString Ptr  '; // Returns the line of source code that the exception occurred within.
    scriptResourceName_utf8 As ZString Ptr  '; // Returns the resource name for the script from where the function causing the error originates.
    lineNumber As Integer '; // Returns the 1-based number of the line where the error occurred or 0 if the line number is unknown.
    startPosition As Integer '; // Returns the index within the script of the first character where the error occurred.
    endPosition As Integer '; // Returns the index within the script of the last character where the error occurred.
    startColumn As Integer '; // Returns the index within the line of the first character where the error occurred.
    endColumn As Integer '; // Returns the index within the line of the last character where the error occurred.
    callstackString_utf8 As ZString Ptr
End Type 
type wkeWindowCreateInfo 
    size As Integer 
    parent As HWND 
    style As ULong 
    styleEx As ULong 
    x As Integer 
    y As Integer 
    w As Integer 
    h As Integer 
    c As COLORREF
End Type 
type wkeWebDragDataItem
        enum wkeStorageType 
'            // String data with an associated MIME type. Depending on the MIME type, there may be
'            // optional metadata attributes as well.
            StorageTypeString
'            // Stores the name of one file being dragged into the renderer.
            StorageTypeFilename
'            // An image being dragged out of the renderer. Contains a buffer holding the image data
'            // as well as the suggested name for saving the image to.
            StorageTypeBinaryData
'            // Stores the filesystem URL of one file being dragged into the renderer.
            StorageTypeFileSystemFile
        End Enum 

'        // Only valid when storageType == StorageTypeString.
        stringType As wkeMemBuf Ptr 
        stringData  As wkeMemBuf Ptr 

'        // Only valid when storageType == StorageTypeFilename.
        filenameData  As wkeMemBuf Ptr 
        displayNameData  As wkeMemBuf Ptr 

'        // Only valid when storageType == StorageTypeBinaryData.
        binaryData  As wkeMemBuf Ptr 

'        // Title associated with a link when stringType == "text/uri-list".
'        // Filename when storageType == StorageTypeBinaryData.
        title  As wkeMemBuf Ptr 

'        // Only valid when storageType == StorageTypeFileSystemFile.
        fileSystemURL  As wkeMemBuf Ptr 
        fileSystemFileSize As LongInt 

'        // Only valid when stringType == "text/html".
        baseURL  As wkeMemBuf Ptr    
End Type 
type wkeWebDragData
    m_itemList As wkeWebDragDataItem Ptr 
    m_itemListLength As Integer 
    m_modifierKeyState As Integer  ' ; // State of Shift/Ctrl/Alt/Meta keys.
    m_filesystemId  As wkeMemBuf Ptr 
End Type 
enum wkeWebDragOperation 
    wkeWebDragOperationNone = 0
    wkeWebDragOperationCopy = 1
    wkeWebDragOperationLink = 2
    wkeWebDragOperationGeneric = 4
    wkeWebDragOperationPrivate = 8
    wkeWebDragOperationMove = 16
    wkeWebDragOperationDelete = 32
    wkeWebDragOperationEvery = &Hffffffff
End Enum 

Type wkeWebDragOperationsMask As wkeWebDragOperation
Type v8Isolate As Any Ptr 

type wkeClientHandler 
    onTitleChanged As SUB(clientHandler As wkeClientHandler Ptr ,title As wkeString)
    onURLChanged As SUB(clientHandler As wkeClientHandler Ptr ,url As wkeString)
 End Type 
enum wkeResourceType
    WKE_RESOURCE_TYPE_MAIN_FRAME = 0  ',       // top level page
    WKE_RESOURCE_TYPE_SUB_FRAME = 1    ',        // frame or iframe
    WKE_RESOURCE_TYPE_STYLESHEET = 2  ',       // a CSS stylesheet
    WKE_RESOURCE_TYPE_SCRIPT = 3          ',           // an external script
    WKE_RESOURCE_TYPE_IMAGE = 4              ',            // an image (jpg/gif/png/etc)
    WKE_RESOURCE_TYPE_FONT_RESOURCE = 5 ',    // a font
    WKE_RESOURCE_TYPE_SUB_RESOURCE = 6 ',     // an "other" subresource.
    WKE_RESOURCE_TYPE_OBJECT = 7   ',           // an object (or embed) tag for a plugin,
                                    '        // or a resource that a plugin requested.
    WKE_RESOURCE_TYPE_MEDIA = 8    ',            // a media resource.
    WKE_RESOURCE_TYPE_WORKER = 9    ',           // the main resource of a dedicated
                                      '      // worker.
    WKE_RESOURCE_TYPE_SHARED_WORKER = 10 ',   // the main resource of a shared worker.
    WKE_RESOURCE_TYPE_PREFETCH = 11 ',        // an explicitly requested prefetch
    WKE_RESOURCE_TYPE_FAVICON = 12   ',         // a favicon
    WKE_RESOURCE_TYPE_XHR = 13    ',             // a XMLHttpRequest
    WKE_RESOURCE_TYPE_PING = 14    ',            // a ping request for <a ping>
    WKE_RESOURCE_TYPE_SERVICE_WORKER = 15  ',  // the main resource of a service worker.
    WKE_RESOURCE_TYPE_LAST_TYPE
End Enum  
type wkeWillSendRequestInfo 
     url As wkeString
     newUrl As wkeString
     resourceType As wkeResourceType
    httpResponseCode As Integer 
     method As wkeString
     referrer As wkeString
    headers As Any Ptr 
End Type 
type  wkeNetJob As Any Ptr 
type wkeTempCallbackInfo
    size As Integer 
    frameId As Integer  
    willSendRequestInfo As wkeWillSendRequestInfo Ptr 
    url As ZString Ptr 
    postBody As wkePostBodyElements Ptr 
   job As wkeNetJob
End Type 
type  wkeSlist
    data_ As ZString Ptr 
    next_ As wkeSlist Ptr  
End Type 
type wkeScreenshotSettings
    structSize As Integer 
    w  As Integer 
    h As Integer 
 End Type 
enum wkeMenuItemId 
    kWkeMenuSelectedAllId = 1 Shl 1
    kWkeMenuSelectedTextId = 1 Shl 2
    kWkeMenuUndoId = 1 Shl 3
    kWkeMenuCopyImageId = 1 Shl 4
    kWkeMenuInspectElementAtId = 1 Shl 5
    kWkeMenuCutId = 1 Shl 6
    kWkeMenuPasteId = 1 Shl 7
    kWkeMenuPrintId = 1 Shl 8
    kWkeMenuGoForwardId = 1 Shl 9
    kWkeMenuGoBackId = 1 Shl 10
    kWkeMenuReloadId = 1 Shl 11
    kWkeMenuSaveImageId = 1 Shl 12
end enum
type wkePrintSettings
    structSize As Integer 
    dpi As Integer 
    w  As Integer '// in px
    h As Integer 
    marginTop As Integer 
    marginBottom As Integer 
    marginLeft As Integer 
    marginRight As Integer 
    isPrintPageHeadAndFooter As BOOL
    isPrintBackgroud As BOOL
    isLandscape As BOOL
    isPrintToMultiPage As BOOL
End Type 
type wkePdfDatas
    count As Integer 
    sizes As size_t Ptr 
    datas As Any Ptr Ptr 
 End Type 
type wkeWindowFeatures
    x As Integer 
    y As Integer 
    w As Integer 
    h As Integer 
    menuBarVisible As bool
    statusBarVisible As bool
    toolBarVisible As bool
    locationBarVisible As bool
    scrollbarsVisible As bool
    resizable As bool
    fullscreen As bool
End Type
type wkeMediaLoadInfo
    size As Integer
    w As Integer 
    h As Integer 
    duration As double
End Type    
type wkeDraggableRegion
    bounds As RECT
    draggable As bool
End Type 

Declare Function wkeVersion cdecl Alias "wkeVersion"() As  uInteger   '[1]获取目前api版本号
Declare Function wkeVersionString cdecl Alias "wkeVersionString"() As ZString Ptr  '[2]获取版本utf8字符串
Declare Sub wkeGC cdecl Alias "wkeGC"(WebView As wkeWebView,delayMs As long) '[4]  延迟让miniblink垃圾回收
Declare Sub wkeEnableHighDPISupport cdecl Alias "wkeEnableHighDPISupport"() '[4] 开启高分屏支持。注意，这个api内部是通过设置ZOOM，并且关闭系统默认放大来实现。所以再使用wkeGetZoomFactor会发现值可能不为1
Declare Function wkeIsDocumentReady cdecl Alias "wkeIsDocumentReady"(WebView As wkeWebView) As bool '[10] DOM文档结构是否加载完成。和上述几个接口不同，上述几个接口是网络相关的判断。
Declare Sub wkeStopLoading cdecl Alias "wkeStopLoading"(WebView As wkeWebView) '[11] 停止加载页面
Declare Function wkeReload cdecl Alias "wkeReload"(WebView As wkeWebView) As bool '[12] 重新加载页面
Declare Function wkeGetTitle cdecl Alias "wkeGetTitle"(WebView As wkeWebView) As ZString Ptr '[13]  获取页面标题 utf8字符串
Declare Function wkeGetTitleW cdecl Alias "wkeGetTitleW"(WebView As wkeWebView) As WString Ptr '[14]   获取页面标题的宽字节版本
Declare Sub wkeResize cdecl Alias "wkeResize"(WebView As wkeWebView,w As Integer ,h As Integer ) '[15] 重新设置页面的宽高。如果webView是带窗口模式的，会设置真窗口的宽高。
Declare Function wkeGetWidth cdecl Alias "wkeGetWidth"(WebView As wkeWebView) As Integer  '[16] 获取页面宽度
Declare Function wkeGetHeight cdecl Alias "wkeGetHeight"(WebView As wkeWebView) As Integer  '[17] 获取页面高度
Declare Function wkeGetContentWidth cdecl Alias "wkeGetContentWidth"(WebView As wkeWebView) As Integer ' [18] 获取网页排版出来的宽度
Declare Function wkeGetContentHeight cdecl Alias "wkeGetContentHeight"(WebView As wkeWebView) As Integer ' [19] 获取网页排版出来的高度
Declare Sub wkePaint2 cdecl Alias "wkePaint2"(WebView As wkeWebView,bits As Any Ptr ,bufWid As Integer ,bufHei As Integer ,xDst As Integer ,yDst As Integer ,w As Integer ,h As Integer ,xSrc As Integer ,ySrc As Integer ,bCopyAlpha As bool) '[24]
'参数名说明
'bits    外部申请并传递给mb的buffer，大小是bufWid * bufHei * 4 字节
'bufWid  bits的宽
'bufHei  bits的高
'xDst    绘制到bits的哪个坐标
'yDst    绘制到bits的哪个坐标
'w       mb需要取的画面的起始坐标
'h       mb需要取的画面的起始坐标
'xSrc    mb需要取的画面的起始坐标
'ySrc    mb需要取的画面的起始坐标
'bCopyAlpha   是否拷贝画面的透明度值
'此函数一般给3d游戏使用。另外频繁使用此接口并拷贝像素有性能问题。最好用wkeGetViewDC再去拷贝dc。

Declare Sub wkePaint cdecl Alias "wkePaint"(WebView As wkeWebView,bits As Any Ptr ,pitch as Integer ) ' [25] 获取页面的像素的简化版函数。
'参数名 说明
'bits     外部申请并传递给mb的buffer，大小是webview宽度 * 高度 * 4 字节。
'pitch    填0即可。这个参数玩过directX的人应该懂
Declare Function wkeGetViewDC cdecl Alias "wkeGetViewDC"(WebView As wkeWebView) As HDC   ' [27] 获取webview的DC
  '    ITERATOR1(HDC, wkeGetViewDC, wkeWebView webView, "") \
Declare Function wkeGetHostHWND cdecl Alias "wkeGetHostHWND"(WebView As wkeWebView) As HWND ' [28] 获取webveiw对应的窗口句柄。实现和wkeGetWindowHandle完全相同
  '    ITERATOR1(HWND, wkeGetHostHWND, wkeWebView webView, "") \
Declare Function wkeCanGoBack cdecl Alias "wkeCanGoBack"(WebView As wkeWebView) As bool '[29] 页面是否可以后退
  '    ITERATOR1(BOOL, wkeCanGoBack, wkeWebView webView, "") \
Declare Function wkeGoBack cdecl Alias "wkeGoBack"(WebView As wkeWebView) As bool '[30] 强制让页面后退
  '    ITERATOR1(BOOL, wkeGoBack, wkeWebView webView, "") \
Declare Function wkeCanGoForward cdecl Alias "wkeCanGoForward"(WebView As wkeWebView) As bool ' [31]  页面是否可以继续前进
  '    ITERATOR1(BOOL, wkeCanGoForward, wkeWebView webView, "") \
Declare Function wkeGoForward cdecl Alias "wkeGoForward"(WebView As wkeWebView) As bool ' [32] 前进
  '    ITERATOR1(BOOL, wkeGoForward, wkeWebView webView, "") \
Declare Sub wkeEditorSelectAll cdecl Alias "wkeEditorSelectAll"(WebView As wkeWebView) ' [33] 给webview发送全选命令
  '    ITERATOR1(void, wkeEditorSelectAll, wkeWebView webView, "") \
Declare Sub wkeEditorUnSelect cdecl Alias "wkeEditorUnSelect"(WebView As wkeWebView) '[34] 取消选择
  '    ITERATOR1(void, wkeEditorUnSelect, wkeWebView webView, "") \
Declare Sub wkeEditorCopy cdecl Alias "wkeEditorCopy"(WebView As wkeWebView) '[35] 拷贝页面里被选中的字符串
  '    ITERATOR1(void, wkeEditorCopy, wkeWebView webView, "") \
Declare Sub wkeEditorCut cdecl Alias "wkeEditorCut"(WebView As wkeWebView) ' [36]
  '    ITERATOR1(void, wkeEditorCut, wkeWebView webView, "") \
Declare Sub wkeEditorDelete cdecl Alias "wkeEditorDelete"(WebView As wkeWebView) ' [37]
  '    ITERATOR1(void, wkeEditorDelete, wkeWebView webView, "") \
Declare Sub wkeEditorUndo cdecl Alias "wkeEditorUndo"(WebView As wkeWebView) ' [38]
  '    ITERATOR1(void, wkeEditorUndo, wkeWebView webView, "") \
Declare Sub wkeEditorRedo cdecl Alias "wkeEditorRedo"(WebView As wkeWebView) ' [39] 
  '    ITERATOR1(void, wkeEditorRedo, wkeWebView webView, "") \
Declare Function wkeGetCookie cdecl Alias "wkeGetCookie"(WebView As wkeWebView) As ZString Ptr ' [40] 获取页面的cookie  utf8字符串
  '    ITERATOR1(const utf8*, wkeGetCookie, wkeWebView webView, "") \
Declare Function wkeGetCookieW cdecl Alias "wkeGetCookieW"(WebView As wkeWebView) As wString Ptr ' [40] 获取页面的cookie  宽字节版本
  '    ITERATOR1(const wchar_t*, wkeGetCookieW, wkeWebView webView, "") \
Declare Sub wkeSetCookie cdecl Alias "wkeSetCookie"(WebView As wkeWebView,url_utf8 As ZString Ptr,cookie_utf8 As ZString Ptr) ' [42] 设置页面cookie
  '    ITERATOR3(void, wkeSetCookie, wkeWebView webView, const utf8* url, const utf8* cookie, "cookie格式必须是类似:cna=4UvTFE12fEECAXFKf4SFW5eo; expires=Tue, 23-Jan-2029 13:17:21 GMT; path=/; domain=.youku.com") \
'cookie必须符合curl的cookie写法。一个例子是：PERSONALIZE=123;expires=Monday, 13-Jun-2022 03:04:55 GMT; domain=.fidelity.com; path=/; secure
Declare Sub wkeVisitAllCookie cdecl Alias "wkeVisitAllCookie"(WebView As wkeWebView,params As Any Ptr,wkeCookieVisitor As Any Ptr ) '[43]  通过访问器visitor访问所有cookie。 wkeCookieVisitor 是回调函数
  '    ITERATOR3(void, wkeVisitAllCookie, wkeWebView webView, void* params, wkeCookieVisitor visitor, "") \
Declare Sub wkePerformCookieCommand cdecl Alias "wkePerformCookieCommand"(WebView As wkeWebView,command_ As wkeCookieCommand ) '[44] 通过设置mb内置的curl来操作cookie。这个接口只是调用curl设置命令，并不会去修改js里的内容
  '     wkePerformCookieCommand, wkeWebView webView, wkeCookieCommand command, "") \
Declare Sub wkeSetCookieEnabled cdecl Alias "wkeSetCookieEnabled"(WebView As wkeWebView,enable As bool) '[45] 开启或关闭cookie 这个接口只是影响blink，并不会设置curl。所以还是会生成curl的cookie文件
  '     wkeSetCookieEnabled, wkeWebView webView, bool enable, "") \
Declare Function wkeIsCookieEnabled cdecl Alias "wkeIsCookieEnabled"(WebView As wkeWebView) As bool ' [46] 暂无接口描述信息
  '    ITERATOR1(BOOL, wkeIsCookieEnabled, wkeWebView webView, "") \
Declare Sub wkeSetCookieJarPath cdecl Alias "wkeSetCookieJarPath"(WebView As wkeWebView,path As wString Ptr) ' [47] 设置cookie的本地文件目录。默认是当前目录。cookies存在当前目录的“cookie.dat”里
  '     wkeSetCookieJarPath, wkeWebView webView, const WCHAR* path, "") \
Declare Sub wkeSetCookieJarFullPath cdecl Alias "wkeSetCookieJarFullPath"(WebView As wkeWebView,path As wString Ptr) ' [48] 设置cookie的全路径+文件名，如c:\mb\cookie.dat
  '     wkeSetCookieJarFullPath, wkeWebView webView, const WCHAR* path, "") \
Declare Sub wkeSetLocalStorageFullPath cdecl Alias "wkeSetLocalStorageFullPath"(WebView As wkeWebView,path As wString Ptr) '[49] 设置local storage的全路径。如“c:\mb\LocalStorage\cookie.dat” 这个接口只能接受目录。
  '     wkeSetLocalStorageFullPath, wkeWebView webView, const WCHAR* path, "") \
Declare Sub wkeSetMediaVolume cdecl Alias "wkeSetMediaVolume"(WebView As wkeWebView,volume As Single ) ' [50] 设置音量，未实现
  '     wkeSetMediaVolume, wkeWebView webView, float volume, "") \
Declare Function wkeGetMediaVolume cdecl Alias "wkeGetMediaVolume"(WebView As wkeWebView) As Single ' [51] 获取音量，未实现
  '    ITERATOR1(float, wkeGetMediaVolume, wkeWebView webView, "") \
Declare Function wkeFireMouseEvent cdecl Alias "wkeFireMouseEvent"(WebView As wkeWebView,message As UInteger ,x As Integer ,y As Integer,flags As UInteger ) As bool ' [52] 向mb发送鼠标消息
  '    ITERATOR5(BOOL, wkeFireMouseEvent, wkeWebView webView, unsigned int message, int x, int y, unsigned int flags, "") \
'参数名 说明
'message    可取WM_MOUSELEAVE等Windows相关鼠标消息
'x          x坐标
'y          y坐标
'flags      可取值有WKE_CONTROL、WKE_SHIFT、WKE_LBUTTON、WKE_MBUTTON、WKE_RBUTTON，可通过“或”操作并联
Declare Function wkeFireContextMenuEvent cdecl Alias "wkeFireContextMenuEvent"(WebView As wkeWebView,x As Integer ,y As Integer ,flags As UInteger ) As bool '[53]   向mb发送菜单消息（未实现）
  '    ITERATOR4(BOOL, wkeFireContextMenuEvent, wkeWebView webView, int x, int y, unsigned int flags, "") \
Declare Function wkeFireMouseWheelEvent cdecl Alias "wkeFireMouseWheelEvent"(WebView As wkeWebView,x As Integer ,y As Integer ,delta As Integer ,flags As UInteger ) As bool '[54] 向mb发送滚轮消息，用法和参数类似wkeFireMouseEvent。
  '    ITERATOR5(BOOL, wkeFireMouseWheelEvent, wkeWebView webView, int x, int y, int delta, unsigned int flags, "") \
Declare Function wkeFireKeyUpEvent cdecl Alias "wkeFireKeyUpEvent"(WebView As wkeWebView,virtualKeyCode As UInteger,flags As UInteger ,systemKey As bool ) As bool ' [55] 向mb发送WM_KEYUP消息，
  '    ITERATOR4(BOOL, wkeFireKeyUpEvent, wkeWebView webView, unsigned int virtualKeyCode, unsigned int flags, bool systemKey, "") \
'参数名  说明
'virtualKeyCode    见https://msdn.microsoft.com/en-us/library/windows/desktop/dd375731(v=vs.85).aspx
'flags             可取值有WKE_REPEAT、WKE_EXTENDED，可通过“或”操作并联。
'systemKey         暂时没用
Declare Function wkeFireKeyDownEvent cdecl Alias "wkeFireKeyDownEvent"(WebView As wkeWebView,virtualKeyCode As UInteger,flags As UInteger ,systemKey As bool ) As bool ' [56] 
  '    ITERATOR4(BOOL, wkeFireKeyDownEvent, wkeWebView webView, unsigned int virtualKeyCode, unsigned int flags, bool systemKey, "") \
Declare Function wkeFireWindowsMessage cdecl Alias "wkeFireWindowsMessage"(WebView As wkeWebView,nWnd As HWND ,message As UInteger,wParam As WPARAM,lParam As LPARAM ,result As LRESULT Ptr) As bool ' [57]  向mb发送任意windows消息。不过目前mb主要用来处理光标相关。mb在无窗口模式下，要响应光标事件，需要通过本函数手动发送光标消息
  '    ITERATOR6(BOOL, wkeFireWindowsMessage, wkeWebView webView, HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, LRESULT* result, "") \
Declare Sub wkeSetFocus cdecl Alias "wkeSetFocus"(WebView As wkeWebView) '[58] 设置webview是焦点态。如果webveiw关联了窗口，窗口也会有焦点
  '    ITERATOR1(void, wkeSetFocus, wkeWebView webView, "") \
Declare Sub wkeKillFocus cdecl Alias "wkeKillFocus"(WebView As wkeWebView) ' [59]  暂无接口描述信息
  '    ITERATOR1(void, wkeKillFocus, wkeWebView webView, "") \
Declare Function wkeGetCaretRect cdecl Alias "wkeGetCaretRect"(WebView As wkeWebView) As wkeRect '[60]  获取编辑框的那个游标的位置
  '    ITERATOR1(wkeRect, wkeGetCaretRect, wkeWebView webView, "") \
Declare Function wkeRunJS cdecl Alias "wkeRunJS"(WebView As wkeWebView,script_utf8 As ZString Ptr ) As jsValue '[61] 运行一段js。返回js的值jsValue。jsValue是个封装了内部v8各种类型的类，如果需要获取详细信息，有jsXXX相关接口可以调用。见下述。
  '    ITERATOR2(jsValue, wkeRunJS, wkeWebView webView, const utf8* script, "") \
Declare Function wkeRunJSW cdecl Alias "wkeRunJSW"(WebView As wkeWebView,script As WString Ptr ) As jsValue ' [62]  同上。注意，此函数以及wkeRunJS，执行的js，也就是script，是在一个闭包中
  '    ITERATOR2(jsValue, wkeRunJSW, wkeWebView webView, const wchar_t* script, "") \
Declare Function wkeGlobalExec cdecl Alias "wkeGlobalExec"(WebView As wkeWebView) As jsExecState ' [63]  获取页面主frame的jsExecState。jsExecState是什么，见下述。
  '    ITERATOR1(jsExecState, wkeGlobalExec, wkeWebView webView, "") \
Declare Sub wkeSleep cdecl Alias "wkeSleep"(WebView As wkeWebView) '[64] 暂未实现
  '    ITERATOR1(void, wkeSleep, wkeWebView webView, "") \
Declare Sub wkeWake cdecl Alias "wkeWake"(WebView As wkeWebView) ' [65]  暂无接口描述信息
  '    ITERATOR1(void, wkeWake, wkeWebView webView, "") \
Declare Function wkeIsAwake cdecl Alias "wkeIsAwake"(WebView As wkeWebView) As bool '[66] 暂未实现
  '    ITERATOR1(BOOL, wkeIsAwake, wkeWebView webView, "") \
Declare Sub wkeSetZoomFactor cdecl Alias "wkeSetZoomFactor"(WebView As wkeWebView,factor As Single ) '[67] 设置页面缩放系数，默认是1
  '     wkeSetZoomFactor, wkeWebView webView, float factor, "") \
Declare Function wkeGetZoomFactor cdecl Alias "wkeGetZoomFactor"(WebView As wkeWebView) As Single '[68]  暂无接口描述信息
  '    ITERATOR1(float, wkeGetZoomFactor, wkeWebView webView, "") \
Declare Sub wkeSetEditable cdecl Alias "wkeSetEditable"(WebView As wkeWebView,editable As bool) ' [69] 未实现
  '     wkeSetEditable, wkeWebView webView, bool editable, "") \
Declare Sub wkeOnTitleChanged cdecl Alias "wkeOnTitleChanged"(WebView As wkeWebView,wkeTitleChangedCallback As Any Ptr ,callbackParam As LPARAM) ' [70] 设置标题变化的通知回调
  '    ITERATOR3(void, wkeOnTitleChanged, wkeWebView webView, wkeTitleChangedCallback callback, void* callbackParam, "") \
Declare Sub wkeOnMouseOverUrlChanged cdecl Alias "wkeOnMouseOverUrlChanged"(WebView As wkeWebView,wkeTitleChangedCallback As Any Ptr ,callbackParam As LPARAM ) '[71]  鼠标划过的元素，如果是，则调用此回调，并发送a标签的url
  '    ITERATOR3(void, wkeOnMouseOverUrlChanged, wkeWebView webView, wkeTitleChangedCallback callback, void* callbackParam, "") \
Declare Sub wkeOnURLChanged cdecl Alias "wkeOnURLChanged"(WebView As wkeWebView, wkeURLChangedCallback As Any Ptr ,callbackParam As LPARAM) ' [72]  url改变回调
  '    ITERATOR3(void, wkeOnURLChanged, wkeWebView webView, wkeURLChangedCallback callback, void* callbackParam, "") \
Declare Sub wkeOnURLChanged2 cdecl Alias "wkeOnURLChanged2"(WebView As wkeWebView, wkeURLChangedCallback2 As Any Ptr ,callbackParam As LPARAM) '[73]  和上个接口不同的是，回调多了个参数
  '    ITERATOR3(void, wkeOnURLChanged2, wkeWebView webView, wkeURLChangedCallback2 callback, void* callbackParam, "") \
'参数名     说明
'callback   typedef Sub(*wkeURLChangedCallback2)(wkeWebView webView, any ptr param, wkeWebFrameHandle frameId, const wkeString url)
'frameId    表示frame的id。有相关接口可以判断这个frameId是否是主frame
Declare Sub wkeOnPaintUpdated cdecl Alias "wkeOnPaintUpdated"(WebView As wkeWebView, wkePaintUpdatedCallback  As Any Ptr ,callbackParam As LPARAM) '[75] 页面有任何需要刷新的地方，将调用此回调
  '    ITERATOR3(void, wkeOnPaintUpdated, wkeWebView webView, wkePaintUpdatedCallback callback, void* callbackParam, "") \
'参数名     说明
'callback   typedef Sub(*wkePaintUpdatedCallback)(wkeWebView webView, any ptr param, const HDC hdc, int x, int y, int cx, int cy)
'x          表示刷新的区域矩形
'y          表示刷新的区域矩形
'cx         表示刷新的区域矩形
'cy         表示刷新的区域矩形
 

Declare Sub wkeOnPaintBitUpdated cdecl Alias "wkeOnPaintBitUpdated"(WebView As wkeWebView, wkePaintBitUpdatedCallback As Any Ptr ,callbackParam As LPARAM) ' [77] 同上。不同的是回调过来的是填充好像素的buffer，而不是DC。方便嵌入到游戏中做离屏渲染
  '    ITERATOR3(void, wkeOnPaintBitUpdated, wkeWebView webView, wkePaintBitUpdatedCallback callback, void* callbackParam, "") \
Declare Sub wkeOnAlertBox cdecl Alias "wkeOnAlertBox"(WebView As wkeWebView, wkeAlertBoxCallback As Any Ptr ,callbackParam As LPARAM) '[78]  网页调用alert会走到这个接口填入的回调
  '    ITERATOR3(void, wkeOnAlertBox, wkeWebView webView, wkeAlertBoxCallback callback, void* callbackParam, "") \
Declare Sub wkeOnConfirmBox cdecl Alias "wkeOnConfirmBox"(WebView As wkeWebView, wkeConfirmBoxCallback As Any Ptr ,callbackParam As LPARAM) ' [79]  暂无接口描述信息
  '    ITERATOR3(void, wkeOnConfirmBox, wkeWebView webView, wkeConfirmBoxCallback callback, void* callbackParam, "") \
Declare Sub wkeOnPromptBox cdecl Alias "wkeOnPromptBox"(WebView As wkeWebView, wkePromptBoxCallback As Any Ptr ,callbackParam As LPARAM) '[80] 暂无接口描述信息
  '    ITERATOR3(void, wkeOnPromptBox, wkeWebView webView, wkePromptBoxCallback callback, void* callbackParam, "") \
Declare Sub wkeOnNavigation cdecl Alias "wkeOnNavigation"(WebView As wkeWebView, wkeNavigationCallback As Any Ptr ,callbackParam As LPARAM) '[81] 网页开始浏览将触发回调
  '    ITERATOR3(void, wkeOnNavigation, wkeWebView webView, wkeNavigationCallback callback, void* param, "") \
'参数名     说明
'callback   typedef bool(*wkeNavigationCallback)(wkeWebView webView, any ptr param, wkeNavigationType navigationType, const wkeString url);
'wkeNavigationType 表示浏览触发的原因。可以取的值有：WKE_NAVIGATION_TYPE_LINKCLICK：点击a标签触发。WKE_NAVIGATION_TYPE_FORMSUBMITTE：点击form触发。WKE_NAVIGATION_TYPE_BACKFORWARD：前进后退触发。WKE_NAVIGATION_TYPE_RELOAD：重新加载触发
'wkeNavigationCallback回调的返回值，如果是true，表示可以继续进行浏览，false表示阻止本次浏览。
Declare Sub wkeOnCreateView cdecl Alias "wkeOnCreateView"(WebView As wkeWebView, wkeCreateViewCallback As Any Ptr ,callbackParam As LPARAM) ' [83] 网页点击a标签创建新窗口时将触发回调
  '    ITERATOR3(void, wkeOnCreateView, wkeWebView webView, wkeCreateViewCallback callback, void* param, "") \
'参数名    说明
'callback  typedef wkeWebView(*wkeCreateViewCallback)(wkeWebView webView, any ptr param, wkeNavigationType navigationType, const wkeString url, const wkeWindowFeatures* windowFeatures);
Declare Sub wkeOnDocumentReady cdecl Alias "wkeOnDocumentReady"(WebView As wkeWebView, wkeDocumentReadyCallback As Any Ptr ,callbackParam As LPARAM) '[85] 对应js里的body onload事件
  '    ITERATOR3(void, wkeOnDocumentReady, wkeWebView webView, wkeDocumentReadyCallback callback, void* param, "") \
Declare Sub wkeOnDocumentReady2 cdecl Alias "wkeOnDocumentReady2"(WebView As wkeWebView, wkeDocumentReady2Callback As Any Ptr ,callbackParam As LPARAM) ' [86] 同上。区别是wkeDocumentReady2Callback多了wkeWebFrameHandle frameId参数。可以判断是否是主frame
  '    ITERATOR3(void, wkeOnDocumentReady2, wkeWebView webView, wkeDocumentReady2Callback callback, void* param, "") \
Declare Sub wkeOnDownload cdecl Alias "wkeOnDownload"(WebView As wkeWebView, wkeDownloadCallback As Any Ptr ,callbackParam As LPARAM) '[87] 页面下载事件回调。点击某些链接，触发下载会调用
  '    ITERATOR3(void, wkeOnDownload, wkeWebView webView, wkeDownloadCallback callback, void* param, "") \
Declare Sub wkeNetOnResponse cdecl Alias "wkeNetOnResponse"(WebView As wkeWebView, wkeNetResponseCallback As Any Ptr ,callbackParam As LPARAM) '[88] 一个网络请求发送后，收到服务器response触发回调
  '    ITERATOR3(void, wkeNetOnResponse, wkeWebView webView, wkeNetResponseCallback callback, void* param, "") \
Declare Sub wkeOnConsole cdecl Alias "wkeOnConsole"(WebView As wkeWebView, wkeConsoleCallback As Any Ptr ,callbackParam As LPARAM) ' [89] 网页调用console触发
  '    ITERATOR3(void, wkeOnConsole, wkeWebView webView, wkeConsoleCallback callback, void* param, "") \
Declare Sub wkeSetUIThreadCallback cdecl Alias "wkeSetUIThreadCallback"(WebView As wkeWebView, wkeCallUiThread As Any Ptr ,callbackParam As LPARAM) '[90]暂时未实现
  '    ITERATOR3(void, wkeSetUIThreadCallback, wkeWebView webView, wkeCallUiThread callback, void* param, "") \
Declare Sub wkeOnLoadUrlBegin cdecl Alias "wkeOnLoadUrlBegin"(WebView As wkeWebView, wkeLoadUrlBeginCallback As Any Ptr ,callbackParam As LPARAM) '[91]  任何网络请求发起前会触发此回调
  '    ITERATOR3(void, wkeOnLoadUrlBegin, wkeWebView webView, wkeLoadUrlBeginCallback callback, void* callbackParam, "") \
'参数名    说明
'callback  typedef bool(*wkeLoadUrlBeginCallback)(wkeWebView webView, any ptr param, const char *url, Sub *job)
'1，此回调功能强大，在回调里，如果对job设置了wkeNetHookRequest，则表示mb会缓存获取到的网络数据，并在这次网络请求 结束后调用wkeOnLoadUrlEnd设置的回调，同时传递缓存的数据。在此期间，mb不会处理网络数据。
'2，如果在wkeLoadUrlBeginCallback里没设置wkeNetHookRequest，则不会触发wkeOnLoadUrlEnd回调。
'3，如果wkeLoadUrlBeginCallback回调里返回true，表示mb不处理此网络请求（既不会发送网络请求）。
'返回false，表示mb依然会发送网络请求。
Declare Sub wkeOnLoadUrlEnd cdecl Alias "wkeOnLoadUrlEnd"(WebView As wkeWebView, wkeLoadUrlEndCallback As Any Ptr ,callbackParam As LPARAM) ' [92] 见 wkeOnLoadUrlBegin 的描述
  '    ITERATOR3(void, wkeOnLoadUrlEnd, wkeWebView webView, wkeLoadUrlEndCallback callback, void* callbackParam, "") \
Declare Sub wkeOnDidCreateScriptContext cdecl Alias "wkeOnDidCreateScriptContext"(WebView As wkeWebView, wkeDidCreateScriptContextCallback As Any Ptr ,callbackParam As LPARAM) '[93]每个frame创建时都会触发此回调 javascript的v8执行环境被创建时触发此回调
  '    ITERATOR3(void, wkeOnDidCreateScriptContext, wkeWebView webView, wkeDidCreateScriptContextCallback callback, void* callbackParam, "") \
Declare Sub wkeOnWillReleaseScriptContext cdecl Alias "wkeOnWillReleaseScriptContext"(WebView As wkeWebView, wkeWillReleaseScriptContextCallback As Any Ptr ,callbackParam As LPARAM) '[94] 每个frame的javascript的v8执行环境被关闭时触发此回调
  '    ITERATOR3(void, wkeOnWillReleaseScriptContext, wkeWebView webView, wkeWillReleaseScriptContextCallback callback, void* callbackParam, "") \
Declare Sub wkeOnWillMediaLoad cdecl Alias "wkeOnWillMediaLoad"(WebView As wkeWebView, wkeWillMediaLoadCallback As Any Ptr ,callbackParam As LPARAM) '[95] video等多媒体标签创建时触发此回调
  '    ITERATOR3(void, wkeOnWillMediaLoad, wkeWebView webView, wkeWillMediaLoadCallback callback, void* param, "") \
Declare Function wkeIsMainFrame cdecl Alias "wkeIsMainFrame"(WebView As wkeWebView,frameId As Integer ) As bool '[96] 判断frameId是否是主frame
  '    ITERATOR2(BOOL, wkeIsMainFrame, wkeWebView webView, wkeWebFrameHandle frameId, "") \
Declare Function wkeWebFrameGetMainFrame cdecl Alias "wkeWebFrameGetMainFrame"(WebView As wkeWebView) As Integer  '[97] 获取主frame的句柄 wkeWebFrameHandle
  '    ITERATOR1(wkeWebFrameHandle, wkeWebFrameGetMainFrame, wkeWebView webView, "") \
Declare Function wkeRunJsByFrame cdecl Alias "wkeRunJsByFrame"(WebView As wkeWebView,frameId As Integer,script_utf8 As ZString Ptr ,isInClosure As bool ) As jsValue ' [98]  运行js在指定的frame上，通过frameId
  '    ITERATOR4(jsValue, wkeRunJsByFrame, wkeWebView webView, wkeWebFrameHandle frameId, const utf8* script, bool isInClosure, "") \
'参数名        说明
'isInClosure   表示是否在外层包个function() {}形式的闭包
'如果需要返回值，在isInClosure为true时，需要写return，为false则不用
Declare Function wkeGetFrameUrl cdecl Alias "wkeGetFrameUrl"(WebView As wkeWebView,frameId As Integer) As ZString Ptr ' [99] 获取frame对应的url utf8字符串
  '    ITERATOR2(const utf8*, wkeGetFrameUrl, wkeWebView webView, wkeWebFrameHandle frameId, "") \
Declare Function wkeGetString cdecl Alias "wkeGetString"(s As wkeString) As ZString Ptr  ' [100] 获取wkeString结构体对应的字符串，utf8编码
  '    ITERATOR1(const utf8*, wkeGetString, const wkeString string, "") \
Declare Function wkeGetStringW cdecl Alias "wkeGetStringW"(s As wkeString) As wString Ptr '[101] 获取wkeString结构体对应的字符串，utf16编码
  '    ITERATOR1(const wchar_t*, wkeGetStringW, const wkeString string, "") \
Declare Sub wkeSetString cdecl Alias "wkeSetString"(s As wkeString ,str_utf8 As ZString Ptr ,len_size As uLong ) '[102] 设置wkeString结构体对应的字符串，utf8编码
  '    ITERATOR3(void, wkeSetString, wkeString string, const utf8* str, size_t len, "") \
Declare Sub wkeSetStringW cdecl Alias "wkeSetStringW"(s As wkeString ,str_wchar As WString Ptr ,len_size As uLong) '[103] 设置wkeString结构体对应的字符串，utf16编码
  '    ITERATOR3(void, wkeSetStringW, wkeString string, const wchar_t* str, size_t len, "") \
Declare Function wkeCreateStringW cdecl Alias "wkeCreateStringW"(str_wchar As WString Ptr ,len_size As uLong) As wkeString  ' [104] 通过utf16编码的字符串，创建一个wkeString
  '    ITERATOR2(wkeString, wkeCreateStringW, const wchar_t* str, size_t len, "") \
Declare Sub wkeDeleteString cdecl Alias "wkeDeleteString"(WebView As wkeWebView) '[105] 销毁这个wkeString
  '    ITERATOR1(void, wkeDeleteString, wkeString str, "") \
Declare Sub wkeSetUserKeyValue cdecl Alias "wkeSetUserKeyValue"(WebView As wkeWebView,key As ZString Ptr ,value As LPARAM) '[106]  对webView设置一个key value键值对。可以用来保存用户自己定义的任何指针
  '    ITERATOR3(void, wkeSetUserKeyValue, wkeWebView webView, const char* key, void* value, "") \
Declare Function wkeGetUserKeyValue cdecl Alias "wkeGetUserKeyValue"(WebView As wkeWebView,key As ZString Ptr) As LPARAM '[107] 暂无接口描述信息
  '    ITERATOR2(void*, wkeGetUserKeyValue, wkeWebView webView, const char* key, "") \
Declare Function wkeGetCursorInfoType cdecl Alias "wkeGetCursorInfoType"(WebView As wkeWebView) As Integer  ' [108] 暂无接口描述信息
  '    ITERATOR1(int, wkeGetCursorInfoType, wkeWebView webView, "") \
Declare Function wkeCreateWebView cdecl Alias "wkeCreateWebView"() As  Any Ptr 'wkeWebView [109] 创建一个webview，但不创建真窗口。一般用在离屏渲染里，如游戏
  '    ITERATOR0(wkeWebView, wkeCreateWebView, "") \
Declare Sub wkeDestroyWebView cdecl Alias "wkeDestroyWebView"(WebView As wkeWebView) ' [110] 效果同wkeDestroyWebWindow
  '    ITERATOR1(void, wkeDestroyWebView, wkeWebView webView, "") \
Declare Function wkeCreateWebWindow cdecl Alias "wkeCreateWebWindow"(wkeType As wkeWindowType ,parent As HWND ,x As Integer ,y As Integer,w As Integer,h As Integer) As Any Ptr  '[111] 创建一个带真实窗口的wkeWebView
  '    ITERATOR6(wkeWebView, wkeCreateWebWindow, wkeWindowType type, HWND parent, int x, int y, int width, int height, "") \
'创建一个带真实窗口的wkeWebView  wkeWindowType WKE_WINDOW_TYPE_POPUP：普通窗口。WKE_WINDOW_TYPE_TRANSPARENT：透明窗口。mb内部通过layer window实现。WKE_WINDOW_TYPE_CONTROL：嵌入在父窗口里的子窗口。此时parent需要被设置
Declare Sub wkeDestroyWebWindow cdecl Alias "wkeDestroyWebWindow"(WebView As wkeWebView) ' [112] 销毁wkeWebView对应的所有数据结构，包括真实窗口等
  '    ITERATOR1(void, wkeDestroyWebWindow, wkeWebView webWindow, "") \
Declare Function wkeGetWindowHandle cdecl Alias "wkeGetWindowHandle"(WebView As wkeWebView) As HWND '[113] 获取窗口对应的真实句柄。和wkeGetHostHWND的实现完全相同
  '    ITERATOR1(HWND, wkeGetWindowHandle, wkeWebView webWindow, "") \
Declare Sub wkeOnWindowClosing cdecl Alias "wkeOnWindowClosing"(WebView As wkeWebView, wkeWindowClosingCallback As Any Ptr ,callbackParam As LPARAM) '[114]  wkeWebView如果是真窗口模式，则在收到WM_CLODE消息时触发此回调。可以通过在回调中返回false拒绝关闭窗口
  '    ITERATOR3(void, wkeOnWindowClosing, wkeWebView webWindow, wkeWindowClosingCallback callback, void* param, "") \
Declare Sub wkeOnWindowDestroy cdecl Alias "wkeOnWindowDestroy"(WebView As wkeWebView, wkeWindowDestroyCallback As Any Ptr ,callbackParam As LPARAM) '[115] 窗口即将被销毁时触发回调。不像wkeOnWindowClosing，这个操作无法取消
  '    ITERATOR3(void, wkeOnWindowDestroy, wkeWebView webWindow, wkeWindowDestroyCallback callback, void* param, "") \
Declare Sub wkeShowWindow cdecl Alias "wkeShowWindow"(WebView As wkeWebView,showFlag As bool) '[116]  暂无接口描述信息
  '     wkeShowWindow, wkeWebView webWindow, bool show, "") \
Declare Sub wkeEnableWindow cdecl Alias "wkeEnableWindow"(WebView As wkeWebView,enableFlag As bool) ' [117]  暂无接口描述信息
  '     wkeEnableWindow, wkeWebView webWindow, bool enable, "") \
Declare Sub wkeMoveWindow cdecl Alias "wkeMoveWindow"(WebView As wkeWebView,x As Integer ,y As Integer ,w As Integer ,h As Integer ) '[118]  暂无接口描述信息
  '    ITERATOR5(void, wkeMoveWindow, wkeWebView webWindow, int x, int y, int width, int height, "") \
Declare Sub wkeMoveToCenter cdecl Alias "wkeMoveToCenter"(WebView As wkeWebView) ' [119] 窗口在父窗口或屏幕里居中
  '    ITERATOR1(void, wkeMoveToCenter, wkeWebView webWindow, "") \
Declare Sub wkeResizeWindow cdecl Alias "wkeResizeWindow"(WebView As wkeWebView,w As Integer ,h As Integer) ' [120] resize窗口，和wkeResize效果一样
  '    ITERATOR3(void, wkeResizeWindow, wkeWebView webWindow, int width, int height, "") \
Declare Sub wkeSetWindowTitle cdecl Alias "wkeSetWindowTitle"(WebView As wkeWebView,title_utf8 As ZString Ptr ) '[121]  暂无接口描述信息
  '     wkeSetWindowTitle, wkeWebView webWindow, const utf8* title, "") \
Declare Sub wkeSetWindowTitleW cdecl Alias "wkeSetWindowTitleW"(WebView As wkeWebView,title As WString Ptr) '[122]  暂无接口描述信息
  '     wkeSetWindowTitleW, wkeWebView webWindow, const wchar_t* title, "") \
Declare Sub wkeSetDeviceParameter cdecl Alias "wkeSetDeviceParameter"(WebView As wkeWebView,device_utf8 As ZString Ptr,paramStr_utf8 As ZString Ptr,paramInt As Integer ,paramFloat As Single ) '[123] 设置mb模拟的硬件设备环境。主要用在伪装手机设备场景
  '    ITERATOR5(void, wkeSetDeviceParameter, wkeWebView webView, const char* device, const char* paramStr, int paramInt, float paramFloat, "") \
'参数名  说明
'device  设备的字符串。可取值有："navigator.maxTouchPoints"此时 paramInt 需要被设置，表示 touch 的点数。
'                                "navigator.platform"此时paramStr 需要被设置，表示js里获取的 navigator.platform字符串。
'                                "navigator.hardwareConcurrency"此时paramInt 需要被设置，表示js里获取的 navigator.hardwareConcurrency 整数值。
'                                "screen.width"此时paramInt 需要被设置，表示js里获取的 screen.width 整数值。
'                                "screen.height"此时 paramInt 需要被设置，表示js里获取的screen.height 整数值。
'                                "screen.availWidth"此时 paramInt 需要被设置，表示js里获取的 screen.availWidth整数值。
'                                "screen.availHeight"此时 paramInt 需要被设置，表示js里获取的 screen.availHeight 整数值。
'                                "screen.pixelDepth"此时paramInt 需要被设置，表示js里获取的 screen.pixelDepth 整数值。
Declare Sub wkeInit cdecl Alias "wkeInit"() ' [124] 初始化整个mb。此句必须在所有mb api前最先调用。并且所有mb api必须和调用wkeInit的线程为同个线程
Declare Sub wkeInitialize cdecl Alias "wkeInitialize"() ' [126] 效果和wkeInit一模一样
Declare Sub wkeSetProxy cdecl Alias "wkeSetProxy"(proxy As wkeProxy Ptr) ' [127] 设置整个mb的代码。此句是全局生效
  '    ITERATOR1(void, wkeSetProxy, const wkeProxy* proxy, "") \
Declare Sub wkeSetViewProxy cdecl Alias "wkeSetViewProxy"(WebView As wkeWebView,proxy As wkeProxy Ptr) '[128] 设置整个mb的代码。此句是针对特定webview生效
  '     wkeSetViewProxy, wkeWebView webView, wkeProxy *proxy, "") \
Declare Sub wkeConfigure cdecl Alias "wkeConfigure"(settings As wkeSettings Ptr) ' [129] 设置一些配置项
  '    ITERATOR1(void, wkeConfigure, const wkeSettings* settings, "") \
'参数名     说明
'settings   typedef struct { wkeProxy proxy; unsigned int mask; } wkeSettings; mask可以取：WKE_SETTING_PROXY：效果和wkeSetProxy一样，通过proxy设置
Declare Function wkeIsInitialize cdecl Alias "wkeIsInitialize"(WebView As wkeWebView) As bool ' [130] 判断是否初始化
  '    ITERATOR0(BOOL, wkeIsInitialize, "") \
Declare Sub wkeSetMemoryCacheEnable cdecl Alias "wkeSetMemoryCacheEnable"(WebView As wkeWebView, b As bool) ' [132] 开启内存缓存。网页的图片等都会在内存缓存里。关闭后，内存使用会降低一些，但容易引起一些问题，如果不懂怎么用，最好别开
  '     wkeSetMemoryCacheEnable, wkeWebView webView, bool b, "") \
Declare Sub wkeSetTouchEnabled cdecl Alias "wkeSetTouchEnabled"(WebView As wkeWebView, b As bool) '[133] 开启触屏模式。开启后，鼠标消息将自动转换成触屏消息
  '     wkeSetTouchEnabled, wkeWebView webView, bool b, "") \
Declare Sub wkeSetMouseEnabled cdecl Alias "wkeSetMouseEnabled"(WebView As wkeWebView, b As bool) '[134] 开启关闭鼠标消息，可以在开启触屏后，关闭鼠标消息
  '     wkeSetMouseEnabled, wkeWebView webView, bool b, "") \
Declare Sub wkeSetNavigationToNewWindowEnable cdecl Alias "wkeSetNavigationToNewWindowEnable"(WebView As wkeWebView, b As bool) '[135] 关闭后，点a标签将不会弹出新窗口，而是在本窗口跳转
  '     wkeSetNavigationToNewWindowEnable, wkeWebView webView, bool b, "") \
Declare Sub wkeSetCspCheckEnable cdecl Alias "wkeSetCspCheckEnable"(WebView As wkeWebView, b As bool) ' [136] 关闭后，跨域检查将被禁止，此时可以做任何跨域操作，如跨域ajax，跨域设置iframe
  '     wkeSetCspCheckEnable, wkeWebView webView, bool b, "") \
Declare Sub wkeSetNpapiPluginsEnabled cdecl Alias "wkeSetNpapiPluginsEnabled"(WebView As wkeWebView, b As bool) ' [137] 开启关闭npapi插件，如flash
  '     wkeSetNpapiPluginsEnabled, wkeWebView webView, bool b, "") \
Declare Sub wkeSetHeadlessEnabled cdecl Alias "wkeSetHeadlessEnabled"(WebView As wkeWebView, b As bool) ' [138] 开启无头模式。开启后，将不会渲染页面，提升了网页性能。
  '     wkeSetHeadlessEnabled, wkeWebView webView, bool b, "可以关闭渲染") \
Declare Sub wkeSetDebugConfig cdecl Alias "wkeSetDebugConfig"(WebView As wkeWebView,debugString As ZString Ptr ,param As ZString Ptr ) '[139]   开启一些实验性选项。
  '    ITERATOR3(void, wkeSetDebugConfig, wkeWebView webView, const char* debugString, const char* param, "") \
'参数名       说明
'debugString  "showDevTools"开启开发者工具，此时param要填写开发者工具的资源路径，如file:///c:/miniblink-release/front_end/inspector.html。注意param此时必须是utf8编码。
'             "wakeMinInterval"设置帧率，默认值是10，值越大帧率越低。
'             "drawMinInterval"设置帧率，默认值是3，值越大帧率越低。
'             "antiAlias"设置抗锯齿渲染。param必须设置为"1"。
'             "minimumFontSize"最小字体。
'             "minimumLogicalFontSize"最小逻辑字体。
'             "defaultFontSize"默认字体。
'             "defaultFixedFontSize"默认fixed字体。
'             "defaultFixedFontSize"默认fixed字体。
'             "defaultFontSize"默认字体。
'             "defaultFixedFontSize"默认fixed字体。
'             "imageEnable" 是否打开无图模式。param为"0"表示开启无图模式
'             "jsEnable" 是否禁用js。param为"0"表示禁用
Declare Sub wkeSetHandle cdecl Alias "wkeSetHandle"(WebView As wkeWebView,wnd As HWND ) '[140] 设置wkeWebView对应的窗口句柄。只有在无窗口模式下才能使用。如果是用wkeCreateWebWindow创建的webview，已经自带窗口句柄了。
  '     wkeSetHandle, wkeWebView webView, HWND wnd, "") \
Declare Sub wkeSetHandleOffset cdecl Alias "wkeSetHandleOffset"(WebView As wkeWebView,x As Integer ,y As Integer ) '[141] 设置无窗口模式下的绘制偏移。在某些情况下（主要是离屏模式），绘制的地方不在真窗口的(0, 0)处，就需要手动调用此接口
  '    ITERATOR3(void, wkeSetHandleOffset, wkeWebView webView, int x, int y, "") \
Declare Sub wkeSetViewSettings cdecl Alias "wkeSetViewSettings"(WebView As wkeWebView,settings As wkeViewSettings) '[142] 设置一些webview相关的设置.目前只有背景颜色可以设置
  '     wkeSetViewSettings, wkeWebView webView, const wkeViewSettings* settings, "") \
Declare Sub wkeSetTransparent cdecl Alias "wkeSetTransparent"(WebView As wkeWebView,transparent As bool) '[143]  通知无窗口模式下，webview开启透明模式。
  '     wkeSetTransparent, wkeWebView webView, bool transparent, "") \
Declare Function wkeIsTransparent cdecl Alias "wkeIsTransparent"(WebView As wkeWebView) As bool  ' [144] 判断窗口是否是分层窗口（layer window）
  '    ITERATOR1(BOOL, wkeIsTransparent, wkeWebView webView, "") \
Declare Sub wkeSetUserAgent cdecl Alias "wkeSetUserAgent"(WebView As wkeWebView,userAgent_utf8 As ZString Ptr) '[145] 设置webview的UA
  '     wkeSetUserAgent, wkeWebView webView, const utf8* userAgent, "") \
Declare Sub wkeSetUserAgentW cdecl Alias "wkeSetUserAgentW"(WebView As wkeWebView,userAgent as wString Ptr) ' [146] 暂无接口描述信息
  '     wkeSetUserAgentW, wkeWebView webView, const wchar_t* userAgent, "") \
Declare Function wkeGetUserAgent cdecl Alias "wkeGetUserAgent"(WebView As wkeWebView) As ZString Ptr  ' [147] 获取webview的UA
  '    ITERATOR1(const char*, wkeGetUserAgent, wkeWebView webView, "") \
Declare Sub wkeLoadURL cdecl Alias "wkeLoadURL"(WebView As wkeWebView,url_utf8 As ZString Ptr) '[148] 加载url。url必须是网络路径，如http://qq.com/
  '     wkeLoadURL, wkeWebView webView, const utf8* url, "") \
Declare Sub wkeLoadW cdecl Alias "wkeLoadW"(WebView As wkeWebView,url As wString Ptr ) ' [149] 暂无接口描述信息
  '     wkeLoadW, wkeWebView webView, const wchar_t* url, "") \
Declare Sub wkeLoadHTML cdecl Alias "wkeLoadHTML"(WebView As wkeWebView,html_utf8 As ZString Ptr) '[150] 加载一段html 如果html里有相对路径，则是相对exe所在目录的路径
  '     wkeLoadHTML, wkeWebView webView, const utf8* html, "") \
Declare Sub wkeLoadHtmlWithBaseUrl cdecl Alias "wkeLoadHtmlWithBaseUrl"(WebView As wkeWebView,html_utf8 As ZString Ptr,baseUrl_utf8 As ZString Ptr) ' [151] 加载一段html，但可以指定baseURL，也就是相对于哪个目录的url
  '    ITERATOR3(void, wkeLoadHtmlWithBaseUrl, wkeWebView webView, const utf8* html, const utf8* baseUrl, "") \
Declare Sub wkeLoadFile cdecl Alias "wkeLoadFile"(WebView As wkeWebView,filename_utf8 As ZString Ptr) ' [152]  暂无接口描述信息
  '     wkeLoadFile, wkeWebView webView, const utf8* filename, "") \
Declare Function wkeGetURL cdecl Alias "wkeGetURL"(WebView As wkeWebView) As ZString Ptr '[153] 获取webview主frame的url
  '    ITERATOR1(const utf8*, wkeGetURL, wkeWebView webView, "") \
Declare Sub wkeNetSetHTTPHeaderField cdecl Alias "wkeNetSetHTTPHeaderField"(jobPtr As Any Ptr,key As wString Ptr,value As wString Ptr,response As bool) '[154] 在wkeOnLoadUrlBegin回调里调用，表示设置http请求（或者file:///协议）的 http header field。response一直要被设置成false
  '    ITERATOR4(void, wkeNetSetHTTPHeaderField, wkeNetJob jobPtr, const wchar_t* key, const wchar_t* value, bool response, "") \
Declare Sub wkeNetSetMIMEType cdecl Alias "wkeNetSetMIMEType"(jobPtr As Any Ptr,type_utf8 As ZString Ptr) ' [155] 在wkeOnLoadUrlBegin回调里调用，表示设置http请求的MIME type
  '     wkeNetSetMIMEType, wkeNetJob jobPtr, const char* type, "设置response的mime") \
Declare Function wkeNetGetMIMEType cdecl Alias "wkeNetGetMIMEType"(jobPtr As Any Ptr,mime As wkeString ) As  ZString Ptr ' [156]  暂无接口描述信息
  '    ITERATOR2(const char*, wkeNetGetMIMEType, wkeNetJob jobPtr, wkeString mime, "获取response的mime") \
Declare Sub wkeNetSetData cdecl Alias "wkeNetSetData"(jobPtr As Any Ptr,buf As Any Ptr ,len_ As Integer ) '[157]  在wkeOnLoadUrlEnd里被调用，表示设置hook后缓存的数据
  '    ITERATOR3(void, wkeNetSetData, wkeNetJob jobPtr, void *buf, int len, "调用此函数后,网络层收到数据会存储在一buf内,接收数据完成后响应OnLoadUrlEnd事件.#此调用严重影响性能,慎用" \
  '        "此函数和wkeNetSetData的区别是，wkeNetHookRequest会在接受到真正网络数据后再调用回调，并允许回调修改网络数据。"\
  '        "而wkeNetSetData是在网络数据还没发送的时候修改") \
Declare Sub wkeNetCancelRequest cdecl Alias "wkeNetCancelRequest"(jobPtr As Any Ptr) '[158] 在wkeOnLoadUrlBegin回调里调用，设置后，此请求将被取消。
  '    ITERATOR1(void, wkeNetCancelRequest, wkeNetJob jobPtr, "")\
Declare Function wkeNetGetFavicon cdecl Alias "wkeNetGetFavicon"(WebView As wkeWebView, wkeOnNetGetFavicon As Any Ptr ,callbackParam As LPARAM) As Integer  ' [159] 获取 favicon。 此接口必须在wkeOnLoadingFinish回调里调用。
  '    ITERATOR3(int, wkeNetGetFavicon, wkeWebView webView, wkeOnNetGetFaviconCallback callback, void* param, "") \
Declare Function wkeNetHoldJobToAsynCommit cdecl Alias "wkeNetHoldJobToAsynCommit"(jobPtr As Any Ptr) As BOOL '[160] 高级用法。在wkeOnLoadUrlBegin回调里调用。 有时候，wkeOnLoadUrlBegin里拦截到一个请求后，不能马上判断出结果。此时可以调用本接口，然后在 异步的某个时刻，调用wkeNetContinueJob来让此请求继续进行
  '    ITERATOR1(BOOL, wkeNetHoldJobToAsynCommit, wkeNetJob jobPtr, "")\
'TRUE代表成功，FALSE代表调用失败，不能再调用wkeNetContinueJob了
Declare Function wkeNetGetRequestMethod cdecl Alias "wkeNetGetRequestMethod"(jobPtr As Any Ptr) As wkeRequestType ' [161]  获取此请求的method，如post还是get
  '    ITERATOR1(wkeRequestType, wkeNetGetRequestMethod, wkeNetJob jobPtr, "") \
Declare Function wkeNetGetPostBody cdecl Alias "wkeNetGetPostBody"(jobPtr As Any Ptr) As wkePostBodyElements Ptr ' [162] 获取此请求中的post数据。只有当请求是post时才有效果
  '    ITERATOR1(wkePostBodyElements*, wkeNetGetPostBody, wkeNetJob jobPtr, "") \
Declare Function wkeNetCreatePostBodyElements cdecl Alias "wkeNetCreatePostBodyElements"(WebView As wkeWebView,length As size_t) As wkePostBodyElements Ptr ' [163] 暂无接口描述信息
  '    ITERATOR2(wkePostBodyElements*, wkeNetCreatePostBodyElements, wkeWebView webView, size_t length, "") \
Declare Sub wkeNetFreePostBodyElements cdecl Alias "wkeNetFreePostBodyElements"(elements As wkePostBodyElements Ptr) ' [164] [165] 暂无接口描述信息
  '    ITERATOR1(void, wkeNetFreePostBodyElements, wkePostBodyElements* elements, "") \
Declare Function wkeNetCreatePostBodyElement cdecl Alias "wkeNetCreatePostBodyElement"(WebView As wkeWebView) As  wkePostBodyElements Ptr  ' [166]  暂无接口描述信息
  '    ITERATOR1(wkePostBodyElement*, wkeNetCreatePostBodyElement, wkeWebView webView, "") \
Declare Sub wkeNetFreePostBodyElement cdecl Alias "wkeNetFreePostBodyElement"(element As wkePostBodyElement Ptr) ' [167] 这四个接口要结合起来使用。 当wkeOnLoadUrlBegin里判断是post时，可以通过wkeNetCreatePostBodyElements来创建一个新的post数据包。 然后wkeNetFreePostBodyElements来释放原post数据。
  '    ITERATOR1(void, wkeNetFreePostBodyElement, wkePostBodyElement* element, "") \
'注意区分  wkePostBodyElement 和 wkePostBodyElements
Declare Function jsArgCount cdecl Alias "jsArgCount"(es As jsExecState) As Integer   ' [168] 获取es里存的参数个数。一般是在绑定的js调用c++回调里使用，判断js传递了多少参数给c++
  '    ITERATOR1(int, jsArgCount, jsExecState es, "") \
Declare Function jsArgType cdecl Alias "jsArgType"(es As jsExecState,argIdx As Integer ) As jsType ' [169] 判断第argIdx个参数的参数类型。argIdx从是个0开始计数的值。如果超出jsArgCount返回的值，将发生崩溃
  '    ITERATOR2(jsType, jsArgType, jsExecState es, int argIdx, "") \
Declare Function jsArg cdecl Alias "jsArg"(es As jsExecState,argIdx As Integer) As jsValue  '[170]  获取第argIdx对应的参数的jsValue值。
  '    ITERATOR2(jsValue, jsArg, jsExecState es, int argIdx, "") \
Declare Function jsTypeOf cdecl Alias "jsTypeOf"(v As jsValue) As jsType '[171]  获取v对应的类型。
  '    ITERATOR1(jsType, jsTypeOf, jsValue v, "") \
Declare Function jsIsNumber cdecl Alias "jsIsNumber"(v As jsValue) As bool '[172] 判断v是否为数字
  '    ITERATOR1(BOOL, jsIsNumber, jsValue v, "") \
Declare Function jsIsString cdecl Alias "jsIsString"(v As jsValue) As bool '[173] 暂无接口描述信息
  '    ITERATOR1(BOOL, jsIsString, jsValue v, "") \
Declare Function jsIsBoolean cdecl Alias "jsIsBoolean"(v As jsValue) As bool ' [174]  暂无接口描述信息
  '    ITERATOR1(BOOL, jsIsBoolean, jsValue v, "") \
Declare Function jsIsObject cdecl Alias "jsIsObject"(v As jsValue) As bool ' [175] 暂无接口描述信息 [176] 当v不是数字、字符串、undefined、null、函数的时候，此接口返回true
  '    ITERATOR1(BOOL, jsIsObject, jsValue v, "") \
Declare Function jsIsTrue cdecl Alias "jsIsTrue"(v As jsValue) As bool '[177] 如果v本身是个布尔值，返回对应的true或者false；如果是个对象（JSTYPE_OBJECT），返回false（这里注意）
  '    ITERATOR1(BOOL, jsIsTrue, jsValue v, "") \
Declare Function jsIsFalse cdecl Alias "jsIsFalse"(v As jsValue) As bool '[178]  等价于!jsIsTrue(v)
  '    ITERATOR1(BOOL, jsIsFalse, jsValue v, "") \
Declare Function jsToInt cdecl Alias "jsToInt"(es As jsExecState,v As jsValue) As Integer  ' [179]  如果v是个整形或者浮点，返回相应值（如果是浮点，返回取整后的值）。如果是其他类型，返回0（这里注意）
  '    ITERATOR2(int, jsToInt, jsExecState es, jsValue v, "") \
Declare Function jsToDouble cdecl Alias "jsToDouble"(es As jsExecState,v As jsValue) As double  '[180]  如果v是个浮点形，返回相应值。如果是其他类型，返回0.0（这里注意）
  '    ITERATOR2(double, jsToDouble, jsExecState es, jsValue v, "") \
Declare Function jsToTempStringW cdecl Alias "jsToTempStringW"(es As jsExecState,v As jsValue) As WString Ptr '[181] 如果v是个字符串，返回相应值。如果是其他类型，返回L""（这里注意） 另外，返回的字符串不需要外部释放。mb会在下一帧自动释放
  '    ITERATOR2(const wchar_t*, jsToTempStringW, jsExecState es, jsValue v, "") \
Declare Function jsToTempString cdecl Alias "jsToTempString"(es As jsExecState,v As jsValue) As zString Ptr '[182] 如果v是个字符串，返回utf8字符串 。如果是其他类型，返回L""（这里注意） 另外，返回的字符串不需要外部释放。mb会在下一帧自动释放
  '    ITERATOR2(const utf8*, jsToTempString, jsExecState es, jsValue v, "") \
Declare Function jsToString cdecl Alias "jsToString"(es As jsExecState,v As jsValue) As zString Ptr '[183] 如果v是个字符串，返回utf8字符串 
  '    ITERATOR2(const utf8*, jsToString, jsExecState es, jsValue v, "") \
Declare Function jsToStringW cdecl Alias "jsToStringW"(es As jsExecState,v As jsValue) As wString Ptr '[184]  暂无接口描述信息
  '    ITERATOR2(const wchar_t*, jsToStringW, jsExecState es, jsValue v, "") \
Declare Function jsInt cdecl Alias "jsInt"(n As Integer ) As jsValue ' [185] 创建建一个int型的jsValue，注意是创建
  '    ITERATOR1(jsValue, jsInt, int n, "") \
Declare Function jsString cdecl Alias "jsString"(es As jsExecState,str_utf8 As ZString Ptr) As jsValue ' [186] 构建一个utf8编码的字符串的的jsValue。str会在内部拷贝保存，注意是创建
  '    ITERATOR2(jsValue, jsString, jsExecState es, const utf8* str, "") \
Declare Function jsArrayBuffer cdecl Alias "jsArrayBuffer"(WebView As wkeWebView,buffer As Any Ptr ,size As size_t) As jsValue ' [187] 构建一个js的arraybuffer类型的jaValue。主要用来处理一些二进制数据，注意是创建 
  '    ITERATOR3(jsValue, jsArrayBuffer, jsExecState es, const char* buffer, size_t size, "") \
Declare Function jsGetArrayBuffer cdecl Alias "jsGetArrayBuffer"(es As jsExecState,value As jsValue) As wkeMemBuf Ptr ' [188] 获取一个js的arraybuffer类型的数据。主要用来处理一些二进制数据
  '    ITERATOR2(wkeMemBuf*, jsGetArrayBuffer, jsExecState es, jsValue value, "") \
Declare Function jsEmptyObject cdecl Alias "jsEmptyObject"(es As jsExecState) As  jsValue ' [189]  构建一个临时js object的jsValue，注意是创建
  '    ITERATOR1(jsValue, jsEmptyObject, jsExecState es, "") \
Declare Function jsEvalW cdecl Alias "jsEvalW"(es As jsExecState,wstr_ As wString Ptr ) As jsValue '[190] 执行一段js，并返回值。 
  '    ITERATOR2(jsValue, jsEvalW, jsExecState es, const wchar_t* str, "") \
'str的代码会在mb内部自动被包裹在一个function(){}中。所以使用的变量会被隔离 注意：要获取返回值，请写return。这和wke不太一样。wke不需要写retrun
Declare Function jsEvalExW cdecl Alias "jsEvalExW"(es As jsExecState,wstr_ As wString Ptr ,isInClosure As bool) As jsValue ' [191]
  '    ITERATOR3(jsValue, jsEvalExW, jsExecState es, const wchar_t* str, bool isInClosure, "") \
'和上述接口的区别是，isInClosure表示是否要包裹一层function(){}。jsEvalW相当于jsEvalExW(es, str, false)
'如果需要返回值，在isInClosure为true时，需要写return，为false则不用
Declare Function jsCall cdecl Alias "jsCall"(es As jsExecState,func As jsValue,thisValue As jsValue,args As jsValue Ptr,argCount As Integer ) As jsValue '[192] 调用一个func对应的js函数。如果此js函数是成员函数，则需要填thisValue。 否则可以传jsUndefined。args是个数组，个数由argCount控制。 func可以是从js里取的，也可以是自行构造的。
  '    ITERATOR5(jsValue, jsCall, jsExecState es, jsValue func, jsValue thisObject, jsValue* args, int argCount, "") \
Declare Function jsCallGlobal cdecl Alias "jsCallGlobal"(es As jsExecState,func As jsValue,args As jsValue Ptr,argCount As Integer) As jsValue '[193] 调用window上的全局函数
  '    ITERATOR4(jsValue, jsCallGlobal, jsExecState es, jsValue func, jsValue* args, int argCount, "") \
Declare Function jsGet cdecl Alias "jsGet"(es As jsExecState,object_ As jsValue ,prop As ZString Ptr) As jsValue '[194] 如果object是个js的object，则获取prop指定的属性。如果object不是js object类型，则返回jsUndefined
  '    ITERATOR3(jsValue, jsGet, jsExecState es, jsValue object, const char* prop, "") \
Declare Sub jsSet cdecl Alias "jsSet"(es As jsExecState,object_ As jsValue ,prop As ZString Ptr,value As jsValue ) ' [195] 设置object的属性
  '    ITERATOR4(void, jsSet, jsExecState es, jsValue object, const char* prop, jsValue v, "") \
Declare Function jsGetGlobal cdecl Alias "jsGetGlobal"(es As jsExecState,prop As ZString Ptr) As jsValue '[196] 获取window上的属性
  '    ITERATOR2(jsValue, jsGetGlobal, jsExecState es, const char* prop, "") \
Declare Sub jsSetGlobal cdecl Alias "jsSetGlobal"(es As jsExecState,prop As ZString Ptr,v As jsValue) '[197]  设置window上的属性
  '    ITERATOR3(void, jsSetGlobal, jsExecState es, const char* prop, jsValue v, "") \
Declare Function jsGetAt cdecl Alias "jsGetAt"(es As jsExecState,object_ As jsValue,index As Integer ) As jsValue ' [198] 设置js arrary的第index个成员的值，object必须是js array才有用，否则会返回jsUndefined
  '    ITERATOR3(jsValue, jsGetAt, jsExecState es, jsValue object, int index, "") \
Declare Sub jsSetAt cdecl Alias "jsSetAt"(es As jsExecState,object_ As jsValue,index As Integer ,value As jsValue) '[199]  设置js arrary的第index个成员的值，object必须是js array才有用。
  '    ITERATOR4(void, jsSetAt, jsExecState es, jsValue object, int index, jsValue v, "") \
Declare Function jsGetKeys cdecl Alias "jsGetKeys"(es As jsExecState,object_ As jsValue) As jsKeys Ptr ' [200] 获取object有哪些key
  '    ITERATOR2(jsKeys*, jsGetKeys, jsExecState es, jsValue object, "") \
Declare Function jsGetLength cdecl Alias "jsGetLength"(es As jsExecState,object_ As jsValue) As Integer '[201] 获取js arrary的长度，object必须是js array才有用。
  '    ITERATOR2(int, jsGetLength, jsExecState es, jsValue object, "") \
Declare Sub jsSetLength cdecl Alias "jsSetLength"(es As jsExecState,object_ As jsValue,length As Integer ) '[202] 设置js arrary的长度，object必须是js array才有用。
  '    ITERATOR3(void, jsSetLength, jsExecState es, jsValue object, int length, "") \
Declare Function jsGetWebView cdecl Alias "jsGetWebView"(es As jsExecState) As Any Ptr '[203] 获取es对应的webview
  '    ITERATOR1(wkeWebView, jsGetWebView, jsExecState es, "") \
Declare Sub jsGC cdecl Alias "jsGC"() '[204] 强制垃圾回收
  '    ITERATOR0(void, jsGC, "") \
'Declare Sub fastcall jsBindFunction cdecl Alias "jsBindFunction"(const char* name, jsNativeFunction fn, unsigned int argCount)  ' [205] 绑定一个全局函数到主frame的window上。
'此接口只能绑定主frame，并且特别需要注意的是，因为历史原因，此接口是fastcall调用约定！（但 wkeJsBindFunction 不是）另外此接口和wkeJsBindFunction必须在webview创建前调用
'FreeBasic 里无 fastcall 模式，只能放弃
Declare Sub jsBindGetter cdecl Alias "jsBindGetter"(name_ As ZString Ptr,jsNativeFunction as Any Ptr ) '[206] 对js winows绑定一个属性访问器，在js里windows.XXX这种形式调用时，fn会被调用
  '     jsBindGetter, const char* name, jsNativeFunction fn, "") \
Declare Sub jsBindSetter cdecl Alias "jsBindSetter"(name_ As ZString Ptr,jsNativeFunction as Any Ptr) '[207]  对js winows绑定一个属性设置器。
  '    ITERATOR2(void, jsBindSetter, const char* name, jsNativeFunction fn, "") \
Declare Sub wkeJsBindFunction cdecl Alias "wkeJsBindFunction"(name_ As ZString Ptr,wkeJsNativeFunction As Any Ptr ,param As LPARAM,argCount As UInteger ) ' [208] 和jsBindFunction功能类似，但更方便一点，可以传一个param做自定义数据。此接口和wkeJsBindFunction必须在webview创建前调用
  '    ITERATOR4(void, wkeJsBindFunction, const char* name, wkeJsNativeFunction fn, void* param, unsigned int argCount, "") \
Declare Function jsObject cdecl Alias "jsObject"(es As jsExecState,data_ As jsData Ptr) As jsValue ' [209] 构建一个js Objcet，可以传递给js使用。
  '    ITERATOR2(jsValue, jsObject, jsExecState es, jsData* obj, "") \
Declare Function jsFunction cdecl Alias "jsFunction"(es As jsExecState,data_ As jsData Ptr) As jsValue '[210] 创建一个主frame的全局函数。jsData的用法如上。js调用：XXX() 此时jsData的callAsFunction触发。 其实jsFunction和jsObject功能基本类似。且jsObject的功能更强大一些
  '    ITERATOR2(jsValue, jsFunction, jsExecState es, jsData* obj, "") \
Declare Function jsGetData cdecl Alias "jsGetData"(es As jsExecState,value As jsValue) As jsData Ptr '[211] 获取jsObject或jsFunction创建的jsValue对应的jsData指针。
  '    ITERATOR2(jsData*, jsGetData, jsExecState es, jsValue object, "") \
Declare Function jsGetLastErrorIfException cdecl Alias "jsGetLastErrorIfException"(es As jsExecState) As jsExceptionInfo Ptr  '[212] 当wkeRunJs、jsCall等接口调用时，如果执行的js代码有异常，此接口将获取到异常信息。否则返回nullptr。
  '    ITERATOR1(jsExceptionInfo*, jsGetLastErrorIfException, jsExecState es, "") \
  
  '下面是补漏的，官网帮助没说明的，什么功能，自己靠猜吧。
Declare Function jsAddRef cdecl Alias "jsAddRef"(es As jsExecState,value As jsValue)As BOOL ' 
  '    ITERATOR2(BOOL, jsAddRef, jsExecState es, jsValue val, "") \
Declare Function jsBoolean cdecl Alias "jsBoolean"(b As bool) As jsValue '
  '    ITERATOR1(jsValue, jsBoolean, bool b, "") \
Declare Sub jsDeleteObjectProp cdecl Alias "jsDeleteObjectProp"(es As jsExecState,object_ As jsValue,prop As ZString Ptr) ' 
  '    ITERATOR3(void, jsDeleteObjectProp, jsExecState es, jsValue object, const char* prop, "") \
Declare Function jsDouble cdecl Alias "jsDouble"(d As Double ) As jsValue ' 
  '    ITERATOR1(jsValue, jsDouble, double d, "") \
Declare Function jsDoubleString cdecl Alias "jsDoubleString"(str_ As ZString Ptr) As jsValue' 
  '    ITERATOR1(jsValue, jsDoubleString, const char* str, "") \
Declare Function jsEmptyArray cdecl Alias "jsEmptyArray"(es As jsExecState) As jsValue ' 
  '    ITERATOR1(jsValue, jsEmptyArray, jsExecState es, "") \
Declare Function jsEval cdecl Alias "jsEval"(es As jsExecState,str_utf8 As ZString Ptr ) As jsValue ' 
  '    ITERATOR2(jsValue, jsEval, jsExecState es, const utf8* str, "") \
Declare Function jsFalse cdecl Alias "jsFalse"() As jsValue ' 
  '    ITERATOR0(jsValue, jsFalse, "") \
Declare Function jsFloat cdecl Alias "jsFloat"(f As Single) As jsValue ' 
  '    ITERATOR1(jsValue, jsFloat, float f, "") \
Declare Function jsGetCallstack cdecl Alias "jsGetCallstack"(es As jsExecState) As ZString Ptr 'utf8 
  '    ITERATOR1(const utf8*, jsGetCallstack, jsExecState es, "")
Declare Function jsGlobalObject cdecl Alias "jsGlobalObject"(es As jsExecState) As jsValue '
  '    ITERATOR1(jsValue, jsGlobalObject, jsExecState es, "") \
Declare Function jsIsArray cdecl Alias "jsIsArray"(v As jsValue) As BOOL '
  '    ITERATOR1(BOOL, jsIsArray, jsValue v, "") \
Declare Function jsIsFunction cdecl Alias "jsIsFunction"(v As jsValue) As  BOOL' 
  '    ITERATOR1(BOOL, jsIsFunction, jsValue v, "") \
Declare Function jsIsJsValueValid cdecl Alias "jsIsJsValueValid"(es As jsExecState,object_ As jsValue) As BOOL '
  '    ITERATOR2(BOOL, jsIsJsValueValid, jsExecState es, jsValue object, "") \
Declare Function jsIsNull cdecl Alias "jsIsNull"(v As jsValue) As BOOL ' 
  '    ITERATOR1(BOOL, jsIsNull, jsValue v, "") \
Declare Function jsIsUndefined cdecl Alias "jsIsUndefined"(v As jsValue) As BOOL ' 
  '    ITERATOR1(BOOL, jsIsUndefined, jsValue v, "") \
Declare Function jsIsValidExecState cdecl Alias "jsIsValidExecState"(es As jsExecState) As BOOL ' 
  '    ITERATOR1(BOOL, jsIsValidExecState, jsExecState es, "") \
Declare Function jsNull cdecl Alias "jsNull"() As jsValue ' 
  '    ITERATOR0(jsValue, jsNull, "") \
Declare Function jsReleaseRef cdecl Alias "jsReleaseRef"(es As jsExecState,v as jsValue) As BOOL ' 
  '    ITERATOR2(BOOL, jsReleaseRef, jsExecState es, jsValue val, "") \
Declare Function jsStringW cdecl Alias "jsStringW"(es As jsExecState,Str_w  As wString Ptr ) As  jsValue'
  '    ITERATOR2(jsValue, jsStringW, jsExecState es, const wchar_t* str, "") \
Declare Function jsThrowException cdecl Alias "jsThrowException"(es As jsExecState,exception_utf8 As ZString Ptr) As jsValue ' 
  '    ITERATOR2(jsValue, jsThrowException, jsExecState es, const utf8* exception, "") \
Declare Function jsToBoolean cdecl Alias "jsToBoolean"(es As jsExecState,v As jsValue) As BOOL ' 
  '    ITERATOR2(BOOL, jsToBoolean, jsExecState es, jsValue v, "") \
Declare Function jsToDoubleString cdecl Alias "jsToDoubleString"(es As jsExecState,v As jsValue) As ZString Ptr ' 
  '    ITERATOR2(const char*, jsToDoubleString, jsExecState es, jsValue v, "") \
Declare Function jsToFloat cdecl Alias "jsToFloat"(es As jsExecState,v As jsValue) As Single ' 
  '    ITERATOR2(float, jsToFloat, jsExecState es, jsValue v, "") \
Declare Function jsToV8Value cdecl Alias "jsToV8Value"(es As jsExecState,v As jsValue) As Any Ptr ' "return v8::Persistent<v8::Value>*"
  '    ITERATOR2(void*, jsToV8Value, jsExecState es, jsValue v, "return v8::Persistent<v8::Value>*") \
Declare Function jsTrue cdecl Alias "jsTrue"() As jsValue '
  '    ITERATOR0(jsValue, jsTrue, "") \
Declare Function jsUndefined cdecl Alias "jsUndefined"() As jsValue ' 
  '    ITERATOR0(jsValue, jsUndefined, "") \
Declare Sub wkeAddDirtyArea cdecl Alias "wkeAddDirtyArea"(WebView As wkeWebView ,x As Integer ,y As Integer ,w As Integer ,h As Integer ) ' 
  '    ITERATOR5(void, wkeAddDirtyArea, wkeWebView webView, int x, int y, int w, int h, "") \
Declare Sub wkeAddNpapiPlugin cdecl Alias "wkeAddNpapiPlugin"(WebView As wkeWebView ,initializeFunc As Any Ptr ,getEntryPointsFunc As Any Ptr,shutdownFunc As Any Ptr ) ' 
  '    ITERATOR4(void, wkeAddNpapiPlugin, wkeWebView webView, void* initializeFunc, void* getEntryPointsFunc, void* shutdownFunc, "") \
Declare Sub wkeAddPluginDirectory cdecl Alias "wkeAddPluginDirectory"(WebView As wkeWebView ,path As wString Ptr ) ' 
  '     wkeAddPluginDirectory, wkeWebView webView, const WCHAR* path, "") \
Declare Sub wkeAwaken cdecl Alias "wkeAwaken"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeAwaken, wkeWebView webView, "") \
Declare Sub wkeClearCookie cdecl Alias "wkeClearCookie"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeClearCookie, wkeWebView webView, "") \
Declare Function wkeContentsHeight cdecl Alias "wkeContentsHeight"(WebView As wkeWebView) As Integer  ' 
  '    ITERATOR1(int, wkeContentsHeight, wkeWebView webView, "") \
Declare Function wkeContentsWidth cdecl Alias "wkeContentsWidth"(WebView As wkeWebView) As Integer  ' 
  '    ITERATOR1(int, wkeContentsWidth, wkeWebView webView, "") \
Declare Function wkeContextMenuEvent cdecl Alias "wkeContextMenuEvent"(WebView As wkeWebView,x As Integer,y As Integer,flags As UInteger ) As BOOL ' 
  '    ITERATOR4(BOOL, wkeContextMenuEvent, wkeWebView webView, int x, int y, unsigned int flags, "") \
Declare Function wkeCookieEnabled cdecl Alias "wkeCookieEnabled"(WebView As wkeWebView) As BOOL ' 
  '    ITERATOR1(BOOL, wkeCookieEnabled, wkeWebView webView, "") \
Declare Sub wkeCopy cdecl Alias "wkeCopy"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeCopy, wkeWebView webView, "") \
Declare Function wkeCreateMemBuf cdecl Alias "wkeCreateMemBuf"(WebView As wkeWebView,buf As Any Ptr,length As size_t) As  wkeMemBuf Ptr ' 
  '    ITERATOR3(wkeMemBuf*, wkeCreateMemBuf, wkeWebView webView, void* buf, size_t length, "") \
Declare Function wkeCreateString cdecl Alias "wkeCreateString"(str_utf8 As ZString Ptr,length As size_t) As wkeString ' 
  '    ITERATOR2(wkeString, wkeCreateString, const utf8* str, size_t len, "") \
Declare Function wkeCreateStringWithoutNullTermination cdecl Alias "wkeCreateStringWithoutNullTermination"(str_utf8 As ZString Ptr,length As size_t) As wkeString ' 
  '    ITERATOR2(wkeString, wkeCreateStringWithoutNullTermination, const utf8* str, size_t len, "") \
Declare Function wkeCreateWebCustomWindow cdecl Alias "wkeCreateWebCustomWindow"(info As wkeWindowCreateInfo Ptr ) As  Any Ptr ' wkeWebView
  '    ITERATOR1(wkeWebView, wkeCreateWebCustomWindow, const wkeWindowCreateInfo* info, "") \
Declare Sub wkeCut cdecl Alias "wkeCut"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeCut, wkeWebView webView, "") \
Declare Sub wkeDelete cdecl Alias "wkeDelete"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeDelete, wkeWebView webView, "") \
Declare Function wkeDragTargetDragEnter cdecl Alias "wkeDragTargetDragEnter"(WebView As wkeWebView,webDragData As wkeWebDragData Ptr, clientPoint As POINT Ptr ,operationsAllowed As wkeWebDragOperationsMask,modifiers As Integer ) As wkeWebDragOperation ' 
  '    ITERATOR6(wkeWebDragOperation, wkeDragTargetDragEnter, wkeWebView webView, const wkeWebDragData* webDragData, const POINT* clientPoint, const POINT* screenPoint, wkeWebDragOperationsMask operationsAllowed, int modifiers, "") \
Declare Sub wkeDragTargetDragLeave cdecl Alias "wkeDragTargetDragLeave"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeDragTargetDragLeave, wkeWebView webView, "") \
Declare Function wkeDragTargetDragOver cdecl Alias "wkeDragTargetDragOver"(WebView As wkeWebView, clientPoint As POINT Ptr,screenPoint As POINT Ptr ,operationsAllowed As wkeWebDragOperationsMask,modifiers As Integer ) As wkeWebDragOperation  ' 
  '    ITERATOR5(wkeWebDragOperation, wkeDragTargetDragOver, wkeWebView webView, const POINT* clientPoint, const POINT* screenPoint, wkeWebDragOperationsMask operationsAllowed, int modifiers, "") \
Declare Sub wkeDragTargetDrop cdecl Alias "wkeDragTargetDrop"(WebView As wkeWebView, clientPoint As POINT Ptr,screenPoint As POINT Ptr,modifiers As Integer ) ' 
  '    ITERATOR4(void, wkeDragTargetDrop, wkeWebView webView, const POINT* clientPoint, const POINT* screenPoint, int modifiers, "") \
Declare Sub wkeDragTargetEnd cdecl Alias "wkeDragTargetEnd"(WebView As wkeWebView, clientPoint As POINT Ptr,screenPoint As POINT Ptr,operation As wkeWebDragOperation) ' 
  '    ITERATOR4(void, wkeDragTargetEnd, wkeWebView webView, const POINT* clientPoint, const POINT* screenPoint, wkeWebDragOperation operation, "") \
Declare Sub wkeEditorPaste cdecl Alias "wkeEditorPaste"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeEditorPaste, wkeWebView webView, "") \
Declare Sub wkeFinalize cdecl Alias "wkeFinalize"(WebView As wkeWebView) ' 
  '    ITERATOR0(void, wkeFinalize, "") \
Declare Function wkeFireKeyPressEvent cdecl Alias "wkeFireKeyPressEvent"(WebView As wkeWebView,charCode As UInteger ,flags As UInteger ,systemKey As bool) As BOOL '
'    ITERATOR4(BOOL, wkeFireKeyPressEvent, wkeWebView webView, unsigned int charCode, unsigned int flags, bool systemKey, "") \
'参数名     说明
'charCode   WM_CHAR消息的The character code of the key.见https://msdn.microsoft.com/en-us/library/windows/desktop/ms646276(v=vs.85).aspx
Declare Sub wkeFocus cdecl Alias "wkeFocus"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeFocus, wkeWebView webView, "") \
Declare Sub wkeFreeMemBuf cdecl Alias "wkeFreeMemBuf"(buf As wkeMemBuf Ptr) ' 
  '    ITERATOR1(void, wkeFreeMemBuf, wkeMemBuf* buf, "") \
Declare Function wkeGetBlinkMainThreadIsolate cdecl Alias "wkeGetBlinkMainThreadIsolate"(WebView As wkeWebView) As v8Isolate 
  '    ITERATOR0(v8Isolate, wkeGetBlinkMainThreadIsolate, "") \
Declare Function wkeGetCaret cdecl Alias "wkeGetCaret"(WebView As wkeWebView) As wkeRect ' 
  '    ITERATOR1(wkeRect, wkeGetCaret, wkeWebView webView, "") \
Declare Function wkeGetCaretRect2 cdecl Alias "wkeGetCaretRect2"(WebView As wkeWebView) As wkeRect Ptr  '给一些不方便获取返回结构体的语言调用 
  '    ITERATOR1(wkeRect*, wkeGetCaretRect2, wkeWebView webView, "给一些不方便获取返回结构体的语言调用") \
Declare Function wkeGetClientHandler cdecl Alias "wkeGetClientHandler"(WebView As wkeWebView) As wkeClientHandler Ptr ' 
  '    ITERATOR1(const wkeClientHandler*, wkeGetClientHandler, wkeWebView webView, "") \
Declare Function wkeGetContentAsMarkup cdecl Alias "wkeGetContentAsMarkup"(WebView As wkeWebView,frameId As Integer,size As size_t Ptr ) As ZString Ptr  ' utf8
  '    ITERATOR3(const utf8* , wkeGetContentAsMarkup, wkeWebView webView, wkeWebFrameHandle frame, size_t* size, "") \
Declare Function wkeGetDebugConfig cdecl Alias "wkeGetDebugConfig"(WebView As wkeWebView,debugString As ZString Ptr ) As Any Ptr ' 
  '    ITERATOR2(void *, wkeGetDebugConfig, wkeWebView webView, const char* debugString, "") \
Declare Function wkeGetDocumentCompleteURL cdecl Alias "wkeGetDocumentCompleteURL"(WebView As wkeWebView,frameId As Integer ,partialURL_utf8 As ZString Ptr) As ZString Ptr  ' utf8 
  '    ITERATOR3(const utf8*, wkeGetDocumentCompleteURL, wkeWebView webView, wkeWebFrameHandle frameId, const utf8* partialURL, "") \
Declare Function wkeGetGlobalExecByFrame cdecl Alias "wkeGetGlobalExecByFrame"(WebView As wkeWebView,frameId As Integer) As jsExecState  'jsExecState 
  '    ITERATOR2(jsExecState, wkeGetGlobalExecByFrame, wkeWebView webView, wkeWebFrameHandle frameId, "") \
Declare Function wkeGetName cdecl Alias "wkeGetName"(WebView As wkeWebView) As  ZString Ptr ' 
  '    ITERATOR1(const char*, wkeGetName, wkeWebView webView, "") \
Declare Function wkeGetSource cdecl Alias "wkeGetSource"(WebView As wkeWebView) As ZString Ptr  'utf8
  '    ITERATOR1(const utf8*, wkeGetSource, wkeWebView webView, "") \
Declare Function wkeGetStringLen cdecl Alias "wkeGetStringLen"(wkestr As wkeString) As size_t '
  '    ITERATOR1(size_t, wkeGetStringLen, wkeString str, "") \
Declare Function wkeGetTempCallbackInfo cdecl Alias "wkeGetTempCallbackInfo"(WebView As wkeWebView) As wkeTempCallbackInfo Ptr ' 
  '    ITERATOR1(wkeTempCallbackInfo*, wkeGetTempCallbackInfo, wkeWebView webView, "") \
Declare Function wkeGetVersion cdecl Alias "wkeGetVersion"() As UInteger ' 
  '    ITERATOR0(unsigned int, wkeGetVersion, "") \
Declare Function wkeGetVersionString cdecl Alias "wkeGetVersionString"() As ZString Ptr ' utf8
  '    ITERATOR0(const utf8*, wkeGetVersionString, "") \
Declare Function wkeGetWebViewByNData cdecl Alias "wkeGetWebViewByNData"(ndata As Any Ptr) As Any Ptr ' wkeWebView
  '    ITERATOR1(wkeWebView, wkeGetWebViewByNData, void* ndata, "") \
Declare Function wkeGetWebViewForCurrentContext cdecl Alias "wkeGetWebViewForCurrentContext"(WebView As wkeWebView) As Any Ptr ' wkeWebView 
  '    ITERATOR0(wkeWebView, wkeGetWebViewForCurrentContext, "") \
Declare Function wkeGetWebviewId cdecl Alias "wkeGetWebviewId"(WebView As wkeWebView) As Integer ' 
  '    ITERATOR1(int, wkeGetWebviewId, wkeWebView webView, "") \
Declare Sub wkeGoToIndex cdecl Alias "wkeGoToIndex"(WebView As wkeWebView,index As Integer ) ' 
  '     wkeGoToIndex, wkeWebView webView, int index, "") \
Declare Sub wkeGoToOffset cdecl Alias "wkeGoToOffset"(WebView As wkeWebView,offset As Integer ) ' 
  '     wkeGoToOffset, wkeWebView webView, int offset, "") \
Declare Function wkeHeight cdecl Alias "wkeHeight"(WebView As wkeWebView) As Integer  ' 
  '    ITERATOR1(int, wkeHeight, wkeWebView webView, "") \
Declare Sub wkeInsertCSSByFrame cdecl Alias "wkeInsertCSSByFrame"(WebView As wkeWebView,frameId As Integer ,cssText_utf8 As ZString Ptr ) ' 
  '    ITERATOR3(void, wkeInsertCSSByFrame, wkeWebView webView, wkeWebFrameHandle frameId, const utf8* cssText, "") \
Declare Function wkeIsDirty cdecl Alias "wkeIsDirty"(WebView As wkeWebView) As BOOL ' 
  '    ITERATOR1(BOOL, wkeIsDirty, wkeWebView webView, "") \
Declare Function wkeIsLoadComplete cdecl Alias "wkeIsLoadComplete"(WebView As wkeWebView) As BOOL ' 
  '    ITERATOR1(BOOL, wkeIsLoadComplete, wkeWebView webView, "") \
Declare Function wkeIsLoaded cdecl Alias "wkeIsLoaded"(WebView As wkeWebView) As BOOL ' 
  '    ITERATOR1(BOOL, wkeIsLoaded, wkeWebView webView, "") \
Declare Function wkeIsLoadFailed cdecl Alias "wkeIsLoadFailed"(WebView As wkeWebView) As BOOL '
  '    ITERATOR1(BOOL, wkeIsLoadFailed, wkeWebView webView, "") \
Declare Function wkeIsLoading cdecl Alias "wkeIsLoading"(WebView As wkeWebView) As BOOL '
  '    ITERATOR1(BOOL, wkeIsLoading, wkeWebView webView, "") \
Declare Function wkeIsLoadingSucceeded cdecl Alias "wkeIsLoadingSucceeded"(WebView As wkeWebView) As BOOL '
  '    ITERATOR1(BOOL, wkeIsLoadingSucceeded, wkeWebView webView, "") \
Declare Function wkeIsLoadingFailed cdecl Alias "wkeIsLoadingFailed"(WebView As wkeWebView) As BOOL '
  '    ITERATOR1(BOOL, wkeIsLoadingFailed, wkeWebView webView, "") \
Declare Function wkeIsLoadingCompleted cdecl Alias "wkeIsLoadingCompleted"(WebView As wkeWebView) As BOOL '
  '    ITERATOR1(BOOL, wkeIsLoadingCompleted, wkeWebView webView, "") \
Declare Function wkeIsProcessingUserGesture cdecl Alias "wkeIsProcessingUserGesture"(WebView As wkeWebView) As BOOL '
  '    ITERATOR1(BOOL, wkeIsProcessingUserGesture, wkeWebView webView, "") \
Declare Function wkeIsWebRemoteFrame cdecl Alias "wkeIsWebRemoteFrame"(WebView As wkeWebView,frameId As Integer) As BOOL ' 
  '    ITERATOR2(BOOL, wkeIsWebRemoteFrame, wkeWebView webView, wkeWebFrameHandle frameId, "") \
Declare Function wkeIsWebviewAlive cdecl Alias "wkeIsWebviewAlive"(id As Integer ) As BOOL ' 
  '    ITERATOR1(BOOL, wkeIsWebviewAlive, int id, "") \
Declare Function wkeIsWebviewValid cdecl Alias "wkeIsWebviewValid"(WebView As wkeWebView) As BOOL ' 
  '    ITERATOR1(BOOL, wkeIsWebviewValid, wkeWebView webView, "") \
Declare Sub wkeJsBindGetter cdecl Alias "wkeJsBindGetter"(name_ As ZString Ptr,wkeJsNativeFunction As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR3(void, wkeJsBindGetter, const char* name, wkeJsNativeFunction fn, void* param, "") \
Declare Sub wkeJsBindSetter cdecl Alias "wkeJsBindSetter"(name_ As ZString Ptr,wkeJsNativeFunction As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR3(void, wkeJsBindSetter, const char* name, wkeJsNativeFunction fn, void* param, "") \
Declare Function wkeKeyDown cdecl Alias "wkeKeyDown"(WebView As wkeWebView,virtualKeyCode As UInteger ,flags As UInteger ,systemKey As BOOL ) As BOOL ' 
  '    ITERATOR4(BOOL, wkeKeyDown, wkeWebView webView, unsigned int virtualKeyCode, unsigned int flags, bool systemKey, "") \
Declare Function wkeKeyPress cdecl Alias "wkeKeyPress"(WebView As wkeWebView,virtualKeyCode As UInteger,flags As UInteger ,systemKey As BOOL ) As BOOL ' 
  '    ITERATOR4(BOOL, wkeKeyPress, wkeWebView webView, unsigned int virtualKeyCode, unsigned int flags, bool systemKey, "") \
Declare Function wkeKeyUp cdecl Alias "wkeKeyUp"(WebView As wkeWebView,virtualKeyCode As UInteger ,flags As UInteger ,systemKey As BOOL  ) As BOOL ' 
  '    ITERATOR4(BOOL, wkeKeyUp, wkeWebView webView, unsigned int virtualKeyCode, unsigned int flags, bool systemKey, "") \
Declare Sub wkeLayoutIfNeeded cdecl Alias "wkeLayoutIfNeeded"(WebView As wkeWebView)  ' 
  '    ITERATOR1(void, wkeLayoutIfNeeded, wkeWebView webView, "") \
Declare Sub wkeLoadFileW cdecl Alias "wkeLoadFileW"(WebView As wkeWebView,filename  As wString Ptr ) ' 
  '     wkeLoadFileW, wkeWebView webView, const wchar_t* filename, "") \
Declare Sub wkeLoadHTMLW cdecl Alias "wkeLoadHTMLW"(WebView As wkeWebView,html As wString Ptr ) ' 
  '     wkeLoadHTMLW, wkeWebView webView, const wchar_t* html, "") \
Declare Sub wkeLoadURLW cdecl Alias "wkeLoadURLW"(WebView As wkeWebView,url As wString Ptr  ) ' 
  '     wkeLoadURLW, wkeWebView webView, const wchar_t* url, "") \
Declare Function wkeMediaVolume cdecl Alias "wkeMediaVolume"(WebView As wkeWebView) As  Single  ' 
  '    ITERATOR1(float, wkeMediaVolume, wkeWebView webView, "") \
Declare Function wkeMouseEvent cdecl Alias "wkeMouseEvent"(WebView As wkeWebView,message As UInteger ,x As Integer,y As Integer ,flags As UInteger ) As BOOL ' 
  '    ITERATOR5(BOOL, wkeMouseEvent, wkeWebView webView, unsigned int message, int x, int y, unsigned int flags, "") \
Declare Function wkeMouseWheel cdecl Alias "wkeMouseWheel"(WebView As wkeWebView,x As Integer,y As Integer,delta As Integer ,flags As UInteger ) As BOOL ' 
  '    ITERATOR5(BOOL, wkeMouseWheel, wkeWebView webView, int x, int y, int delta, unsigned int flags, "") \
Declare Sub wkeNetAddHTTPHeaderFieldToUrlRequest cdecl Alias "wkeNetAddHTTPHeaderFieldToUrlRequest"(request_wkeWebUrlRequestPtr As Any Ptr,name_utf8 As ZString Ptr,value_utf8 As ZString Ptr ) ' 
  '    ITERATOR3(void, wkeNetAddHTTPHeaderFieldToUrlRequest, wkeWebUrlRequestPtr request, const utf8* name, const utf8* value, "")\
Declare Sub wkeNetCancelWebUrlRequest cdecl Alias "wkeNetCancelWebUrlRequest"(requestId As Integer ) ' 
  '    ITERATOR1(void, wkeNetCancelWebUrlRequest, int requestId, "")\
Declare Sub wkeNetChangeRequestUrl cdecl Alias "wkeNetChangeRequestUrl"(jobPtr As wkeNetJob,url As ZString Ptr) ' 
  '     wkeNetChangeRequestUrl, wkeNetJob jobPtr, const char* url, "")\
Declare Sub wkeNetContinueJob cdecl Alias "wkeNetContinueJob"(jobPtr As wkeNetJob) ' 
  '    ITERATOR1(void, wkeNetContinueJob, wkeNetJob jobPtr, "")\
Declare Function wkeNetCopyWebUrlRequest cdecl Alias "wkeNetCopyWebUrlRequest"(jobPtr As wkeNetJob,needExtraData As bool) As Any Ptr  'blinkWebURLRequestPtr 
  '    ITERATOR2(blinkWebURLRequestPtr, wkeNetCopyWebUrlRequest, wkeNetJob jobPtr, bool needExtraData, "")\
Declare Function wkeNetCreateWebUrlRequest cdecl Alias "wkeNetCreateWebUrlRequest"(url_utf8 As ZString Ptr,method_utf8 As ZString Ptr,mime_utf8 As ZString Ptr) As Any Ptr  'blinkWebURLRequestPtr  ' 
  '    ITERATOR3(wkeWebUrlRequestPtr, wkeNetCreateWebUrlRequest, const utf8* url, const utf8* method, const utf8* mime, "")\
Declare Function wkeNetCreateWebUrlRequest2 cdecl Alias "wkeNetCreateWebUrlRequest2"(request_blinkWebURLRequestPtr As Any Ptr ) As Any Ptr  'blinkWebURLRequestPtr  ' 
  '    ITERATOR1(wkeWebUrlRequestPtr, wkeNetCreateWebUrlRequest2, const blinkWebURLRequestPtr request, "")\
Declare Sub wkeNetDeleteBlinkWebURLRequestPtr cdecl Alias "wkeNetDeleteBlinkWebURLRequestPtr"(request_blinkWebURLRequestPtr As Any Ptr ) ' 
  '    ITERATOR1(void, wkeNetDeleteBlinkWebURLRequestPtr, blinkWebURLRequestPtr request, "")\
Declare Function wkeNetGetExpectedContentLength cdecl Alias "wkeNetGetExpectedContentLength"(response_wkeWebUrlResponsePtr As Any Ptr) As LongInt ' 
  '    ITERATOR1(__int64, wkeNetGetExpectedContentLength, wkeWebUrlResponsePtr response, "")\
Declare Function wkeNetGetHTTPHeaderField cdecl Alias "wkeNetGetHTTPHeaderField"(jobPtr As wkeNetJob,key As ZString Ptr ) As ZString Ptr  ' 
  '    ITERATOR2(const char*, wkeNetGetHTTPHeaderField, wkeNetJob jobPtr, const char* key, "") \
Declare Function wkeNetGetHTTPHeaderFieldFromResponse cdecl Alias "wkeNetGetHTTPHeaderFieldFromResponse"(jobPtr As wkeNetJob,key As ZString Ptr ) As ZString Ptr  ' 
  '    ITERATOR2(const char*, wkeNetGetHTTPHeaderFieldFromResponse, wkeNetJob jobPtr, const char* key, "") \
Declare Function wkeNetGetHttpStatusCode cdecl Alias "wkeNetGetHttpStatusCode"(response_wkeWebUrlResponsePtr As Any Ptr) As Integer  ' 
  '    ITERATOR1(int, wkeNetGetHttpStatusCode, wkeWebUrlResponsePtr response, "")\
Declare Function wkeNetGetRawHttpHead cdecl Alias "wkeNetGetRawHttpHead"(jobPtr As wkeNetJob) As wkeSlist Ptr ' 
  '    ITERATOR1(const wkeSlist*, wkeNetGetRawHttpHead, wkeNetJob jobPtr, "")\
Declare Function wkeNetGetRawResponseHead cdecl Alias "wkeNetGetRawResponseHead"(jobPtr As wkeNetJob) As wkeSlist Ptr ' 
  '    ITERATOR1(const wkeSlist*, wkeNetGetRawResponseHead, wkeNetJob jobPtr, "")\
Declare Function wkeNetGetResponseUrl cdecl Alias "wkeNetGetResponseUrl"(response_wkeWebUrlResponsePtr As Any Ptr) As ZString Ptr ' 
  '    ITERATOR1(const utf8*, wkeNetGetResponseUrl, wkeWebUrlResponsePtr response, "")\
Declare Function wkeNetGetUrlByJob cdecl Alias "wkeNetGetUrlByJob"(response_wkeWebUrlResponsePtr As Any Ptr) As ZString Ptr ' 
  '    ITERATOR1(const char*, wkeNetGetUrlByJob, wkeNetJob jobPtr, "")\
Declare Sub wkeNetHookRequest cdecl Alias "wkeNetHookRequest"(response_wkeWebUrlResponsePtr As Any Ptr) ' 此函数和wkeNetSetData的区别是，wkeNetHookRequest会在接受到真正网络数据后再调用回调，并允许回调修改网络数据。
  '        "此函数和wkeNetSetData的区别是，wkeNetHookRequest会在接受到真正网络数据后再调用回调，并允许回调修改网络数据。"\
  '    ITERATOR1(void, wkeNetHookRequest, wkeNetJob jobPtr, "") \
Declare Function wkeNetStartUrlRequest cdecl Alias "wkeNetStartUrlRequest"(WebView As wkeWebView,response_wkeWebUrlResponsePtr As Any Ptr,param As LPARAM,wkeUrlRequestCallbacks As Any Ptr ) As Integer  '
  '    ITERATOR4(int, wkeNetStartUrlRequest, wkeWebView webView, wkeWebUrlRequestPtr request, void* param, const wkeUrlRequestCallbacks* callbacks, "")\
Declare Sub wkeNodeOnCreateProcess cdecl Alias "wkeNodeOnCreateProcess"(WebView As wkeWebView,wkeNodeOnCreateProcessCallback As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR3(void, wkeNodeOnCreateProcess, wkeWebView webView, wkeNodeOnCreateProcessCallback callback, void* param, "") \
Declare Sub wkeOnContextMenuItemClick cdecl Alias "wkeOnContextMenuItemClick"(WebView As wkeWebView,wkeOnContextMenuItemClickCallback As Any Ptr ,param As LPARAM  ) ' 
  '    ITERATOR3(void, wkeOnContextMenuItemClick, wkeWebView webView, wkeOnContextMenuItemClickCallback callback, void* param, "") \
Declare Sub wkeOnDownload2 cdecl Alias "wkeOnDownload2"(WebView As wkeWebView,wkeDownload2Callback As Any Ptr ,param As LPARAM) ' 
  '    ITERATOR3(void, wkeOnDownload2, wkeWebView webView, wkeDownload2Callback callback, void* param, "") \
Declare Sub wkeOnDraggableRegionsChanged cdecl Alias "wkeOnDraggableRegionsChanged"(WebView As wkeWebView,wkeDraggableRegionsChangedCallback As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR3(void, wkeOnDraggableRegionsChanged, wkeWebView webView, wkeDraggableRegionsChangedCallback callback, void* param, "") \
Declare Sub wkeOnLoadingFinish cdecl Alias "wkeOnLoadingFinish"(WebView As wkeWebView,wkeLoadingFinishCallback As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR3(void, wkeOnLoadingFinish, wkeWebView webView, wkeLoadingFinishCallback callback, void* param, "") \
Declare Sub wkeOnLoadUrlFail cdecl Alias "wkeOnLoadUrlFail"(WebView As wkeWebView,wkeLoadUrlFailCallback As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR3(void, wkeOnLoadUrlFail, wkeWebView webView, wkeLoadUrlFailCallback callback, void* callbackParam, "") \
Declare Sub wkeOnOtherLoad cdecl Alias "wkeOnOtherLoad"(WebView As wkeWebView,wkeOnOtherLoadCallback As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR3(void, wkeOnOtherLoad, wkeWebView webView, wkeOnOtherLoadCallback callback, void* param, "") \
Declare Sub wkeOnPluginFind cdecl Alias "wkeOnPluginFind"(WebView As wkeWebView,mime As ZString Ptr ,wkeOnPluginFindCallback As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR4(void, wkeOnPluginFind, wkeWebView webView, const char* mime, wkeOnPluginFindCallback callback, void* param, "") \
Declare Sub wkeOnPrint cdecl Alias "wkeOnPrint"(WebView As wkeWebView,wkeOnPrintCallback As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR3(void, wkeOnPrint, wkeWebView webView, wkeOnPrintCallback callback, void* param, "") \
Declare Sub wkeOnStartDragging cdecl Alias "wkeOnStartDragging"(WebView As wkeWebView,wkeStartDraggingCallback As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR3(void, wkeOnStartDragging, wkeWebView webView, wkeStartDraggingCallback callback, void* param, "") \
Declare Sub wkePaste cdecl Alias "wkePaste"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkePaste, wkeWebView webView, "") \
Declare Sub wkePluginListBuilderAddFileExtensionToLastMediaType cdecl Alias "wkePluginListBuilderAddFileExtensionToLastMediaType"(builder As Any Ptr,fileExtension_utf8 As ZString Ptr ) ' 
  '     wkePluginListBuilderAddFileExtensionToLastMediaType, void* builder, const utf8* fileExtension, "") \
Declare Sub wkePluginListBuilderAddMediaTypeToLastPlugin cdecl Alias "wkePluginListBuilderAddMediaTypeToLastPlugin"(builder As Any Ptr,name_utf8 As ZString Ptr,description_utf8 As ZString Ptr) ' 
  '    ITERATOR3(void, wkePluginListBuilderAddMediaTypeToLastPlugin, void* builder, const utf8* name, const utf8* description, "") \
Declare Sub wkePluginListBuilderAddPlugin cdecl Alias "wkePluginListBuilderAddPlugin"(builder As Any Ptr,name_utf8 As ZString Ptr,description_utf8 As ZString Ptr,fileName_utf8 As ZString Ptr) ' 
  '    ITERATOR4(void, wkePluginListBuilderAddPlugin, void* builder, const utf8* name, const utf8* description, const utf8* fileName, "") \
Declare Sub wkePostURL cdecl Alias "wkePostURL"(WebView As wkeWebView,url_utf8 As ZString Ptr,postData As ZString Ptr,postLen As Long ) ' 
  '    ITERATOR4(void, wkePostURL, wkeWebView wkeView, const utf8* url, const char* postData, int postLen, "") \
Declare Sub wkePostURLW cdecl Alias "wkePostURLW"(WebView As wkeWebView,url_w As wString Ptr,postData As ZString Ptr,postLen As Long ) ' 
  '    ITERATOR4(void, wkePostURLW, wkeWebView wkeView, const wchar_t* url, const char* postData, int postLen, "") \
Declare Function wkePrintToBitmap cdecl Alias "wkePrintToBitmap"(WebView As wkeWebView,frameId As Integer,settings As wkeScreenshotSettings Ptr ) As wkeMemBuf Ptr ' 
  '    ITERATOR3(const wkeMemBuf*, wkePrintToBitmap, wkeWebView webView, wkeWebFrameHandle frameId, const wkeScreenshotSettings* settings,"") \
Declare Function wkeRegisterEmbedderCustomElement cdecl Alias "wkeRegisterEmbedderCustomElement"(WebView As wkeWebView,frameId As Integer,name_utf8 As ZString Ptr,options As Any Ptr ,outResult As Any Ptr ) As BOOL ' 
  '    ITERATOR5(BOOL, wkeRegisterEmbedderCustomElement, wkeWebView webView, wkeWebFrameHandle frameId, const char* name, void* options, void* outResult, "") \
Declare Sub wkeRepaintIfNeeded cdecl Alias "wkeRepaintIfNeeded"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeRepaintIfNeeded, wkeWebView webView, "") \
Declare Sub wkeRunMessageLoop cdecl Alias "wkeRunMessageLoop"() ' 
  '    ITERATOR0(void, wkeRunMessageLoop, "") \
Declare Sub wkeSaveMemoryCache cdecl Alias "wkeSaveMemoryCache"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeSaveMemoryCache, wkeWebView webView, "") \
Declare Sub wkeScreenshot cdecl Alias "wkeScreenshot"(WebView As wkeWebView,settings As wkeScreenshotSettings Ptr,wkeOnScreenshot_callback As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR4(void, wkeScreenshot, wkeWebView webView, const wkeScreenshotSettings* settings, wkeOnScreenshot callback, void* param, "") \
Declare Sub wkeSelectAll cdecl Alias "wkeSelectAll"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeSelectAll, wkeWebView webView, "") \
Declare Sub wkeSetClientHandler cdecl Alias "wkeSetClientHandler"(WebView As wkeWebView,handler As wkeClientHandler Ptr ) ' 
  '     wkeSetClientHandler, wkeWebView webView, const wkeClientHandler* handler, "") \
Declare Sub wkeSetContextMenuEnabled cdecl Alias "wkeSetContextMenuEnabled"(WebView As wkeWebView,b As bool) ' 
  '     wkeSetContextMenuEnabled, wkeWebView webView, bool b, "") \
Declare Sub wkeSetContextMenuItemShow cdecl Alias "wkeSetContextMenuItemShow"(WebView As wkeWebView,item As wkeMenuItemId,isShow As bool) '设置某项menu是否显示 
  '    ITERATOR3(void, wkeSetContextMenuItemShow, wkeWebView webView, wkeMenuItemId item, bool isShow, "设置某项menu是否显示") \
Declare Sub wkeSetCursorInfoType cdecl Alias "wkeSetCursorInfoType"(WebView As wkeWebView,Type_ As Integer ) ' 
  '     wkeSetCursorInfoType, wkeWebView webView, int type, "") \
Declare Sub wkeSetDirty cdecl Alias "wkeSetDirty"(WebView As wkeWebView,dirty As bool) ' 
  '     wkeSetDirty, wkeWebView webView, bool dirty, "") \
Declare Sub wkeSetDragDropEnable cdecl Alias "wkeSetDragDropEnable"(WebView As wkeWebView,b As bool) '可关闭拖拽到其他进程 
  '     wkeSetDragDropEnable, wkeWebView webView, bool b, "可关闭拖拽到其他进程") \
Declare Sub wkeSetDragEnable cdecl Alias "wkeSetDragEnable"(WebView As wkeWebView,b As bool) '可关闭拖拽文件加载网页 
  '     wkeSetDragEnable, wkeWebView webView, bool b, "可关闭拖拽文件加载网页") \
Declare Sub wkeSetDragFiles cdecl Alias "wkeSetDragFiles"(WebView As wkeWebView,clintPos As POINT Ptr,screenPos As POINT ,files As wkeString Ptr Ptr ,filesCount As Integer ) ' 
  '    ITERATOR5(void, wkeSetDragFiles, wkeWebView webView, const POINT* clintPos, const POINT* screenPos, wkeString files[], int filesCount, "") \
Declare Sub wkeSetLanguage cdecl Alias "wkeSetLanguage"(WebView As wkeWebView,language As ZString Ptr) ' 
  '     wkeSetLanguage, wkeWebView webView, const char* language, "") \
Declare Sub wkeSetMediaPlayerFactory cdecl Alias "wkeSetMediaPlayerFactory"(WebView As wkeWebView,wkeMediaPlayerFactory As Any Ptr ,wkeOnIsMediaPlayerSupportsMIMEType As Any Ptr ) ' 
  '    ITERATOR3(void, wkeSetMediaPlayerFactory, wkeWebView webView, wkeMediaPlayerFactory factory, wkeOnIsMediaPlayerSupportsMIMEType callback, "") \
Declare Sub wkeSetName cdecl Alias "wkeSetName"(WebView As wkeWebView,name_ as ZString Ptr) ' 
  '     wkeSetName, wkeWebView webView, const char* name, "") \
Declare Sub wkeSetResourceGc cdecl Alias "wkeSetResourceGc"(WebView As wkeWebView,intervalSec As Long ) ' 
  '     wkeSetResourceGc, wkeWebView webView, long intervalSec, "") \\
Declare Sub wkeSetStringWithoutNullTermination cdecl Alias "wkeSetStringWithoutNullTermination"(WebView As wkeWebView,wkestr As wkeString,str_utf8 As ZString Ptr,Len_ As size_t) ' 
  '    ITERATOR3(void, wkeSetStringWithoutNullTermination, wkeString string, const utf8* str, size_t len, "") \
Declare Sub wkeSetSystemTouchEnabled cdecl Alias "wkeSetSystemTouchEnabled"(WebView As wkeWebView,b As bool) ' 
  '     wkeSetSystemTouchEnabled, wkeWebView webView, bool b, "") \
Declare Sub wkeSetViewNetInterface cdecl Alias "wkeSetViewNetInterface"(WebView As wkeWebView,netInterface As ZString Ptr) ' 
  '     wkeSetViewNetInterface, wkeWebView webView, const char* netInterface, "") \
Declare Sub wkeSetWebViewName cdecl Alias "wkeSetWebViewName"(WebView As wkeWebView,name_ As ZString Ptr) ' 
  '     wkeSetWebViewName, wkeWebView webView, const char* name, "") \
Declare Sub wkeShowDevtools cdecl Alias "wkeShowDevtools"(WebView As wkeWebView,path As wString Ptr ,wkeOnShowDevtoolsCallback As Any Ptr ,param As LPARAM ) ' 
  '    ITERATOR4(void, wkeShowDevtools, wkeWebView webView, const wchar_t* path, wkeOnShowDevtoolsCallback callback, void* param, "") \
Declare Function wkeTitle cdecl Alias "wkeTitle"(WebView As wkeWebView) As ZString Ptr  'utf8 
  '    ITERATOR1(const utf8*, wkeTitle, wkeWebView webView, "") \
Declare Function wkeTitleW cdecl Alias "wkeTitleW"(WebView As wkeWebView) As wString Ptr  ' 
  '    ITERATOR1(const wchar_t*, wkeTitleW, wkeWebView webView, "") \
Declare Function wkeToString cdecl Alias "wkeToString"(wkestr As wkeString) As ZString Ptr ' utf8
  '    ITERATOR1(const utf8*, wkeToString, const wkeString string, "") \
Declare Function wkeToStringW cdecl Alias "wkeToStringW"(wkestr As wkeString) As wString Ptr ' 
  '    ITERATOR1(const wchar_t*, wkeToStringW, const wkeString string, "") \
Declare Sub wkeUnfocus cdecl Alias "wkeUnfocus"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeUnfocus, wkeWebView webView, "") \
Declare Sub wkeUnlockViewDC cdecl Alias "wkeUnlockViewDC"(WebView As wkeWebView) ' 
  '    ITERATOR1(void, wkeUnlockViewDC, wkeWebView webView, "") \
Declare Sub wkeUpdate cdecl Alias "wkeUpdate"() ' 
  '    ITERATOR0(void, wkeUpdate, "") \
Declare Function wkeUtilBase64Decode cdecl Alias "wkeUtilBase64Decode"(str_utf8 As ZString Ptr) As ZString Ptr ' utf8
  '    ITERATOR1(const utf8*, wkeUtilBase64Decode, const utf8* str, "") \
Declare Function wkeUtilBase64Encode cdecl Alias "wkeUtilBase64Encode"(str_utf8 As ZString Ptr) As ZString Ptr ' utf8
  '    ITERATOR1(const utf8*, wkeUtilBase64Encode, const utf8* str, "") \
Declare Function wkeUtilCreateV8Snapshot cdecl Alias "wkeUtilCreateV8Snapshot"(str_utf8 As ZString Ptr) As wkeMemBuf Ptr ' 
  '    ITERATOR1(const wkeMemBuf*, wkeUtilCreateV8Snapshot, const utf8* str, "") \
Declare Function wkeUtilDecodeURLEscape cdecl Alias "wkeUtilDecodeURLEscape"(url_utf8 As ZString Ptr) As ZString Ptr ' utf8
  '    ITERATOR1(const utf8*, wkeUtilDecodeURLEscape, const utf8* url, "") \
Declare Function wkeUtilEncodeURLEscape cdecl Alias "wkeUtilEncodeURLEscape"(url_utf8 As ZString Ptr) As ZString Ptr ' utf8
  '    ITERATOR1(const utf8*, wkeUtilEncodeURLEscape, const utf8* url, "") \
Declare Function wkeUtilPrintToPdf cdecl Alias "wkeUtilPrintToPdf"(WebView As wkeWebView,frameId As Integer,settings As wkePrintSettings Ptr ) As wkePdfDatas Ptr  '
  '    ITERATOR3(const wkePdfDatas*, wkeUtilPrintToPdf, wkeWebView webView, wkeWebFrameHandle frameId, const wkePrintSettings* settings,"") \
Declare Sub wkeUtilRelasePrintPdfDatas cdecl Alias "wkeUtilRelasePrintPdfDatas"(datas As wkePdfDatas Ptr) ' 
  '    ITERATOR1(void, wkeUtilRelasePrintPdfDatas, const wkePdfDatas* datas,"") \
Declare Function wkeUtilSerializeToMHTML cdecl Alias "wkeUtilSerializeToMHTML"(WebView As wkeWebView) As ZString Ptr  ' 
  '    ITERATOR1(const utf8*, wkeUtilSerializeToMHTML, wkeWebView webView, "") \
Declare Sub wkeUtilSetUiCallback cdecl Alias "wkeUtilSetUiCallback"(WebView As wkeWebView,wkeUiThreadPostTaskCallback As Any Ptr ) ' 
  '    ITERATOR1(void, wkeUtilSetUiCallback, wkeUiThreadPostTaskCallback callback, "") \
Declare Sub wkeWebFrameGetMainWorldScriptContext cdecl Alias "wkeWebFrameGetMainWorldScriptContext"(WebView As wkeWebView,frameId As Integer,contextOut As Any Ptr ) ' 
  '    ITERATOR3(void, wkeWebFrameGetMainWorldScriptContext, wkeWebView webView, wkeWebFrameHandle webFrameId, v8ContextPtr contextOut, "") \
Declare Function wkeWebViewName cdecl Alias "wkeWebViewName"(WebView As wkeWebView) As ZString Ptr '
  '    ITERATOR1(const char*, wkeWebViewName, wkeWebView webView, "") \
Declare Function wkeWidth cdecl Alias "wkeWidth"(WebView As wkeWebView) As  Integer  ' 
  '    ITERATOR1(int, wkeWidth, wkeWebView webView, "") \
Declare Function wkeZoomFactor cdecl Alias "wkeZoomFactor"(WebView As wkeWebView) As Single ' 
  '    ITERATOR1(float, wkeZoomFactor, wkeWebView webView, "") \

end extern