﻿

Function initialization() As Long Export '初始化
   '当 VFB5 主软件加载本DLL后，主动调用一下此函数，可以在此做初始化代码
   SetFunctionAddress()  '设置函数地址
   Function = 4 '返回协议版本号，不同协议（发生接口变化）不能通用，会发生崩溃等问题，因此VFB主软件会判断此版本号，不匹配就不使用本控件。
End Function


Function Edit_AddControls(cw As CWindow Ptr,hParent AS HWND,IDC As ULong ,Caption As CWSTR, x As Long, y As Long, w As Long, h As Long,WndProc As Any Ptr) As HWND Export '增加1个控件 
   '编辑：窗口刚被打开，需要新建，返回新建后的控件窗口句柄
   'cw      基于CWindow创建，这是当前窗口的 CWindow 指针
   'hParent 父窗口句柄
   'IDC     控件IDC号
   'Caption 控件标题
   'xywh    位置
   'WndProc 主窗口处理消息的函数地址(窗口消息回调函数)

   Function = cw->AddControl("LABEL", hParent, IDC, Caption, x, y, w, h, WS_CHILD, , , WndProc)

End Function

Function Edit_SetControlProperty(ByRef Control As clsControl, ByRef ColTool As ColToolType, ki As Long) As Long Export '设置控件属性
   '编辑：新创建控件、修改控件属性后，都调用1次
   'Control  窗口中的控件
   'ColTool  当前控件配置和属性
   'ki       被修改的属性索引，=0为全部
   Dim hWndControl As hWnd = Control.nHwnd
   Dim vv As String, cvv As CWSTR, i As Long
   
   For i = 1 To ColTool.plU
      vv = Control.pValue(i) '值是 Utf8 格式
      cvv.UTF8 = pp_Replace(vv, Chr(3, 1), vbCrLf)
      '先设置通用部分
      Select Case ColTool.ProList(i).uName
         Case "CAPTION"
            if ColTool.uName <> "STATUSBAR" Then
               SetWindowTextW hWndControl, cvv.vptr
            End if
            Control.Caption = pp_Replace(vv, Chr(3, 1), vbCrLf)
         Case "ICON"
            Dim pa As String = GetProRunFile(0,4)
            Dim svv As String, fvv As Long = InStr(vv, "|")
            if fvv = 0 Then svv = vv Else svv = Left(vv, fvv -1)
            Dim hIcon As HICON = LoadImage(Null, pa & "images\" & Utf8toStr(svv), IMAGE_ICON, 0, 0, LR_DEFAULTSIZE Or LR_LOADFROMFILE)
            If hIcon Then
               hIcon = AfxSetWindowIcon(hWndControl, ICON_SMALL, hIcon)
               If hIcon Then DestroyIcon(hIcon)
            End If
         Case "LEFT"
            If ki = i Then  '只有控件才设置，主窗口不设置
               Control.nLeft = ValInt(vv)
               FF_Control_SetLoc hWndControl, AfxScaleX(Control.nLeft), AfxScaleY(Control.nTop)
            End If
         Case "TOP"   '只有控件才设置，主窗口不设置
            If ki = i Then
               Control.nTop = ValInt(vv)
               FF_Control_SetLoc hWndControl, AfxScaleX(Control.nLeft), AfxScaleY(Control.nTop)
            End If
         Case "WIDTH"
            If ki = i And ColTool.Feature <> 4 Then
               Control.nWidth = ValInt(vv)
               FF_Control_SetSize hWndControl, AfxScaleX(Control.nWidth), AfxScaleY(Control.nHeight)
            End If
         Case "HEIGHT"
            If ki = i And ColTool.Feature <> 4 Then
               Control.nHeight = ValInt(vv)
               FF_Control_SetSize hWndControl, AfxScaleX(Control.nWidth), AfxScaleY(Control.nHeight)
            End If
         Case "CHILD"
         Case "MOUSEPOINTER"
         Case "FORECOLOR"
            Control.ForeColor = GetColorText(vv)
         Case "BACKCOLOR"
            Control.BackColor = GetColorText(vv)
         Case "TAG"
         Case "TAB"
         Case "ACCEPTFILES"
         Case "INDEX"
         Case "FONT"
            Dim tFont As HFONT = GetWinFontLog(vv)
            SendMessage hWndControl, WM_SETFONT, Cast(wParam, tFont), True
            Control.Font = vv
         Case "TOOLTIPBALLOON"
         Case "TOOLTIP"
            '==============     以上是公共设置，下面是每个控件私有设置    =================
         Case "STYLE" '0 - 顶部\0 - 顶部,1 - 左边,2 - 右边,3 - 底部,4 - 上斜,5 - 下斜
            Dim sy As UInteger = ValUInt(vv)
            Control.Style = (Control.Style And &H0FFFFFFF) Or (sy Shl 28)
         Case "BORDERWIDTH" '\边框宽度\0\1\
            Dim sy As Long = ValUInt(vv)
            If sy < 0 Then sy = 0
            If sy > 15 Then sy = 15
            Control.Style = (Control.Style And &HF0FFFFFF) Or (sy Shl 24)
         Case "ARROWSTARTW" '
            Dim sy As UInteger = ValUInt(vv)
            If sy < 0 Then sy = 0
            If sy > 15 Then sy = 15
            Control.Style = (Control.Style And &HFF0FFFFF) Or (sy Shl 20)
         Case "ARROWSTARTH" '
            Dim sy As UInteger = ValUInt(vv)
            If sy < 0 Then sy = 0
            If sy > 15 Then sy = 15
            Control.Style = (Control.Style And &HFFF0FFFF) Or (sy Shl 16)
         Case "ARROWENDW" '
            Dim sy As UInteger = ValUInt(vv)
            If sy < 0 Then sy = 0
            If sy > 15 Then sy = 15
            Control.Style = (Control.Style And &HFFFF0FFF) Or (sy Shl 12)
         Case "ARROWENDH" '
            Dim sy As UInteger = ValUInt(vv)
            If sy < 0 Then sy = 0
            If sy > 15 Then sy = 15
            Control.Style = (Control.Style And &HFFFFF0FF) Or (sy Shl 8)
            
         Case "BORDERCOLOR" '\线条色彩\3\用于在对象中显示文本和图形的前景色。\SYS,8\
            Control.ForeColor = GetColorText(vv)
         Case "ENABLED"
            If UCase(vv) = "TRUE" Then Control.Style Or= &H1 Else Control.Style And= Not &H1
         Case "VISIBLE"
            If UCase(vv) = "TRUE" Then Control.Style Or= &H2 Else Control.Style And= Not &H2
      End Select
   Next
   Function = 0
End Function

Function Edit_ControlPropertyAlter(hWndForm As hWnd, hWndList As hWnd, nType As Long, value As String, default As String, AllList As String, nName As String, FomName As String) As Long Export  ' 控件属性修改
   '编辑：用户点击窗口属性，修改属性时，1--6由EXE处理，7 或其它由本DLL处理
   'hWndForm   EXE 主窗口句柄
   'hWndList   控件属性显示窗口句柄（是List控件）
   'nType      类型，由 Attribute.ini 里设置，7 或其它由本DLL处理
   'value      当前的值
   'default    默认值，由 Attribute.ini 里设置
   'AllList    所有值，由 Attribute.ini 里设置
   Select Case nType  '这里根据需要编写
      Case 100
         Dim aa As StyleFormType
         'aa.hWndForm = hWndForm
         'aa.hWndList = hWndList
         'aa.nType = nType
         'aa.value = @value
         'aa.default = @default
         'aa.AllList = @AllList
         'aa.Rvalue = value
         'aa.nName = nName : aa.FomName = FomName '当前被编辑的控件名和窗口名
         'StyleForm.Show hWndForm, True, Cast(Integer, @aa)
         value = aa.Rvalue
         Function = len(value)
         
   End Select
End Function
Function Edit_OnPaint(gg As yGDI, Control As clsControl, ColTool As ColToolType, WinCc As Long, nFile As String) as Long Export '描绘控件
   '编辑：当被刷新窗口，需要重绘控件时，窗口和实控件由系统绘画，不需要我们在这里处理，虚拟控件必须由此画出来。
   'gg    目标， 画在这个缓冲里。
   'Control  窗口中的控件
   'ColTool  当前控件配置和属性
   'WinCc    主窗口底色，不是本控件底色
   'nFile    当前工程主文件名，带文件夹，用来提取路径用。
   '返回非0  将会立即结束描绘操作，就是在此之后的控件就不会画了。按照最底层的控件先画。
   
   '样式结构：&H12345678  1主样式 2线条 3前W 4前H 5后W 6后H   78 选项 &H1=允许 &H2=显示
   Dim As Long Style = (Control.Style And &HF0000000) Shr 28,BorderWidth = (Control.Style And &H0F000000) Shr 24 , _
      ArrowStartW = (Control.Style And &H00F00000) Shr 20, ArrowStartH = (Control.Style And &H000F0000) Shr 16, _
      ArrowEndW = (Control.Style And &H0000F000) Shr 12, ArrowEndH = (Control.Style And &H00000F00) Shr 8, x, y, w, h, x2, y2
   gg.GpPen BorderWidth, GetCodeColorGDIplue(Control.ForeColor)
   x = Control.nLeft : y = Control.nTop : w = Control.nWidth : h = Control.nHeight
   Select Case Style   '0 - 顶部,1 - 左边,2 - 右边,3 - 底部,4 - 上斜,5 - 下斜
      Case 0
         x2 = x + w : y2 = y
      Case 1
         x2 = x : y2 = y + h
      Case 2
         x = x + w : x2 = x : y2 = y + h
      Case 3
         y = y + h : x2 = x + w : y2 = y
      Case 4
         x2 = x + w : y2 = y + h
      Case 5
         y = y + h : x2 = x + w : y2 = y - h
   End Select
   gg.GpArrowCap ArrowEndW, ArrowEndH, True, ArrowStartW, ArrowStartH
   gg.GpDrawLine x, y, x2, y2
   
   Function = 0
End Function
Function Compile_ExplainControl(Control As clsControl, ColTool As ColToolType, ProWinCode As String, ussl() As String, ByRef IDC As Long, DECLARESdim As String, Form_clName as String, nFile As String) as Long Export '解释控件，制造创建控件和事件的代码
   '编译：解释控件 ，注意：编译处理字符全部为 UTF8 编码。Control和ColTool里的是 A字符。
   'Control      窗口中的控件
   'ColTool      当前控件配置和属性
   'ProWinCode   处理后的窗口代码，最初由窗口加载窗口模板处理，然后分发给其它控件。填充处理
   'ussl()       已特殊处理过的用户写的窗口代码，主要用来识辨事件
   'IDC          控件IDC，每个控件唯一，VFB自动累计1，我们代码也可以累计
   'DECLARESdim  全局变量定义，整个工程的定义都在此处
   'Form_clName  主窗口类名，最初由窗口设置，方便后面控件使用。
   'nFile        窗口文件名，用在事件调用注释，出错时可以提示源文件地方，避免提示临时文件。
   
   
   '创建控件 ------------------------------
   Dim ii As Long
   Dim As String clClName,clName,clStyle,clExStyle,clPro

   Dim As Long clType '为了解释代码里用，>=100 为虚拟控件  100=LABEL 1=TEXT
   clName = pp_StrToUtf8(Control.nName)
   If Control.Index > -1 Then clName &= "(" & Control.Index & ")"
   clClName = "LINE"
   clType = 102
   
   For ii = 1 To ColTool.plU
      if ExplainControlPublic(Form_clName, Control, clName, ii, ColTool.ProList(ii).uName, clType, clStyle, clExStyle, clPro, ProWinCode) Then '处理公共部分，已处理返回0，未处理返回非0
         Select Case ColTool.ProList(ii).uName
               'Case "NAME"  '名称\1\用来代码中识别对象的名称
               'Case "INDEX"  '数组索引\0\控件数组中的控件位置的索引数字。值小于零表示不是控件数组
               'Case "CAPTION"  '文本\1\显示的文本\Label\
               'Case "TEXT"  '文本\1\显示的文本\Label\
               'Case "ENABLED"  '允许\2\创建控件时最初是否允许操作。\True\True,False
               'Case "VISIBLE"  '显示\2\创建控件时最初是显示或隐藏。\True\True,False
               'Case "FORECOLOR"  '文字色\3\用于在对象中显示文本和图形的前景色。\SYS,8\
               'Case "BACKCOLOR"  '背景色\3\用于在对象中显示文本和图形的背景色。\SYS,15\
               'Case "FONT"  '字体\4\用于此对象的文本字体。\微软雅黑,9,0\
               'Case "LEFT"  '位置X\0\左边缘和父窗口的左边缘之间的距离。自动响应DPI缩放\0\
               'Case "TOP"  '位置Y\0\内部上边缘和父窗口的顶部边缘之间的距离。自动响应DPI缩放\0\
               'Case "WIDTH"  '宽度\0\窗口宽度，100%DPI时的像素单位，自动响应DPI缩放。\100\
               'Case "HEIGHT"  '高度\0\窗口高度，100%DPI时的像素单位，自动响应DPI缩放。\20\
               'Case "LAYOUT"
               'Case "MOUSEPOINTER"  '鼠标指针\2\鼠标在窗口上的形状\0 - 默认\0 - 默认,1 - 后台运行,2 - 标准箭头,3 - 十字光标,4 - 箭头和问号,5 - 文本工字光标,6 - 不可用禁止圈,7 - 移动,8 - 双箭头↙↗,9 - 双箭头↑↓,10 - 双箭头向↖↘,11 - 双箭头←→,12 - 垂直箭头,13 - 沙漏,14 - 手型
               'Case "TAG"  '附加\1\私有自定义文本与控件关联。\\
               'Case "TAB"  '导航\2\当用户按下TAB键时可以接收键盘焦点。\False\True,False
               'Case "TOOLTIP"  '提示\1\一个提示，当鼠标光标悬停在控件时显示它。\\
               'Case "TOOLTIPBALLOON"  '气球样式\2\一个气球样式显示工具提示。\False\True,False
               'Case "ACCEPTFILES"  '拖放\2\窗口是否接受拖放文件。\False\True,False
               '==============     以上是公共设置，下面是每个控件私有设置    =================
            Case "STYLE" '0 - 顶部\0 - 顶部,1 - 左边,2 - 右边,3 - 底部,4 - 上斜,5 - 下斜
               Dim sy As UInteger = ValUInt(Control.pValue(ii))
               If sy > 5 Then sy = 5
               clPro &= "      fp->Style = (fp->Style And &H0FFFFFFF) Or (Cast(UInteger," & sy & ") Shl 28)" & vbCrLf
            Case "BORDERWIDTH" '\边框宽度\0\1\
               Dim sy As UInteger = ValUInt(Control.pValue(ii))
               If sy > 15 Then sy = 15
               clPro &= "      fp->Style = (fp->Style And &HF0FFFFFF) Or (Cast(UInteger," & sy & ") Shl 24)" & vbCrLf
            Case "ARROWSTARTW" '
               Dim sy As UInteger = ValUInt(Control.pValue(ii))
               If sy > 15 Then sy = 15
               clPro &= "      fp->Style = (fp->Style And &HFF0FFFFF) Or (Cast(UInteger," & sy & ") Shl 20)" & vbCrLf
            Case "ARROWSTARTH" '
               Dim sy As UInteger = ValUInt(Control.pValue(ii))
               If sy > 15 Then sy = 15
               clPro &= "      fp->Style = (fp->Style And &HFFF0FFFF) Or (Cast(UInteger," & sy & ") Shl 16)" & vbCrLf
            Case "ARROWENDW" '
               Dim sy As UInteger = ValUInt(Control.pValue(ii))
               If sy > 15 Then sy = 15
               clPro &= "      fp->Style = (fp->Style And &HFFFF0FFF) Or (Cast(UInteger," & sy & ") Shl 12)" & vbCrLf
            Case "ARROWENDH" '
               Dim sy As UInteger = ValUInt(Control.pValue(ii))
               If sy > 15 Then sy = 15
               clPro &= "      fp->Style = (fp->Style And &HFFFFF0FF) Or (Cast(UInteger," & sy & ") Shl 8)" & vbCrLf
            Case "BORDERCOLOR" '\线条色彩\3\用于在对象中显示文本和图形的前景色。\SYS,8\
               clPro &= "      fp->ForeColor = &H" & Hex(GetColorText(Control.pValue(ii)), 8) & vbCrLf
         End Select
      End if
   Next
   
   '当主窗口销毁，通知每个控件类（包括虚拟控件），做必要的卸载工作，因为窗口类是全局的，不会因为窗口销毁而销毁。
   Insert_code(ProWinCode, "'[CALL_WM_DESTROY]", _
      "            " & Form_clName & "." & clName & ".hWndForm = hWndForm" & vbCrLf & _
      "            " & Form_clName & "." & clName & ".Destructor")
   
   
   Dim CONTROL_CODExx As String
   '虚拟控件，直接画窗口的 ============
   CONTROL_CODExx &= "   fp->VrControls = new FormControlsPro_TYPE '" & pp_StrToUtf8("创建虚拟控件链表") & vbCrLf
   CONTROL_CODExx &= "   fp = fp->VrControls" & vbCrLf
   CONTROL_CODExx &= "   If fp Then " & vbCrLf
   CONTROL_CODExx &= "      This." & clName & ".hWndForm = hWnd " & vbCrLf
   
   CONTROL_CODExx &= "      fp->hWndParent = hWnd" & vbCrLf
   CONTROL_CODExx &= "      fp->Index = " & Control.Index & vbCrLf
   CONTROL_CODExx &= "      fp->IDC = " & IDC & vbCrLf
   CONTROL_CODExx &= "      fp->nText = """ & pp_Replace(Control.Caption, Chr(34), Chr(34, 34)) & """" & vbCrLf
'   CONTROL_CODExx &= "      fp->ControlType = " & clType & vbCrLf
   CONTROL_CODExx &= "      This." & clName & ".IDC =" & IDC & vbCrLf
   
   CONTROL_CODExx &= clPro
   CONTROL_CODExx &= "   End IF" & vbCrLf
   Insert_code(ProWinCode, "'[Create control]", CONTROL_CODExx)
   
   '事件处理 ------------------------------
   
   '虚拟控件，直接画窗口的
   For ii = 1 To ColTool.elU
      Dim sim As String '事件函数名组合
      sim = " " & UCase(Form_clName & "_" & pp_StrToUtf8(Control.nName & "_" & ColTool.EveList(ii).sName)) & "("
      Dim ff As Long
      for fi As Long = 0 To UBound(ussl)
         If left(ussl(fi), 1) <> "'" AndAlso InStr(ussl(fi), sim) > 0 Then
            ff = fi + 1
            Exit for
         End If
      Next
      If ff > 0 Then
         if IsEventComparison(Control, ColTool, ii, ff, nFile, ussl(ff -1), Form_clName) Then Return 3 '检查事件是不是正确
         dim VIRTUAL_CONTROL_EVENTS As String = "   If wMsg = " & ColTool.EveList(ii).tMsg & " Then " & vbCrLf
         VIRTUAL_CONTROL_EVENTS &= "      " & Form_clName & "." & clName & ".hWndForm = hWndForm " & vbCrLf
         VIRTUAL_CONTROL_EVENTS &= "      Dim As Long xPos =GET_X_LPARAM(lParam),yPos =GET_Y_LPARAM(lParam)" & vbCrLf
         VIRTUAL_CONTROL_EVENTS &= "      If " & Form_clName & "." & clName & ".HitTest(xPos,yPos) Then" & vbCrLf
         VIRTUAL_CONTROL_EVENTS &= "         " & sim
         If Control.Index > -1 Then VIRTUAL_CONTROL_EVENTS &= Control.Index & ","
         VIRTUAL_CONTROL_EVENTS &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
         VIRTUAL_CONTROL_EVENTS &= "      End if " & vbCrLf
         VIRTUAL_CONTROL_EVENTS &= "   End If " & vbCrLf
         Insert_code(ProWinCode, "'[VIRTUAL_CONTROL_EVENTS]", VIRTUAL_CONTROL_EVENTS)
      End If
   Next
   
   '描绘虚拟控件，最底层的控件先画
   Insert_code(ProWinCode, "'[DRAWINGVIRTUALCONTROLS]", _
      "            " & Form_clName & "." & clName & ".hWndForm = hWndForm " & vbCrLf & "            " & Form_clName & "." & clName & ".Drawing(gg,hWndForm,WinCc)  ", 1)
   
  
   '成功返回0，失败非0
   Function = 0
End Function


Function GetCodeColorGDI(coColor As Long) As Long  '把控件特殊颜色值，转换为 GDI 色  ,返回-1 为不使用或默认
  If (&H00FFFFFF And coColor) = &H7F7F7F Then
      Dim f As Long = Cast(UInteger, (&HFF000000 And coColor)) Shr 24
      If f=25 Then  Return -1   '不使用或默认值 
      If f < 31 Then 
          Return GetSysColor(f)  
      End If  
  End If
  Function = (&H00FFFFFF And coColor) '去掉 A 通道
End Function
Function GetCodeColorGDIplue(coColor As Long) As Long  '把控件特殊颜色值，转换为 GDI+ 色  ,返回0 为不使用或默认
  Dim tColor As Long = coColor 
  If (&H00FFFFFF And coColor) = &H7F7F7F Then
      Dim f As Long = Cast(UInteger, (&HFF000000 And coColor)) Shr 24
      If f = 25 Then Return 0  ' 不使用或默认值 
      If f < 31 Then 
          tColor = GetSysColor(f) Or &HFF000000 '增加 A通道，不透明，不然是全透明  
      End If  
  End If 
  '因为保存的是GDI 的颜色，GDI+ 需要调换
  Dim As UInteger c1 =(&H00FF0000 And tColor),c2 = (&H000000FF And tColor) ,c3 =(&HFF00FF00 And tColor)
  c1 Shr= 16
  c2 Shl= 16 
  Function = c1 Or c2 Or c3  
End Function
























