#include Once "cairo/cairo-win32.bi"

Type Class_Cairo
Private : 
   m_hWndForm As HWnd 'ؼ
   m_IDC As Long     'ؼIDC
   cr As cairo_t ptr  'Cairo 
   cs As cairo_surface_t Ptr ' WInDC ľ
   matrix as cairo_matrix_t  ' cr 㣬ҪΪ ԭ ת ΪÿתҪԭ
   Declare Function GetFP() As FormControlsPro_TYPE ptr 'ؿؼݵָ루һԼã
Public : 
   Declare Constructor
   Declare Destructor
   Declare Property hWndForm() As.hWnd         '/ÿؼڵĴھҪڶ࿪ͬһںҪʹÿؼǰָؼڵĴھʹÿؼ
   Declare Property hWndForm(ByVal hWndParent As.hWnd) 'ȡؼڵĴھڣ
   Declare Property IDC() As Long             '/ÿؼIDCؼʶ1ÿؼIDCΨһģؼ顣޸ģϵͳԶ
   Declare Property IDC(NewIDC As Long)
   Declare Property Tag() As CWSTR                       '洢ĸݡ
   Declare Property Tag(ByVal sText As CWSTR)
   Declare Property UserData(idx AS LONG) As Integer      '/ûݣidxţΧΪ0991ؼԴ100ֵ
   Declare Property UserData(idx AS LONG, bValue As Integer)   
   
   Declare Property WinDC(nDC As HDC)  '봰DC󶨣ʾDC Display() ʾ
   Declare Sub Display()  'ʾͼÿλʼ WinDC() ʾ ʾ´λʹ WinDC
   Declare Sub Scale(x as Single,y as Single) 'ţ֧ϵͳDPIãCairo1.Scale(AfxScaleX(1),AfxScaleY(1))ĬѾ֧ӦDPIע⣺תǧţֻתΪ0ʱ 
   Declare Sub Rotate(x as Single, y as Single,angle As Single) 'ת,x,y Ϊ angle(0--360)˳ʱ룬ʱתýǶΪ 0 Ͳתע⣺תǧţֻתΪ0ʱ
   Declare Function CairoHandle() as cairo_t ptr 'ȡWINDC󶨺 Cairo  δ󶨷 0 رմںԶ١ 
   Declare Function Version() as String  'ȡ Cairo ֿ֧ 汾   
   Declare Sub Clear(nColor As Long = &HFFFFFF ) 'ջ壬ɫGDIɫ ãBGR(r, g, b) :CairoΪԴ 
   Declare Sub SourceRGB(nColor As Long ) 'ɫGDIɫ ãBGR(r, g, b) :CairoΪԴ 
   Declare Sub SourceRGBA(nColor As ARGB ) 'ɫGDI+ɫ͸ A ãRGBA (r, g, b, a) :CairoΪԴ 
   Declare Sub SourcePNG(PngFileName_utf8 As String,x as Single,y as Single,extend As Long ) 'PNGͼļ  xyͼʼλ :CairoΪԴ {2.CAIRO_EXTEND_NONE ƽ.CAIRO_EXTEND_REPEAT ƽ.CAIRO_EXTEND_REFLECT ƽ.CAIRO_EXTEND_PAD }
   Declare Sub SourceLinearRGB(Color1 As Long ,x1 as Single,y1 as Single,Color2 As Long ,x2 as Single,y2 as Single) 'Խ䣬Ϊɫ1 ɫ2䣨GDIɫ ãBGR(r, g, b) 
   Declare Sub SourceLinearRGBA(Color1 As ARGB ,x1 as Single,y1 as Single,Color2 As ARGB ,x2 as Single,y2 as Single) 'Խ䣬Ϊɫ1 ɫ2䣨GDI+ɫ͸ A ãRGBA (r, g, b, a)
   Declare Sub SourceRadialRGB(Color1 As Long ,cx1 as Single,cy1 as Single,radius1 As Single,Color2 As Long ,cx2 as Single,cy2 as Single,radius2 As Single) 'þ򽥱䣬Ϊɫ1 ɫ2䣨GDIɫ ãBGR(r, g, b)  ɫ,Բxy,Բİ뾶һ÷2Բͬ1Բ뾶=0 2뾶ĳߴ硣
   Declare Sub SourceRadialRGBA(Color1 As ARGB ,cx1 as Single,cy1 as Single,radius1 As Single,Color2 As ARGB ,cx2 as Single,cy2 as Single,radius2 As Single) 'þ򽥱䣬Ϊɫ1 ɫ2䣨GDI+ɫ͸ A ãRGBA (r, g, b, a)  ɫ,Բxy,Բİ뾶һ÷2Բͬ1Բ뾶=0 2뾶ĳߴ硣
   
   Declare Property LineWidth(nWidth As Single ) '/ȡ ȣλ
   Declare Property LineWidth() As Single 
   Declare Property FillRule(fill_rule As Long ) '/ȡ ģʽ {=.CAIRO_FILL_RULE_WINDING ں.CAIRO_FILL_RULE_EVEN_ODD }
   Declare Property FillRule() As Long 
   Declare Property Caps(line_cap As Long ) '/ȡ ñ {=.CAIRO_LINE_CAP_SQUARE ͷ.CAIRO_LINE_CAP_ROUND Բͷ.CAIRO_LINE_CAP_BUTT ñ}
   Declare Property Caps()As Long  
   Declare Property Join(line_join As Long ) '/ȡߴ״ǵ״ {=.CAIRO_LINE_JOIN_MITER .CAIRO_LINE_JOIN_BEVEL ƽ.CAIRO_LINE_JOIN_ROUND Բ}   
   Declare Property Join() As Long  
   Declare Sub Dash(d1 as Single =0 ,s1 as Single =0,d2 as Single =0 ,s2 as Single =0,d3 as Single =0 ,s3 as Single =0,d4 as Single =0 ,s4 as Single =0 ) ',dΪʵߣsΪߣ޲ʱȫΪʵߡ
   
   Declare Sub DrawStroke()          '·߿򣬲·
   Declare Sub DrawStrokePreserve()  '·߿򣬱·
   Declare Sub DrawFill()            '··
   Declare Sub DrawFillPreserve()    '··
   Declare Sub DrawPNG(PngFileName_utf8 As String,x as Single,y as Single) 'PNGͼ
   
   Declare Sub ClosePath()    '·
   Declare Sub GetCurrentPoint(ByRef x as Single,ByRef y as Single) 'صǰ
   Declare Sub MoveTo(x as Single,y as Single) '·ĵǰ
   Declare Sub MoveToRel(x as Single,y as Single) '·ĵǰ
   Declare Sub LineTo(x as Single, y as Single) '·ֱߣӵǰ껭ֱߵĿ꣬ĿΪǰ
   Declare Sub LineToRel(x as Single, y as Single) '·ֱߣ(Ŀ뵱ǰ) ӵǰ껭ֱߵĿ꣬ĿΪǰ
   Declare Sub Rectangle(x as Single, y as Single,w as Single, h as Single) '·ľΣ
   Declare Sub RectangleRound(x as Single, y as Single,w as Single, h as Single,r1 As Single,r2 As Single,r3 As Single,r4 As Single) '·ԲǾΣr1-4ΪԲǰ뾶 Ͻǣ½ǣϽǣ½
   
   Declare Sub Arc(xc as Single, yc as Single,radiusX as Single,radiusY as Single,angle1 as Single,angle2 as Single,Negative As Long = 0 ) '·Ļ/ԲԲ,뾶,ʼǶ(0--360),ֹǶ(0--360),˳ʱ=0/ʱ<>0
   Declare Sub CurveTo(x1 as Single, y1 as Single,x2 as Single,y2 as Single,x as Single, y as Single) '·α()1Ƶx1y1,2Ƶx2y2,ĩxy
   Declare Sub CurveToRel(dx1 as Single, dy1 as Single,dx2 as Single,dy2 as Single,dx as Single, dy as Single) '·α()1Ƶx1y1,2Ƶx2y2,ĩxy

   Declare Sub FontFace(Family_utf8 As String,Slant As Long=CAIRO_FONT_SLANT_NORMAL,Weight As Long=CAIRO_FONT_WEIGHT_NORMAL) 'ʽ ʽֱƣбĴϸ {2.CAIRO_FONT_SLANT_NORMAL .CAIRO_FONT_SLANT_ITALIC б.CAIRO_FONT_SLANT_OBLIQUE б}{3.CAIRO_FONT_WEIGHT_NORMAL .CAIRO_FONT_WEIGHT_BOLD Ӵ}
   Declare Sub FontSize(size As Single) 'ֳߴ磬صλ
   Declare Sub TextPath(Text_utf8 As String ) 'ʾ֣ııպ·ӵǰ·ǰֵ ͵ײ
   
End Type

'----------------------------------------------------------------------------------------------------------------------------------------------------------------
Constructor Class_Cairo
   'ע⣺ڴõģȫֱӿִֻ1Ρ

End Constructor

Destructor Class_Cairo
    'ע⣺ڴõģȫֱΪ˿⹦ܣDestructor ظִ
   '1ÿδ  ִ1 Destructor  ʾ͹شھظ
   '2˳  ִ1 Destructor    
   Dim fp As FormControlsPro_TYPE ptr = GetFP()
   if fp then
      Dim nn As Any Ptr Ptr = Cast(Any Ptr, @fp->nData)
      if nn[2] Then cairo_surface_destroy nn[2] 'DC
      if nn[1] Then cairo_destroy nn[1] 'cairo
      nn[0] = 0
      nn[1] = 0
   End If   
End Destructor
Function Class_Cairo.GetFP() As FormControlsPro_TYPE ptr 'Լؼָ
   Dim fp As FormControlsPro_TYPE ptr = vfb_Get_Control_Ptr(m_hWndForm)
   While fp
      if fp->IDC = m_IDC Then Return fp      
      fp = fp->VrControls
   Wend

End Function
Property Class_Cairo.hWndForm() As .hWnd         '/ÿؼڵĴھ
      Return m_hWndForm
End Property
Property Class_Cairo.hWndForm(ByVal hWndParent As .hWnd)
   m_hWndForm = hWndParent
End Property

Property Class_Cairo.WinDC(nDC As HDC)
   'ÿλһ
   cs= cairo_win32_surface_create(nDC) ' cairo_surface_t Ptr 
   cr = cairo_create(cs)
   Scale(AfxScaleX(1), AfxScaleY(1))
   FontFace "NSimSun"
   FontSize 15   
End Property
Sub Class_Cairo.Display()
   '3󣬲 Ӧ DC 
   cairo_destroy cr 'cairo
   cairo_surface_destroy cs 'DC  
End Sub
Function Class_Cairo.CairoHandle() As cairo_t ptr    
   Return cr 
End Function


Property Class_Cairo.IDC() As Long                  '/ε Timer ؼ Timer ¼ĺ
   Return m_IDC
End Property
Property Class_Cairo.IDC(ByVal NewIDC As Long)
   m_IDC  =NewIDC
End Property
Property Class_Cairo.Tag() As CWSTR 
   Dim fp As FormControlsPro_TYPE ptr = GetFP()
   if fp then
      Return fp->Tag
   End If
End Property
Property Class_Cairo.Tag(ByVal sText As CWSTR )
   Dim fp As FormControlsPro_TYPE ptr = GetFP()
   if fp then
      fp->Tag = sText
   End If
End Property
Property Class_Cairo.UserData(idx AS LONG) As Integer      '/ûݣ1ؼԴ100ֵ
   If idx < 0 Or idx > 99 Then Return 0
   Dim fp As FormControlsPro_TYPE ptr = GetFP()
   If fp  Then
      Return fp->UserData(idx)
   End If   

End Property
Property Class_Cairo.UserData(idx AS LONG, bValue As Integer)
   If idx < 0 Or idx > 99 Then Return 
   Dim fp As FormControlsPro_TYPE ptr = GetFP()
   If fp  Then
      fp->UserData(idx) = bValue
   End If    
End Property
Function Class_Cairo.Version() As String   
   Dim zz As Any Ptr = Cast(Any Ptr, cairo_version_string())
   Dim pp As ZString * 20 
   memcpy @pp, zz, 20
   Return pp 
End Function
Sub Class_Cairo.SourceRGB(nColor As Long) 'ɫGDIɫ ãBGR(r, g, b)
   if cr Then 
      Dim b As UByte Ptr = Cast(Any Ptr, @nColor) '
      cairo_set_source_rgb cr,b[0]/255, b[1]/255, b[2]/255
   End if 
End Sub
Sub Class_Cairo.SourceRGBA(nColor As ARGB) 'ɫGDI+ɫ͸ A ãRGBA (r, g, b, a)
   if cr Then 
      Dim b As UByte Ptr = Cast(Any Ptr, @nColor) '
      cairo_set_source_rgba cr,b[0]/255, b[1]/255, b[2]/255 ,b[3]/255
   End if 
End Sub
Sub Class_Cairo.SourcePNG(PngFileName_utf8 As String,x as Single,y as Single,extend As Long )
   if cr Then 
      Dim surface As cairo_surface_t Ptr = cairo_image_surface_create_from_png(StrPtr(PngFileName_utf8))
      Dim pattern As cairo_pattern_t Ptr = cairo_pattern_create_for_surface(surface)
      cairo_set_source (cr, pattern)
      cairo_set_source_surface(cr,surface,x,y) 
      cairo_pattern_set_extend(cairo_get_source(cr), extend)

      cairo_pattern_destroy pattern
      cairo_surface_destroy surface
   End if 
End Sub
Sub Class_Cairo.SourceLinearRGB(Color1 As Long ,x1 as Single,y1 as Single,Color2 As Long ,x2 as Single,y2 as Single)
   if cr Then 
      Dim pattern As cairo_pattern_t Ptr = cairo_pattern_create_linear(x1, y1, x2, y2)
      Dim b1 As UByte Ptr = Cast(Any Ptr, @Color1) ,b2 As UByte Ptr = Cast(Any Ptr, @Color2)
      cairo_pattern_add_color_stop_rgb pattern, 0, b1[0]/255, b1[1]/255, b1[2]/255
      cairo_pattern_add_color_stop_rgb pattern, 1, b2[0]/255, b2[1]/255, b2[2]/255
      cairo_set_source (cr, pattern)
      cairo_pattern_destroy pattern
   End if 
End Sub
Sub Class_Cairo.SourceLinearRGBA(Color1 As ARGB ,x1 as Single,y1 as Single,Color2 As ARGB ,x2 as Single,y2 as Single)
   if cr Then 
      Dim pattern As cairo_pattern_t Ptr = cairo_pattern_create_linear(x1, y1, x2, y2)
      Dim b1 As UByte Ptr = Cast(Any Ptr, @Color1) ,b2 As UByte Ptr = Cast(Any Ptr, @Color2)
      cairo_pattern_add_color_stop_rgba pattern, 0, b1[0]/255, b1[1]/255, b1[2]/255 ,b1[3]/255
      cairo_pattern_add_color_stop_rgba pattern, 1, b2[0]/255, b2[1]/255, b2[2]/255 ,b2[3]/255
      cairo_set_source (cr, pattern)
      cairo_pattern_destroy pattern
   End if 
End Sub
Sub Class_Cairo.SourceRadialRGB(Color1 As Long ,cx1 as Single,cy1 as Single,radius1 As Single,Color2 As Long ,x2 as Single,y2 as Single,radius2 As Single)
   if cr Then 
      Dim pattern As cairo_pattern_t Ptr = cairo_pattern_create_radial(cx1, cy1,radius1,x2, y2,radius2)
      Dim b1 As UByte Ptr = Cast(Any Ptr, @Color1) ,b2 As UByte Ptr = Cast(Any Ptr, @Color2)
      cairo_pattern_add_color_stop_rgb pattern, 0, b1[0]/255, b1[1]/255, b1[2]/255
      cairo_pattern_add_color_stop_rgb pattern, 1, b2[0]/255, b2[1]/255, b2[2]/255
      cairo_set_source (cr, pattern)
      cairo_pattern_destroy pattern
   End if 
End Sub
Sub Class_Cairo.SourceRadialRGBA(Color1 As ARGB ,cx1 as Single,cy1 as Single,radius1 As Single,Color2 As ARGB ,x2 as Single,y2 as Single,radius2 As Single)
   if cr Then 
      Dim pattern As cairo_pattern_t Ptr = cairo_pattern_create_radial(cx1, cy1,radius1,x2, y2,radius2)
      Dim b1 As UByte Ptr = Cast(Any Ptr, @Color1) ,b2 As UByte Ptr = Cast(Any Ptr, @Color2)
      cairo_pattern_add_color_stop_rgba pattern, 0, b1[0]/255, b1[1]/255, b1[2]/255 ,b1[3]/255
      cairo_pattern_add_color_stop_rgba pattern, 1, b2[0]/255, b2[1]/255, b2[2]/255 ,b2[3]/255
      cairo_set_source (cr, pattern)
      cairo_pattern_destroy pattern
   End if 
End Sub
Property Class_Cairo.LineWidth(nWidth As Single ) 'ȣλ
   if cr Then 
      cairo_set_line_width cr,nWidth
   End if 
End Property
Property Class_Cairo.LineWidth()As Single  'ȣλ
   if cr Then 
      Property = cairo_get_line_width(cr)
   End if 
End Property
Sub Class_Cairo.MoveTo(x as Single,y as Single) 'ÿʼ
   if cr Then 
       cairo_move_to(cr,x,y)
   End if 
End Sub
Sub Class_Cairo.MoveToRel(x as Single,y as Single) 'ÿʼ
   if cr Then 
       cairo_rel_move_to(cr,x,y)
   End if 
End Sub
Sub Class_Cairo.LineTo(x as Single, y as Single) 
   if cr Then 
      cairo_line_to(cr, x, y)
   End if 
End Sub
Sub Class_Cairo.LineToRel(x as Single, y as Single) 
   if cr Then 
      cairo_rel_line_to(cr, x, y)
   End if 
End Sub
Sub Class_Cairo.GetCurrentPoint(ByRef x as Single, ByRef y as Single)
   if cr Then
      Dim As Double xx,yy
      cairo_get_current_point(cr, @xx, @yy)
      x = xx
      y = yy
   End if
End Sub

Sub Class_Cairo.DrawStroke() 
   if cr Then 
      cairo_stroke(cr)
   End if 
End Sub
Sub Class_Cairo.DrawStrokePreserve() 
   if cr Then 
      cairo_stroke_preserve(cr)
   End if 
End Sub
Sub Class_Cairo.DrawFill() 
   if cr Then 
      cairo_fill(cr)
   End if 
End Sub
Sub Class_Cairo.DrawFillPreserve() 
   if cr Then 
      cairo_fill_preserve(cr)
   End if 
End Sub
Sub Class_Cairo.Arc(xc as Single, yc as Single,radiusX as Single,radiusY as Single,angle1 as Single,angle2 as Single,Negative As Long = 0 )
   if cr Then 
      cairo_scale(cr,1,radiusY/radiusX)
      if Negative Then 
         cairo_arc_negative(cr, xc, yc, radiusX, angle1* (3.1415926 / 180), angle2* (3.1415926 / 180))
      Else 
         cairo_arc(cr, xc, yc, radiusX, angle1* (3.1415926 / 180), angle2* (3.1415926 / 180))
      End if 
   End if 
End Sub

Sub Class_Cairo.CurveTo(x1 as Single, y1 as Single,x2 as Single,y2 as Single,x as Single, y as Single)
   if cr Then 
       cairo_curve_to(cr,x1,y1,x2,y2,x,y)
   End if 
End Sub
Sub Class_Cairo.CurveToRel(dx1 as Single, dy1 as Single,dx2 as Single,dy2 as Single,dx as Single, dy as Single) 
   if cr Then 
       cairo_curve_to(cr,dx1,dy1,dx2,dy2,dx,dy)
   End if 
End Sub
Sub Class_Cairo.ClosePath()    '·
   if cr Then 
       cairo_close_path (cr)
   End if 
End Sub
Sub Class_Cairo.Rectangle(x as Single, y as Single,w as Single, h as Single)
   if cr Then 
       cairo_rectangle(cr,x,y,w,h)
   End if 
End Sub
Sub Class_Cairo.TextPath(Text_utf8 As String )
   if cr Then 
       cairo_text_path(cr,StrPtr(Text_utf8))
   End if 
End Sub
Sub Class_Cairo.FontFace(Family_utf8 As String,Slant As Long,Weight As Long)
   if cr Then 
       cairo_select_font_face(cr,StrPtr(Family_utf8),Slant,Weight)
   End if 
End Sub
Sub Class_Cairo.FontSize(size As Single) '
   if cr Then 
       cairo_set_font_size(cr,size)
   End if 
End Sub
Sub Class_Cairo.Scale(x as Single,y as Single)
   if cr Then 
      cairo_scale(cr, x, y)
      cairo_get_matrix cr, @matrix 'ݾ
   End if 
End Sub
Sub Class_Cairo.Dash(d1 as Single =0 ,s1 as Single =0,d2 as Single =0 ,s2 as Single =0,d3 as Single =0 ,s3 as Single =0,d4 as Single =0 ,s4 as Single =0 )
   if cr Then 
      Dim dashed(7) As Double = {d1, s1, d2, s2, d3, s3, d4, s4}
      Dim As Long i, n
      For i = 0 To 7
         if dashed(i) = 0 Then Exit For 
         n += 1
      Next 
       cairo_set_dash(cr,@dashed(0),n,0)
   End if 
End Sub
Property Class_Cairo.Caps(line_cap As Long )
   if cr Then 
       cairo_set_line_cap(cr,line_cap)
   End if 
End Property
Property Class_Cairo.Caps()As Long
   if cr Then 
      Property =cairo_get_line_cap(cr)
   End if 
End Property
Property Class_Cairo.Join(line_join As Long )
   if cr Then 
       cairo_set_line_join(cr,line_join)
   End if 
End Property
Property Class_Cairo.Join() As Long 
   if cr Then 
      Property = cairo_get_line_join(cr)
   End if 
End Property
Sub Class_Cairo.RectangleRound(x as Single, y as Single, w as Single, h as Single, r1 As Single, r2 As Single, r3 As Single, r4 As Single)
   if cr Then
      cairo_move_to(cr, x + r1, y)
      cairo_line_to(cr, x + w - r3, y) 
      cairo_move_to(cr, x + w, y + r3)
      cairo_line_to(cr, x + w, y + h - r4)
      cairo_move_to(cr, x + w - r4, y + h) 
      cairo_line_to(cr, x + r2, y + h) 
      cairo_move_to(cr, x, y + h - r2) 
      cairo_line_to(cr, x, y + r1) 
      cairo_arc(cr, x + r1, y + r1, r1, 180*(3.1415926 / 180), 270*(3.1415926 / 180)) 
      cairo_arc(cr, x + w - r3, y + r3, r3, 270 *(3.1415926 / 180), 360 *(3.1415926 / 180))
      cairo_arc(cr, x + w - r4, y + h - r4, r4, 0, 90 *(3.1415926 / 180)) 
      cairo_arc(cr, x + r2, y + h - r2, r2,90 *(3.1415926 / 180), 180 *(3.1415926 / 180))
   End if
End Sub
Sub Class_Cairo.DrawPNG(PngFileName_utf8 As String,x as Single,y as Single )
   if cr Then 
      Dim surface As cairo_surface_t Ptr = cairo_image_surface_create_from_png(StrPtr(PngFileName_utf8))
      cairo_set_source_surface(cr,surface,x,y) 
      cairo_paint(cr)
      cairo_surface_destroy surface    
   End if 
End Sub
Sub Class_Cairo.Rotate(x as Single, y as Single, angle As Single)
   if cr Then
'      if matrix.xx = 0 And matrix.yx = 0 And matrix.xy = 0 And matrix.yy = 0 And matrix.x0 = 0 and matrix.y0 = 0 Then
'         cairo_get_matrix cr, @matrix 'ݾ
'      End if
      cairo_set_matrix cr, @matrix 'Ȼԭ
      if angle <>0 Then
         cairo_translate(cr, x, y)
         cairo_rotate(cr, angle * (3.1415926 / 180))
         cairo_translate(cr, - x, - y)
      End if
   End if
End Sub
Property Class_Cairo.FillRule(fill_rule As Long )
   if cr Then
      cairo_set_fill_rule cr,fill_rule
   End if
End Property
Property Class_Cairo.FillRule()As Long
   if cr Then
     Property = cairo_get_fill_rule(cr)
   End if
End Property
Sub Class_Cairo.Clear(nColor As Long = &HFFFFFF )
   if cr Then 
      SourceRGB(nColor) 
      cairo_paint cr 
   End if 
End Sub




