/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.util;

import javafx.scene.control.Label;
import us.donut.visualbukkit.VisualBukkit;

public class TitleLabel
extends Label {
    private VisualBukkit visualBukkit = VisualBukkit.getInstance();
    private double sizeFactor;

    public TitleLabel(String string, double sizeFactor) {
        super(string);
        this.sizeFactor = sizeFactor;
        this.updateFontSize();
        this.visualBukkit.getRootPane().styleProperty().addListener((observable, oldValue, newValue) -> this.updateFontSize());
    }

    public TitleLabel(String string, double sizeFactor, boolean underline) {
        this(string, sizeFactor);
        this.setUnderline(underline);
    }

    private void updateFontSize() {
        this.setStyle("-fx-font-size:" + (double)this.visualBukkit.getFontSize() * this.sizeFactor + ";");
    }
}

