/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.util;

import java.util.Collection;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;

public class ComboBoxView<T>
extends HBox {
    private ComboBox<T> comboBox = new ComboBox();
    private ContextMenu contextMenu = new ContextMenu();
    private StringBuilder stringBuilder;

    public ComboBoxView() {
        this.getStyleClass().addAll((Object[])new String[]{"combo-box-base", "combo-box-view"});
        ListView listView = new ListView();
        listView.setCellFactory(view -> {
            TextFieldListCell cell = new TextFieldListCell();
            cell.setConverter(this.comboBox.getConverter());
            return cell;
        });
        listView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.comboBox.setValue(newValue);
                this.contextMenu.hide();
            }
        });
        Label label = new Label();
        label.setOnKeyReleased(e -> {
            if (this.contextMenu.isShowing()) {
                if (e.getCode() == KeyCode.BACK_SPACE && this.stringBuilder.length() > 0) {
                    this.stringBuilder.deleteCharAt(this.stringBuilder.length() - 1);
                } else {
                    this.stringBuilder.append(e.getText());
                }
                String search = this.stringBuilder.toString();
                listView.getItems().setAll((Collection)this.comboBox.getItems());
                listView.getItems().removeIf(o -> !this.comboBox.getConverter().toString(o).toLowerCase().contains(search));
            }
        });
        this.getChildren().addAll((Object[])new Node[]{label, new Label("\u25be")});
        this.comboBox.valueProperty().addListener((observable, oldValue, newValue) -> label.setText(this.comboBox.getConverter().toString(newValue)));
        this.contextMenu.getItems().add((Object)new CustomMenuItem((Node)listView, false));
        listView.setPrefHeight(250.0);
        listView.setPrefWidth(200.0);
        this.setOnMouseClicked(e -> {
            this.stringBuilder = new StringBuilder();
            listView.getItems().setAll((Collection)this.comboBox.getItems());
            label.requestFocus();
            Bounds bounds = this.localToScreen(this.getBoundsInLocal());
            this.contextMenu.show((Node)this, bounds.getMinX(), bounds.getMaxY());
        });
    }

    public ComboBox<T> getComboBox() {
        return this.comboBox;
    }

    public ContextMenu getContextMenu() {
        return this.contextMenu;
    }
}

