/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.plugin.modules;

import com.google.common.collect.ObjectArrays;
import java.util.Arrays;
import java.util.HashSet;
import javassist.CtClass;
import javassist.CtMethod;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import us.donut.visualbukkit.plugin.modules.classes.DatabaseManager;
import us.donut.visualbukkit.plugin.modules.classes.ExpansionHandler;
import us.donut.visualbukkit.plugin.modules.classes.PapiExpansion;
import us.donut.visualbukkit.plugin.modules.classes.PlaceholderEvent;
import us.donut.visualbukkit.plugin.modules.classes.ProcedureRunnable;
import us.donut.visualbukkit.plugin.modules.classes.ReflectionUtil;
import us.donut.visualbukkit.plugin.modules.classes.VaultHook;
import us.donut.visualbukkit.plugin.modules.classes.WorldGuardHook;

public enum PluginModule {
    DATABASE(ObjectArrays.concat(DatabaseManager.class, PluginModule.getClasses("com.zaxxer.hikari"))),
    PROCEDURE_RUNNABLE(ProcedureRunnable.class),
    REFLECTION_UTIL(ReflectionUtil.class),
    WORLDGUARD(WorldGuardHook.class),
    VAULT(VaultHook.class),
    PlACEHOLDERAPI(new Class[]{ExpansionHandler.class, PapiExpansion.class, PlaceholderEvent.class}){

        @Override
        public void insertInto(CtClass mainClass) throws Exception {
            CtMethod enableMethod = mainClass.getDeclaredMethod("onEnable");
            enableMethod.insertAfter("if(Bukkit.getPluginManager().getPlugin(\"PlaceholderAPI\") != null) {us.donut.visualbukkit.plugin.modules.classes.ExpansionHandler.register(PluginMain.getInstance());}");
        }
    };

    private Class<?>[] classes;

    private static Class<?>[] getClasses(String packageName) {
        HashSet classes = new HashSet();
        for (Class<Object> clazz : new Reflections(packageName, new SubTypesScanner(false)).getSubTypesOf(Object.class)) {
            classes.add(clazz);
            try {
                classes.addAll(Arrays.asList(clazz.getDeclaredClasses()));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        return classes.toArray(new Class[0]);
    }

    private PluginModule(Class<?> ... classes) {
        this.classes = classes;
    }

    public void insertInto(CtClass mainClass) throws Exception {
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }
}

