/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.plugin;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Entity;
import us.donut.visualbukkit.plugin.PluginMain;

public class VariableManager {
    private static Map<String, Object> nonPersistentVariables = new ConcurrentHashMap<String, Object>();
    private static Map<String, Object> persistentVariables = new ConcurrentHashMap<String, Object>();
    private static HashFunction hashFunction = Hashing.md5();

    public static void loadVariables() {
        YamlConfiguration dataConfig = PluginMain.getDataConfig();
        if (dataConfig != null) {
            for (String key : dataConfig.getKeys(false)) {
                Object object = dataConfig.get(key);
                persistentVariables.put(key, object);
            }
        }
    }

    public static void saveVariables() {
        YamlConfiguration dataConfig = PluginMain.getDataConfig();
        if (dataConfig != null) {
            for (Map.Entry<String, Object> entry : persistentVariables.entrySet()) {
                String key = entry.getKey();
                Object[] value = entry.getValue();
                if (value instanceof List) {
                    value = ((List)value).stream().filter(VariableManager::isSerializable).toArray();
                }
                if (!VariableManager.isSerializable(value)) continue;
                dataConfig.set(key, value);
            }
            try {
                dataConfig.save(PluginMain.getDataFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Object getVarValue(boolean persistent, Object ... args) {
        return (persistent ? persistentVariables : nonPersistentVariables).get(VariableManager.getVariableString(args));
    }

    public static void setVarValue(boolean persistent, Object value, Object ... args) {
        (persistent ? persistentVariables : nonPersistentVariables).put(VariableManager.getVariableString(args), value);
    }

    public static void deleteVar(boolean persistent, Object ... args) {
        (persistent ? persistentVariables : nonPersistentVariables).remove(VariableManager.getVariableString(args));
    }

    public static void addToVar(boolean persistent, Object delta, Object ... args) {
        Map<String, Object> map = persistent ? persistentVariables : nonPersistentVariables;
        String variableString = VariableManager.getVariableString(args);
        map.put(variableString, VariableManager.addToObject(map.get(variableString), delta));
    }

    public static void removeFromVar(boolean persistent, Object delta, Object ... args) {
        Map<String, Object> map = persistent ? persistentVariables : nonPersistentVariables;
        String variableString = VariableManager.getVariableString(args);
        map.put(variableString, VariableManager.removeFromObject(map.get(variableString), delta));
    }

    public static Object addToObject(Object object, Object delta) {
        if (object instanceof List) {
            ((List)object).add(delta);
            return object;
        }
        if (object instanceof Number && delta instanceof Number) {
            return ((Number)object).doubleValue() + ((Number)delta).doubleValue();
        }
        if (object instanceof Duration && delta instanceof Duration) {
            return ((Duration)object).plus((Duration)delta);
        }
        throw new IllegalArgumentException("Cannot add " + delta + " to " + object);
    }

    public static Object removeFromObject(Object object, Object delta) {
        if (object instanceof List) {
            ((List)object).remove(delta);
            return object;
        }
        if (object instanceof Number && delta instanceof Number) {
            return ((Number)object).doubleValue() - ((Number)delta).doubleValue();
        }
        if (object instanceof Duration && delta instanceof Duration) {
            return ((Duration)object).minus((Duration)delta);
        }
        throw new IllegalArgumentException("Cannot remove " + delta + " from " + object);
    }

    private static String getVariableString(Object ... args) {
        StringBuilder variable = new StringBuilder();
        for (Object object : args) {
            String string = object.toString();
            if (object instanceof Entity) {
                string = ((Entity)object).getUniqueId().toString();
            } else if (object instanceof OfflinePlayer) {
                string = ((OfflinePlayer)object).getUniqueId().toString();
            } else if (object instanceof World) {
                string = ((World)object).getUID().toString();
            } else if (object instanceof Block) {
                string = ((Block)object).getLocation().toString();
            }
            variable.append(object.getClass().getCanonicalName()).append(string);
        }
        return hashFunction.hashString(variable.toString(), StandardCharsets.UTF_8).toString();
    }

    private static boolean isSerializable(Object object) {
        return object instanceof Serializable || object instanceof ConfigurationSerializable;
    }
}

