/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import us.donut.visualbukkit.plugin.VariableManager;

public class PluginMain
extends JavaPlugin
implements Listener {
    private static PluginMain instance;
    private static File dataFile;
    private static YamlConfiguration dataConfig;
    private static Map<String, String> stringMap;
    private static Base64.Decoder decoder;

    public PluginMain() {
    }

    protected PluginMain(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
    }

    @Override
    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        dataFile = new File(this.getDataFolder(), "data.yml");
        dataConfig = YamlConfiguration.loadConfiguration(dataFile);
        if (!dataFile.exists()) {
            try {
                dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        VariableManager.loadVariables();
        Bukkit.getScheduler().runTaskTimer((Plugin)this, VariableManager::saveVariables, 0L, 18000L);
    }

    @Override
    public void onDisable() {
        VariableManager.saveVariables();
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] commandArgs) {
        return true;
    }

    public static void procedure(String procedure, Object ... args) {
    }

    public static Object function(String function, Object ... args) {
        return null;
    }

    public static List<Object> createList(Object obj) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(obj, i));
            }
        } else if (obj instanceof Collection) {
            list.addAll((Collection)obj);
        } else {
            list.add(obj);
        }
        return list;
    }

    public static String decode(String string) {
        String decoded = stringMap.get(string);
        if (decoded == null) {
            decoded = new String(decoder.decode(string), StandardCharsets.UTF_8);
            stringMap.put(string, decoded);
        }
        return decoded;
    }

    public static String color(String string) {
        return string != null ? ChatColor.translateAlternateColorCodes('&', string) : null;
    }

    public static PluginMain getInstance() {
        return instance;
    }

    public static File getDataFile() {
        return dataFile;
    }

    public static YamlConfiguration getDataConfig() {
        return dataConfig;
    }

    static {
        stringMap = new HashMap<String, String>();
        decoder = Base64.getDecoder();
    }
}

