/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.plugin;

import com.google.common.io.ByteStreams;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.editor.BlockPane;
import us.donut.visualbukkit.editor.CommandPane;
import us.donut.visualbukkit.editor.Project;
import us.donut.visualbukkit.plugin.BuildContext;
import us.donut.visualbukkit.plugin.PluginMain;
import us.donut.visualbukkit.plugin.UtilMethods;
import us.donut.visualbukkit.plugin.VariableManager;
import us.donut.visualbukkit.plugin.modules.PluginModule;

public class PluginBuilder {
    private static ClassPool classPool = ClassPool.getDefault();

    public static void init() {
        classPool.importPackage("java.io");
        classPool.importPackage("java.nio.file");
        classPool.importPackage("java.sql");
        classPool.importPackage("java.util");
        classPool.importPackage("org.bukkit");
        classPool.importPackage("org.bukkit.block");
        classPool.importPackage("org.bukkit.entity");
        classPool.importPackage("org.bukkit.inventory");
        classPool.importPackage("org.bukkit.inventory.meta");
        classPool.importPackage("org.bukkit.util");
        classPool.importPackage("us.donut.visualbukkit.plugin");
        classPool.importPackage("us.donut.visualbukkit.plugin.modules.classes");
        classPool.importPackage("us.donut.visualbukkit.util");
        try {
            PluginBuilder.getCtClass(PluginMain.class, null);
        }
        catch (NotFoundException e) {
            VisualBukkit.displayException("Failed to init plugin main class", e);
        }
    }

    public static boolean isCodeValid(BlockPane blockPane) {
        try {
            BuildContext.create();
            blockPane.insertInto(PluginBuilder.getCtClass(PluginMain.class, null));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void build(Project project) throws Exception {
        String name = project.getPluginName().replaceAll("\\s", "");
        if (name.isEmpty()) {
            name = "VisualBukkitPlugin";
        }
        HashMap classes = new HashMap();
        CtClass mainClass = PluginBuilder.getCtClass(PluginMain.class, null);
        classes.put(PluginMain.class, mainClass);
        classes.put(VariableManager.class, PluginBuilder.getCtClass(VariableManager.class, mainClass.getPackageName()));
        BuildContext.create();
        for (BlockPane blockPane : project.getBlockPanes()) {
            blockPane.insertInto(mainClass);
        }
        for (PluginModule pluginModule : BuildContext.getPluginModules()) {
            pluginModule.insertInto(mainClass);
            Class<?>[] classArray = pluginModule.getClasses();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> clazz = classArray[i];
                classes.put(clazz, PluginBuilder.getCtClass(clazz, mainClass.getPackageName()));
            }
        }
        CtClass utilMethodsClass = PluginBuilder.getCtClass(UtilMethods.class, mainClass.getPackageName());
        for (CtMethod method : utilMethodsClass.getDeclaredMethods()) {
            if (BuildContext.getUtilMethods().contains(method.getName())) continue;
            utilMethodsClass.removeMethod(method);
        }
        if (utilMethodsClass.getDeclaredMethods().length > 0) {
            classes.put(UtilMethods.class, utilMethodsClass);
        }
        Path path = project.getPluginOutputDir();
        Path srcDir = path.resolve("src");
        Path jar = path.resolve(name + ".jar");
        Path pluginYml = srcDir.resolve("plugin.yml");
        Path configYml = srcDir.resolve("config.yml");
        Files.deleteIfExists(jar);
        if (Files.exists(srcDir, new LinkOption[0])) {
            MoreFiles.deleteRecursively(srcDir, RecursiveDeleteOption.ALLOW_INSECURE);
        }
        Files.createDirectories(srcDir, new FileAttribute[0]);
        for (CtClass ctClass : classes.values()) {
            for (Map.Entry entry : classes.entrySet()) {
                ctClass.replaceClassName(((Class)entry.getKey()).getName(), ((CtClass)entry.getValue()).getName());
            }
        }
        PluginBuilder.addClasses(srcDir, classes.values());
        Files.write(pluginYml, Arrays.asList(PluginBuilder.createYml(project, name, mainClass.getName()).split("\n")), StandardCharsets.UTF_8, new OpenOption[0]);
        Files.write(configYml, Arrays.asList(project.getPluginConfigPane().getConfigContent().split("\n")), StandardCharsets.UTF_8, new OpenOption[0]);
        PluginBuilder.createJar(srcDir, jar);
        MoreFiles.deleteRecursively(srcDir, RecursiveDeleteOption.ALLOW_INSECURE);
        VisualBukkit.displayMessage("Successfully built plugin\n(" + jar.toString() + ")");
    }

    public static String createYml(Project project, String name, String mainClassName) {
        StringBuilder pluginYml = new StringBuilder();
        String ver = project.getPluginVer();
        String author = project.getPluginAuthor();
        String desc = project.getPluginDesc();
        String website = project.getPluginWebsite();
        String depend = project.getPluginDepend();
        String softDepend = project.getPluginSoftDepend();
        pluginYml.append("name: ").append(name).append('\n');
        pluginYml.append("version: ").append(ver.isEmpty() ? "1.0" : ver).append('\n');
        pluginYml.append("main: ").append(mainClassName).append('\n');
        if (!author.isEmpty()) {
            pluginYml.append("author: ").append(author).append('\n');
        }
        if (!desc.isEmpty()) {
            pluginYml.append("description: ").append(desc).append('\n');
        }
        if (!website.isEmpty()) {
            pluginYml.append("website: ").append(website).append('\n');
        }
        if (!depend.isEmpty()) {
            pluginYml.append("depend: [").append(depend).append("]\n");
        }
        if (!softDepend.isEmpty()) {
            pluginYml.append("softdepend: [").append(softDepend).append("]\n");
        }
        pluginYml.append("api-version: 1.13\n");
        pluginYml.append("commands:\n");
        for (CommandPane command : project.getCommands()) {
            pluginYml.append("  ").append(command.getCommand()).append(":\n");
            if (!command.getDescription().isEmpty()) {
                pluginYml.append("    description: ").append(command.getDescription()).append('\n');
            }
            if (!command.getAliases().isEmpty()) {
                pluginYml.append("    aliases: [").append(command.getAliases()).append("]\n");
            }
            if (!command.getPermission().isEmpty()) {
                pluginYml.append("    permission: ").append(command.getPermission()).append('\n');
            }
            if (command.getPermMessage().isEmpty()) continue;
            pluginYml.append("    permission-message: ").append(command.getPermMessage()).append('\n');
        }
        return pluginYml.toString();
    }

    public static CtClass getCtClass(Class<?> clazz, String packageName) throws NotFoundException {
        if (packageName == null) {
            packageName = "a" + UUID.randomUUID().toString().replace("-", "");
        }
        String className = clazz.isAnonymousClass() ? clazz.getName().replaceFirst(clazz.getPackage().getName() + "\\.", "") : clazz.getSimpleName();
        return classPool.getAndRename(clazz.getName(), packageName + "." + className);
    }

    private static void createJar(Path rootDir, Path jar) throws IOException {
        try (OutputStream os = Files.newOutputStream(jar, new OpenOption[0]);
             JarOutputStream jos = new JarOutputStream(os);
             DirectoryStream<Path> paths = Files.newDirectoryStream(rootDir);){
            for (Path path : paths) {
                PluginBuilder.addJarEntries(jos, path, path);
            }
        }
    }

    private static void addJarEntries(JarOutputStream jos, Path rootDir, Path file) throws IOException {
        if (Files.isDirectory(file, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(file);){
                for (Path path : paths) {
                    PluginBuilder.addJarEntries(jos, rootDir, path);
                }
            }
        }
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            JarEntry jarEntry = new JarEntry(file.toString().replace(rootDir.getParent() + File.separator, "").replace("\\", "/"));
            jos.putNextEntry(jarEntry);
            jos.write(ByteStreams.toByteArray(is));
            jos.closeEntry();
        }
    }

    private static void addClasses(Path dir, Iterable<CtClass> classes) throws IOException, CannotCompileException {
        for (CtClass ctClass : classes) {
            Path packageDir = dir;
            for (String packageComponent : ctClass.getPackageName().split("\\.")) {
                if (!Files.notExists(packageDir = packageDir.resolve(packageComponent), new LinkOption[0])) continue;
                Files.createDirectory(packageDir, new FileAttribute[0]);
            }
            OutputStream os = Files.newOutputStream(packageDir.resolve(ctClass.getSimpleName() + ".class"), new OpenOption[0]);
            Throwable throwable = null;
            try {
                os.write(ctClass.toBytecode());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (os == null) continue;
                if (throwable != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                os.close();
            }
        }
    }
}

