/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.editor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.bukkit.configuration.file.YamlConfiguration;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.VisualBukkitLauncher;
import us.donut.visualbukkit.blocks.BlockContainer;
import us.donut.visualbukkit.blocks.BlockInfo;
import us.donut.visualbukkit.blocks.BlockRegistry;
import us.donut.visualbukkit.blocks.CodeBlock;
import us.donut.visualbukkit.blocks.DragManager;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.ExpressionBlockInfo;
import us.donut.visualbukkit.blocks.ModifierBlock;
import us.donut.visualbukkit.blocks.TypeHandler;
import us.donut.visualbukkit.blocks.UndoManager;
import us.donut.visualbukkit.blocks.syntax.ExpressionParameter;
import us.donut.visualbukkit.editor.BlockPane;
import us.donut.visualbukkit.editor.EventPane;
import us.donut.visualbukkit.plugin.PluginBuilder;
import us.donut.visualbukkit.util.CenteredHBox;
import us.donut.visualbukkit.util.ComboBoxView;
import us.donut.visualbukkit.util.TitleLabel;
import us.donut.visualbukkit.util.TreeNode;

public class SelectorPane
extends VBox
implements BlockContainer {
    private Set<BlockInfo.Node> blockInfoNodes = new TreeSet<BlockInfo.Node>(Comparator.comparing(Labeled::getText));
    private ComboBoxView<String> categoryComboBox = new ComboBoxView();
    private ComboBoxView<Class<?>> eventComboBox = new ComboBoxView();
    private ComboBoxView<String> returnTypeComboBox = new ComboBoxView();
    private CheckBox statementCheckBox = new CheckBox("Statements");
    private CheckBox expressionCheckBox = new CheckBox("Expressions");
    private TreeNode pinnedBlocks = new TreeNode("Pinned Blocks");
    private TextField searchField = new TextField();

    public SelectorPane() {
        VBox blockSelector = new VBox();
        VBox blocksArea = new VBox();
        blockSelector.getStyleClass().add((Object)"selector-pane");
        blocksArea.getStyleClass().add((Object)"selector-pane");
        this.backgroundProperty().bind((ObservableValue)blockSelector.backgroundProperty());
        ScrollPane scrollPane = new ScrollPane((Node)blocksArea);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        this.getChildren().addAll((Object[])new Node[]{blockSelector, new Separator(), scrollPane});
        DragManager.enableBlockContainer(this);
        TitleLabel selectorTitle = new TitleLabel("Block Selector", 1.5, true);
        TitleLabel statementTitle = new TitleLabel("Statements", 1.5, true);
        TitleLabel expressionTitle = new TitleLabel("Expressions", 1.5, true);
        VBox statementBox = new VBox(10.0, new Node[]{statementTitle});
        VBox expressionBox = new VBox(10.0, new Node[]{expressionTitle});
        statementBox.setFillWidth(false);
        expressionBox.setFillWidth(false);
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> this.blockInfoNodes.forEach(this::updateVisibility));
        this.categoryComboBox.setFocusTraversable(false);
        this.categoryComboBox.getComboBox().getItems().add((Object)"---");
        this.categoryComboBox.getComboBox().setValue((Object)"---");
        this.categoryComboBox.getComboBox().valueProperty().addListener((observable, oldValue, newValue) -> this.blockInfoNodes.forEach(this::updateVisibility));
        this.eventComboBox.getComboBox().setConverter(new StringConverter<Class<?>>(){

            public String toString(Class<?> clazz) {
                return clazz == Any.class ? "---" : (clazz != null ? clazz.getSimpleName() : null);
            }

            public Class<?> fromString(String string) {
                return null;
            }
        });
        this.eventComboBox.setFocusTraversable(false);
        this.eventComboBox.getComboBox().getItems().add(Any.class);
        this.eventComboBox.getComboBox().getItems().addAll((Object[])EventPane.EVENTS);
        this.eventComboBox.getComboBox().setValue(Any.class);
        this.eventComboBox.getComboBox().valueProperty().addListener((observable, oldValue, newValue) -> this.blockInfoNodes.forEach(this::updateVisibility));
        this.returnTypeComboBox.setFocusTraversable(false);
        this.returnTypeComboBox.getComboBox().getItems().add((Object)"---");
        this.returnTypeComboBox.getComboBox().getItems().addAll(TypeHandler.getAliases());
        this.returnTypeComboBox.getComboBox().setValue((Object)"---");
        this.returnTypeComboBox.getComboBox().valueProperty().addListener((observable, oldValue, newValue) -> this.blockInfoNodes.forEach(this::updateVisibility));
        this.statementCheckBox.setFocusTraversable(false);
        this.statementCheckBox.setSelected(true);
        this.statementCheckBox.setOnAction(e -> {
            boolean state = this.statementCheckBox.isSelected();
            statementBox.setVisible(state);
            statementBox.setManaged(state);
        });
        this.expressionCheckBox.setFocusTraversable(false);
        this.expressionCheckBox.setSelected(true);
        this.expressionCheckBox.setOnAction(e -> {
            boolean state = this.expressionCheckBox.isSelected();
            expressionBox.setVisible(state);
            expressionBox.setManaged(state);
        });
        CheckBox modifiersCheckBox = new CheckBox("Modifiers");
        modifiersCheckBox.setFocusTraversable(false);
        modifiersCheckBox.setSelected(true);
        this.updatePins();
        blockSelector.getChildren().addAll((Object[])new Node[]{selectorTitle, new CenteredHBox(10.0, new Node[]{new Label("Category:"), this.categoryComboBox}), new CenteredHBox(10.0, new Node[]{new Label("Event:   "), this.eventComboBox}), new CenteredHBox(10.0, new Node[]{new Label("Returns: "), this.returnTypeComboBox}), new CenteredHBox(10.0, new Node[]{new Label("Type:    "), this.statementCheckBox}), new CenteredHBox(10.0, new Node[]{new Label("         "), this.expressionCheckBox}), new CenteredHBox(10.0, new Node[]{new Label("         "), modifiersCheckBox}), new CenteredHBox(10.0, new Node[]{new Label("Search:  "), this.searchField}), this.pinnedBlocks});
        blocksArea.getChildren().addAll((Object[])new Node[]{statementBox, expressionBox});
        for (BlockInfo<? extends CodeBlock> blockInfo : BlockRegistry.getAll()) {
            if (ModifierBlock.class.isAssignableFrom(blockInfo.getBlockType())) continue;
            BlockInfo.Node blockInfoNode = blockInfo.createNode();
            this.blockInfoNodes.add(blockInfoNode);
            MenuItem pinItem = new MenuItem("Pin");
            pinItem.setOnAction(e -> {
                YamlConfiguration config = VisualBukkitLauncher.DATA_FILE.getConfig();
                List<String> pinned = config.getStringList("pinned-blocks");
                pinned.add(blockInfo.getBlockType().getCanonicalName());
                config.set("pinned-blocks", pinned);
                this.updatePins();
            });
            ContextMenu contextMenu = new ContextMenu(new MenuItem[]{pinItem});
            blockInfoNode.setOnContextMenuRequested(e -> {
                contextMenu.show((Node)blockInfoNode, e.getScreenX(), e.getScreenY());
                e.consume();
            });
            String[] categories = blockInfo.getCategories();
            if (categories == null) continue;
            for (String category : blockInfo.getCategories()) {
                if (this.categoryComboBox.getComboBox().getItems().contains((Object)category)) continue;
                int i = this.categoryComboBox.getComboBox().getItems().filtered(item -> category.compareTo((String)item) > 0).size();
                this.categoryComboBox.getComboBox().getItems().add(i, (Object)category);
            }
        }
        for (BlockInfo.Node blockInfoNode : this.blockInfoNodes) {
            final BlockInfo blockInfo = blockInfoNode.getBlockInfo();
            if (blockInfo instanceof ExpressionBlockInfo) {
                Class<ModifierBlock>[] modifiers = ((ExpressionBlockInfo)blockInfo).getModifiers();
                if (modifiers != null) {
                    CenteredHBox modifiersBox = new CenteredHBox(5.0, new Node[]{new Label("-")});
                    modifiersBox.setPadding(new Insets(0.0, 0.0, 0.0, 20.0));
                    VBox vBox = new VBox(5.0, new Node[]{blockInfoNode, modifiersBox});
                    vBox.visibleProperty().bind((ObservableValue)blockInfoNode.visibleProperty());
                    vBox.managedProperty().bind((ObservableValue)blockInfoNode.managedProperty());
                    modifiersBox.visibleProperty().bind((ObservableValue)vBox.visibleProperty().and((ObservableBooleanValue)modifiersCheckBox.selectedProperty()));
                    modifiersBox.managedProperty().bind((ObservableValue)modifiersBox.visibleProperty());
                    expressionBox.getChildren().add((Object)vBox);
                    for (Class<ModifierBlock> modifierClass : modifiers) {
                        modifiersBox.getChildren().add((Object)new BlockInfo(modifierClass){

                            public CodeBlock createBlock() {
                                ModifierBlock statement = (ModifierBlock)super.createBlock();
                                statement.init((ExpressionBlockInfo)blockInfo);
                                return statement;
                            }
                        }.createNode());
                    }
                    continue;
                }
                expressionBox.getChildren().add((Object)blockInfoNode);
                continue;
            }
            statementBox.getChildren().add((Object)blockInfoNode);
        }
    }

    @Override
    public boolean canAccept(CodeBlock block, double yCoord) {
        boolean valid = false;
        Pane parent = (Pane)block.getParent();
        if (parent != null) {
            BlockPane blockPane = block.getBlockPane();
            if (parent instanceof ExpressionParameter) {
                ExpressionParameter expressionParameter = (ExpressionParameter)parent;
                expressionParameter.setExpression(null);
                valid = PluginBuilder.isCodeValid(blockPane);
                expressionParameter.setExpression((ExpressionBlock)block);
            } else {
                int currentIndex = parent.getChildren().indexOf((Object)block);
                parent.getChildren().remove((Object)block);
                valid = PluginBuilder.isCodeValid(blockPane);
                parent.getChildren().add(currentIndex, (Object)block);
            }
        }
        return valid;
    }

    @Override
    public void accept(CodeBlock block, double yCoord) {
        UndoManager.capture();
        Parent parent = block.getParent();
        if (parent instanceof ExpressionParameter) {
            ((ExpressionParameter)parent).setExpression(null);
        } else if (parent instanceof Pane) {
            ((Pane)parent).getChildren().remove((Object)block);
        }
        Platform.runLater(block::onDragDrop);
    }

    @Override
    public List<? extends CodeBlock> getBlocks(boolean ignoreDisabled) {
        return Collections.emptyList();
    }

    private void updatePins() {
        YamlConfiguration config = VisualBukkitLauncher.DATA_FILE.getConfig();
        this.pinnedBlocks.clear();
        for (String blockType : config.getStringList("pinned-blocks")) {
            BlockInfo<String> blockInfo = BlockRegistry.getInfo(blockType);
            if (blockInfo != null) {
                BlockInfo.Node node = blockInfo.createNode();
                MenuItem unpinItem = new MenuItem("Unpin");
                unpinItem.setOnAction(e -> {
                    List<String> pinned = config.getStringList("pinned-blocks");
                    pinned.remove(blockInfo.getBlockType().getCanonicalName());
                    config.set("pinned-blocks", pinned);
                    this.updatePins();
                });
                MenuItem moveUpItem = new MenuItem("Move Up");
                moveUpItem.setOnAction(e -> {
                    List<String> pinned = config.getStringList("pinned-blocks");
                    int index = pinned.indexOf(blockInfo.getBlockType().getCanonicalName());
                    if (index != 0) {
                        Collections.swap(pinned, index, index - 1);
                        config.set("pinned-blocks", pinned);
                        this.updatePins();
                    }
                });
                MenuItem moveDownItem = new MenuItem("Move Down");
                moveDownItem.setOnAction(e -> {
                    List<String> pinned = config.getStringList("pinned-blocks");
                    int index = pinned.indexOf(blockInfo.getBlockType().getCanonicalName());
                    if (index != pinned.size() - 1) {
                        Collections.swap(pinned, index, index + 1);
                        config.set("pinned-blocks", pinned);
                        this.updatePins();
                    }
                });
                ContextMenu contextMenu = new ContextMenu(new MenuItem[]{unpinItem, moveUpItem, moveDownItem});
                node.setOnContextMenuRequested(e -> {
                    contextMenu.show((Node)node, e.getScreenX(), e.getScreenY());
                    e.consume();
                });
                this.pinnedBlocks.add(new Node[]{node});
                continue;
            }
            VisualBukkit.displayError("Failed to load pinned block " + blockType);
        }
    }

    private void updateVisibility(BlockInfo.Node blockInfoNode) {
        BlockInfo blockInfo = blockInfoNode.getBlockInfo();
        String category = (String)this.categoryComboBox.getComboBox().getValue();
        Class event = (Class)this.eventComboBox.getComboBox().getValue();
        String returnType = (String)this.returnTypeComboBox.getComboBox().getValue();
        String search = this.searchField.getText().toLowerCase();
        boolean state = !(!category.equals("---") && !this.checkCategory(blockInfo, category) || event != Any.class && !this.checkEvent(blockInfo, event) || !returnType.equals("---") && !this.checkReturnType(blockInfo, TypeHandler.getType(returnType)) || !search.isEmpty() && !blockInfoNode.getText().toLowerCase().contains(search));
        blockInfoNode.setVisible(state);
        blockInfoNode.setManaged(state);
    }

    private boolean checkCategory(BlockInfo<?> blockInfo, String category) {
        if (blockInfo.getCategories() != null) {
            for (String blockCategory : blockInfo.getCategories()) {
                if (!blockCategory.equalsIgnoreCase(category)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkEvent(BlockInfo<?> blockInfo, Class<?> clazz) {
        if (blockInfo.getEvents() != null) {
            for (Class<?> event : blockInfo.getEvents()) {
                if (!event.isAssignableFrom(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkReturnType(BlockInfo<?> blockInfo, Class<?> returnType) {
        if (blockInfo instanceof ExpressionBlockInfo) {
            Class<?> blockReturn = ((ExpressionBlockInfo)blockInfo).getReturnType();
            return blockReturn != null && (returnType.isAssignableFrom(blockReturn) || TypeHandler.isNumber(returnType) && TypeHandler.isNumber(blockReturn) || blockReturn == Boolean.TYPE && returnType == Boolean.class);
        }
        return false;
    }

    static {
        try {
            Tooltip tooltip = new Tooltip();
            Class<?> clazz = Class.forName("javafx.scene.control.Tooltip$TooltipBehavior");
            Constructor<?> constructor = clazz.getDeclaredConstructor(Duration.class, Duration.class, Duration.class, Boolean.TYPE);
            constructor.setAccessible(true);
            Object tooltipBehavior = constructor.newInstance(new Duration(150.0), new Duration(60000.0), new Duration(0.0), false);
            Field fieldBehavior = tooltip.getClass().getDeclaredField("BEHAVIOR");
            fieldBehavior.setAccessible(true);
            fieldBehavior.set(tooltip, tooltipBehavior);
        }
        catch (Exception e) {
            VisualBukkit.displayException("Failed to modify tooltips", e);
        }
    }

    private static class Any {
        private Any() {
        }
    }
}

