/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.editor;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextInputDialog;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.VisualBukkitLauncher;
import us.donut.visualbukkit.blocks.UndoManager;
import us.donut.visualbukkit.editor.Project;

public class ProjectManager {
    private static Path projectsFolder = VisualBukkitLauncher.DATA_FOLDER.resolve("Projects");
    private static List<Project> projects = new ArrayList<Project>();
    private static Project currentProject;

    public static void loadProjects() {
        try {
            if (Files.notExists(projectsFolder, new LinkOption[0])) {
                Files.createDirectory(projectsFolder, new FileAttribute[0]);
            }
            Files.list(projectsFolder).forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    try {
                        projects.add(new Project(path.getFileName().toString()));
                    }
                    catch (IOException e) {
                        VisualBukkit.displayException("Failed to load project", e);
                    }
                }
            });
        }
        catch (IOException e) {
            VisualBukkit.displayException("Failed to load projects", e);
            Platform.exit();
        }
        if (projects.isEmpty()) {
            ProjectManager.promptCreateProject(false);
        } else {
            Project lastProject = ProjectManager.getProject(VisualBukkitLauncher.DATA_FILE.getConfig().getString("last-project"));
            ProjectManager.open(lastProject == null ? projects.get(0) : lastProject);
        }
    }

    public static void open(Project project) {
        try {
            if (currentProject != null) {
                currentProject.save();
            }
        }
        catch (IOException e) {
            VisualBukkit.displayException("Failed to save project", e);
        }
        UndoManager.clear();
        SplitPane splitPane = VisualBukkit.getInstance().getSplitPane();
        splitPane.getItems().set(1, (Object)project.getTabPane());
        splitPane.getItems().set(2, (Object)project.getProjectPane());
        splitPane.setDividerPositions(new double[]{0.2, 0.825});
        currentProject = project;
        currentProject.load();
        VisualBukkitLauncher.DATA_FILE.getConfig().set("last-project", currentProject.getName());
    }

    public static void promptCreateProject(boolean canCancel) {
        TextInputDialog newProjectDialog = new TextInputDialog();
        newProjectDialog.setTitle("Create New Project");
        newProjectDialog.setContentText("Project name:");
        newProjectDialog.setHeaderText(null);
        newProjectDialog.setGraphic(null);
        String name = newProjectDialog.showAndWait().orElse("").replaceAll("\\s", "");
        if (projects.stream().anyMatch(project -> project.getName().equalsIgnoreCase(name))) {
            VisualBukkit.displayError("Project already exists");
            ProjectManager.promptCreateProject(canCancel);
        } else if (name.isEmpty()) {
            if (!canCancel) {
                VisualBukkit.displayError("Invalid project name");
                ProjectManager.promptCreateProject(false);
            }
        } else {
            try {
                Project project2 = new Project(name);
                projects.add(project2);
                ProjectManager.open(project2);
                project2.getPluginEnablePane().open();
                VisualBukkit.displayMessage("Successfully created project");
            }
            catch (IOException e) {
                VisualBukkit.displayException("Failed to create project", e);
            }
        }
    }

    public static void promptOpenProject() {
        ChoiceDialog openProjectDialog = new ChoiceDialog();
        openProjectDialog.getItems().addAll(projects);
        openProjectDialog.setTitle("Open Project");
        openProjectDialog.setContentText("Project:");
        openProjectDialog.setHeaderText(null);
        openProjectDialog.setGraphic(null);
        openProjectDialog.showAndWait().ifPresent(project -> {
            ProjectManager.open(project);
            VisualBukkit.displayMessage("Successfully opened project");
        });
    }

    public static void promptDeleteProject() {
        ChoiceDialog deleteProjectDialog = new ChoiceDialog();
        deleteProjectDialog.getItems().addAll(projects);
        deleteProjectDialog.setTitle("Delete Project");
        deleteProjectDialog.setContentText("Project:");
        deleteProjectDialog.setHeaderText(null);
        deleteProjectDialog.setGraphic(null);
        deleteProjectDialog.showAndWait().ifPresent(project -> {
            try {
                MoreFiles.deleteRecursively(project.getFolder(), RecursiveDeleteOption.ALLOW_INSECURE);
                projects.remove(project);
                if (project.equals(currentProject)) {
                    currentProject = null;
                }
                VisualBukkit.displayMessage("Successfully deleted project");
                if (projects.isEmpty()) {
                    ProjectManager.promptCreateProject(false);
                } else {
                    ProjectManager.open(projects.get(0));
                }
            }
            catch (IOException e) {
                VisualBukkit.displayException("Failed to delete project", e);
            }
        });
    }

    public static Project getProject(String name) {
        for (Project project : projects) {
            if (!project.getName().equalsIgnoreCase(name)) continue;
            return project;
        }
        return null;
    }

    public static Project getCurrentProject() {
        return currentProject;
    }

    public static Path getProjectsFolder() {
        return projectsFolder;
    }
}

