/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.editor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.eclipse.fx.ui.controls.tabpane.DndTabPane;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.blocks.TypeHandler;
import us.donut.visualbukkit.editor.BlockPane;
import us.donut.visualbukkit.editor.CommandPane;
import us.donut.visualbukkit.editor.EventPane;
import us.donut.visualbukkit.editor.FunctionPane;
import us.donut.visualbukkit.editor.PluginConfigPane;
import us.donut.visualbukkit.editor.PluginEnablePane;
import us.donut.visualbukkit.editor.PluginTestStage;
import us.donut.visualbukkit.editor.ProcedurePane;
import us.donut.visualbukkit.editor.ProjectManager;
import us.donut.visualbukkit.plugin.PluginBuilder;
import us.donut.visualbukkit.util.CenteredHBox;
import us.donut.visualbukkit.util.DataFile;
import us.donut.visualbukkit.util.TitleLabel;
import us.donut.visualbukkit.util.TreeNode;

public class Project {
    private String name;
    private Path folder;
    private Path backupFolder;
    private DataFile dataFile;
    private Pane projectPane;
    private DndTabPane tabPane;
    private PluginConfigPane pluginConfigPane = new PluginConfigPane(this);
    private PluginEnablePane pluginEnablePane = new PluginEnablePane(this);
    private List<CommandPane> commands = new ArrayList<CommandPane>();
    private List<EventPane> events = new ArrayList<EventPane>();
    private List<ProcedurePane> procedures = new ArrayList<ProcedurePane>();
    private List<FunctionPane> functions = new ArrayList<FunctionPane>();
    private boolean loaded = false;
    private int backupNum;

    public Project(String name) throws IOException {
        this.name = name;
        this.folder = ProjectManager.getProjectsFolder().resolve(name);
        if (Files.notExists(this.folder, new LinkOption[0])) {
            Files.createDirectory(this.folder, new FileAttribute[0]);
        }
        this.backupFolder = this.folder.resolve("backup");
        if (Files.notExists(this.backupFolder, new LinkOption[0])) {
            Files.createDirectory(this.backupFolder, new FileAttribute[0]);
        }
        this.dataFile = new DataFile(this.folder.resolve("data.yml"));
        this.projectPane = new Pane();
        this.tabPane = (DndTabPane)((Object)DndTabPaneFactory.createDefaultDnDPane(DndTabPaneFactory.FeedbackType.MARKER, null).getChildren().get(0));
    }

    public void load() {
        ConfigurationSection pluginConfigSection;
        ConfigurationSection configurationSection;
        ConfigurationSection configurationSection2;
        ConfigurationSection functionSection;
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        ConfigurationSection procedureSection = this.dataFile.getConfig().getConfigurationSection("procedures");
        if (procedureSection != null) {
            for (String string : procedureSection.getKeys(false)) {
                List<String> list = procedureSection.getConfigurationSection(string).getStringList("parameters");
                this.procedures.add(new ProcedurePane(this, string, (Class[])list.stream().map(TypeHandler::getType).toArray(Class[]::new)));
            }
        }
        if ((functionSection = this.dataFile.getConfig().getConfigurationSection("functions")) != null) {
            for (String string : functionSection.getKeys(false)) {
                List<String> list = functionSection.getConfigurationSection(string).getStringList("parameters");
                this.functions.add(new FunctionPane(this, string, (Class[])list.stream().map(TypeHandler::getType).toArray(Class[]::new)));
            }
        }
        for (ProcedurePane procedurePane : this.procedures) {
            try {
                procedurePane.load(procedureSection.getConfigurationSection(procedurePane.getMethodName()));
                this.projectPane.procedureTree.add(new Node[]{procedurePane.getProjectStructureLabel()});
            }
            catch (Exception exception) {
                this.procedures.remove(procedurePane);
                VisualBukkit.displayException("Failed to load procedure", exception);
            }
        }
        for (FunctionPane functionPane : this.functions) {
            try {
                functionPane.load(functionSection.getConfigurationSection(functionPane.getMethodName()));
                this.projectPane.functionTree.add(new Node[]{functionPane.getProjectStructureLabel()});
            }
            catch (Exception exception) {
                this.functions.remove(functionPane);
                VisualBukkit.displayException("Failed to load procedure", exception);
            }
        }
        ConfigurationSection configurationSection3 = this.dataFile.getConfig().getConfigurationSection("commands");
        if (configurationSection3 != null) {
            for (String string : configurationSection3.getKeys(false)) {
                CommandPane commandPane = new CommandPane(this, string);
                try {
                    commandPane.load(configurationSection3.getConfigurationSection(string));
                    this.add(commandPane);
                }
                catch (Exception e) {
                    VisualBukkit.displayException("Failed to load command", e);
                }
            }
        }
        if ((configurationSection2 = this.dataFile.getConfig().getConfigurationSection("events")) != null) {
            for (String eventClass : configurationSection2.getKeys(false)) {
                try {
                    String className = eventClass.replace('_', '.');
                    EventPane eventPane = new EventPane(this, Class.forName(className));
                    eventPane.load(configurationSection2.getConfigurationSection(eventClass));
                    this.add(eventPane);
                }
                catch (Exception e) {
                    VisualBukkit.displayException("Failed to load event", e);
                }
            }
        }
        if ((configurationSection = this.dataFile.getConfig().getConfigurationSection("plugin-enable")) != null) {
            try {
                this.pluginEnablePane.load(configurationSection);
            }
            catch (Exception e) {
                VisualBukkit.displayException("Failed to load plugin enable", e);
            }
        }
        if ((pluginConfigSection = this.dataFile.getConfig().getConfigurationSection("plugin-config")) != null) {
            this.pluginConfigPane.load(pluginConfigSection);
        }
    }

    public void add(BlockPane blockPane) {
        if (blockPane instanceof CommandPane) {
            this.commands.add((CommandPane)blockPane);
            this.projectPane.commandTree.add(new Node[]{blockPane.getProjectStructureLabel()});
        } else if (blockPane instanceof EventPane) {
            this.events.add((EventPane)blockPane);
            this.projectPane.eventTree.add(new Node[]{blockPane.getProjectStructureLabel()});
        } else if (blockPane instanceof ProcedurePane) {
            this.procedures.add((ProcedurePane)blockPane);
            this.projectPane.procedureTree.add(new Node[]{blockPane.getProjectStructureLabel()});
        } else if (blockPane instanceof FunctionPane) {
            this.functions.add((FunctionPane)blockPane);
            this.projectPane.functionTree.add(new Node[]{blockPane.getProjectStructureLabel()});
        }
    }

    public void remove(BlockPane blockPane) {
        this.tabPane.getTabs().remove((Object)blockPane);
        if (blockPane instanceof CommandPane) {
            this.commands.remove(blockPane);
            this.projectPane.commandTree.remove((Node)blockPane.getProjectStructureLabel());
        } else if (blockPane instanceof EventPane) {
            this.events.remove(blockPane);
            this.projectPane.eventTree.remove((Node)blockPane.getProjectStructureLabel());
        } else if (blockPane instanceof ProcedurePane) {
            this.procedures.remove(blockPane);
            this.projectPane.procedureTree.remove((Node)blockPane.getProjectStructureLabel());
        } else if (blockPane instanceof FunctionPane) {
            this.functions.remove(blockPane);
            this.projectPane.functionTree.remove((Node)blockPane.getProjectStructureLabel());
        }
    }

    public void save() throws IOException {
        YamlConfiguration data = new YamlConfiguration();
        this.dataFile.setConfig(data);
        data.set("plugin.name", this.getPluginName());
        data.set("plugin.version", this.getPluginVer());
        data.set("plugin.author", this.getPluginAuthor());
        data.set("plugin.description", this.getPluginDesc());
        data.set("plugin.website", this.getPluginWebsite());
        data.set("plugin.depend", this.getPluginDepend());
        data.set("plugin.soft-depend", this.getPluginSoftDepend());
        data.set("plugin.output-dir", this.getPluginOutputDir().toString());
        data.set("notes", this.projectPane.projectNotesTextArea.getText());
        this.pluginConfigPane.unload(data.createSection("plugin-config"));
        this.pluginEnablePane.unload(data.createSection("plugin-enable"));
        this.commands.forEach(command -> command.unload(data.createSection("commands." + command.getCommand())));
        this.procedures.forEach(procedure -> procedure.unload(data.createSection("procedures." + procedure.getMethodName())));
        this.functions.forEach(function -> function.unload(data.createSection("functions." + function.getMethodName())));
        this.events.forEach(eventPane -> {
            String className = eventPane.getEvent().getCanonicalName().replace('.', '_');
            eventPane.unload(data.createSection("events." + className));
        });
        this.dataFile.save();
        this.dataFile.getConfig().save(this.backupFolder.resolve("backup-" + (this.backupNum + 1) + ".yml").toFile());
        this.backupNum = (this.backupNum + 1) % 3;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Path getFolder() {
        return this.folder;
    }

    public DataFile getDataFile() {
        return this.dataFile;
    }

    public Pane getProjectPane() {
        return this.projectPane;
    }

    public TabPane getTabPane() {
        return this.tabPane;
    }

    public PluginConfigPane getPluginConfigPane() {
        return this.pluginConfigPane;
    }

    public PluginEnablePane getPluginEnablePane() {
        return this.pluginEnablePane;
    }

    public List<CommandPane> getCommands() {
        return this.commands;
    }

    public List<EventPane> getEvents() {
        return this.events;
    }

    public List<ProcedurePane> getProcedures() {
        return this.procedures;
    }

    public List<FunctionPane> getFunctions() {
        return this.functions;
    }

    public List<BlockPane> getBlockPanes() {
        ArrayList<BlockPane> blockPanes = new ArrayList<BlockPane>(1 + this.commands.size() + this.events.size() + this.procedures.size() + this.functions.size());
        blockPanes.add(this.pluginEnablePane);
        blockPanes.addAll(this.commands);
        blockPanes.addAll(this.events);
        blockPanes.addAll(this.procedures);
        blockPanes.addAll(this.functions);
        return blockPanes;
    }

    public String getPluginName() {
        return this.projectPane.pluginNameField.getText();
    }

    public String getPluginVer() {
        return this.projectPane.pluginVerField.getText();
    }

    public String getPluginAuthor() {
        return this.projectPane.pluginAuthorField.getText();
    }

    public String getPluginDesc() {
        return this.projectPane.pluginDescField.getText();
    }

    public String getPluginWebsite() {
        return this.projectPane.pluginWebsiteField.getText();
    }

    public String getPluginDepend() {
        return this.projectPane.pluginDependField.getText();
    }

    public String getPluginSoftDepend() {
        return this.projectPane.pluginSoftDependField.getText();
    }

    public Path getPluginOutputDir() {
        return Paths.get(this.projectPane.pluginOutputDirField.getText(), new String[0]);
    }

    public class Pane
    extends VBox {
        private TreeNode commandTree = new TreeNode("Commands");
        private TreeNode eventTree = new TreeNode("Events");
        private TreeNode procedureTree = new TreeNode("Procedures");
        private TreeNode functionTree = new TreeNode("Functions");
        private TextField pluginNameField = new TextField();
        private TextField pluginVerField = new TextField();
        private TextField pluginAuthorField = new TextField();
        private TextField pluginDescField = new TextField();
        private TextField pluginWebsiteField = new TextField();
        private TextField pluginDependField = new TextField();
        private TextField pluginSoftDependField = new TextField();
        private TextField pluginOutputDirField = new TextField();
        private TextArea projectNotesTextArea = new TextArea();

        public Pane() {
            YamlConfiguration data = Project.this.dataFile.getConfig();
            this.pluginNameField.setText(data.getString("plugin.name", ""));
            this.pluginVerField.setText(data.getString("plugin.version", ""));
            this.pluginAuthorField.setText(data.getString("plugin.author", ""));
            this.pluginDescField.setText(data.getString("plugin.description", ""));
            this.pluginWebsiteField.setText(data.getString("plugin.website", ""));
            this.pluginDependField.setText(data.getString("plugin.depend", ""));
            this.pluginSoftDependField.setText(data.getString("plugin.soft-depend", ""));
            this.pluginOutputDirField.setText(data.getString("plugin.output-dir", Project.this.folder.resolve("output").toString()));
            this.projectNotesTextArea.setText(data.getString("notes", ""));
            Button projectNotesButton = new Button("Notes");
            projectNotesButton.setOnAction(e -> {
                Stage stage = new Stage();
                stage.initOwner((Window)VisualBukkit.getInstance().getPrimaryStage());
                stage.setTitle("Project Notes");
                if (this.projectNotesTextArea.getParent() != null) {
                    this.projectNotesTextArea.getScene().getWindow().hide();
                }
                VBox rootPane = new VBox(new Node[]{this.projectNotesTextArea});
                this.projectNotesTextArea.prefHeightProperty().bind((ObservableValue)rootPane.heightProperty());
                stage.setScene(new Scene((Parent)rootPane, 300.0, 400.0));
                stage.show();
            });
            Button newCommandButton = new Button("New Command");
            newCommandButton.setOnAction(e -> CommandPane.promptNew(Project.this));
            Button newEventButton = new Button("New Event");
            newEventButton.setOnAction(e -> EventPane.promptNew(Project.this));
            Button newProcedureButton = new Button("New Procedure");
            newProcedureButton.setOnAction(e -> ProcedurePane.promptNew(Project.this));
            Button newFunctionButton = new Button("New Function");
            newFunctionButton.setOnAction(e -> FunctionPane.promptNew(Project.this));
            GridPane buttonGrid = new GridPane();
            buttonGrid.setHgap(5.0);
            buttonGrid.setVgap(5.0);
            buttonGrid.add((Node)newCommandButton, 0, 0);
            buttonGrid.add((Node)newEventButton, 1, 0);
            buttonGrid.add((Node)newProcedureButton, 0, 1);
            buttonGrid.add((Node)newFunctionButton, 1, 1);
            buttonGrid.getChildren().forEach(child -> {
                ((Button)child).setMaxWidth(Double.MAX_VALUE);
                GridPane.setFillWidth((Node)child, (Boolean)true);
            });
            TreeNode structureTree = new TreeNode("Project Structure");
            structureTree.toggle();
            structureTree.add(new Node[]{Project.this.pluginConfigPane.getProjectStructureLabel(), Project.this.pluginEnablePane.getProjectStructureLabel(), this.commandTree, this.eventTree, this.procedureTree, this.functionTree});
            Button testButton = new Button("Test Plugin");
            testButton.setOnAction(e -> new PluginTestStage(Project.this).show());
            Button buildButton = new Button("Build Plugin");
            buildButton.setOnAction(e -> {
                try {
                    PluginBuilder.build(Project.this);
                }
                catch (Exception ex) {
                    VisualBukkit.displayException("Failed to build plugin", ex);
                }
            });
            DirectoryChooser chooser = new DirectoryChooser();
            chooser.setTitle("Output Directory");
            chooser.setInitialDirectory(new File(System.getProperty("user.dir")));
            this.pluginOutputDirField.setEditable(false);
            this.pluginOutputDirField.setOnMouseClicked(e -> {
                File dir = chooser.showDialog((Window)VisualBukkit.getInstance().getPrimaryStage());
                if (dir != null) {
                    this.pluginOutputDirField.setText(dir.toPath().toString());
                }
            });
            VBox content = new VBox();
            ScrollPane scrollPane = new ScrollPane((Node)content);
            scrollPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
            scrollPane.prefHeightProperty().bind((ObservableValue)this.heightProperty());
            scrollPane.setFitToWidth(true);
            scrollPane.setFitToHeight(true);
            this.getChildren().add((Object)scrollPane);
            content.getStyleClass().add((Object)"project-pane");
            content.getChildren().addAll((Object[])new Node[]{new TitleLabel("Project Manager", 1.5, true), new Label("Name: " + Project.this.name), structureTree, new CenteredHBox(10.0, new Node[]{new Label("Project Notes:"), projectNotesButton}), buttonGrid, new Separator(), new TitleLabel("Plugin Information", 1.5, true), new CenteredHBox(10.0, new Node[]{new Label("Name:       "), this.pluginNameField}), new CenteredHBox(10.0, new Node[]{new Label("Version:    "), this.pluginVerField}), new CenteredHBox(10.0, new Node[]{new Label("Author:     "), this.pluginAuthorField}), new CenteredHBox(10.0, new Node[]{new Label("Description:"), this.pluginDescField}), new CenteredHBox(10.0, new Node[]{new Label("Website:    "), this.pluginWebsiteField}), new CenteredHBox(10.0, new Node[]{new Label("Depend:     "), this.pluginDependField}), new CenteredHBox(10.0, new Node[]{new Label("Soft Depend:"), this.pluginSoftDependField}), new CenteredHBox(10.0, new Node[]{new Label("Output dir: "), this.pluginOutputDirField}), testButton, buildButton});
        }
    }
}

