/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.editor;

import java.util.List;
import java.util.StringJoiner;
import javafx.scene.Node;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.Pane;
import javassist.CtClass;
import javassist.CtMethod;
import org.apache.commons.lang.StringUtils;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.ParentBlock;
import us.donut.visualbukkit.blocks.StatementBlock;
import us.donut.visualbukkit.blocks.expressions.ExprProcedureRunnable;
import us.donut.visualbukkit.blocks.syntax.BlockParameter;
import us.donut.visualbukkit.blocks.syntax.ExpressionParameter;
import us.donut.visualbukkit.editor.MethodPane;
import us.donut.visualbukkit.editor.Project;

public class ProcedurePane
extends MethodPane {
    public static void promptNew(Project project) {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle("New Procedure");
        dialog.setContentText("Procedure:");
        dialog.setHeaderText(null);
        dialog.setGraphic(null);
        String procedure = dialog.showAndWait().orElse("").replaceAll("\\s", "");
        if (!procedure.isEmpty()) {
            if (StringUtils.isAlphanumeric(procedure)) {
                for (ProcedurePane procedurePane : project.getProcedures()) {
                    if (!procedurePane.getMethodName().equalsIgnoreCase(procedure)) continue;
                    VisualBukkit.displayError("Procedure already exists");
                    return;
                }
                ProcedurePane procedurePane = new ProcedurePane(project, procedure, ProcedurePane.promptParameters());
                project.add(procedurePane);
                procedurePane.open();
                project.getTabPane().getSelectionModel().select((Object)procedurePane);
            } else {
                VisualBukkit.displayError("Invalid procedure name");
            }
        }
    }

    public ProcedurePane(Project project, String procedureName, Class<?> ... parameters) {
        super("Procedure", project, procedureName, parameters);
        this.getInfoArea().getChildren().addAll((Object[])new Node[]{this.titleLabel, this.deleteButton, this.changeParamButton});
    }

    @Override
    protected void deleteUsages(Pane pane) {
        for (Node child : pane.getChildren()) {
            if (!(child instanceof StatementBlock)) continue;
            this.deleteUsages(((StatementBlock)child).getParameters());
            if (!(child instanceof ParentBlock)) continue;
            this.deleteUsages((Pane)((ParentBlock)child));
        }
    }

    private void deleteUsages(List<BlockParameter> parameters) {
        for (BlockParameter parameter : parameters) {
            if (!(parameter instanceof ExpressionParameter)) continue;
            ExpressionParameter expressionParameter = (ExpressionParameter)parameter;
            ExpressionBlock<?> expression = expressionParameter.getExpression();
            if (expression instanceof ExprProcedureRunnable && this.equals(((ExprProcedureRunnable)expression).getProcedure())) {
                expressionParameter.setExpression(null);
                continue;
            }
            if (expression == null) continue;
            this.deleteUsages(expression.getParameters());
        }
    }

    @Override
    public void insertInto(CtClass mainClass) throws Exception {
        CtMethod procedureMethod = mainClass.getDeclaredMethod("procedure");
        StringJoiner stringJoiner = new StringJoiner("\n");
        this.getBlockArea().getBlocks(true).forEach(block -> stringJoiner.add(block.toJava()));
        String src = "if (procedure.equalsIgnoreCase(\"" + this.methodName + "\")) {" + this.declareLocalVariables() + stringJoiner.toString() + "}";
        procedureMethod.insertBefore(src);
    }
}

