/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.editor;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMockFactory;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.editor.BlockPane;
import us.donut.visualbukkit.editor.Project;
import us.donut.visualbukkit.plugin.BuildContext;
import us.donut.visualbukkit.plugin.PluginBuilder;
import us.donut.visualbukkit.plugin.PluginMain;
import us.donut.visualbukkit.util.CenteredHBox;

public class PluginTestStage
extends Stage {
    private SplitPane outputPane = new SplitPane();
    private TextArea errorTextArea = new TextArea();
    private Map<Integer, PlayerVBox> playerVBoxes = new HashMap<Integer, PlayerVBox>();
    private ListView<String> playerListView = new ListView();
    private ServerMock serverMock;
    private PlayerMockFactory playerFactory;
    private Timeline playerUpdater;

    public PluginTestStage(Project project) {
        this.initModality(Modality.APPLICATION_MODAL);
        this.initOwner((Window)VisualBukkit.getInstance().getPrimaryStage());
        SplitPane rootPane = new SplitPane();
        this.setScene(new Scene((Parent)rootPane, 1000.0, 600.0));
        this.setTitle("Plugin Test");
        this.setOnCloseRequest(e -> {
            if (this.playerUpdater != null) {
                this.playerUpdater.stop();
            }
            try {
                MockBukkit.unmock();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.playerListView.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.outputPane.getItems().set(0, (Object)this.playerVBoxes.get(newValue.intValue()));
            }
        });
        Button addPlayerButton = new Button("Add Player");
        addPlayerButton.setOnAction(e -> this.addPlayer());
        VBox playerListVBox = new VBox(10.0, new Node[]{new Label("Players"), this.playerListView, addPlayerButton});
        playerListVBox.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        playerListVBox.setAlignment(Pos.TOP_CENTER);
        this.playerListView.prefHeightProperty().bind((ObservableValue)playerListVBox.heightProperty());
        VBox errorVBox = new VBox(10.0, new Node[]{new Label("Errors"), this.errorTextArea});
        errorVBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.errorTextArea.setEditable(false);
        this.errorTextArea.prefHeightProperty().bind((ObservableValue)errorVBox.heightProperty());
        this.outputPane.getItems().addAll((Object[])new Node[]{new VBox(), errorVBox});
        this.outputPane.setOrientation(Orientation.VERTICAL);
        this.outputPane.setDividerPositions(new double[]{0.5, 0.5});
        rootPane.getStylesheets().add((Object)"/style.css");
        rootPane.getItems().addAll((Object[])new Node[]{playerListVBox, this.outputPane});
        rootPane.setDividerPositions(new double[]{0.2, 0.8});
        try {
            this.serverMock = MockBukkit.mock();
            this.playerFactory = new PlayerMockFactory(this.serverMock);
            BuildContext.create();
            CtClass mainCtClass = PluginBuilder.getCtClass(PluginMain.class, null);
            for (BlockPane blockPane : project.getBlockPanes()) {
                blockPane.insertInto(mainCtClass);
            }
            String joinEventMethod = "public void a" + UUID.randomUUID().toString().replace("-", "") + "(" + PlayerJoinEvent.class.getCanonicalName() + " event) {Bukkit.broadcastMessage(event.getJoinMessage());}";
            String chatEventMethod = "public void a" + UUID.randomUUID().toString().replace("-", "") + "(" + AsyncPlayerChatEvent.class.getCanonicalName() + " event) {if (!event.isCancelled()) {Iterator it = event.getRecipients().iterator();while (it.hasNext()) {((Player) it.next()).sendMessage(\"[\" + event.getPlayer().getName() + \"] \" + event.getMessage());}}}";
            for (String methodString : new String[]{joinEventMethod, chatEventMethod}) {
                CtMethod event = CtMethod.make(methodString, mainCtClass);
                ConstPool methodConstPool = event.getMethodInfo().getConstPool();
                AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(methodConstPool, "RuntimeVisibleAnnotations");
                annotationsAttribute.setAnnotation(new Annotation("org.bukkit.event.EventHandler", methodConstPool));
                event.getMethodInfo().addAttribute(annotationsAttribute);
                mainCtClass.addMethod(event);
            }
            Class<?> mainClass = mainCtClass.toClass();
            String pluginName = project.getPluginName().replaceAll("\\s", "");
            String pluginYml = PluginBuilder.createYml(project, pluginName.isEmpty() ? "VisualBukkitPlugin" : pluginName, mainClass.getName());
            try (ByteArrayInputStream ymlStream = new ByteArrayInputStream(pluginYml.getBytes(StandardCharsets.UTF_8));){
                MockBukkit.loadWith(mainClass, ymlStream, new Object[0]);
                this.playerUpdater = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), e -> this.playerVBoxes.forEach((k, v) -> v.update()), new KeyValue[0])});
                this.playerUpdater.setCycleCount(-1);
                this.playerUpdater.play();
            }
        }
        catch (Throwable e2) {
            this.displayException(e2);
        }
    }

    private void addPlayer() {
        try {
            PlayerMock player = this.playerFactory.createRandomPlayer();
            player.setName(player.getName().replace(" ", ""));
            player.setDisplayName(player.getName());
            this.serverMock.addPlayer(player);
            this.playerVBoxes.put(this.serverMock.getOnlinePlayers().size() - 1, new PlayerVBox(player));
            this.playerListView.getItems().add((Object)player.getName());
        }
        catch (Throwable e) {
            this.displayException(e);
        }
    }

    private void displayException(Throwable e) {
        if (!this.errorTextArea.getText().isEmpty()) {
            this.errorTextArea.appendText("\n");
        }
        this.errorTextArea.appendText(ExceptionUtils.getStackTrace(e));
    }

    private class PlayerVBox
    extends VBox {
        private TextArea outputTextArea;
        private TextField messageField;
        private List<String> messageLog;
        private int messageIndex;
        private PlayerMock player;

        public PlayerVBox(PlayerMock player) {
            super(10.0);
            this.outputTextArea = new TextArea();
            this.messageField = new TextField();
            this.messageLog = new ArrayList<String>();
            this.player = player;
            this.outputTextArea.setEditable(false);
            this.outputTextArea.prefHeightProperty().bind((ObservableValue)this.heightProperty());
            Button sendButton = new Button("Send");
            sendButton.setOnAction(e -> this.sendMessage());
            this.setPadding(new Insets(5.0, 5.0, 10.0, 5.0));
            this.messageField.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
                if (e.getCode() == KeyCode.ENTER) {
                    this.sendMessage();
                    e.consume();
                } else if (e.getCode() == KeyCode.UP) {
                    if (!this.messageLog.isEmpty() && this.messageIndex > 0) {
                        this.messageField.setText(this.messageLog.get(--this.messageIndex));
                    }
                    e.consume();
                } else if (e.getCode() == KeyCode.DOWN) {
                    if (this.messageLog.size() > this.messageIndex + 1) {
                        this.messageField.setText(this.messageLog.get(++this.messageIndex));
                    }
                    e.consume();
                }
            });
            CheckBox opCheckBox = new CheckBox("Operator");
            opCheckBox.setFocusTraversable(false);
            opCheckBox.setOnAction(e -> player.setOp(opCheckBox.isSelected()));
            this.getChildren().addAll((Object[])new Node[]{new Label("Player: " + player.getName()), this.outputTextArea, new CenteredHBox(5.0, new Node[]{new Label("Message/Command:"), this.messageField, sendButton}), opCheckBox});
        }

        public void sendMessage() {
            try {
                String message = this.messageField.getText();
                this.messageLog.add(message);
                this.messageIndex = this.messageLog.size();
                this.messageField.clear();
                if (message.startsWith("/")) {
                    this.player.performCommand(message.substring(1));
                } else {
                    this.player.chat(message);
                }
            }
            catch (Throwable ex) {
                PluginTestStage.this.displayException(ex);
            }
        }

        public void update() {
            String message;
            while ((message = this.player.nextMessage()) != null) {
                if (!this.outputTextArea.getText().isEmpty()) {
                    this.outputTextArea.appendText("\n");
                }
                this.outputTextArea.appendText(message);
            }
        }
    }
}

