/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.editor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.bukkit.configuration.ConfigurationSection;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;
import us.donut.visualbukkit.editor.Project;
import us.donut.visualbukkit.util.Loadable;
import us.donut.visualbukkit.util.TitleLabel;

public class PluginConfigPane
extends Tab
implements Loadable {
    private Project project;
    private CodeArea textArea = new CodeArea();
    private Label projectStructureLabel;

    public PluginConfigPane(Project project) {
        super("Plugin Config");
        this.project = project;
        this.projectStructureLabel = new Label(this.getText());
        this.projectStructureLabel.setOnMouseEntered(e -> this.projectStructureLabel.setStyle("-fx-text-fill: gold;"));
        this.projectStructureLabel.setOnMouseExited(e -> this.projectStructureLabel.setStyle(null));
        this.projectStructureLabel.setOnMouseClicked(e -> this.open());
        HBox infoArea = new HBox(15.0);
        infoArea.getStyleClass().add((Object)"block-pane-info-area");
        infoArea.getChildren().addAll((Object[])new Node[]{new TitleLabel("Plugin Config", 2.0), new Label("(default config.yml)")});
        VBox content = new VBox(new Node[]{infoArea, this.textArea});
        this.setContent((Node)content);
        this.textArea.prefHeightProperty().bind((ObservableValue)content.heightProperty());
        this.textArea.setParagraphGraphicFactory(LineNumberFactory.get(this.textArea));
        Pattern whiteSpace = Pattern.compile("^\\s+");
        this.textArea.setOnKeyReleased(e -> {
            int currentParagraph;
            Matcher matcher;
            if (e.getCode() == KeyCode.ENTER && (matcher = whiteSpace.matcher((CharSequence)this.textArea.getParagraph((currentParagraph = this.textArea.getCurrentParagraph()) - 1).getSegments().get(0))).find()) {
                this.textArea.insertText(this.textArea.getCaretPosition(), matcher.group());
            }
        });
    }

    public void open() {
        if (!this.project.getTabPane().getTabs().contains((Object)this)) {
            this.project.getTabPane().getTabs().add((Object)this);
        }
    }

    @Override
    public void unload(ConfigurationSection section) {
        if (this.getTabPane() != null) {
            section.set("open", true);
        }
        section.set("content", this.textArea.getText());
    }

    @Override
    public void load(ConfigurationSection section) {
        if (section.getBoolean("open")) {
            this.open();
        }
        this.textArea.appendText(section.getString("content", ""));
    }

    public Label getProjectStructureLabel() {
        return this.projectStructureLabel;
    }

    public String getConfigContent() {
        return this.textArea.getText();
    }
}

