/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.editor;

import java.util.ArrayList;
import java.util.Optional;
import java.util.StringJoiner;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.blocks.TypeHandler;
import us.donut.visualbukkit.editor.BlockPane;
import us.donut.visualbukkit.editor.Project;
import us.donut.visualbukkit.util.TitleLabel;

public abstract class MethodPane
extends BlockPane {
    protected String methodName;
    protected Class<?>[] parameters;
    protected TitleLabel titleLabel;
    protected Button deleteButton;
    protected Button changeParamButton;

    public MethodPane(String type, Project project, String methodName, Class<?> ... parameters) {
        super(project, methodName + "()");
        this.methodName = methodName;
        this.parameters = parameters;
        this.titleLabel = new TitleLabel(type + ": " + methodName + "(" + this.getParametersString() + ")", 2.0);
        this.deleteButton = new Button("Delete");
        this.deleteButton.setOnAction(e -> {
            Alert confirmation = new Alert(Alert.AlertType.CONFIRMATION, "Are you sure you want to delete this?\n(all usages will be deleted)", new ButtonType[0]);
            confirmation.setHeaderText(null);
            confirmation.setGraphic(null);
            if (confirmation.showAndWait().orElse(ButtonType.CANCEL) == ButtonType.OK) {
                project.remove(this);
                for (BlockPane blockPane : project.getBlockPanes()) {
                    if (this.equals(blockPane)) continue;
                    this.deleteUsages((Pane)blockPane.getBlockArea());
                }
                VisualBukkit.displayMessage("Successfully deleted");
            }
        });
        this.changeParamButton = new Button("Change Parameters");
        this.changeParamButton.setOnAction(e -> {
            Alert confirmation = new Alert(Alert.AlertType.CONFIRMATION, "Are you sure you want to change parameters?\n(all usages will be deleted)", new ButtonType[0]);
            confirmation.setHeaderText(null);
            confirmation.setGraphic(null);
            if (confirmation.showAndWait().orElse(ButtonType.CANCEL) == ButtonType.OK) {
                this.parameters = MethodPane.promptParameters();
                this.titleLabel.setText(type + ": " + methodName + "(" + this.getParametersString() + ")");
                for (BlockPane blockPane : project.getBlockPanes()) {
                    this.deleteUsages((Pane)blockPane.getBlockArea());
                }
            }
        });
    }

    protected abstract void deleteUsages(Pane var1);

    @Override
    public void unload(ConfigurationSection section) {
        super.unload(section);
        ArrayList<String> parameters = new ArrayList<String>();
        for (Class<?> parameter : this.parameters) {
            parameters.add(TypeHandler.getAlias(parameter));
        }
        section.set("parameters", parameters);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getParameters() {
        return this.parameters;
    }

    public String getParametersString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (Class<?> parameter : this.parameters) {
            joiner.add(TypeHandler.getAlias(parameter));
        }
        return joiner.toString();
    }

    public String toString() {
        return this.methodName;
    }

    protected static Class<?>[] promptParameters() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Parameters");
        alert.setHeaderText(null);
        alert.setGraphic(null);
        alert.getButtonTypes().remove((Object)ButtonType.CANCEL);
        ListView parameterList = new ListView();
        parameterList.setPlaceholder((Node)new Label("<no parameters>"));
        parameterList.setPrefHeight(200.0);
        Button addButton = new Button("Add");
        addButton.setOnAction(e -> {
            ChoiceDialog choiceDialog = new ChoiceDialog();
            choiceDialog.setTitle("Select type");
            choiceDialog.setContentText("Type:");
            choiceDialog.setHeaderText(null);
            choiceDialog.setGraphic(null);
            choiceDialog.getItems().addAll(TypeHandler.getAliases());
            Optional choice = choiceDialog.showAndWait();
            choice.ifPresent(s -> parameterList.getItems().add(s));
        });
        Button moveUpButton = new Button("Move up");
        moveUpButton.setOnAction(e -> {
            int i = parameterList.getSelectionModel().getSelectedIndex();
            if (i > 0) {
                parameterList.getItems().add(i - 1, parameterList.getItems().remove(i));
                parameterList.getSelectionModel().select(i - 1);
            }
        });
        Button moveDownButton = new Button("Move down");
        moveDownButton.setOnAction(e -> {
            int i = parameterList.getSelectionModel().getSelectedIndex();
            if (i != parameterList.getItems().size() - 1) {
                parameterList.getItems().add(i + 1, parameterList.getItems().remove(i));
                parameterList.getSelectionModel().select(i + 1);
            }
        });
        Button removeButton = new Button("Delete");
        removeButton.setOnAction(e -> {
            int i = parameterList.getSelectionModel().getSelectedIndex();
            if (i != -1) {
                parameterList.getItems().remove(i);
            }
        });
        VBox content = new VBox(5.0, new Node[]{new Label("Parameter types:"), parameterList, new HBox(3.0, new Node[]{addButton, moveUpButton, moveDownButton, removeButton})});
        alert.getDialogPane().setContent((Node)content);
        alert.showAndWait();
        Class[] parameters = new Class[parameterList.getItems().size()];
        for (int i = 0; i < parameterList.getItems().size(); ++i) {
            parameters[i] = TypeHandler.getType((String)parameterList.getItems().get(i));
        }
        return parameters;
    }
}

