/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.editor;

import java.util.List;
import java.util.StringJoiner;
import javafx.scene.Node;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.Pane;
import javassist.CtClass;
import javassist.CtMethod;
import org.apache.commons.lang.StringUtils;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.ParentBlock;
import us.donut.visualbukkit.blocks.StatementBlock;
import us.donut.visualbukkit.blocks.expressions.ExprFunction;
import us.donut.visualbukkit.blocks.syntax.BlockParameter;
import us.donut.visualbukkit.blocks.syntax.ExpressionParameter;
import us.donut.visualbukkit.editor.MethodPane;
import us.donut.visualbukkit.editor.Project;

public class FunctionPane
extends MethodPane {
    public static void promptNew(Project project) {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle("New Function");
        dialog.setContentText("Function:");
        dialog.setHeaderText(null);
        dialog.setGraphic(null);
        String function = dialog.showAndWait().orElse("").replaceAll("\\s", "");
        if (!function.isEmpty()) {
            if (StringUtils.isAlphanumeric(function)) {
                for (FunctionPane functionPane : project.getFunctions()) {
                    if (!functionPane.getMethodName().equalsIgnoreCase(function)) continue;
                    VisualBukkit.displayError("Function already exists");
                    return;
                }
                FunctionPane functionPane = new FunctionPane(project, function, FunctionPane.promptParameters());
                project.add(functionPane);
                functionPane.open();
                project.getTabPane().getSelectionModel().select((Object)functionPane);
            } else {
                VisualBukkit.displayError("Invalid function name");
            }
        }
    }

    public FunctionPane(Project project, String functionName, Class<?> ... parameters) {
        super("Function", project, functionName, parameters);
        this.getInfoArea().getChildren().addAll((Object[])new Node[]{this.titleLabel, this.deleteButton, this.changeParamButton});
    }

    @Override
    protected void deleteUsages(Pane pane) {
        for (Node child : pane.getChildren()) {
            if (!(child instanceof StatementBlock)) continue;
            this.deleteUsages(((StatementBlock)child).getParameters());
            if (!(child instanceof ParentBlock)) continue;
            this.deleteUsages((Pane)((ParentBlock)child));
        }
    }

    private void deleteUsages(List<BlockParameter> parameters) {
        for (BlockParameter parameter : parameters) {
            if (!(parameter instanceof ExpressionParameter)) continue;
            ExpressionParameter expressionParameter = (ExpressionParameter)parameter;
            ExpressionBlock<?> expression = expressionParameter.getExpression();
            if (expression instanceof ExprFunction && this.equals(((ExprFunction)expression).getFunction())) {
                expressionParameter.setExpression(null);
                continue;
            }
            if (expression == null) continue;
            this.deleteUsages(expression.getParameters());
        }
    }

    @Override
    public void insertInto(CtClass mainClass) throws Exception {
        CtMethod functionMethod = mainClass.getDeclaredMethod("function");
        StringJoiner stringJoiner = new StringJoiner("\n");
        this.getBlockArea().getBlocks(true).forEach(block -> stringJoiner.add(block.toJava()));
        String src = "if (function.equalsIgnoreCase(\"" + this.methodName + "\")) {" + this.declareLocalVariables() + stringJoiner.toString() + "}";
        functionMethod.insertBefore(src);
    }
}

