/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.editor;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TreeSet;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.MemberValue;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.editor.BlockPane;
import us.donut.visualbukkit.editor.Project;
import us.donut.visualbukkit.plugin.BuildContext;
import us.donut.visualbukkit.plugin.modules.PluginModule;
import us.donut.visualbukkit.plugin.modules.classes.PlaceholderEvent;
import us.donut.visualbukkit.util.CenteredHBox;
import us.donut.visualbukkit.util.ComboBoxView;
import us.donut.visualbukkit.util.TitleLabel;

public class EventPane
extends BlockPane {
    public static final Class<?>[] EVENTS;
    private Class<? extends Event> event;
    private ComboBox<String> priorityComboBox = new ComboBox();

    public static void promptNew(Project project) {
        Class event2;
        ComboBoxView comboBoxView = new ComboBoxView();
        comboBoxView.getStylesheets().add((Object)"/style.css");
        comboBoxView.getComboBox().setConverter(new StringConverter<Class<?>>(){

            public String toString(Class<?> clazz) {
                return clazz != null ? clazz.getSimpleName() : null;
            }

            public Class<?> fromString(String string) {
                return null;
            }
        });
        comboBoxView.getComboBox().getItems().addAll((Object[])EVENTS);
        project.getEvents().forEach(event -> comboBoxView.getComboBox().getItems().remove(event.getEvent()));
        Alert alert = new Alert(Alert.AlertType.INFORMATION, "New Event", new ButtonType[]{ButtonType.OK, ButtonType.CLOSE});
        alert.setHeaderText(null);
        alert.setGraphic(null);
        alert.getDialogPane().setContent((Node)new HBox(5.0, new Node[]{new Text("Event:"), comboBoxView}));
        alert.getDialogPane().setPrefWidth(300.0);
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK && (event2 = (Class)comboBoxView.getComboBox().getValue()) != null) {
            EventPane eventPane = new EventPane(project, event2);
            project.add(eventPane);
            eventPane.open();
            project.getTabPane().getSelectionModel().select((Object)eventPane);
        }
    }

    public EventPane(Project project, Class<?> event) {
        super(project, event.getSimpleName());
        if (!Event.class.isAssignableFrom(event)) {
            throw new IllegalArgumentException(event.getCanonicalName() + " is not an event");
        }
        this.event = event;
        this.priorityComboBox.getItems().addAll((Object[])Arrays.stream(EventPriority.values()).map(Enum::toString).toArray(String[]::new));
        this.priorityComboBox.setValue((Object)"HIGHEST");
        Button deleteButton = new Button("Delete");
        deleteButton.setOnAction(e -> {
            Alert confirmation = new Alert(Alert.AlertType.CONFIRMATION, "Are you sure you want to delete this event?", new ButtonType[0]);
            confirmation.setHeaderText(null);
            confirmation.setGraphic(null);
            if (confirmation.showAndWait().orElse(ButtonType.CANCEL) == ButtonType.OK) {
                project.remove(this);
                VisualBukkit.displayMessage("Successfully deleted event");
            }
        });
        this.getInfoArea().getChildren().add((Object)new VBox(5.0, new Node[]{new CenteredHBox(10.0, new Node[]{new TitleLabel("Event: " + this.getText(), 2.0), deleteButton}), new CenteredHBox(10.0, new Node[]{new Label("Listener priority:"), this.priorityComboBox})}));
    }

    @Override
    public void insertInto(CtClass mainClass) throws Exception {
        StringJoiner stringJoiner = new StringJoiner("\n");
        this.getBlockArea().getBlocks(true).forEach(block -> stringJoiner.add(block.toJava()));
        String src = "public void on" + this.event.getSimpleName() + "(" + this.event.getCanonicalName() + " event) {" + this.declareLocalVariables() + stringJoiner.toString() + "}";
        CtMethod eventMethod = CtMethod.make(src, mainClass);
        ConstPool methodConstPool = eventMethod.getMethodInfo().getConstPool();
        AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(methodConstPool, "RuntimeVisibleAnnotations");
        Annotation annotation = new Annotation("org.bukkit.event.EventHandler", methodConstPool);
        EnumMemberValue priority = new EnumMemberValue(methodConstPool);
        priority.setType(EventPriority.class.getCanonicalName());
        priority.setValue((String)this.priorityComboBox.getValue());
        annotation.addMemberValue("priority", (MemberValue)priority);
        annotationsAttribute.setAnnotation(annotation);
        eventMethod.getMethodInfo().addAttribute(annotationsAttribute);
        mainClass.addMethod(eventMethod);
        if (this.event == PlaceholderEvent.class) {
            BuildContext.addPluginModule(PluginModule.PlACEHOLDERAPI);
        }
    }

    @Override
    public void unload(ConfigurationSection section) {
        super.unload(section);
        section.set("priority", this.priorityComboBox.getValue());
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        super.load(section);
        String priority = section.getString("priority");
        if (priority != null) {
            this.priorityComboBox.setValue((Object)priority);
        }
    }

    public Class<? extends Event> getEvent() {
        return this.event;
    }

    static {
        Reflections reflections = new Reflections("org.bukkit.event", new Scanner[0]);
        TreeSet<Class> events = new TreeSet<Class>(Comparator.comparing(Class::getSimpleName));
        for (Class<Event> clazz : reflections.getSubTypesOf(Event.class)) {
            if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isAnnotationPresent(Deprecated.class)) continue;
            events.add(clazz);
        }
        events.add(PlaceholderEvent.class);
        EVENTS = events.toArray(new Class[0]);
    }
}

