/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.editor;

import java.util.StringJoiner;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.VBox;
import javassist.CtClass;
import javassist.CtMethod;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.blocks.BlockRegistry;
import us.donut.visualbukkit.blocks.expressions.ExprCommandArg;
import us.donut.visualbukkit.blocks.expressions.ExprCommandArgs;
import us.donut.visualbukkit.blocks.expressions.ExprCommandSender;
import us.donut.visualbukkit.editor.BlockPane;
import us.donut.visualbukkit.editor.Project;
import us.donut.visualbukkit.util.CenteredHBox;
import us.donut.visualbukkit.util.TitleLabel;

public class CommandPane
extends BlockPane {
    private String command;
    private TextField descField = new TextField();
    private TextField aliasesField = new TextField();
    private TextField permField = new TextField();
    private TextField permMessageField = new TextField();

    public static void promptNew(Project project) {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle("New Command");
        dialog.setContentText("Command:");
        dialog.setHeaderText(null);
        dialog.setGraphic(null);
        String command = dialog.showAndWait().orElse("").replaceAll("\\s", "");
        if (!command.isEmpty()) {
            for (CommandPane commandPane : project.getCommands()) {
                if (!commandPane.getCommand().equalsIgnoreCase(command)) continue;
                VisualBukkit.displayError("Command already exists");
                return;
            }
            CommandPane commandPane = new CommandPane(project, command);
            project.add(commandPane);
            commandPane.open();
            project.getTabPane().getSelectionModel().select((Object)commandPane);
        }
    }

    public CommandPane(Project project, String command) {
        super(project, "/" + command);
        this.command = command;
        TitleLabel label = new TitleLabel("Command: /" + command, 2.0);
        Button renameButton = new Button("Rename");
        renameButton.setOnAction(e -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("Rename Command");
            dialog.setContentText("New command:");
            dialog.setHeaderText(null);
            dialog.setGraphic(null);
            String newCommand = dialog.showAndWait().orElse("").replaceAll("\\s", "");
            if (!newCommand.isEmpty()) {
                if (StringUtils.isAlphanumeric(newCommand)) {
                    for (CommandPane commandPane : project.getCommands()) {
                        if (!commandPane.getCommand().equalsIgnoreCase(newCommand)) continue;
                        VisualBukkit.displayError("Command already exists");
                        return;
                    }
                    this.command = newCommand;
                    this.setText("/" + newCommand);
                    label.setText("Command: /" + newCommand);
                    this.getProjectStructureLabel().setText(this.getText());
                } else {
                    VisualBukkit.displayError("Invalid command name");
                }
            }
        });
        Button deleteButton = new Button("Delete");
        deleteButton.setOnAction(e -> {
            Alert confirmation = new Alert(Alert.AlertType.CONFIRMATION, "Are you sure you want to delete this command?", new ButtonType[0]);
            confirmation.setHeaderText(null);
            confirmation.setGraphic(null);
            if (confirmation.showAndWait().orElse(ButtonType.CANCEL) == ButtonType.OK) {
                project.remove(this);
                VisualBukkit.displayMessage("Successfully deleted command");
            }
        });
        this.getInfoArea().getChildren().add((Object)new VBox(15.0, new Node[]{new CenteredHBox(10.0, new Node[]{label, renameButton, deleteButton}), new CenteredHBox(5.0, new Node[]{new Label("Aliases:"), this.aliasesField, new Label("  Description:"), this.descField, new Label("  Permission:"), this.permField, new Label("  Perm Message:"), this.permMessageField}), new CenteredHBox(10.0, new Node[]{new Label("Blocks:"), BlockRegistry.getInfo(ExprCommandSender.class).createNode(), BlockRegistry.getInfo(ExprCommandArgs.class).createNode(), BlockRegistry.getInfo(ExprCommandArg.class).createNode()})}));
    }

    @Override
    public void insertInto(CtClass mainClass) throws Exception {
        CtMethod commandMethod = mainClass.getDeclaredMethod("onCommand");
        StringJoiner stringJoiner = new StringJoiner("\n");
        this.getBlockArea().getBlocks(true).forEach(block -> stringJoiner.add(block.toJava()));
        String src = "if (command.getName().equalsIgnoreCase(\"" + this.command + "\")) {" + this.declareLocalVariables() + stringJoiner.toString() + "}";
        commandMethod.insertBefore(src);
    }

    @Override
    public void unload(ConfigurationSection section) {
        super.unload(section);
        section.set("description", this.descField.getText());
        section.set("aliases", this.aliasesField.getText());
        section.set("permission", this.permField.getText());
        section.set("permission-message", this.permMessageField.getText());
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        super.load(section);
        this.descField.setText(section.getString("description", ""));
        this.aliasesField.setText(section.getString("aliases", ""));
        this.permField.setText(section.getString("permission", ""));
        this.permMessageField.setText(section.getString("permission-message", ""));
    }

    public String getCommand() {
        return this.command;
    }

    public String getDescription() {
        return this.descField.getText();
    }

    public String getAliases() {
        return this.aliasesField.getText();
    }

    public String getPermission() {
        return this.permField.getText();
    }

    public String getPermMessage() {
        return this.permMessageField.getText();
    }
}

