/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.editor;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javassist.CtClass;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.blocks.BlockContainer;
import us.donut.visualbukkit.blocks.BlockRegistry;
import us.donut.visualbukkit.blocks.CodeBlock;
import us.donut.visualbukkit.blocks.CopyPasteManager;
import us.donut.visualbukkit.blocks.DragManager;
import us.donut.visualbukkit.blocks.StatementBlock;
import us.donut.visualbukkit.blocks.UndoManager;
import us.donut.visualbukkit.editor.Project;
import us.donut.visualbukkit.plugin.BuildContext;
import us.donut.visualbukkit.plugin.PluginBuilder;
import us.donut.visualbukkit.util.Loadable;

public abstract class BlockPane
extends Tab
implements Loadable {
    private Project project;
    private HBox infoArea = new HBox(15.0);
    private BlockArea blockArea = new BlockArea();
    private Label projectStructureLabel;

    public BlockPane(Project project, String tabText) {
        super(tabText);
        this.project = project;
        ScrollPane scrollPane = new ScrollPane((Node)this.blockArea);
        VBox content = new VBox(new Node[]{this.infoArea, scrollPane});
        scrollPane.prefHeightProperty().bind((ObservableValue)content.heightProperty());
        this.blockArea.prefWidthProperty().bind((ObservableValue)scrollPane.widthProperty());
        this.blockArea.prefHeightProperty().bind((ObservableValue)scrollPane.heightProperty());
        this.infoArea.getStyleClass().add((Object)"block-pane-info-area");
        this.projectStructureLabel = new Label(this.getText());
        this.projectStructureLabel.setOnMouseEntered(e -> this.projectStructureLabel.setStyle("-fx-text-fill: gold;"));
        this.projectStructureLabel.setOnMouseExited(e -> this.projectStructureLabel.setStyle(null));
        this.projectStructureLabel.setOnMouseClicked(e -> this.open());
        this.setContent((Node)content);
    }

    public void open() {
        if (!this.project.getTabPane().getTabs().contains((Object)this)) {
            this.project.getTabPane().getTabs().add((Object)this);
        }
    }

    public String declareLocalVariables() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String variable : BuildContext.getLocalVariables()) {
            stringBuilder.append("Object ").append(variable).append("= null;");
        }
        BuildContext.getLocalVariables().clear();
        return stringBuilder.toString();
    }

    public abstract void insertInto(CtClass var1) throws Exception;

    @Override
    public void unload(ConfigurationSection section) {
        if (this.getTabPane() != null) {
            section.set("open", true);
        }
        List<StatementBlock> blocks = this.blockArea.getBlocks(false);
        ConfigurationSection blocksSection = section.createSection("blocks");
        for (int i = 0; i < blocks.size(); ++i) {
            CodeBlock block = blocks.get(i);
            ConfigurationSection blockSection = blocksSection.createSection(String.valueOf(i));
            blockSection.set("block-type", block.getClass().getCanonicalName());
            block.unload(blockSection);
        }
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        ConfigurationSection blocksSection;
        if (section.getBoolean("open")) {
            this.open();
        }
        if ((blocksSection = section.getConfigurationSection("blocks")) != null) {
            for (String key : blocksSection.getKeys(false)) {
                String blockType;
                ConfigurationSection blockSection = blocksSection.getConfigurationSection(key);
                if (blockSection == null || (blockType = blockSection.getString("block-type")) == null) continue;
                String block = BlockRegistry.getInfo(blockType).createBlock();
                ((CodeBlock)((Object)block)).load(blockSection);
                this.blockArea.getChildren().add((Object)block);
            }
        }
    }

    public Project getProject() {
        return this.project;
    }

    public HBox getInfoArea() {
        return this.infoArea;
    }

    public BlockArea getBlockArea() {
        return this.blockArea;
    }

    public Label getProjectStructureLabel() {
        return this.projectStructureLabel;
    }

    public class BlockArea
    extends VBox
    implements BlockContainer {
        private double contextMenuYCoord;

        public BlockArea() {
            this.getStyleClass().add((Object)"block-area");
            DragManager.enableBlockContainer(this);
            MenuItem pasteItem = new MenuItem("Paste");
            pasteItem.setOnAction(e -> CopyPasteManager.paste(this, this.contextMenuYCoord));
            ContextMenu contextMenu = new ContextMenu(new MenuItem[]{pasteItem});
            this.setOnMouseClicked(e -> contextMenu.hide());
            this.setOnContextMenuRequested(e -> {
                contextMenu.show((Node)this, e.getScreenX(), e.getScreenY());
                this.contextMenuYCoord = e.getY();
                e.consume();
            });
        }

        @Override
        public boolean canAccept(CodeBlock block, double yCoord) {
            boolean valid = false;
            if (block instanceof StatementBlock) {
                Pane parent = (Pane)block.getParent();
                int currentIndex = -1;
                if (parent != null) {
                    currentIndex = parent.getChildren().indexOf((Object)block);
                    parent.getChildren().remove(currentIndex);
                }
                int index = DragManager.getIndexAt((Pane)this, yCoord);
                this.getChildren().add(index, (Object)block);
                valid = PluginBuilder.isCodeValid(block.getBlockPane());
                this.getChildren().remove(index);
                if (parent != null) {
                    parent.getChildren().add(currentIndex, (Object)block);
                }
            }
            return valid;
        }

        @Override
        public void accept(CodeBlock block, double yCoord) {
            UndoManager.capture();
            Pane parent = (Pane)block.getParent();
            if (parent != null) {
                parent.getChildren().remove((Object)block);
            }
            this.getChildren().add(DragManager.getIndexAt((Pane)this, yCoord), (Object)block);
            Platform.runLater(block::onDragDrop);
        }

        public List<StatementBlock> getBlocks(boolean ignoreDisabled) {
            ArrayList<StatementBlock> blocks = new ArrayList<StatementBlock>();
            for (Node child : BlockPane.this.blockArea.getChildren()) {
                if (!(child instanceof StatementBlock) || ignoreDisabled && !((StatementBlock)child).isEnabled()) continue;
                blocks.add((StatementBlock)child);
            }
            return blocks;
        }

        public BlockPane getBlockPane() {
            return BlockPane.this;
        }
    }
}

