/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.syntax;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import us.donut.visualbukkit.blocks.syntax.BlockParameter;
import us.donut.visualbukkit.blocks.syntax.ExpressionParameter;

public class SyntaxNode
extends VBox {
    private List<BlockParameter> parameters = new ArrayList<BlockParameter>();

    public SyntaxNode(Object ... components) {
        super(5.0);
        this.getChildren().add((Object)new SyntaxLine(components));
    }

    public SyntaxNode line(Object ... components) {
        SyntaxLine syntaxLine = new SyntaxLine(components);
        syntaxLine.setPadding(new Insets(0.0, 0.0, 0.0, 15.0));
        this.getChildren().add((Object)syntaxLine);
        return this;
    }

    public void add(Object ... components) {
        this.add(0, components);
    }

    public void add(int lineIndex, Object ... components) {
        ((SyntaxLine)((Object)this.getChildren().get(lineIndex))).add(components);
    }

    public void clear() {
        for (Node node : this.getChildren()) {
            ((SyntaxLine)node).getChildren().clear();
        }
    }

    public List<BlockParameter> getParameters() {
        return this.parameters;
    }

    private class SyntaxLine
    extends HBox {
        private SyntaxLine(Object ... components) {
            this.getStyleClass().add((Object)"syntax-node");
            this.add(components);
        }

        private void add(Object ... components) {
            for (Object component : components) {
                if (component instanceof BlockParameter) {
                    SyntaxNode.this.parameters.add((BlockParameter)component);
                }
                if (component instanceof Node) {
                    this.getChildren().add((Object)((Node)component));
                }
                if (component instanceof String) {
                    this.getChildren().add((Object)new Text((String)component));
                    continue;
                }
                if (!(component instanceof Class)) continue;
                ExpressionParameter expressionParameter = new ExpressionParameter((Class)component);
                SyntaxNode.this.parameters.add(expressionParameter);
                this.getChildren().add((Object)expressionParameter);
            }
        }
    }
}

