/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.syntax;

import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.blocks.BlockContainer;
import us.donut.visualbukkit.blocks.BlockInfo;
import us.donut.visualbukkit.blocks.BlockRegistry;
import us.donut.visualbukkit.blocks.CodeBlock;
import us.donut.visualbukkit.blocks.CopyPasteManager;
import us.donut.visualbukkit.blocks.DragManager;
import us.donut.visualbukkit.blocks.EmptyExpressionBlock;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.StatementBlock;
import us.donut.visualbukkit.blocks.TypeHandler;
import us.donut.visualbukkit.blocks.UndoManager;
import us.donut.visualbukkit.blocks.expressions.ExprNumber;
import us.donut.visualbukkit.blocks.expressions.ExprString;
import us.donut.visualbukkit.blocks.syntax.BlockParameter;
import us.donut.visualbukkit.plugin.PluginBuilder;

public class ExpressionParameter
extends VBox
implements BlockParameter,
BlockContainer {
    private Class<?> returnType;
    private ExpressionBlock<?> expression;
    private EmptyExpressionBlock<?> emptyExprBlock;
    private Text emptyText;

    public ExpressionParameter(Class<?> returnType) {
        this.getStyleClass().add((Object)"expression-parameter-empty");
        this.returnType = returnType;
        this.emptyExprBlock = new EmptyExpressionBlock(returnType);
        this.emptyText = new Text("<" + TypeHandler.getUserFriendlyName(returnType) + ">");
        this.getChildren().add((Object)this.emptyText);
        DragManager.enableBlockContainer(this);
        MenuItem pasteItem = new MenuItem("Paste");
        pasteItem.setOnAction(e -> CopyPasteManager.paste(this, -1.0));
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{pasteItem});
        this.setOnContextMenuRequested(e -> {
            if (this.isEmpty()) {
                contextMenu.show((Node)this, e.getScreenX(), e.getScreenY());
                for (Parent parent = this.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof StatementBlock)) continue;
                    ((StatementBlock)parent).getContextMenu().hide();
                    break;
                }
                e.consume();
            }
        });
        this.setOnMouseClicked(e -> {
            if (this.isEmpty() && e.getButton() == MouseButton.PRIMARY) {
                if (returnType == String.class) {
                    this.setExpression((ExpressionBlock)((Object)BlockRegistry.getInfo(ExprString.class).createBlock()));
                    e.consume();
                } else if (TypeHandler.isNumber(returnType)) {
                    this.setExpression((ExpressionBlock)((Object)BlockRegistry.getInfo(ExprNumber.class).createBlock()));
                    e.consume();
                }
            }
        });
    }

    @Override
    public boolean canAccept(CodeBlock block, double yCoord) {
        boolean valid = false;
        if (block instanceof ExpressionBlock) {
            ExpressionParameter parent = (ExpressionParameter)block.getParent();
            ExpressionBlock newExpression = (ExpressionBlock)block;
            ExpressionBlock<?> currentExpression = this.getExpression();
            if (parent != null) {
                parent.setExpression(null);
            }
            this.setExpression(newExpression);
            valid = PluginBuilder.isCodeValid(block.getBlockPane());
            this.setExpression(currentExpression);
            if (parent != null) {
                parent.setExpression(newExpression);
            }
        }
        return valid;
    }

    @Override
    public void accept(CodeBlock block, double yCoord) {
        UndoManager.capture();
        ExpressionParameter parent = (ExpressionParameter)block.getParent();
        if (parent != null) {
            parent.setExpression(null);
        }
        this.setExpression((ExpressionBlock)block);
        Platform.runLater(block::onDragDrop);
    }

    public void setExpression(ExpressionBlock<?> expression) {
        this.getChildren().clear();
        if (expression == null || expression instanceof EmptyExpressionBlock) {
            this.expression = null;
            this.getChildren().add((Object)this.emptyText);
            this.getStyleClass().set(0, (Object)"expression-parameter-empty");
        } else {
            this.expression = expression;
            this.getChildren().add(this.expression);
            this.getStyleClass().set(0, (Object)"expression-parameter-filled");
        }
    }

    public boolean isEmpty() {
        return this.expression == null;
    }

    @Override
    public String toJava() {
        return TypeHandler.convert(this.getExpression().getReturnType(), this.returnType, this.getExpression().toJava());
    }

    @Override
    public void unload(ConfigurationSection section) {
        section.set("block-type", this.getExpression().getClass().getCanonicalName());
        this.getExpression().unload(section);
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        BlockInfo<String> blockInfo;
        String blockType = section.getString("block-type");
        if (blockType != null && (blockInfo = BlockRegistry.getInfo(blockType)) != null) {
            ExpressionBlock expression = (ExpressionBlock)((Object)blockInfo.createBlock());
            expression.load(section);
            this.setExpression(expression);
        }
    }

    public List<ExpressionBlock<?>> getBlocks(boolean ignoreDisabled) {
        return this.expression == null ? Collections.emptyList() : Collections.singletonList(this.expression);
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public ExpressionBlock<?> getExpression() {
        return this.expression != null ? this.expression : this.emptyExprBlock;
    }
}

