/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.statements;

import java.sql.PreparedStatement;
import us.donut.visualbukkit.blocks.StatementBlock;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Name;
import us.donut.visualbukkit.blocks.statements.StatOpenDatabaseConnection;
import us.donut.visualbukkit.blocks.syntax.ChoiceParameter;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

@Name(value="Set SQL Parameter")
@Description(value={"Sets a parameter in a SQL statement"})
public class StatSetSQLParameter
extends StatementBlock {
    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("set SQL parameter").line("type:     ", new ChoiceParameter("boolean", "double", "integer", "object", "varchar")).line("statement:", PreparedStatement.class).line("parameter:", Integer.TYPE).line("value:    ", Object.class);
    }

    @Override
    public String toJava() {
        if (this.isChildOf(StatOpenDatabaseConnection.class)) {
            String type = this.arg(0).toUpperCase();
            if (type.equals("OBJECT")) {
                type = "JAVA_OBJECT";
            }
            return this.arg(1) + ".setObject(" + this.arg(2) + "," + this.arg(3) + ",JDBCType." + type + ");";
        }
        throw new IllegalStateException();
    }
}

