/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.statements;

import javafx.event.Event;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.blocks.BlockInfo;
import us.donut.visualbukkit.blocks.BlockRegistry;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.ExpressionBlockInfo;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.ModifierBlock;
import us.donut.visualbukkit.blocks.TypeHandler;
import us.donut.visualbukkit.blocks.syntax.ExpressionParameter;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

public class StatAdd
extends ModifierBlock {
    private ExpressionParameter deltaParameter;

    @Override
    protected SyntaxNode init() {
        return new SyntaxNode(new Object[0]);
    }

    @Override
    public void init(ExpressionBlockInfo<?> expressionBlockInfo) {
        super.init(expressionBlockInfo);
        this.deltaParameter = new ExpressionParameter(this.expressionBlock.getDeltaType(ModificationType.ADD));
        ExpressionParameter expressionParameter = new ExpressionParameter(Object.class);
        expressionParameter.setOnDragOver(Event::consume);
        expressionParameter.setExpression(this.expressionBlock);
        this.getSyntaxNode().add("add", this.deltaParameter, "to", expressionParameter);
    }

    @Override
    public String toJava() {
        ExpressionBlock<?> deltaExpr = this.deltaParameter.getExpression();
        String delta = TypeHandler.convert(deltaExpr.getReturnType(), this.expressionBlock.getDeltaType(ModificationType.ADD), deltaExpr.toJava());
        return this.expressionBlock.modify(ModificationType.ADD, delta);
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        BlockInfo<String> expressionBlockInfo = BlockRegistry.getInfo(section.getString("parameters.1.block-type"));
        if (!(expressionBlockInfo instanceof ExpressionBlockInfo)) {
            throw new IllegalStateException();
        }
        this.init((ExpressionBlockInfo)expressionBlockInfo);
        this.deltaParameter.load(section.getConfigurationSection("parameters.0"));
        this.expressionBlock.load(section.getConfigurationSection("parameters.1"));
    }
}

