/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import org.bukkit.entity.Player;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.annotations.Category;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

@Category(value={"Player"})
@Description(value={"The walk speed of a player", "Returns: number"})
@Modifier(value={ModificationType.SET, ModificationType.ADD, ModificationType.REMOVE})
public class ExprWalkSpeed
extends ModifiableExpressionBlock<Float> {
    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("walk speed of", Player.class);
    }

    @Override
    public String toJava() {
        return this.arg(0) + ".getWalkSpeed()";
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        switch (modificationType) {
            case SET: {
                return this.arg(0) + ".setWalkSpeed(" + delta + ");";
            }
            case ADD: {
                return this.modify(ModificationType.SET, this.toJava() + "-" + delta);
            }
            case REMOVE: {
                return this.modify(ModificationType.SET, this.toJava() + "+" + delta);
            }
        }
        return null;
    }
}

