/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import java.util.List;
import org.bukkit.event.server.TabCompleteEvent;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Event;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

@Description(value={"The tab completions in a TabCompleteEvent", "Returns: list of strings"})
@Event(value={TabCompleteEvent.class})
@Modifier(value={ModificationType.SET, ModificationType.ADD, ModificationType.REMOVE})
public class ExprTabCompletions
extends ModifiableExpressionBlock<List> {
    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("tab completions");
    }

    @Override
    public String toJava() {
        return "PluginMain.createList(event.getCompletions())";
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        switch (modificationType) {
            case SET: {
                return "event.setCompletions(" + delta + ");";
            }
            case ADD: {
                return "event.getCompletions().add(" + delta + ");";
            }
            case REMOVE: {
                return "event.getCompletions().remove(" + delta + ");";
            }
            case CLEAR: {
                return "event.getCompletions().clear();";
            }
        }
        return null;
    }

    @Override
    public Class<?> getDeltaType(ModificationType modificationType) {
        return modificationType == ModificationType.SET ? List.class : String.class;
    }
}

