/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import java.util.List;
import java.util.StringJoiner;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.scheduler.BukkitRunnable;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.syntax.ExpressionParameter;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;
import us.donut.visualbukkit.editor.ProcedurePane;
import us.donut.visualbukkit.editor.ProjectManager;
import us.donut.visualbukkit.plugin.BuildContext;
import us.donut.visualbukkit.plugin.modules.PluginModule;

@Description(value={"Gets a procedure runnable", "Returns: bukkit runnable"})
public class ExprProcedureRunnable
extends ExpressionBlock<BukkitRunnable> {
    private ProcedurePane procedure;

    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("procedure <...>");
    }

    @Override
    public void onDragDrop() {
        if (this.procedure == null) {
            List<ProcedurePane> procedures = this.getBlockPane().getProject().getProcedures();
            if (!procedures.isEmpty()) {
                ChoiceDialog dialog = new ChoiceDialog();
                dialog.getDialogPane().getButtonTypes().remove((Object)ButtonType.CANCEL);
                dialog.setTitle("Select procedure");
                dialog.setContentText("Procedure:");
                dialog.setHeaderText(null);
                dialog.setGraphic(null);
                for (ProcedurePane procedurePane : procedures) {
                    dialog.getItems().add((Object)procedurePane);
                }
                dialog.setSelectedItem(dialog.getItems().get(0));
                this.setProcedure((ProcedurePane)dialog.showAndWait().orElse(dialog.getItems().get(0)));
            } else {
                ((ExpressionParameter)this.getParent()).setExpression(null);
                VisualBukkit.displayError("No procedures have been defined");
            }
        }
    }

    @Override
    public String toJava() {
        BuildContext.addPluginModule(PluginModule.PROCEDURE_RUNNABLE);
        if (this.procedure != null) {
            if (!this.getParameters().isEmpty()) {
                StringJoiner joiner = new StringJoiner(",");
                this.getParameters().forEach(parameter -> joiner.add(parameter.toJava()));
                return "new ProcedureRunnable(\"" + this.procedure.getMethodName() + "\", new Object[]{" + joiner.toString() + "})";
            }
            return "new ProcedureRunnable(\"" + this.procedure.getMethodName() + "\", new Object[0])";
        }
        return "new ProcedureRunnable(null, null)";
    }

    @Override
    public void unload(ConfigurationSection section) {
        super.unload(section);
        section.set("procedure", this.procedure.getMethodName());
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        for (ProcedurePane procedure : ProjectManager.getCurrentProject().getProcedures()) {
            if (!procedure.getMethodName().equalsIgnoreCase(section.getString("procedure"))) continue;
            this.setProcedure(procedure);
            super.load(section);
            return;
        }
        throw new IllegalStateException("Undefined procedure");
    }

    public ProcedurePane getProcedure() {
        return this.procedure;
    }

    private void setProcedure(ProcedurePane procedure) {
        this.procedure = procedure;
        this.syntaxNode.clear();
        this.syntaxNode.add(procedure.getMethodName() + "(");
        Class<?>[] parameters = procedure.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            this.syntaxNode.add(parameters[i]);
            if (i == parameters.length - 1) continue;
            this.syntaxNode.add(",");
        }
        this.syntaxNode.add(")");
    }
}

