/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import java.util.StringJoiner;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;
import us.donut.visualbukkit.util.CenteredHBox;

@Description(value={"A persistent variable", "Returns: object"})
@Modifier(value={ModificationType.SET, ModificationType.ADD, ModificationType.REMOVE, ModificationType.DELETE})
public class ExprPersistentVariable
extends ModifiableExpressionBlock<Object> {
    private int numArgs = -1;

    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("<...>");
    }

    @Override
    public void onDragDrop() {
        if (this.numArgs < 1) {
            Dialog dialog = new Dialog();
            Spinner spinner = new Spinner();
            spinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 100));
            dialog.getDialogPane().setContent((Node)new CenteredHBox(new Node[]{new Label("Number of arguments: "), spinner}));
            dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
            dialog.setResultConverter(buttonType -> (Integer)spinner.getValue());
            this.setNumArgs(dialog.showAndWait().orElse(2));
        }
    }

    @Override
    public String toJava() {
        return "VariableManager.getVarValue(true," + this.getVarArgs() + ")";
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        switch (modificationType) {
            case SET: {
                return "VariableManager.setVarValue(true," + delta + "," + this.getVarArgs() + ");";
            }
            case ADD: {
                return "VariableManager.addToVar(true," + delta + "," + this.getVarArgs() + ");";
            }
            case REMOVE: {
                return "VariableManager.removeFromVar(true," + delta + "," + this.getVarArgs() + ");";
            }
            case DELETE: {
                return "VariableManager.deleteVar(true," + this.getVarArgs() + ");";
            }
        }
        return null;
    }

    @Override
    public void unload(ConfigurationSection section) {
        super.unload(section);
        section.set("num-args", this.numArgs);
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        this.setNumArgs(section.getInt("num-args"));
        super.load(section);
    }

    private void setNumArgs(int numArgs) {
        this.numArgs = numArgs;
        this.syntaxNode.clear();
        this.syntaxNode.add("variable(");
        for (int i = 0; i < numArgs; ++i) {
            this.syntaxNode.add(Object.class);
            if (i == numArgs - 1) continue;
            this.syntaxNode.add(",");
        }
        this.syntaxNode.add(")");
    }

    private String getVarArgs() {
        if (!this.getParameters().isEmpty()) {
            StringJoiner joiner = new StringJoiner(",");
            this.getParameters().forEach(parameter -> joiner.add(parameter.toJava()));
            return "new Object[]{" + joiner.toString() + "}";
        }
        return "null";
    }
}

