/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import java.util.regex.Pattern;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.annotations.Category;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.syntax.InputParameter;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

@Category(value={"Math"})
@Description(value={"A number", "Returns: number"})
public class ExprNumber
extends ExpressionBlock<Double> {
    private static Pattern numPattern = Pattern.compile("-?\\d*\\.?\\d*");

    @Override
    protected SyntaxNode init() {
        InputParameter inputParameter = new InputParameter();
        inputParameter.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!numPattern.matcher(inputParameter.getText()).matches()) {
                inputParameter.setText((String)oldValue);
            }
        });
        return new SyntaxNode(inputParameter);
    }

    @Override
    public String toJava() {
        String number = this.arg(0);
        try {
            Double.parseDouble(number);
            return number + "d";
        }
        catch (NumberFormatException e) {
            return "0d";
        }
    }
}

