/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Event;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

@Description(value={"The message recipients in an AsyncPlayerChatEvent", "Returns: list of players"})
@Event(value={AsyncPlayerChatEvent.class})
@Modifier(value={ModificationType.ADD, ModificationType.REMOVE, ModificationType.CLEAR})
public class ExprMessageRecipients
extends ModifiableExpressionBlock<List> {
    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("message recipients");
    }

    @Override
    public String toJava() {
        return "PluginMain.createList(event.getRecipients())";
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        switch (modificationType) {
            case CLEAR: {
                return "event.getRecipients().clear();";
            }
            case ADD: {
                return "event.getRecipients().add(" + delta + ");";
            }
            case REMOVE: {
                return "event.getRecipients().remove(" + delta + ");";
            }
        }
        return null;
    }

    @Override
    public Class<?> getDeltaType(ModificationType modificationType) {
        return Player.class;
    }
}

