/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import org.bukkit.entity.Entity;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.annotations.Category;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

@Category(value={"Entity"})
@Description(value={"The max fire ticks of an entity", "Returns: number"})
@Modifier(value={ModificationType.SET, ModificationType.ADD, ModificationType.REMOVE})
public class ExprMaxFireTicks
extends ModifiableExpressionBlock<Integer> {
    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("max fire ticks of", Entity.class);
    }

    @Override
    public String toJava() {
        return this.arg(0) + ".getMaxFireTicks()";
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        switch (modificationType) {
            case SET: {
                return this.arg(0) + ".setMaxFireTicks(" + delta + ");";
            }
            case ADD: {
                return this.modify(ModificationType.SET, this.toJava() + "-" + delta);
            }
            case REMOVE: {
                return this.modify(ModificationType.SET, this.toJava() + "+" + delta);
            }
        }
        return null;
    }
}

