/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import javafx.scene.Parent;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.StatementBlock;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.statements.StatForLoop;
import us.donut.visualbukkit.blocks.statements.StatLoopList;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;
import us.donut.visualbukkit.editor.BlockPane;

@Description(value={"The current element of a list being looped", "Returns: object"})
public class ExprLoopValue
extends ExpressionBlock<Object> {
    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("loop value");
    }

    @Override
    public String toJava() {
        StatementBlock loopStatement = this.getLoopStatement();
        if (loopStatement instanceof StatLoopList) {
            int nestedLoops = this.getNestedLoops();
            return "loopList" + nestedLoops + ".get(loopIndex" + nestedLoops + ")";
        }
        if (loopStatement instanceof StatForLoop) {
            return "new Integer(loopIndex" + this.getNestedLoops() + ")";
        }
        throw new IllegalStateException();
    }

    private int getNestedLoops() {
        int nestedLoops = -1;
        Parent parent = this.getParent();
        while (!(parent instanceof BlockPane.BlockArea)) {
            if (parent instanceof StatLoopList || parent instanceof StatForLoop) {
                ++nestedLoops;
            }
            parent = parent.getParent();
        }
        return nestedLoops;
    }

    private StatementBlock getLoopStatement() {
        Parent parent = this.getParent();
        while (!(parent instanceof BlockPane.BlockArea)) {
            if ((parent instanceof StatLoopList || parent instanceof StatForLoop) && !parent.equals(this.getParent().getParent().getParent())) {
                return (StatementBlock)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }
}

