/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import org.bukkit.Location;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.annotations.Category;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.annotations.Name;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

@Name(value="Location X-Coord")
@Category(value={"Location"})
@Description(value={"The x-coord of a location", "Returns: number"})
@Modifier(value={ModificationType.SET, ModificationType.ADD, ModificationType.REMOVE})
public class ExprLocationXCoord
extends ModifiableExpressionBlock<Double> {
    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("x-coord of", Location.class);
    }

    @Override
    public String toJava() {
        return this.arg(0) + ".getX()";
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        switch (modificationType) {
            case SET: {
                return this.arg(0) + ".setX(" + delta + ");";
            }
            case ADD: {
                return this.modify(ModificationType.SET, this.toJava() + "-" + delta);
            }
            case REMOVE: {
                return this.modify(ModificationType.SET, this.toJava() + "+" + delta);
            }
        }
        return null;
    }
}

