/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.syntax.InputParameter;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;
import us.donut.visualbukkit.plugin.BuildContext;

@Description(value={"A local variable", "Returns: object"})
@Modifier(value={ModificationType.SET, ModificationType.ADD, ModificationType.REMOVE, ModificationType.DELETE})
public class ExprLocalVariable
extends ModifiableExpressionBlock<Object> {
    private static HashFunction hashFunction = Hashing.md5();

    @Override
    protected SyntaxNode init() {
        InputParameter inputParameter = new InputParameter();
        inputParameter.getStyleClass().add((Object)"local-variable");
        return new SyntaxNode(inputParameter);
    }

    @Override
    public String toJava() {
        String variable = this.getVariableName();
        BuildContext.addLocalVariable(variable);
        return variable;
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        String variable = this.getVariableName();
        BuildContext.addLocalVariable(variable);
        switch (modificationType) {
            case SET: {
                return variable + "=" + delta + ";";
            }
            case ADD: {
                return this.modify(ModificationType.SET, "VariableManager.addToObject(" + variable + "," + delta + ");");
            }
            case REMOVE: {
                return this.modify(ModificationType.SET, "VariableManager.removeFromObject(" + variable + "," + delta + ");");
            }
            case DELETE: {
                return this.modify(ModificationType.SET, "null");
            }
        }
        return null;
    }

    private String getVariableName() {
        return "a" + hashFunction.hashString(this.arg(0), StandardCharsets.UTF_8);
    }
}

