/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import java.util.List;
import java.util.StringJoiner;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;
import us.donut.visualbukkit.util.CenteredHBox;

@Description(value={"A list of objects", "Returns: list"})
public class ExprList
extends ExpressionBlock<List> {
    private int size = -1;

    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("empty list");
    }

    @Override
    public void onDragDrop() {
        if (this.size < 0) {
            Dialog dialog = new Dialog();
            Spinner spinner = new Spinner();
            spinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 100));
            dialog.getDialogPane().setContent((Node)new CenteredHBox(new Node[]{new Label("Size of list: "), spinner}));
            dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
            dialog.setResultConverter(buttonType -> (Integer)spinner.getValue());
            this.setSize(dialog.showAndWait().orElse(0));
        }
    }

    @Override
    public String toJava() {
        if (!this.getParameters().isEmpty()) {
            StringJoiner joiner = new StringJoiner(",");
            this.getParameters().forEach(parameter -> joiner.add(parameter.toJava()));
            return "PluginMain.createList(new Object[]{" + joiner.toString() + "})";
        }
        return "new ArrayList()";
    }

    @Override
    public void unload(ConfigurationSection section) {
        super.unload(section);
        section.set("size", this.size);
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        this.setSize(section.getInt("size"));
        super.load(section);
    }

    private void setSize(int size) {
        this.size = size;
        if (size > 0) {
            this.syntaxNode.clear();
            for (int i = 0; i < size; ++i) {
                this.syntaxNode.add(Object.class);
                if (i == size - 1) continue;
                this.syntaxNode.add(",");
            }
        }
    }
}

