/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import java.util.List;
import java.util.StringJoiner;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Name;
import us.donut.visualbukkit.blocks.syntax.ExpressionParameter;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;
import us.donut.visualbukkit.editor.FunctionPane;
import us.donut.visualbukkit.editor.ProjectManager;

@Name(value="Function Value")
@Description(value={"The return value of a function"})
public class ExprFunction
extends ExpressionBlock<Object> {
    private FunctionPane function;

    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("<...>");
    }

    @Override
    public void onDragDrop() {
        if (this.function == null) {
            List<FunctionPane> functions = this.getBlockPane().getProject().getFunctions();
            if (!functions.isEmpty()) {
                ChoiceDialog dialog = new ChoiceDialog();
                dialog.setTitle("Select function");
                dialog.setContentText("Function:");
                dialog.getDialogPane().getButtonTypes().remove((Object)ButtonType.CANCEL);
                dialog.setHeaderText(null);
                dialog.setGraphic(null);
                for (FunctionPane functionPane : functions) {
                    dialog.getItems().add((Object)functionPane);
                }
                dialog.setSelectedItem(dialog.getItems().get(0));
                this.setFunction((FunctionPane)dialog.showAndWait().orElse(dialog.getItems().get(0)));
            } else {
                ((ExpressionParameter)this.getParent()).setExpression(null);
                VisualBukkit.displayError("No functions have been defined");
            }
        }
    }

    @Override
    public String toJava() {
        if (this.function != null) {
            if (!this.getParameters().isEmpty()) {
                StringJoiner joiner = new StringJoiner(",");
                this.getParameters().forEach(parameter -> joiner.add(parameter.toJava()));
                return "PluginMain.function(\"" + this.function.getMethodName() + "\", new Object[]{" + joiner.toString() + "})";
            }
            return "PluginMain.function(\"" + this.function.getMethodName() + "\", new Object[0])";
        }
        return "new Object()";
    }

    @Override
    public void unload(ConfigurationSection section) {
        super.unload(section);
        section.set("function", this.function.getMethodName());
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        for (FunctionPane function : ProjectManager.getCurrentProject().getFunctions()) {
            if (!function.getMethodName().equalsIgnoreCase(section.getString("function"))) continue;
            this.setFunction(function);
            super.load(section);
            return;
        }
        throw new IllegalStateException("Undefined function");
    }

    public FunctionPane getFunction() {
        return this.function;
    }

    private void setFunction(FunctionPane function) {
        this.function = function;
        this.syntaxNode.clear();
        this.syntaxNode.add(function.getMethodName() + "(");
        Class<?>[] parameters = function.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            this.syntaxNode.add(parameters[i]);
            if (i == parameters.length - 1) continue;
            this.syntaxNode.add(",");
        }
        this.syntaxNode.add(")");
    }
}

