/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import java.util.List;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Event;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

@Description(value={"The item stacks dropped in an EntityDeathEvent", "Returns: list of item stacks"})
@Event(value={EntityDeathEvent.class})
@Modifier(value={ModificationType.ADD, ModificationType.REMOVE, ModificationType.CLEAR})
public class ExprDeathDrops
extends ModifiableExpressionBlock<List> {
    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("death drops");
    }

    @Override
    public String toJava() {
        return "PluginMain.createList(event.getDrops())";
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        switch (modificationType) {
            case CLEAR: {
                return "event.getDrops().clear();";
            }
            case ADD: {
                return "event.getDrops().add(" + delta + ");";
            }
            case REMOVE: {
                return "event.getDrops().remove(" + delta + ");";
            }
        }
        return null;
    }

    @Override
    public Class<?> getDeltaType(ModificationType modificationType) {
        return ItemStack.class;
    }
}

