/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import org.bukkit.boss.BossBar;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

@Description(value={"The progress of a boss bar", "Returns: number"})
@Modifier(value={ModificationType.SET, ModificationType.ADD, ModificationType.REMOVE})
public class ExprBossBarProgress
extends ModifiableExpressionBlock<Double> {
    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("progress of", BossBar.class);
    }

    @Override
    public String toJava() {
        return this.arg(0) + ".getProgress()";
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        switch (modificationType) {
            case SET: {
                return this.arg(0) + ".setProgress(" + delta + ");";
            }
            case ADD: {
                return this.modify(ModificationType.SET, this.toJava() + "-" + delta);
            }
            case REMOVE: {
                return this.modify(ModificationType.SET, this.toJava() + "+" + delta);
            }
        }
        return null;
    }
}

