/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import java.util.List;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

@Description(value={"The players viewing a boss bar", "Returns: list of players"})
@Modifier(value={ModificationType.ADD, ModificationType.REMOVE, ModificationType.CLEAR})
public class ExprBossBarPlayers
extends ModifiableExpressionBlock<List> {
    @Override
    protected SyntaxNode init() {
        return new SyntaxNode("players of", BossBar.class);
    }

    @Override
    public String toJava() {
        return "PluginMain.createList(" + this.arg(0) + ".getPlayers())";
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        switch (modificationType) {
            case CLEAR: {
                return this.arg(0) + ".removeAll();";
            }
            case ADD: {
                return this.arg(0) + ".addPlayer(" + delta + ");";
            }
            case REMOVE: {
                return this.arg(0) + ".removePlayer(" + delta + ");";
            }
        }
        return null;
    }

    @Override
    public Class<?> getDeltaType(ModificationType modificationType) {
        return Player.class;
    }
}

