/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks.expressions;

import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

@Description(value={"The value of an attribute", "Returns: number"})
@Modifier(value={ModificationType.SET, ModificationType.ADD, ModificationType.REMOVE})
public class ExprAttributeValue
extends ModifiableExpressionBlock<Double> {
    @Override
    protected SyntaxNode init() {
        return new SyntaxNode(Attribute.class, "value for", Attributable.class);
    }

    @Override
    public String toJava() {
        return this.arg(1) + ".getAttribute(" + this.arg(0) + ").getBaseValue()";
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        switch (modificationType) {
            case SET: {
                return this.arg(1) + ".getAttribute(" + this.arg(0) + ").setBaseValue(" + delta + ");";
            }
            case ADD: {
                return this.modify(ModificationType.SET, this.toJava() + "-" + delta);
            }
            case REMOVE: {
                return this.modify(ModificationType.SET, this.toJava() + "+" + delta);
            }
        }
        return null;
    }
}

