/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks;

import com.google.common.base.CaseFormat;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.File;
import java.sql.PreparedStatement;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang.ClassUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.Vector;

public class TypeHandler {
    private static BiMap<Class<?>, String> types = HashBiMap.create();
    private static Map<String, Function<String, String>> stringParsers = new HashMap<String, Function<String, String>>();
    private static Set<String> aliases;

    private static void register(Class<?> clazz, String alias, Function<String, String> stringParser) {
        stringParsers.put(alias, stringParser);
        TypeHandler.register(clazz, alias);
    }

    private static void register(Class<?> clazz, String alias) {
        types.put(clazz, alias);
    }

    public static String convert(Class<?> from, Class<?> to, String src) {
        if (to.isAssignableFrom(from) || to == Void.class) {
            return src;
        }
        if (to == String.class) {
            return "String.valueOf(" + src + ")";
        }
        if (TypeHandler.isPrimitiveNumber(from) && TypeHandler.isPrimitiveNumber(to)) {
            return "((" + to.getSimpleName() + ")" + src + ")";
        }
        if (to.isPrimitive() && from == ClassUtils.primitiveToWrapper(to)) {
            return src + "." + to.getSimpleName() + "Value()";
        }
        if (Number.class.isAssignableFrom(from) && TypeHandler.isPrimitiveNumber(to)) {
            return src + "." + to.getSimpleName() + "Value()";
        }
        if (TypeHandler.isPrimitiveNumber(from) && to == Number.class) {
            return TypeHandler.boxPrimitive(from, src);
        }
        if (from.isPrimitive() && to == ClassUtils.primitiveToWrapper(from)) {
            return TypeHandler.boxPrimitive(from, src);
        }
        if (from.isPrimitive() && to == Object.class) {
            return TypeHandler.boxPrimitive(from, src);
        }
        if (from.isAssignableFrom(to) || from == Void.class) {
            return "((" + to.getCanonicalName() + ")" + src + ")";
        }
        if (from == Object.class && TypeHandler.isPrimitiveNumber(to)) {
            return TypeHandler.convert(Number.class, to, "((Number)" + src + ")");
        }
        if (from == Object.class && to.isPrimitive()) {
            Class wrapper = ClassUtils.primitiveToWrapper(to);
            return TypeHandler.convert(wrapper, to, "((" + wrapper.getCanonicalName() + ")" + src + ")");
        }
        throw new UnsupportedOperationException();
    }

    private static String boxPrimitive(Class<?> primitive, String src) {
        Class wrapper = ClassUtils.primitiveToWrapper(primitive);
        return "new " + wrapper.getCanonicalName() + "(" + src + ")";
    }

    public static boolean isNumber(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz) || TypeHandler.isPrimitiveNumber(clazz);
    }

    public static boolean isPrimitiveNumber(Class<?> clazz) {
        return clazz.isPrimitive() && clazz != Boolean.TYPE && clazz != Character.TYPE;
    }

    public static String getUserFriendlyName(Class<?> clazz) {
        String name = TypeHandler.getAlias(clazz);
        if (name != null) {
            return name;
        }
        if (TypeHandler.isNumber(clazz)) {
            return "number";
        }
        if (clazz == Class.class) {
            return "type";
        }
        if (Configuration.class.isAssignableFrom(clazz)) {
            return "config";
        }
        name = clazz.getSimpleName();
        if (name.toUpperCase().equals(name)) {
            return name;
        }
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name).replace("_", " ");
    }

    public static Set<String> getAliases() {
        return aliases;
    }

    public static String getAlias(Class<?> type) {
        return (String)types.get(type);
    }

    public static Class<?> getType(String alias) {
        return (Class)types.inverse().get(alias);
    }

    public static Map<String, Function<String, String>> getStringParsers() {
        return stringParsers;
    }

    static {
        TypeHandler.register(Block.class, "block");
        TypeHandler.register(Boolean.class, "boolean", s -> "Boolean.valueOf(" + s + ")");
        TypeHandler.register(ConfigurationSection.class, "config");
        TypeHandler.register(Duration.class, "duration");
        TypeHandler.register(Entity.class, "entity");
        TypeHandler.register(EntityType.class, "entity type", s -> "EntityType.valueOf(" + s + ".toUpperCase())");
        TypeHandler.register(File.class, "file");
        TypeHandler.register(ItemStack.class, "item stack");
        TypeHandler.register(Inventory.class, "inventory");
        TypeHandler.register(InventoryView.class, "inventory view");
        TypeHandler.register(LivingEntity.class, "living entity");
        TypeHandler.register(List.class, "list");
        TypeHandler.register(LocalDateTime.class, "date");
        TypeHandler.register(Location.class, "location");
        TypeHandler.register(Material.class, "material", s -> "Material.valueOf(" + s + ".toUpperCase())");
        TypeHandler.register(Number.class, "number", s -> "Double.valueOf(" + s + ")");
        TypeHandler.register(Object.class, "object");
        TypeHandler.register(OfflinePlayer.class, "offline player", s -> "Bukkit.getOfflinePlayer(" + s + ")");
        TypeHandler.register(Particle.class, "particle", s -> "Particle.valueOf(" + s + ".toUpperCase())");
        TypeHandler.register(Player.class, "player", s -> "Bukkit.getPlayer(" + s + ")");
        TypeHandler.register(PreparedStatement.class, "SQL statement");
        TypeHandler.register(Scoreboard.class, "scoreboard");
        TypeHandler.register(Sound.class, "sound", s -> "Sound.valueOf(" + s + ".toUpperCase())");
        TypeHandler.register(String.class, "string");
        TypeHandler.register(UUID.class, "UUID", s -> "UUID.fromString(" + s + ")");
        TypeHandler.register(Vector.class, "vector");
        TypeHandler.register(World.class, "world", s -> "Bukkit.getWorld(" + s + ")");
        aliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        aliases.addAll(types.values());
        aliases = Collections.unmodifiableSet(aliases);
    }
}

